/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.injected.editor.DocumentWindow;
import org.jetbrains.kotlin.com.intellij.injected.editor.VirtualFileWindow;
import org.jetbrains.kotlin.com.intellij.lang.LanguageUtil;
import org.jetbrains.kotlin.com.intellij.lang.injection.InjectedLanguageManager;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.ProperTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.kotlin.com.intellij.psi.SmartPointerManager;
import org.jetbrains.kotlin.com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.kotlin.com.intellij.psi.SmartPsiFileRange;
import org.jetbrains.kotlin.com.intellij.psi.impl.FreeThreadedFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.Identikit;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

class InjectedSelfElementInfo
extends SmartPointerElementInfo {
    private final SmartPsiFileRange myInjectedFileRangeInHostFile;
    @Nullable
    private final AffixOffsets myAffixOffsets;
    private final Identikit myType;
    @NotNull
    private final SmartPsiElementPointer<PsiLanguageInjectionHost> myHostContext;

    InjectedSelfElementInfo(@NotNull Project project, @NotNull PsiElement injectedElement, @NotNull TextRange injectedRange, @NotNull PsiFile containingFile, @NotNull SmartPsiElementPointer<PsiLanguageInjectionHost> hostContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        if (injectedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedElement", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        if (injectedRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedRange", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        if (hostContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostContext", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        this.myHostContext = hostContext;
        assert (containingFile.getViewProvider() instanceof FreeThreadedFileViewProvider) : "element parameter must be an injected element: " + injectedElement + "; " + containingFile;
        assert (containingFile.getTextRange().contains(injectedRange)) : "Injected range outside the file: " + injectedRange + "; file: " + containingFile.getTextRange();
        TextRange hostRange = InjectedLanguageManager.getInstance(project).injectedToHost(injectedElement, injectedRange);
        PsiFile hostFile = hostContext.getContainingFile();
        assert (!(hostFile.getViewProvider() instanceof FreeThreadedFileViewProvider)) : "hostContext parameter must not be and injected element: " + hostContext;
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(project);
        this.myInjectedFileRangeInHostFile = smartPointerManager.createSmartPsiFileRangePointer(hostFile, hostRange);
        this.myType = Identikit.fromPsi(injectedElement, LanguageUtil.getRootLanguage(containingFile));
        int startAffixIndex = -1;
        int startAffixOffset = -1;
        int endAffixIndex = -1;
        int endAffixOffset = -1;
        List<TextRange> fragments2 = InjectedLanguageManager.getInstance(project).getNonEditableFragments((DocumentWindow)containingFile.getViewProvider().getDocument());
        for (int i = 0; i < fragments2.size(); ++i) {
            TextRange range = fragments2.get(i);
            if (range.containsOffset(injectedRange.getStartOffset())) {
                startAffixIndex = i;
                startAffixOffset = injectedRange.getStartOffset() - range.getStartOffset();
            }
            if (!range.containsOffset(injectedRange.getEndOffset())) continue;
            endAffixIndex = i;
            endAffixOffset = injectedRange.getEndOffset() - range.getStartOffset();
        }
        this.myAffixOffsets = startAffixIndex >= 0 || endAffixIndex >= 0 ? new AffixOffsets(startAffixIndex, startAffixOffset, endAffixIndex, endAffixOffset) : null;
    }

    @Override
    public VirtualFile getVirtualFile() {
        PsiElement element = this.restoreElement();
        if (element == null) {
            return null;
        }
        return element.getContainingFile().getVirtualFile();
    }

    @Override
    public Segment getRange() {
        return this.getInjectedRange(false);
    }

    @Override
    @Nullable
    public Segment getPsiRange() {
        return this.getInjectedRange(true);
    }

    @Override
    public PsiElement restoreElement() {
        PsiFile hostFile = this.myHostContext.getContainingFile();
        if (hostFile == null || !hostFile.isValid()) {
            return null;
        }
        PsiLanguageInjectionHost hostContext = this.myHostContext.getElement();
        if (hostContext == null) {
            return null;
        }
        Segment segment = this.myInjectedFileRangeInHostFile.getPsiRange();
        if (segment == null) {
            return null;
        }
        PsiFile injectedPsi = this.getInjectedFileIn(hostContext, hostFile, TextRange.create(segment));
        ProperTextRange rangeInInjected = InjectedSelfElementInfo.hostToInjected(true, segment, injectedPsi, this.myAffixOffsets);
        if (rangeInInjected == null) {
            return null;
        }
        return this.myType.findPsiElement(injectedPsi, rangeInInjected.getStartOffset(), rangeInInjected.getEndOffset());
    }

    private PsiFile getInjectedFileIn(@NotNull PsiElement hostContext, @NotNull PsiFile hostFile, final @NotNull TextRange rangeInHostFile) {
        PsiFile[] result2;
        block6: {
            PsiLanguageInjectionHost.InjectedPsiVisitor visitor2;
            block5: {
                if (hostContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostContext", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "getInjectedFileIn"));
                }
                if (hostFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "getInjectedFileIn"));
                }
                if (rangeInHostFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInHostFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "getInjectedFileIn"));
                }
                final PsiDocumentManagerBase docManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.getProject());
                result2 = new PsiFile[]{null};
                visitor2 = new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                    @Override
                    public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                        DocumentWindow window;
                        TextRange hostRange;
                        if (injectedPsi == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo$1", "visit"));
                        }
                        if (places == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo$1", "visit"));
                        }
                        Document document = docManager.getDocument(injectedPsi);
                        if (document instanceof DocumentWindow && (hostRange = (window = (DocumentWindow)((Object)docManager.getLastCommittedDocument(document))).injectedToHost(new TextRange(0, injectedPsi.getTextLength()))).contains(rangeInHostFile)) {
                            result2[0] = injectedPsi;
                        }
                    }
                };
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance(this.getProject());
                Document document = documentManager.getDocument(hostFile);
                if (document == null || !documentManager.isUncommited(document)) break block5;
                for (DocumentWindow documentWindow : InjectedLanguageManager.getInstance(this.getProject()).getCachedInjectedDocuments(hostFile)) {
                    PsiFile injected = documentManager.getPsiFile(documentWindow);
                    if (injected == null) continue;
                    visitor2.visit(injected, Collections.emptyList());
                }
                break block6;
            }
            List<Pair<PsiElement, TextRange>> injected = InjectedLanguageManager.getInstance(this.getProject()).getInjectedPsiFiles(hostContext);
            if (injected == null) break block6;
            for (Pair<PsiElement, TextRange> pair : injected) {
                PsiFile injectedFile = ((PsiElement)pair.first).getContainingFile();
                visitor2.visit(injectedFile, ContainerUtil.emptyList());
            }
        }
        return result2[0];
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "pointsToTheSameElementAs"));
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        if (!((InjectedSelfElementInfo)other).myHostContext.equals(this.myHostContext)) {
            return false;
        }
        SmartPointerElementInfo myElementInfo = ((SmartPsiElementPointerImpl)((Object)this.myInjectedFileRangeInHostFile)).getElementInfo();
        SmartPointerElementInfo oElementInfo = ((SmartPsiElementPointerImpl)((Object)((InjectedSelfElementInfo)other).myInjectedFileRangeInHostFile)).getElementInfo();
        return myElementInfo.pointsToTheSameElementAs(oElementInfo);
    }

    @Override
    public PsiFile restoreFile() {
        PsiFile hostFile = this.myHostContext.getContainingFile();
        if (hostFile == null || !hostFile.isValid()) {
            return null;
        }
        PsiLanguageInjectionHost hostContext = this.myHostContext.getElement();
        if (hostContext == null) {
            return null;
        }
        Segment segment = this.myInjectedFileRangeInHostFile.getPsiRange();
        if (segment == null) {
            return null;
        }
        TextRange rangeInHostFile = TextRange.create(segment);
        return this.getInjectedFileIn(hostContext, hostFile, rangeInHostFile);
    }

    @Nullable
    private ProperTextRange getInjectedRange(boolean psi) {
        Segment hostElementRange;
        PsiLanguageInjectionHost hostContext = this.myHostContext.getElement();
        if (hostContext == null) {
            return null;
        }
        Segment segment = hostElementRange = psi ? this.myInjectedFileRangeInHostFile.getPsiRange() : this.myInjectedFileRangeInHostFile.getRange();
        if (hostElementRange == null) {
            return null;
        }
        return InjectedSelfElementInfo.hostToInjected(psi, hostElementRange, this.restoreFile(), this.myAffixOffsets);
    }

    @Nullable
    private static ProperTextRange hostToInjected(boolean psi, Segment hostRange, @Nullable PsiFile injectedFile, @Nullable AffixOffsets affixOffsets) {
        VirtualFile virtualFile2;
        VirtualFile virtualFile3 = virtualFile2 = injectedFile == null ? null : injectedFile.getVirtualFile();
        if (virtualFile2 instanceof VirtualFileWindow) {
            Project project = injectedFile.getProject();
            DocumentWindow documentWindow = ((VirtualFileWindow)((Object)virtualFile2)).getDocumentWindow();
            if (psi) {
                documentWindow = (DocumentWindow)((Object)((PsiDocumentManagerBase)PsiDocumentManager.getInstance(project)).getLastCommittedDocument(documentWindow));
            }
            int start = documentWindow.hostToInjected(hostRange.getStartOffset());
            int end = documentWindow.hostToInjected(hostRange.getEndOffset());
            if (affixOffsets != null) {
                return affixOffsets.expandRangeToAffixes(start, end, InjectedLanguageManager.getInstance(project).getNonEditableFragments(documentWindow));
            }
            return ProperTextRange.create(start, end);
        }
        return null;
    }

    @Override
    public void cleanup() {
        SmartPointerManager.getInstance(this.getProject()).removePointer(this.myInjectedFileRangeInHostFile);
    }

    @Override
    @Nullable
    public Document getDocumentToSynchronize() {
        return ((SmartPsiElementPointerImpl)this.myHostContext).getElementInfo().getDocumentToSynchronize();
    }

    @Override
    public int elementHashCode() {
        return ((SmartPsiElementPointerImpl)this.myHostContext).getElementInfo().elementHashCode();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myHostContext.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "getProject"));
        }
        return project;
    }

    public String toString() {
        return "injected{type=" + this.myType + ", range=" + this.myInjectedFileRangeInHostFile + ", host=" + this.myHostContext + "}";
    }

    private static class AffixOffsets {
        final int startAffixIndex;
        final int startAffixOffset;
        final int endAffixIndex;
        final int endAffixOffset;

        AffixOffsets(int startAffixIndex, int startAffixOffset, int endAffixIndex, int endAffixOffset) {
            this.startAffixIndex = startAffixIndex;
            this.startAffixOffset = startAffixOffset;
            this.endAffixIndex = endAffixIndex;
            this.endAffixOffset = endAffixOffset;
        }

        @Nullable
        ProperTextRange expandRangeToAffixes(int start, int end, List<TextRange> fragments2) {
            TextRange fragment;
            if (this.startAffixIndex >= 0) {
                TextRange textRange = fragment = this.startAffixIndex < fragments2.size() ? fragments2.get(this.startAffixIndex) : null;
                if (fragment == null || this.startAffixOffset > fragment.getLength()) {
                    return null;
                }
                start = fragment.getStartOffset() + this.startAffixOffset;
            }
            if (this.endAffixIndex >= 0) {
                TextRange textRange = fragment = this.endAffixIndex < fragments2.size() ? fragments2.get(this.endAffixIndex) : null;
                if (fragment == null || this.endAffixOffset > fragment.getLength()) {
                    return null;
                }
                end = fragment.getStartOffset() + this.endAffixOffset;
            }
            return ProperTextRange.create(start, end);
        }
    }
}

