/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.List;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPolyadicExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiConcatenationUtil {
    public static void buildFormatString(PsiExpression expression2, StringBuilder formatString, List<PsiExpression> formatParameters, boolean printfFormat) {
        if (expression2 instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression2;
            String text2 = String.valueOf(literalExpression.getValue());
            String formatText = printfFormat ? StringUtil.escapeStringCharacters(text2).replace("%", "%%").replace("\\'", "'") : StringUtil.escapeStringCharacters(text2).replace("'", "''").replaceAll("((\\{|})+)", "'$1'");
            formatString.append(formatText);
        } else if (expression2 instanceof PsiPolyadicExpression) {
            PsiType type2 = expression2.getType();
            if (type2 != null && type2.equalsToText("java.lang.String")) {
                boolean stringStarted;
                PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)expression2;
                PsiExpression[] operands = binaryExpression.getOperands();
                PsiType left = operands[0].getType();
                boolean bl = stringStarted = left != null && left.equalsToText("java.lang.String");
                if (stringStarted) {
                    PsiConcatenationUtil.buildFormatString(operands[0], formatString, formatParameters, printfFormat);
                }
                for (int i = 1; i < operands.length; ++i) {
                    PsiExpression op = operands[i];
                    PsiType optype = op.getType();
                    PsiType r = TypeConversionUtil.calcTypeForBinaryExpression(left, optype, binaryExpression.getOperationTokenType(), true);
                    if (r != null && r.equalsToText("java.lang.String") && !stringStarted) {
                        stringStarted = true;
                        PsiElement element = binaryExpression.getTokenBeforeOperand(op);
                        if (element.getPrevSibling() instanceof PsiWhiteSpace) {
                            element = element.getPrevSibling();
                        }
                        String text3 = binaryExpression.getText().substring(0, element.getStartOffsetInParent());
                        PsiExpression subExpression = JavaPsiFacade.getInstance(binaryExpression.getProject()).getElementFactory().createExpressionFromText(text3, binaryExpression);
                        PsiConcatenationUtil.addFormatParameter(subExpression, formatString, formatParameters, printfFormat);
                    }
                    if (stringStarted) {
                        if (optype != null && (optype.equalsToText("java.lang.String") || PsiType.CHAR.equals(optype))) {
                            PsiConcatenationUtil.buildFormatString(op, formatString, formatParameters, printfFormat);
                        } else {
                            PsiConcatenationUtil.addFormatParameter(op, formatString, formatParameters, printfFormat);
                        }
                    }
                    left = r;
                }
            } else {
                PsiConcatenationUtil.addFormatParameter(expression2, formatString, formatParameters, printfFormat);
            }
        } else {
            PsiConcatenationUtil.addFormatParameter(expression2, formatString, formatParameters, printfFormat);
        }
    }

    private static void addFormatParameter(PsiExpression expression2, StringBuilder formatString, List<PsiExpression> formatParameters, boolean printfFormat) {
        PsiType type2 = expression2.getType();
        if (!printfFormat) {
            formatString.append("{").append(formatParameters.size()).append("}");
        } else if (type2 != null && (type2.equalsToText("long") || type2.equalsToText("int") || type2.equalsToText("java.lang.Long") || type2.equalsToText("java.lang.Integer"))) {
            formatString.append("%d");
        } else {
            formatString.append("%s");
        }
        formatParameters.add(PsiConcatenationUtil.getBoxedArgument(expression2));
    }

    private static PsiExpression getBoxedArgument(PsiExpression arg) throws IncorrectOperationException {
        arg = PsiUtil.deparenthesizeExpression(arg);
        assert (arg != null);
        if (PsiUtil.isLanguageLevel5OrHigher(arg)) {
            return arg;
        }
        PsiType type2 = arg.getType();
        if (!(type2 instanceof PsiPrimitiveType) || type2.equals(PsiType.NULL)) {
            return arg;
        }
        PsiPrimitiveType primitiveType = (PsiPrimitiveType)type2;
        String boxedQName = primitiveType.getBoxedTypeName();
        if (boxedQName == null) {
            return arg;
        }
        GlobalSearchScope resolveScope = arg.getResolveScope();
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(arg.getProject());
        PsiJavaCodeReferenceElement ref = factory2.createReferenceElementByFQClassName(boxedQName, resolveScope);
        PsiNewExpression newExpr = (PsiNewExpression)factory2.createExpressionFromText("new A(b)", null);
        PsiJavaCodeReferenceElement classRef = newExpr.getClassReference();
        assert (classRef != null);
        classRef.replace(ref);
        PsiExpressionList argumentList2 = newExpr.getArgumentList();
        assert (argumentList2 != null);
        argumentList2.getExpressions()[0].replace(arg);
        return newExpr;
    }
}

