/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.AccessorForCallableDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForPropertyBackingField;
import org.jetbrains.kotlin.codegen.AccessorForPropertyDescriptor;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.ExceptionLogger;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FieldAccessorKind;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.InnerClassConsumer;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.PropertyCodegen;
import org.jetbrains.kotlin.codegen.PropertyReferenceCodegen;
import org.jetbrains.kotlin.codegen.SourceInfo;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.WriteAnnotationUtilKt;
import org.jetbrains.kotlin.codegen.annotation.AnnotatedSimple;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.DelegatingToPartContext;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.InlineLambdaContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassFacadeContext;
import org.jetbrains.kotlin.codegen.inline.DefaultSourceMapper;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParametersUsages;
import org.jetbrains.kotlin.codegen.inline.SourceMapper;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializerExtension;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public abstract class MemberCodegen<T extends KtPureElement>
implements InnerClassConsumer {
    public final GenerationState state;
    protected final T element;
    protected final FieldOwnerContext context;
    public final ClassBuilder v;
    public final FunctionCodegen functionCodegen;
    public final PropertyCodegen propertyCodegen;
    public final KotlinTypeMapper typeMapper;
    public final BindingContext bindingContext;
    private final JvmFileClassesProvider fileClassesProvider;
    private final MemberCodegen<?> parentCodegen;
    private final ReifiedTypeParametersUsages reifiedTypeParametersUsages;
    private final Collection<ClassDescriptor> innerClasses;
    private ExpressionCodegen clInit;
    private NameGenerator inlineNameGenerator;
    private DefaultSourceMapper sourceMapper;

    public MemberCodegen(@NotNull GenerationState state2, @Nullable MemberCodegen<?> parentCodegen, @NotNull FieldOwnerContext context, T element, @NotNull ClassBuilder builder) {
        if (state2 == null) {
            MemberCodegen.$$$reportNull$$$0(0);
        }
        if (context == null) {
            MemberCodegen.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            MemberCodegen.$$$reportNull$$$0(2);
        }
        this.reifiedTypeParametersUsages = new ReifiedTypeParametersUsages();
        this.innerClasses = new LinkedHashSet<ClassDescriptor>();
        this.state = state2;
        this.typeMapper = state2.getTypeMapper();
        this.bindingContext = state2.getBindingContext();
        this.fileClassesProvider = state2.getFileClassesProvider();
        this.element = element;
        this.context = context;
        this.v = builder;
        this.functionCodegen = new FunctionCodegen(context, this.v, state2, this);
        this.propertyCodegen = new PropertyCodegen(context, this.v, this.functionCodegen, this);
        this.parentCodegen = parentCodegen;
    }

    protected MemberCodegen(@NotNull MemberCodegen<T> wrapped, T declaration, FieldOwnerContext codegenContext) {
        if (wrapped == null) {
            MemberCodegen.$$$reportNull$$$0(3);
        }
        this(wrapped.state, wrapped.getParentCodegen(), codegenContext, declaration, wrapped.v);
    }

    public void generate() {
        boolean shouldGenerateSyntheticParts;
        this.generateDeclaration();
        boolean bl = shouldGenerateSyntheticParts = !(this.element instanceof KtClassOrObject) || this.state.getGenerateDeclaredClassFilter().shouldGenerateClassMembers((KtClassOrObject)this.element);
        if (shouldGenerateSyntheticParts) {
            this.generateSyntheticPartsBeforeBody();
        }
        this.generateBody();
        if (shouldGenerateSyntheticParts) {
            this.generateSyntheticPartsAfterBody();
        }
        if (this.state.getClassBuilderMode().generateMetadata) {
            this.generateKotlinMetadataAnnotation();
        }
        this.done();
    }

    protected abstract void generateDeclaration();

    protected void generateSyntheticPartsBeforeBody() {
    }

    protected abstract void generateBody();

    protected void generateSyntheticPartsAfterBody() {
    }

    protected abstract void generateKotlinMetadataAnnotation();

    @Nullable
    protected ClassDescriptor classForInnerClassRecord() {
        return null;
    }

    public static void markLineNumberForDescriptor(@Nullable ClassDescriptor declarationDescriptor, @NotNull InstructionAdapter v) {
        if (v == null) {
            MemberCodegen.$$$reportNull$$$0(4);
        }
        if (declarationDescriptor == null) {
            return;
        }
        PsiElement classElement = DescriptorToSourceUtils.getSourceFromDescriptor(declarationDescriptor);
        if (classElement != null) {
            MemberCodegen.markLineNumberForElement(classElement, v);
        }
    }

    public static void markLineNumberForElement(@NotNull PsiElement element, @NotNull InstructionAdapter v) {
        Integer lineNumber;
        if (element == null) {
            MemberCodegen.$$$reportNull$$$0(5);
        }
        if (v == null) {
            MemberCodegen.$$$reportNull$$$0(6);
        }
        if ((lineNumber = CodegenUtil.getLineNumberForElement(element, false)) != null) {
            Label label = new Label();
            v.visitLabel(label);
            v.visitLineNumber(lineNumber, label);
        }
    }

    protected void done() {
        if (this.clInit != null) {
            this.clInit.v.visitInsn(177);
            FunctionCodegen.endVisit((MethodVisitor)this.clInit.v, "static initializer", this.element);
        }
        this.writeInnerClasses();
        if (this.sourceMapper != null) {
            SourceMapper.Companion.flushToClassBuilder(this.sourceMapper, this.v);
        }
        this.v.done();
    }

    public void genSimpleMember(@NotNull KtDeclaration declaration) {
        if (declaration == null) {
            MemberCodegen.$$$reportNull$$$0(7);
        }
        if (declaration instanceof KtNamedFunction) {
            try {
                this.functionCodegen.gen((KtNamedFunction)declaration);
            }
            catch (CompilationException | ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate function " + declaration.getName(), e, declaration);
            }
        } else if (declaration instanceof KtProperty) {
            try {
                this.propertyCodegen.gen((KtProperty)declaration);
            }
            catch (CompilationException | ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate property " + declaration.getName(), e, declaration);
            }
        } else if (declaration instanceof KtTypeAlias) {
            this.genTypeAlias((KtTypeAlias)declaration);
        } else if (declaration instanceof KtDestructuringDeclarationEntry) {
            try {
                this.propertyCodegen.genDestructuringDeclaration((KtDestructuringDeclarationEntry)declaration);
            }
            catch (CompilationException | ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate destructuring declaration entry " + declaration.getName(), e, declaration);
            }
        } else {
            throw new IllegalArgumentException("Unknown parameter: " + declaration);
        }
    }

    private void genTypeAlias(@NotNull KtTypeAlias typeAlias) {
        if (typeAlias == null) {
            MemberCodegen.$$$reportNull$$$0(8);
        }
        if (!this.state.getClassBuilderMode().generateMetadata) {
            return;
        }
        TypeAliasDescriptor typeAliasDescriptor = this.bindingContext.get(BindingContext.TYPE_ALIAS, typeAlias);
        if (typeAliasDescriptor == null) {
            throw ExceptionLogger.logDescriptorNotFound("Type alias " + typeAlias.getName() + " should have a descriptor", typeAlias);
        }
        this.genTypeAliasAnnotationsMethodIfRequired(typeAliasDescriptor);
    }

    private void genTypeAliasAnnotationsMethodIfRequired(TypeAliasDescriptor typeAliasDescriptor) {
        boolean isAnnotationsMethodOwner = CodegenContextUtil.isImplClassOwner(this.context);
        Annotations annotations2 = typeAliasDescriptor.getAnnotations();
        if (!isAnnotationsMethodOwner || annotations2.getAllAnnotations().isEmpty()) {
            return;
        }
        String name = JvmAbi.getSyntheticMethodNameForAnnotatedTypeAlias(typeAliasDescriptor.getName());
        this.generateSyntheticAnnotationsMethod(typeAliasDescriptor, new Method(name, "()V"), annotations2, null);
    }

    protected void generateSyntheticAnnotationsMethod(@NotNull MemberDescriptor descriptor2, @NotNull Method syntheticMethod, @NotNull Annotations annotations2, @Nullable AnnotationUseSiteTarget allowedTarget) {
        if (descriptor2 == null) {
            MemberCodegen.$$$reportNull$$$0(9);
        }
        if (syntheticMethod == null) {
            MemberCodegen.$$$reportNull$$$0(10);
        }
        if (annotations2 == null) {
            MemberCodegen.$$$reportNull$$$0(11);
        }
        int flags = 0x21008 | AsmUtil.getVisibilityAccessFlag(descriptor2);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(descriptor2), flags, syntheticMethod.getName(), syntheticMethod.getDescriptor(), null, null);
        AnnotationCodegen.forMethod(mv, this, this.typeMapper).genAnnotations(new AnnotatedSimple(annotations2), Type.VOID_TYPE, allowedTarget);
        mv.visitCode();
        mv.visitInsn(177);
        mv.visitEnd();
    }

    public static void genClassOrObject(@NotNull CodegenContext parentContext, @NotNull KtClassOrObject aClass2, @NotNull GenerationState state2, @Nullable MemberCodegen<?> parentCodegen) {
        ClassDescriptor descriptor2;
        if (parentContext == null) {
            MemberCodegen.$$$reportNull$$$0(12);
        }
        if (aClass2 == null) {
            MemberCodegen.$$$reportNull$$$0(13);
        }
        if (state2 == null) {
            MemberCodegen.$$$reportNull$$$0(14);
        }
        if ((descriptor2 = state2.getBindingContext().get(BindingContext.CLASS, aClass2)) == null || ErrorUtils.isError(descriptor2)) {
            MemberCodegen.badDescriptor(descriptor2, state2.getClassBuilderMode());
            return;
        }
        if (descriptor2.getName().equals(SpecialNames.NO_NAME_PROVIDED)) {
            MemberCodegen.badDescriptor(descriptor2, state2.getClassBuilderMode());
        }
        MemberCodegen.genClassOrObject(parentContext, aClass2, state2, parentCodegen, descriptor2);
    }

    private static void genClassOrObject(@NotNull CodegenContext parentContext, @NotNull KtPureClassOrObject aClass2, @NotNull GenerationState state2, @Nullable MemberCodegen<?> parentCodegen, @NotNull ClassDescriptor descriptor2) {
        if (parentContext == null) {
            MemberCodegen.$$$reportNull$$$0(15);
        }
        if (aClass2 == null) {
            MemberCodegen.$$$reportNull$$$0(16);
        }
        if (state2 == null) {
            MemberCodegen.$$$reportNull$$$0(17);
        }
        if (descriptor2 == null) {
            MemberCodegen.$$$reportNull$$$0(18);
        }
        Type classType = state2.getTypeMapper().mapClass(descriptor2);
        ClassBuilder classBuilder2 = state2.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOriginFromPure(aClass2, descriptor2), classType, aClass2.getContainingKtFile());
        ClassContext classContext = parentContext.intoClass(descriptor2, OwnerKind.IMPLEMENTATION, state2);
        new ImplementationBodyCodegen(aClass2, classContext, classBuilder2, state2, parentCodegen, false).generate();
    }

    public static void badDescriptor(ClassDescriptor descriptor2, ClassBuilderMode mode) {
        if (mode.generateBodies) {
            throw new IllegalStateException("Generating bad descriptor in ClassBuilderMode = " + mode + ": " + descriptor2);
        }
    }

    public void genClassOrObject(KtClassOrObject aClass2) {
        MemberCodegen.genClassOrObject(this.context, aClass2, this.state, this);
    }

    public void genSyntheticClassOrObject(SyntheticClassOrObjectDescriptor descriptor2) {
        MemberCodegen.genClassOrObject(this.context, descriptor2.getSyntheticDeclaration(), this.state, this, descriptor2);
    }

    private void writeInnerClasses() {
        ClassDescriptor classDescriptor = this.classForInnerClassRecord();
        if (classDescriptor != null) {
            if (this.parentCodegen != null) {
                this.parentCodegen.innerClasses.add(classDescriptor);
            }
            this.addParentsToInnerClassesIfNeeded(this.innerClasses);
        }
        for (ClassDescriptor innerClass : this.innerClasses) {
            this.writeInnerClass(innerClass);
        }
    }

    protected void addParentsToInnerClassesIfNeeded(@NotNull Collection<ClassDescriptor> innerClasses2) {
        MemberCodegen<?> parentCodegen;
        ClassDescriptor outerClass2;
        if (innerClasses2 == null) {
            MemberCodegen.$$$reportNull$$$0(19);
        }
        if ((outerClass2 = this.classForInnerClassRecord()) != null) {
            innerClasses2.add(outerClass2);
        }
        if ((parentCodegen = this.getParentCodegen()) != null) {
            parentCodegen.addParentsToInnerClassesIfNeeded(innerClasses2);
        }
    }

    @Override
    public void addInnerClassInfoFromAnnotation(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            MemberCodegen.$$$reportNull$$$0(20);
        }
        for (DeclarationDescriptor current = classDescriptor; current != null && !DescriptorUtils.isTopLevelDeclaration(current); current = current.getContainingDeclaration()) {
            if (!(current instanceof ClassDescriptor)) continue;
            this.innerClasses.add((ClassDescriptor)current);
        }
    }

    private void writeInnerClass(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            MemberCodegen.$$$reportNull$$$0(21);
        }
        if (!ErrorUtils.isError(innerClass)) {
            MemberCodegen.writeInnerClass(innerClass, this.typeMapper, this.v);
        }
    }

    public static void writeInnerClass(@NotNull ClassDescriptor innerClass, @NotNull KotlinTypeMapper typeMapper, @NotNull ClassBuilder v) {
        if (innerClass == null) {
            MemberCodegen.$$$reportNull$$$0(22);
        }
        if (typeMapper == null) {
            MemberCodegen.$$$reportNull$$$0(23);
        }
        if (v == null) {
            MemberCodegen.$$$reportNull$$$0(24);
        }
        DeclarationDescriptor containing = innerClass.getContainingDeclaration();
        String outerClassInternalName = null;
        if (containing instanceof ClassDescriptor) {
            outerClassInternalName = typeMapper.classInternalName((ClassDescriptor)containing);
        }
        String innerName2 = innerClass.getName().isSpecial() ? null : innerClass.getName().asString();
        String innerClassInternalName = typeMapper.classInternalName(innerClass);
        v.visitInnerClass(innerClassInternalName, outerClassInternalName, innerName2, AsmUtil.calculateInnerClassAccessFlags(innerClass));
    }

    protected void writeOuterClassAndEnclosingMethod() {
        CodegenContext context = this.context.getParentContext();
        while (context instanceof InlineLambdaContext) {
            context = context.getParentContext().getParentContext();
        }
        assert (context != null) : "Outermost context can't be null: " + this.context;
        Type enclosingAsmType = this.computeOuterClass(context);
        if (enclosingAsmType != null) {
            Method method = this.computeEnclosingMethod(context);
            this.v.visitOuterClass(enclosingAsmType.getInternalName(), method == null ? null : method.getName(), method == null ? null : method.getDescriptor());
        }
    }

    @Nullable
    private Type computeOuterClass(@NotNull CodegenContext<?> context) {
        CodegenContext<ClassOrPackageFragmentDescriptor> outermost;
        if (context == null) {
            MemberCodegen.$$$reportNull$$$0(25);
        }
        if ((outermost = context.getClassOrPackageParentContext()) instanceof ClassContext) {
            FunctionDescriptor functionDescriptor;
            ClassDescriptor classDescriptor = (ClassDescriptor)((ClassContext)outermost).getContextDescriptor();
            if (context instanceof MethodContext && DescriptorUtils.isInterface((functionDescriptor = ((MethodContext)context).getFunctionDescriptor()).getContainingDeclaration()) && !JvmCodegenUtil.isJvm8InterfaceWithDefaultsMember(functionDescriptor, this.state)) {
                return this.typeMapper.mapDefaultImpls(classDescriptor);
            }
            return this.typeMapper.mapType(classDescriptor);
        }
        if (outermost instanceof MultifileClassFacadeContext || outermost instanceof DelegatingToPartContext) {
            Type implementationOwnerType = CodegenContextUtil.getImplementationOwnerClassType(outermost);
            if (implementationOwnerType != null) {
                return implementationOwnerType;
            }
            return FileClasses.getFileClassType(this.fileClassesProvider, this.element.getContainingKtFile());
        }
        return null;
    }

    @Nullable
    private Method computeEnclosingMethod(@NotNull CodegenContext context) {
        if (context == null) {
            MemberCodegen.$$$reportNull$$$0(26);
        }
        if (context instanceof MethodContext) {
            FunctionDescriptor functionDescriptor = ((MethodContext)context).getFunctionDescriptor();
            if ("<clinit>".equals(functionDescriptor.getName().asString())) {
                return null;
            }
            if (((MethodContext)context).isDefaultFunctionContext()) {
                return this.typeMapper.mapDefaultMethod(functionDescriptor, context.getContextKind());
            }
            return this.typeMapper.mapAsmMethod(functionDescriptor, context.getContextKind());
        }
        return null;
    }

    @NotNull
    public NameGenerator getInlineNameGenerator() {
        if (this.inlineNameGenerator == null) {
            String prefix = InlineCodegenUtilsKt.getInlineName(this.context, this.typeMapper, this.fileClassesProvider);
            this.inlineNameGenerator = new NameGenerator(prefix);
        }
        NameGenerator nameGenerator2 = this.inlineNameGenerator;
        if (nameGenerator2 == null) {
            MemberCodegen.$$$reportNull$$$0(27);
        }
        return nameGenerator2;
    }

    @NotNull
    public final ExpressionCodegen createOrGetClInitCodegen() {
        if (this.clInit == null) {
            Object contextDescriptor = this.context.getContextDescriptor();
            SimpleFunctionDescriptorImpl clInitDescriptor = this.createClInitFunctionDescriptor((DeclarationDescriptor)contextDescriptor);
            MethodVisitor mv = this.createClInitMethodVisitor((DeclarationDescriptor)contextDescriptor);
            this.clInit = new ExpressionCodegen(mv, new FrameMap(), Type.VOID_TYPE, this.context.intoFunction(clInitDescriptor), this.state, this);
        }
        ExpressionCodegen expressionCodegen = this.clInit;
        if (expressionCodegen == null) {
            MemberCodegen.$$$reportNull$$$0(28);
        }
        return expressionCodegen;
    }

    @NotNull
    public MethodVisitor createClInitMethodVisitor(@NotNull DeclarationDescriptor contextDescriptor) {
        if (contextDescriptor == null) {
            MemberCodegen.$$$reportNull$$$0(29);
        }
        MethodVisitor methodVisitor = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(contextDescriptor), 8, "<clinit>", "()V", null, null);
        if (methodVisitor == null) {
            MemberCodegen.$$$reportNull$$$0(30);
        }
        return methodVisitor;
    }

    @NotNull
    private SimpleFunctionDescriptorImpl createClInitFunctionDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            MemberCodegen.$$$reportNull$$$0(31);
        }
        SimpleFunctionDescriptorImpl clInit = SimpleFunctionDescriptorImpl.create(descriptor2, Annotations.Companion.getEMPTY(), Name.special("<clinit>"), CallableMemberDescriptor.Kind.SYNTHESIZED, KotlinSourceElementKt.toSourceElement(this.element));
        clInit.initialize((KotlinType)null, (ReceiverParameterDescriptor)null, Collections.emptyList(), Collections.emptyList(), (KotlinType)DescriptorUtilsKt.getModule(descriptor2).getBuiltIns().getUnitType(), (Modality)null, Visibilities.PRIVATE);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = clInit;
        if (simpleFunctionDescriptorImpl == null) {
            MemberCodegen.$$$reportNull$$$0(32);
        }
        return simpleFunctionDescriptorImpl;
    }

    protected void generateInitializers(@NotNull Function0<ExpressionCodegen> createCodegen) {
        if (createCodegen == null) {
            MemberCodegen.$$$reportNull$$$0(33);
        }
        NotNullLazyValue<ExpressionCodegen> codegen = LockBasedStorageManager.NO_LOCKS.createLazyValue(createCodegen);
        for (KtDeclaration declaration : ((KtDeclarationContainer)this.element).getDeclarations()) {
            KtExpression body;
            if (declaration instanceof KtProperty) {
                if (!this.shouldInitializeProperty((KtProperty)declaration)) continue;
                this.initializeProperty((ExpressionCodegen)codegen.invoke(), (KtProperty)declaration);
                continue;
            }
            if (declaration instanceof KtDestructuringDeclaration) {
                ((ExpressionCodegen)codegen.invoke()).initializeDestructuringDeclaration((KtDestructuringDeclaration)declaration, true);
                continue;
            }
            if (!(declaration instanceof KtAnonymousInitializer) || (body = ((KtAnonymousInitializer)declaration).getBody()) == null) continue;
            ((ExpressionCodegen)codegen.invoke()).gen(body, Type.VOID_TYPE);
        }
    }

    public void beforeMethodBody(@NotNull MethodVisitor mv) {
        if (mv == null) {
            MemberCodegen.$$$reportNull$$$0(34);
        }
    }

    public void initializeProperty(@NotNull ExpressionCodegen codegen, @NotNull KtProperty property) {
        if (codegen == null) {
            MemberCodegen.$$$reportNull$$$0(35);
        }
        if (property == null) {
            MemberCodegen.$$$reportNull$$$0(36);
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.bindingContext.get(BindingContext.VARIABLE, property);
        assert (propertyDescriptor != null);
        KtExpression initializer2 = property.getDelegateExpressionOrInitializer();
        assert (initializer2 != null) : "shouldInitializeProperty must return false if initializer is null";
        StackValue.Property propValue = codegen.intermediateValueForProperty(propertyDescriptor, true, false, null, true, StackValue.LOCAL_0, null);
        ResolvedCall<FunctionDescriptor> provideDelegateResolvedCall = this.bindingContext.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor);
        if (provideDelegateResolvedCall == null) {
            propValue.store(codegen.gen(initializer2), codegen.v);
            return;
        }
        StackValue provideDelegateReceiver = codegen.gen(initializer2);
        StackValue delegateValue = PropertyCodegen.invokeDelegatedPropertyConventionMethod(codegen, provideDelegateResolvedCall, provideDelegateReceiver, propertyDescriptor);
        propValue.store(delegateValue, codegen.v);
    }

    public boolean shouldInitializeProperty(@NotNull KtProperty property) {
        ConstantValue<?> initializerValue2;
        if (property == null) {
            MemberCodegen.$$$reportNull$$$0(37);
        }
        if (!property.hasDelegateExpressionOrInitializer()) {
            return false;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.bindingContext.get(BindingContext.VARIABLE, property);
        assert (propertyDescriptor != null);
        if (propertyDescriptor.isConst()) {
            return false;
        }
        KtExpression initializer2 = property.getInitializer();
        ConstantValue<?> constantValue = initializerValue2 = initializer2 != null ? ExpressionCodegen.getCompileTimeConstant(initializer2, this.bindingContext, this.state.getShouldInlineConstVals()) : null;
        if (initializerValue2 == null) {
            return this.state.getClassBuilderMode().generateBodies;
        }
        KotlinType jetType = this.getPropertyOrDelegateType(property, propertyDescriptor);
        Type type2 = this.typeMapper.mapType(jetType);
        return !MemberCodegen.skipDefaultValue(propertyDescriptor, initializerValue2.getValue(), type2);
    }

    @NotNull
    private KotlinType getPropertyOrDelegateType(@NotNull KtProperty property, @NotNull PropertyDescriptor descriptor2) {
        KtExpression delegateExpression;
        if (property == null) {
            MemberCodegen.$$$reportNull$$$0(38);
        }
        if (descriptor2 == null) {
            MemberCodegen.$$$reportNull$$$0(39);
        }
        if ((delegateExpression = property.getDelegateExpression()) != null) {
            KotlinType delegateType = this.bindingContext.getType(delegateExpression);
            assert (delegateType != null) : "Type of delegate expression should be recorded";
            KotlinType kotlinType = delegateType;
            if (kotlinType == null) {
                MemberCodegen.$$$reportNull$$$0(40);
            }
            return kotlinType;
        }
        KotlinType kotlinType = descriptor2.getType();
        if (kotlinType == null) {
            MemberCodegen.$$$reportNull$$$0(41);
        }
        return kotlinType;
    }

    private static boolean skipDefaultValue(@NotNull PropertyDescriptor propertyDescriptor, Object value, @NotNull Type type2) {
        if (propertyDescriptor == null) {
            MemberCodegen.$$$reportNull$$$0(42);
        }
        if (type2 == null) {
            MemberCodegen.$$$reportNull$$$0(43);
        }
        if (AsmUtil.isPrimitive(type2)) {
            if (!propertyDescriptor.getType().isMarkedNullable() && value instanceof Number) {
                if (type2 == Type.INT_TYPE && ((Number)value).intValue() == 0) {
                    return true;
                }
                if (type2 == Type.BYTE_TYPE && ((Number)value).byteValue() == 0) {
                    return true;
                }
                if (type2 == Type.LONG_TYPE && ((Number)value).longValue() == 0L) {
                    return true;
                }
                if (type2 == Type.SHORT_TYPE && ((Number)value).shortValue() == 0) {
                    return true;
                }
                if (type2 == Type.DOUBLE_TYPE && ((Number)value).doubleValue() == 0.0) {
                    return true;
                }
                if (type2 == Type.FLOAT_TYPE && ((Number)value).floatValue() == 0.0f) {
                    return true;
                }
            }
            if (type2 == Type.BOOLEAN_TYPE && value instanceof Boolean && !((Boolean)value).booleanValue()) {
                return true;
            }
            if (type2 == Type.CHAR_TYPE && value instanceof Character && ((Character)value).charValue() == '\u0000') {
                return true;
            }
        } else if (value == null) {
            return true;
        }
        return false;
    }

    protected void generatePropertyMetadataArrayFieldIfNeeded(@NotNull Type thisAsmType) {
        List<VariableDescriptorWithAccessors> delegatedProperties;
        if (thisAsmType == null) {
            MemberCodegen.$$$reportNull$$$0(44);
        }
        if ((delegatedProperties = this.bindingContext.get(CodegenBinding.DELEGATED_PROPERTIES, thisAsmType)) == null || delegatedProperties.isEmpty()) {
            return;
        }
        this.v.newField(JvmDeclarationOrigin.NO_ORIGIN, 4120, "$$delegatedProperties", "[" + AsmTypes.K_PROPERTY_TYPE, null, null);
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        InstructionAdapter iv = this.createOrGetClInitCodegen().v;
        iv.iconst(delegatedProperties.size());
        iv.newarray(AsmTypes.K_PROPERTY_TYPE);
        int size = delegatedProperties.size();
        for (int i = 0; i < size; ++i) {
            VariableDescriptorWithAccessors property = delegatedProperties.get(i);
            iv.dup();
            iv.iconst(i);
            int receiverCount = (property.getDispatchReceiverParameter() != null ? 1 : 0) + (property.getExtensionReceiverParameter() != null ? 1 : 0);
            Type implType = property.isVar() ? AsmTypes.MUTABLE_PROPERTY_REFERENCE_IMPL[receiverCount] : AsmTypes.PROPERTY_REFERENCE_IMPL[receiverCount];
            iv.anew(implType);
            iv.dup();
            ClosureCodegen.generateCallableReferenceDeclarationContainer(iv, property, this.state);
            iv.aconst(property.getName().asString());
            PropertyReferenceCodegen.generateCallableReferenceSignature(iv, property, this.state);
            iv.invokespecial(implType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, AsmTypes.K_DECLARATION_CONTAINER_TYPE, AsmTypes.JAVA_STRING_TYPE, AsmTypes.JAVA_STRING_TYPE), false);
            Method wrapper = PropertyReferenceCodegen.getWrapperMethodForPropertyReference(property, receiverCount);
            iv.invokestatic("kotlin/jvm/internal/Reflection", wrapper.getName(), wrapper.getDescriptor(), false);
            StackValue.onStack(implType).put(AsmTypes.K_PROPERTY_TYPE, iv);
            iv.astore(AsmTypes.K_PROPERTY_TYPE);
        }
        iv.putstatic(thisAsmType.getInternalName(), "$$delegatedProperties", "[" + AsmTypes.K_PROPERTY_TYPE);
    }

    public String getClassName() {
        return this.v.getThisName();
    }

    @NotNull
    public FieldOwnerContext<?> getContext() {
        FieldOwnerContext fieldOwnerContext = this.context;
        if (fieldOwnerContext == null) {
            MemberCodegen.$$$reportNull$$$0(45);
        }
        return fieldOwnerContext;
    }

    @NotNull
    public ReifiedTypeParametersUsages getReifiedTypeParametersUsages() {
        ReifiedTypeParametersUsages reifiedTypeParametersUsages = this.reifiedTypeParametersUsages;
        if (reifiedTypeParametersUsages == null) {
            MemberCodegen.$$$reportNull$$$0(46);
        }
        return reifiedTypeParametersUsages;
    }

    public MemberCodegen<?> getParentCodegen() {
        return this.parentCodegen;
    }

    public String toString() {
        return this.context.toString();
    }

    @NotNull
    public DefaultSourceMapper getOrCreateSourceMapper() {
        if (this.sourceMapper == null) {
            this.sourceMapper = new DefaultSourceMapper(SourceInfo.Companion.createInfo((KtElement)this.element, this.getClassName()));
        }
        DefaultSourceMapper defaultSourceMapper = this.sourceMapper;
        if (defaultSourceMapper == null) {
            MemberCodegen.$$$reportNull$$$0(47);
        }
        return defaultSourceMapper;
    }

    protected void generateConstInstance(@NotNull Type thisAsmType, @NotNull Type fieldAsmType) {
        if (thisAsmType == null) {
            MemberCodegen.$$$reportNull$$$0(48);
        }
        if (fieldAsmType == null) {
            MemberCodegen.$$$reportNull$$$0(49);
        }
        this.v.newField(JvmDeclarationOriginKt.OtherOriginFromPure(this.element), 25, "INSTANCE", fieldAsmType.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode().generateBodies) {
            InstructionAdapter iv = this.createOrGetClInitCodegen().v;
            iv.anew(thisAsmType);
            iv.dup();
            iv.invokespecial(thisAsmType.getInternalName(), "<init>", "()V", false);
            iv.putstatic(thisAsmType.getInternalName(), "INSTANCE", fieldAsmType.getDescriptor());
        }
    }

    protected void generateSyntheticAccessors() {
        for (AccessorForCallableDescriptor<?> accessor : this.context.getAccessors()) {
            this.generateSyntheticAccessor(accessor);
        }
    }

    private void generateSyntheticAccessor(@NotNull AccessorForCallableDescriptor<?> accessorForCallableDescriptor) {
        if (accessorForCallableDescriptor == null) {
            MemberCodegen.$$$reportNull$$$0(50);
        }
        if (accessorForCallableDescriptor instanceof FunctionDescriptor) {
            final FunctionDescriptor accessor = (FunctionDescriptor)((Object)accessorForCallableDescriptor);
            final FunctionDescriptor original = (FunctionDescriptor)accessorForCallableDescriptor.getCalleeDescriptor();
            this.functionCodegen.generateMethod(JvmDeclarationOriginKt.Synthetic(null, original), accessor, new FunctionGenerationStrategy.CodegenBased(this.state){

                @Override
                public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature2) {
                    if (codegen == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (signature2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    MemberCodegen.markLineNumberForElement(MemberCodegen.this.element.getPsiOrParent(), codegen.v);
                    MemberCodegen.this.generateMethodCallTo(original, accessor, codegen.v).coerceTo(signature2.getReturnType(), codegen.v);
                    codegen.v.areturn(signature2.getReturnType());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "codegen";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "signature";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/kotlin/codegen/MemberCodegen$1";
                    objectArray[2] = "doGenerateBody";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        } else if (accessorForCallableDescriptor instanceof AccessorForPropertyDescriptor) {
            class PropertyAccessorStrategy
            extends FunctionGenerationStrategy.CodegenBased {
                private final PropertyAccessorDescriptor callableDescriptor;

                PropertyAccessorStrategy(PropertyAccessorDescriptor callableDescriptor) {
                    if (propertyDescriptor == null) {
                        PropertyAccessorStrategy.$$$reportNull$$$0(0);
                    }
                    super(MemberCodegen.this.state);
                    this.callableDescriptor = callableDescriptor;
                }

                @Override
                public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature2) {
                    if (codegen == null) {
                        PropertyAccessorStrategy.$$$reportNull$$$0(1);
                    }
                    if (signature2 == null) {
                        PropertyAccessorStrategy.$$$reportNull$$$0(2);
                    }
                    boolean syntheticBackingField = accessor instanceof AccessorForPropertyBackingField && ((AccessorForPropertyBackingField)accessor).getFieldAccessorKind() == FieldAccessorKind.FIELD_FROM_LOCAL;
                    boolean forceFieldForCompanionProperty = JvmAbi.isPropertyWithBackingFieldInOuterClass(original) && !DescriptorUtils.isCompanionObject(accessor.getContainingDeclaration());
                    boolean forceField = forceFieldForCompanionProperty || syntheticBackingField || original.getVisibility() == JavaVisibilities.PROTECTED_STATIC_VISIBILITY;
                    StackValue.Property property = codegen.intermediateValueForProperty(original, forceField, syntheticBackingField, accessor.getSuperCallTarget(), forceFieldForCompanionProperty, StackValue.none(), null);
                    InstructionAdapter iv = codegen.v;
                    MemberCodegen.markLineNumberForElement(MemberCodegen.this.element.getPsiOrParent(), iv);
                    Type[] argTypes = signature2.getAsmMethod().getArgumentTypes();
                    int reg = 0;
                    for (int i = 0; i < argTypes.length; ++i) {
                        Type argType = argTypes[i];
                        iv.load(reg, argType);
                        reg += argType.getSize();
                    }
                    if (this.callableDescriptor instanceof PropertyGetterDescriptor) {
                        property.put(signature2.getReturnType(), iv);
                    } else {
                        ((StackValue)property).store(StackValue.onStack(property.type), iv, true);
                    }
                    iv.areturn(signature2.getReturnType());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "0";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "codegen";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "signature";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/kotlin/codegen/MemberCodegen$1PropertyAccessorStrategy";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "<init>";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "doGenerateBody";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format(string, objectArray));
                }
            }
            final AccessorForPropertyDescriptor accessor = (AccessorForPropertyDescriptor)accessorForCallableDescriptor;
            final PropertyDescriptor original = accessor.getCalleeDescriptor();
            if (accessor.isWithSyntheticGetterAccessor()) {
                PropertyGetterDescriptorImpl getter2 = accessor.getGetter();
                assert (getter2 != null);
                this.functionCodegen.generateMethod(JvmDeclarationOriginKt.Synthetic(null, original.getGetter() != null ? original.getGetter() : original), getter2, new PropertyAccessorStrategy(getter2));
            }
            if (accessor.isVar() && accessor.isWithSyntheticSetterAccessor()) {
                PropertySetterDescriptor setter2 = accessor.getSetter();
                assert (setter2 != null);
                this.functionCodegen.generateMethod(JvmDeclarationOriginKt.Synthetic(null, original.getSetter() != null ? original.getSetter() : original), setter2, new PropertyAccessorStrategy(setter2));
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected StackValue generateMethodCallTo(@NotNull FunctionDescriptor functionDescriptor, @Nullable FunctionDescriptor accessorDescriptor, @NotNull InstructionAdapter iv) {
        if (functionDescriptor == null) {
            MemberCodegen.$$$reportNull$$$0(51);
        }
        if (iv == null) {
            MemberCodegen.$$$reportNull$$$0(52);
        }
        CallableMethod callableMethod = this.typeMapper.mapToCallableMethod(functionDescriptor, accessorDescriptor instanceof AccessorForCallableDescriptor && ((AccessorForCallableDescriptor)((Object)accessorDescriptor)).getSuperCallTarget() != null);
        boolean hasDispatchReceiver = !DescriptorUtils.isStaticDeclaration(functionDescriptor) && !JvmCodegenUtil.isNonDefaultInterfaceMember(functionDescriptor, this.state);
        int reg = hasDispatchReceiver ? 1 : 0;
        boolean accessorIsConstructor = accessorDescriptor instanceof AccessorForConstructorDescriptor;
        if (!accessorIsConstructor && functionDescriptor instanceof ConstructorDescriptor) {
            iv.anew(callableMethod.getOwner());
            iv.dup();
            reg = 0;
        } else if ((accessorIsConstructor || accessorDescriptor != null && KotlinTypeMapper.isAccessor(accessorDescriptor) && hasDispatchReceiver) && !CodegenUtilKt.isJvmStaticInObjectOrClass(functionDescriptor)) {
            iv.load(0, AsmTypes.OBJECT_TYPE);
        }
        for (Type argType : callableMethod.getParameterTypes()) {
            if (AsmTypes.DEFAULT_CONSTRUCTOR_MARKER.equals(argType)) {
                iv.aconst(null);
                continue;
            }
            iv.load(reg, argType);
            reg += argType.getSize();
        }
        callableMethod.genInvokeInstruction(iv);
        return StackValue.onStack(callableMethod.getReturnType());
    }

    protected void generateKotlinClassMetadataAnnotation(@NotNull ClassDescriptor descriptor2, boolean isScript) {
        if (descriptor2 == null) {
            MemberCodegen.$$$reportNull$$$0(53);
        }
        DescriptorSerializer serializer = DescriptorSerializer.create(descriptor2, new JvmSerializerExtension(this.v.getSerializationBindings(), this.state));
        ProtoBuf.Class classProto = serializer.classProto(descriptor2).build();
        int flags = isScript ? 4 : 0;
        WriteAnnotationUtilKt.writeKotlinMetadata(this.v, this.state, KotlinClassHeader.Kind.CLASS, flags, av -> {
            AsmUtil.writeAnnotationData(av, serializer, classProto);
            return Unit.INSTANCE;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapped";
                break;
            }
            case 4: 
            case 6: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAlias";
                break;
            }
            case 9: 
            case 18: 
            case 31: 
            case 39: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntheticMethod";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContext";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClasses";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/MemberCodegen";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextDescriptor";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createCodegen";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mv";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisAsmType";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldAsmType";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorForCallableDescriptor";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/MemberCodegen";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineNameGenerator";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrGetClInitCodegen";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createClInitMethodVisitor";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createClInitFunctionDescriptor";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyOrDelegateType";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getReifiedTypeParametersUsages";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateSourceMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "markLineNumberForDescriptor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "markLineNumberForElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "genSimpleMember";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "genTypeAlias";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generateSyntheticAnnotationsMethod";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "genClassOrObject";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addParentsToInnerClassesIfNeeded";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addInnerClassInfoFromAnnotation";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "writeInnerClass";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "computeOuterClass";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "computeEnclosingMethod";
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 47: {
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createClInitMethodVisitor";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createClInitFunctionDescriptor";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "generateInitializers";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "beforeMethodBody";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "initializeProperty";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "shouldInitializeProperty";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyOrDelegateType";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "skipDefaultValue";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "generatePropertyMetadataArrayFieldIfNeeded";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "generateConstInstance";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "generateSyntheticAccessor";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodCallTo";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "generateKotlinClassMetadataAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

