/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.extensions.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.LoadingOrder;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginAware;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.util.pico.AssignableToComponentAdapter;
import org.jetbrains.kotlin.com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializer;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.picocontainer.ComponentAdapter;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;
import org.jetbrains.kotlin.org.picocontainer.PicoException;
import org.jetbrains.kotlin.org.picocontainer.PicoInitializationException;

public class ExtensionComponentAdapter
implements LoadingOrder.Orderable,
AssignableToComponentAdapter {
    public static final ExtensionComponentAdapter[] EMPTY_ARRAY = new ExtensionComponentAdapter[0];
    private Object myComponentInstance;
    private final Element myExtensionElement;
    private final PicoContainer myContainer;
    private final PluginDescriptor myPluginDescriptor;
    private final boolean myDeserializeInstance;
    private ComponentAdapter myDelegate;
    @NotNull
    private Object myImplementationClassOrName;
    private boolean myNotificationSent;

    public ExtensionComponentAdapter(@NotNull String implementationClassName, Element extensionElement, PicoContainer container2, PluginDescriptor pluginDescriptor, boolean deserializeInstance) {
        if (implementationClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementationClassName", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionComponentAdapter", "<init>"));
        }
        this.myImplementationClassOrName = implementationClassName;
        this.myExtensionElement = extensionElement;
        this.myContainer = container2;
        this.myPluginDescriptor = pluginDescriptor;
        this.myDeserializeInstance = deserializeInstance;
    }

    @Override
    public Object getComponentKey() {
        return this;
    }

    @Override
    public Class getComponentImplementation() {
        return this.loadImplementationClass();
    }

    @Override
    public Object getComponentInstance(PicoContainer container2) throws PicoException, ProcessCanceledException {
        if (this.myComponentInstance == null) {
            block9: {
                try {
                    if (Element.class.equals((Object)this.getComponentImplementation())) {
                        this.myComponentInstance = this.myExtensionElement;
                        break block9;
                    }
                    Object componentInstance = this.getDelegate().getComponentInstance(container2);
                    if (this.myDeserializeInstance) {
                        try {
                            XmlSerializer.deserializeInto(componentInstance, this.myExtensionElement);
                        }
                        catch (Exception e) {
                            throw new PicoInitializationException(e);
                        }
                    }
                    this.myComponentInstance = componentInstance;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable t) {
                    PluginId pluginId = this.myPluginDescriptor != null ? this.myPluginDescriptor.getPluginId() : null;
                    throw new PicoPluginExtensionInitializationException(t.getMessage(), t, pluginId);
                }
            }
            if (this.myComponentInstance instanceof PluginAware) {
                PluginAware pluginAware = (PluginAware)this.myComponentInstance;
                pluginAware.setPluginDescriptor(this.myPluginDescriptor);
            }
        }
        return this.myComponentInstance;
    }

    public Object getExtension() {
        return this.getComponentInstance(this.myContainer);
    }

    @Override
    public LoadingOrder getOrder() {
        return LoadingOrder.readOrder(this.myExtensionElement.getAttributeValue("order"));
    }

    @Override
    public String getOrderId() {
        return this.myExtensionElement.getAttributeValue("id");
    }

    private Element getExtensionElement() {
        return this.myExtensionElement;
    }

    @Override
    public Element getDescribingElement() {
        return this.getExtensionElement();
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.myPluginDescriptor;
    }

    @NotNull
    private Class loadImplementationClass() {
        Class<?> implementationClassOrName = this.myImplementationClassOrName;
        if (implementationClassOrName instanceof String) {
            try {
                ClassLoader classLoader;
                ClassLoader classLoader2 = classLoader = this.myPluginDescriptor == null ? this.getClass().getClassLoader() : this.myPluginDescriptor.getPluginClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                this.myImplementationClassOrName = implementationClassOrName = Class.forName((String)((Object)implementationClassOrName), false, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        Class clazz = implementationClassOrName;
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionComponentAdapter", "loadImplementationClass"));
        }
        return clazz;
    }

    private synchronized ComponentAdapter getDelegate() {
        if (this.myDelegate == null) {
            Class impl = this.loadImplementationClass();
            this.myDelegate = new CachingConstructorInjectionComponentAdapter(this.getComponentKey(), impl, null, true);
        }
        return this.myDelegate;
    }

    @Override
    public String getAssignableToClassName() {
        Object implementationClassOrName = this.myImplementationClassOrName;
        if (implementationClassOrName instanceof String) {
            return (String)implementationClassOrName;
        }
        return ((Class)implementationClassOrName).getName();
    }

    boolean isNotificationSent() {
        return this.myNotificationSent;
    }

    void setNotificationSent(boolean notificationSent) {
        this.myNotificationSent = notificationSent;
    }

    public String toString() {
        return "ExtensionComponentAdapter[" + this.getAssignableToClassName() + "]: plugin=" + this.myPluginDescriptor;
    }
}

