/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\u0015\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0019H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010#\u001a\u00020\u001cH\u0016J\b\u0010$\u001a\u00020\u0019H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u000eH\u0016J\b\u0010(\u001a\u00020\u000eH\u0016J\b\u0010)\u001a\u00020\u000eH\u0016J\"\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000e2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtVirtualFile;", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "handler", "Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem$CoreJrtHandler;", "path", "Ljava/nio/file/Path;", "(Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem$CoreJrtHandler;Ljava/nio/file/Path;)V", "attributes", "Ljava/nio/file/attribute/BasicFileAttributes;", "getAttributes", "()Ljava/nio/file/attribute/BasicFileAttributes;", "contentsToByteArray", "", "equals", "", "other", "", "getChildren", "", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "getFileSystem", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFileSystem;", "getInputStream", "Ljava/io/InputStream;", "getLength", "", "getModificationStamp", "getName", "", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "newModificationStamp", "newTimeStamp", "getParent", "getPath", "getTimeStamp", "hashCode", "", "isDirectory", "isValid", "isWritable", "refresh", "", "asynchronous", "recursive", "postRunnable", "Ljava/lang/Runnable;", "cli"})
public final class CoreJrtVirtualFile
extends VirtualFile {
    private final CoreJrtFileSystem.CoreJrtHandler handler;
    private final Path path;

    private final BasicFileAttributes getAttributes() {
        BasicFileAttributes basicFileAttributes = Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)basicFileAttributes, (String)"Files.readAttributes(pat\u2026leAttributes::class.java)");
        return basicFileAttributes;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.handler.getVirtualFileSystem();
    }

    @Override
    @NotNull
    public String getName() {
        return ((Object)this.path.getFileName()).toString();
    }

    @Override
    @NotNull
    public String getPath() {
        String string = FileUtil.toSystemIndependentName(this.handler.getJdkHomePath() + "!/" + this.path);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.toSystemIndepen\u2026til.JAR_SEPARATOR + path)");
        return string;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.path, new LinkOption[0]);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    @Nullable
    public VirtualFile getParent() {
        Path parentPath = this.path.getParent();
        return parentPath != null ? (VirtualFile)new CoreJrtVirtualFile(this.handler, parentPath) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public VirtualFile[] getChildren() {
        VirtualFile[] virtualFileArray;
        Object object;
        try {
            Object object2;
            Iterable p122;
            object = Files.newDirectoryStream(this.path);
            boolean bl = false;
            try {
                p122 = (Iterable)object;
                p122 = CollectionsKt.toList((Iterable)p122);
                object2 = object;
            }
            catch (Exception p122) {
                try {
                    bl = true;
                    try {
                        Object object3 = object;
                        if (object3 != null) {
                            object3.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw (Throwable)p122;
                }
                catch (Throwable p122) {
                    if (!bl) {
                        Object object4 = object;
                        if (object4 != null) {
                            object4.close();
                        }
                    }
                    throw p122;
                }
            }
            if (object2 != null) {
                object2.close();
            }
            object = p122;
        }
        catch (IOException e) {
            object = CollectionsKt.emptyList();
        }
        List paths = object;
        if (paths.isEmpty()) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
            Intrinsics.checkExpressionValueIsNotNull((Object)VirtualFile.EMPTY_ARRAY, (String)"VirtualFile.EMPTY_ARRAY");
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable e = $receiver$iv = (Iterable)paths;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void path2;
                Path path3 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                CoreJrtVirtualFile coreJrtVirtualFile = new CoreJrtVirtualFile(this.handler, (Path)path2);
                collection.add(coreJrtVirtualFile);
            }
            $receiver$iv = (List)destination$iv$iv;
            Iterable thisCollection$iv = $receiver$iv;
            CoreJrtVirtualFile[] coreJrtVirtualFileArray = thisCollection$iv.toArray(new CoreJrtVirtualFile[thisCollection$iv.size()]);
            if (coreJrtVirtualFileArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            virtualFileArray = coreJrtVirtualFileArray;
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(@NotNull Object requestor, long newModificationStamp, long newTimeStamp) {
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() {
        byte[] byArray = Files.readAllBytes(this.path);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Files.readAllBytes(path)");
        return byArray;
    }

    @Override
    public long getTimeStamp() {
        return this.getAttributes().lastModifiedTime().toMillis();
    }

    @Override
    public long getLength() {
        return this.getAttributes().size();
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = Files.newInputStream(this.path, new OpenOption[0]);
        int n = 8192;
        InputStream inputStream2 = VfsUtilCore.inputStreamSkippingBOM(inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n), this);
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"VfsUtilCore.inputStreamS\u2026m(path).buffered(), this)");
        return inputStream2;
    }

    @Override
    public long getModificationStamp() {
        return 0L;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof CoreJrtVirtualFile && Intrinsics.areEqual((Object)this.path, (Object)((CoreJrtVirtualFile)other).path) && Intrinsics.areEqual((Object)this.getFileSystem(), (Object)((CoreJrtVirtualFile)other).getFileSystem());
    }

    public int hashCode() {
        return ((Object)this.path).hashCode();
    }

    public CoreJrtVirtualFile(@NotNull CoreJrtFileSystem.CoreJrtHandler handler2, @NotNull Path path2) {
        Intrinsics.checkParameterIsNotNull((Object)handler2, (String)"handler");
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        this.handler = handler2;
        this.path = path2;
    }
}

