/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Collection;
import java.util.HashSet;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.MultifileClassCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;

public class KotlinCodegenFacade {
    public static void compileCorrectFiles(@NotNull GenerationState state2, @NotNull CompilationErrorHandler errorHandler) {
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        state2.beforeCompile();
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        KotlinCodegenFacade.doGenerateFiles(state2.getFiles(), state2, errorHandler);
    }

    public static void doGenerateFiles(@NotNull Collection<KtFile> files2, @NotNull GenerationState state2, @NotNull CompilationErrorHandler errorHandler) {
        MultiMap<FqName, KtFile> filesInPackages = new MultiMap<FqName, KtFile>();
        MultiMap<FqName, KtFile> filesInMultifileClasses = new MultiMap<FqName, KtFile>();
        for (KtFile ktFile : files2) {
            if (ktFile == null) {
                throw new IllegalArgumentException("A null file given for compilation");
            }
            JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(ktFile);
            if (fileClassInfo.getWithJvmMultifileClass()) {
                filesInMultifileClasses.putValue(fileClassInfo.getFacadeClassFqName(), ktFile);
                continue;
            }
            filesInPackages.putValue(ktFile.getPackageFqName(), ktFile);
        }
        HashSet<FqName> obsoleteMultifileClasses = new HashSet<FqName>(state2.getObsoleteMultifileClasses());
        for (FqName multifileClassFqName : SetsKt.plus(filesInMultifileClasses.keySet(), obsoleteMultifileClasses)) {
            KotlinCodegenFacade.doCheckCancelled(state2);
            KotlinCodegenFacade.generateMultifileClass(state2, multifileClassFqName, filesInMultifileClasses.get(multifileClassFqName), errorHandler);
        }
        HashSet<FqName> hashSet = new HashSet<FqName>(state2.getPackagesWithObsoleteParts());
        for (FqName packageFqName : SetsKt.plus(hashSet, filesInPackages.keySet())) {
            KotlinCodegenFacade.doCheckCancelled(state2);
            KotlinCodegenFacade.generatePackage(state2, packageFqName, filesInPackages.get(packageFqName), errorHandler);
        }
        KotlinCodegenFacade.doCheckCancelled(state2);
        state2.getFactory().done();
    }

    private static void doCheckCancelled(GenerationState state2) {
        if (state2.getClassBuilderMode().generateBodies) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        }
    }

    public static void generatePackage(@NotNull GenerationState state2, @NotNull FqName packageFqName, @NotNull Collection<KtFile> jetFiles, @NotNull CompilationErrorHandler errorHandler) {
        PackageCodegen codegen = state2.getFactory().forPackage(packageFqName, jetFiles);
        codegen.generate(errorHandler);
    }

    private static void generateMultifileClass(@NotNull GenerationState state2, @NotNull FqName multifileClassFqName, @NotNull Collection<KtFile> files2, @NotNull CompilationErrorHandler handler2) {
        MultifileClassCodegen codegen = state2.getFactory().forMultifileClass(multifileClassFqName, files2);
        codegen.generate(handler2);
    }

    private KotlinCodegenFacade() {
    }
}

