/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.progress;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.CommonBundle;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.PerformInBackgroundOption;
import org.jetbrains.kotlin.com.intellij.openapi.progress.Progressive;
import org.jetbrains.kotlin.com.intellij.openapi.progress.TaskInfo;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;

public abstract class Task
implements Progressive,
TaskInfo {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.progress.Task");
    protected final Project myProject;
    protected String myTitle;
    private final boolean myCanBeCancelled;
    private String myCancelText;
    private String myCancelTooltipText;

    public Task(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, boolean canBeCancelled) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/kotlin/com/intellij/openapi/progress/Task", "<init>"));
        }
        this.myCancelText = CommonBundle.getCancelButtonText();
        this.myCancelTooltipText = CommonBundle.getCancelButtonText();
        this.myProject = project;
        this.myTitle = title;
        this.myCanBeCancelled = canBeCancelled;
    }

    public void onCancel() {
    }

    public void onSuccess() {
    }

    @Deprecated
    public void onError(@NotNull Exception error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/kotlin/com/intellij/openapi/progress/Task", "onError"));
        }
        LOG.error(error);
    }

    public void onThrowable(@NotNull Throwable error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/kotlin/com/intellij/openapi/progress/Task", "onThrowable"));
        }
        if (error instanceof Exception) {
            this.onError((Exception)error);
        } else {
            LOG.error(error);
        }
    }

    public void onFinished() {
    }

    public final Project getProject() {
        return this.myProject;
    }

    @NotNull
    public final String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/progress/Task", "getTitle"));
        }
        return string;
    }

    public final String getCancelText() {
        return this.myCancelText;
    }

    public boolean isHeadless() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public final boolean isCancellable() {
        return this.myCanBeCancelled;
    }

    public abstract boolean isModal();

    @NotNull
    public final Modal asModal() {
        if (this.isModal()) {
            Modal modal = (Modal)this;
            if (modal == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/progress/Task", "asModal"));
            }
            return modal;
        }
        throw new IllegalStateException("Not a modal task");
    }

    @NotNull
    public final Backgroundable asBackgroundable() {
        if (!this.isModal()) {
            Backgroundable backgroundable = (Backgroundable)this;
            if (backgroundable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/progress/Task", "asBackgroundable"));
            }
            return backgroundable;
        }
        throw new IllegalStateException("Not a backgroundable task");
    }

    public static abstract class WithResult<T, E extends Exception>
    extends Modal {
        private final Ref<T> myResult;
        private final Ref<Throwable> myError;

        public T getResult() throws E {
            Throwable t = this.myError.get();
            ExceptionUtil.rethrowUnchecked(t);
            if (t != null) {
                throw (Exception)t;
            }
            return this.myResult.get();
        }
    }

    public static abstract class Modal
    extends Task {
        public Modal(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, boolean canBeCancelled) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/kotlin/com/intellij/openapi/progress/Task$Modal", "<init>"));
            }
            super(project, title, canBeCancelled);
        }

        @Override
        public final boolean isModal() {
            return true;
        }
    }

    public static abstract class Backgroundable
    extends Task
    implements PerformInBackgroundOption {
        protected final PerformInBackgroundOption myBackgroundOption;

        public Backgroundable(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, boolean canBeCancelled, @Nullable PerformInBackgroundOption backgroundOption) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/kotlin/com/intellij/openapi/progress/Task$Backgroundable", "<init>"));
            }
            super(project, title, canBeCancelled);
            this.myBackgroundOption = backgroundOption;
            if (StringUtil.isEmptyOrSpaces(title)) {
                LOG.warn("Empty title for backgroundable task.", new Throwable());
            }
        }

        @Override
        public boolean shouldStartInBackground() {
            return this.myBackgroundOption == null || this.myBackgroundOption.shouldStartInBackground();
        }

        @Override
        public final boolean isModal() {
            return false;
        }

        public boolean isConditionalModal() {
            return false;
        }
    }
}

