/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.testFramework;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.CharsetUtil;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFileBase;
import org.jetbrains.kotlin.com.intellij.util.LocalTimeCounter;

public class LightVirtualFile
extends LightVirtualFileBase {
    private CharSequence myContent;
    private Language myLanguage;

    public LightVirtualFile() {
        this("");
    }

    public LightVirtualFile(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        this(name, "");
    }

    public LightVirtualFile(@NonNls @NotNull String name, @NotNull CharSequence content) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        this(name, null, content, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(@NotNull String name, FileType fileType, @NotNull CharSequence text2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        this(name, fileType, text2, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(@NotNull String name, FileType fileType, @NotNull CharSequence text2, long modificationStamp) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        this(name, fileType, text2, CharsetUtil.extractCharsetFromFileContent(null, null, fileType, text2), modificationStamp);
    }

    public LightVirtualFile(@NotNull String name, FileType fileType, @NotNull CharSequence text2, Charset charset, long modificationStamp) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        super(name, fileType, modificationStamp);
        this.myContent = text2;
        this.setCharset(charset);
    }

    public LightVirtualFile(@NotNull String name, Language language, @NotNull CharSequence text2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        super(name, null, LocalTimeCounter.currentTime());
        this.myContent = text2;
        this.setLanguage(language);
    }

    public Language getLanguage() {
        return this.myLanguage;
    }

    public void setLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFile", "setLanguage"));
        }
        this.myLanguage = language;
        FileType type2 = language.getAssociatedFileType();
        if (type2 == null) {
            type2 = FileTypeRegistry.getInstance().getFileTypeByFileName(this.getName());
        }
        this.setFileType(type2);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM(this.contentsToByteArray(), this);
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        this.assertWritable();
        OutputStream outputStream2 = VfsUtilCore.outputStreamAddingBOM(new ByteArrayOutputStream(){

            @Override
            public void close() {
                assert (LightVirtualFile.this.isWritable());
                LightVirtualFile.this.setModificationStamp(newModificationStamp);
                try {
                    LightVirtualFile.this.myContent = this.toString(LightVirtualFile.this.getCharset().name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }, this);
        if (outputStream2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFile", "getOutputStream"));
        }
        return outputStream2;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        Charset charset = this.getCharset();
        String s = this.getContent().toString();
        byte[] byArray = s.getBytes(charset.name());
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFile", "contentsToByteArray"));
        }
        return byArray;
    }

    @NotNull
    public CharSequence getContent() {
        CharSequence charSequence = this.myContent;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/testFramework/LightVirtualFile", "getContent"));
        }
        return charSequence;
    }

    @Override
    public String toString() {
        return "LightVirtualFile: " + this.getPresentableUrl();
    }
}

