/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.concurrency;

import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;

public class Semaphore {
    private final Sync sync = new Sync();

    public Semaphore() {
    }

    public Semaphore(int downs) {
        assert (downs >= 0) : "A nonnegative amount of 'downs' expected, found " + downs;
        for (int i = 0; i < downs; ++i) {
            this.down();
        }
    }

    public void up() {
        this.tryUp();
    }

    public boolean tryUp() {
        return this.sync.releaseShared(1);
    }

    public void down() {
        this.sync.down();
    }

    public void waitFor() {
        try {
            this.waitForUnsafe();
        }
        catch (InterruptedException e) {
            throw new ProcessCanceledException(e);
        }
    }

    public void waitForUnsafe() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private Sync() {
        }

        @Override
        public int tryAcquireShared(int acquires) {
            return this.getState() == 0 ? 1 : -1;
        }

        @Override
        public boolean tryReleaseShared(int releases) {
            int next;
            int c;
            do {
                if ((c = this.getState()) != 0) continue;
                return false;
            } while (!this.compareAndSetState(c, next = c - 1));
            return next == 0;
        }

        private void down() {
            int next;
            int current;
            while (!this.compareAndSetState(current = this.getState(), next = current + 1)) {
            }
        }
    }
}

