/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.util.containers.PeekableIterator;

public class FilteringIterator<Dom, E extends Dom>
implements PeekableIterator<E> {
    private final Iterator<Dom> myDelegate;
    private final Condition<? super Dom> myCondition;
    private boolean myNextObtained;
    private boolean myCurrentIsValid;
    private Dom myCurrent;
    private Boolean myCurrentPassedFilter;

    public FilteringIterator(@NotNull Iterator<Dom> delegate2, @NotNull Condition<? super Dom> condition) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/com/intellij/util/containers/FilteringIterator", "<init>"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/FilteringIterator", "<init>"));
        }
        this.myDelegate = delegate2;
        this.myCondition = condition;
    }

    private void obtainNext() {
        if (this.myNextObtained) {
            return;
        }
        boolean hasNext = this.myDelegate.hasNext();
        this.setCurrent(hasNext ? (Dom)this.myDelegate.next() : null);
        this.myCurrentIsValid = hasNext;
        this.myNextObtained = true;
    }

    @Override
    public boolean hasNext() {
        this.obtainNext();
        if (!this.myCurrentIsValid) {
            return false;
        }
        boolean value = this.isCurrentPassesFilter();
        while (!value && this.myDelegate.hasNext()) {
            Dom next = this.myDelegate.next();
            this.setCurrent(next);
            value = this.isCurrentPassesFilter();
        }
        return value;
    }

    private void setCurrent(Dom next) {
        this.myCurrent = next;
        this.myCurrentPassedFilter = null;
    }

    private boolean isCurrentPassesFilter() {
        if (this.myCurrentPassedFilter != null) {
            return this.myCurrentPassedFilter;
        }
        boolean passed = this.myCondition.value(this.myCurrent);
        this.myCurrentPassedFilter = passed;
        return passed;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Dom result2 = this.myCurrent;
        this.myNextObtained = false;
        return (E)result2;
    }

    @Override
    public void remove() {
        if (this.myNextObtained) {
            throw new IllegalStateException();
        }
        this.myDelegate.remove();
    }

    public static <T> InstanceOf<T> instanceOf(Class<T> aClass2) {
        return new InstanceOf<T>(aClass2);
    }

    public static class InstanceOf<T>
    implements Condition<Object> {
        private final Class<T> myInstancesClass;

        public InstanceOf(Class<T> instancesClass) {
            this.myInstancesClass = instancesClass;
        }

        @Override
        public boolean value(Object object) {
            return this.myInstancesClass.isInstance(object);
        }
    }
}

