/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.codegen;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegenKt$WhenMappings;
import org.jetbrains.kotlin.backend.jvm.descriptors.JvmDescriptorWithExtraFlags;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElement;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\tH\u0002\u001a\n\u0010\u0013\u001a\u00020\u0012*\u00020\u0014\u001a\n\u0010\u0015\u001a\u00020\u0012*\u00020\t\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u001a\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"OtherOrigin", "Lorg/jetbrains/kotlin/resolve/jvm/diagnostics/JvmDeclarationOrigin;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getOtherOrigin", "(Lorg/jetbrains/kotlin/ir/declarations/IrField;)Lorg/jetbrains/kotlin/resolve/jvm/diagnostics/JvmDeclarationOrigin;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/resolve/jvm/diagnostics/JvmDeclarationOrigin;", "effectiveModality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "getEffectiveModality", "(Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;)Lorg/jetbrains/kotlin/descriptors/Modality;", "psiElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithSource;", "getPsiElement", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithSource;)Lcom/intellij/psi/PsiElement;", "calcModalityFlag", "", "calculateClassFlags", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "calculateCommonFlags", "backend"})
public final class ClassCodegenKt {
    public static final int calculateClassFlags(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int flags = 0;
        flags |= DescriptorUtils.isInterface($receiver) || DescriptorUtils.isAnnotationClass($receiver) ? 512 : 32;
        flags |= ClassCodegenKt.calcModalityFlag($receiver);
        flags |= AsmUtil.getVisibilityAccessFlagForClass($receiver);
        flags |= Intrinsics.areEqual((Object)((Object)$receiver.getKind()), (Object)((Object)ClassKind.ENUM_CLASS)) ? 16384 : 0;
        return flags |= Intrinsics.areEqual((Object)((Object)$receiver.getKind()), (Object)((Object)ClassKind.ANNOTATION_CLASS)) ? 8192 : 0;
    }

    public static final int calculateCommonFlags(@NotNull MemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int flags = 0;
        if (Visibilities.isPrivate($receiver.getVisibility())) {
            flags |= 2;
        } else if (Intrinsics.areEqual((Object)$receiver.getVisibility(), (Object)Visibilities.PUBLIC) || Intrinsics.areEqual((Object)$receiver.getVisibility(), (Object)Visibilities.INTERNAL)) {
            flags |= 1;
        } else if (Intrinsics.areEqual((Object)$receiver.getVisibility(), (Object)Visibilities.PROTECTED)) {
            flags |= 4;
        } else if (!Intrinsics.areEqual((Object)$receiver.getVisibility(), (Object)JavaVisibilities.PACKAGE_VISIBILITY)) {
            throw (Throwable)new RuntimeException("Unsupported visibility " + $receiver.getVisibility() + " for descriptor " + $receiver);
        }
        flags |= ClassCodegenKt.calcModalityFlag($receiver);
        if ($receiver instanceof JvmDescriptorWithExtraFlags) {
            flags |= ((JvmDescriptorWithExtraFlags)((Object)$receiver)).getExtraFlags();
        }
        return flags;
    }

    private static final int calcModalityFlag(@NotNull MemberDescriptor $receiver) {
        int flags = 0;
        switch (ClassCodegenKt$WhenMappings.$EnumSwitchMapping$0[ClassCodegenKt.getEffectiveModality($receiver).ordinal()]) {
            case 1: {
                flags |= 0x400;
                break;
            }
            case 2: {
                if ($receiver instanceof ConstructorDescriptor || DescriptorUtils.isEnumClass($receiver)) break;
                flags |= 0x10;
                break;
            }
            case 3: {
                boolean bl;
                boolean bl2 = bl = !Visibilities.isPrivate($receiver.getVisibility());
                if (!_Assertions.ENABLED || bl) break;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            default: {
                throw (Throwable)new RuntimeException("Unsupported modality " + (Object)((Object)$receiver.getModality()) + " for descriptor " + $receiver);
            }
        }
        if ($receiver instanceof CallableMemberDescriptor && !($receiver instanceof ConstructorDescriptor) && ((CallableMemberDescriptor)$receiver).getDispatchReceiverParameter() == null) {
            flags |= 8;
        }
        return flags;
    }

    private static final Modality getEffectiveModality(@NotNull MemberDescriptor $receiver) {
        if ($receiver instanceof ClassDescriptor && Intrinsics.areEqual((Object)((Object)((ClassDescriptor)$receiver).getKind()), (Object)((Object)ClassKind.ENUM_CLASS)) && JvmCodegenUtil.hasAbstractMembers((ClassDescriptor)$receiver)) {
            return Modality.ABSTRACT;
        }
        if (DescriptorUtils.isSealedClass($receiver) || DescriptorUtils.isAnnotationClass($receiver) || DescriptorUtils.isAnnotationClass($receiver.getContainingDeclaration())) {
            return Modality.ABSTRACT;
        }
        Modality modality = $receiver.getModality();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)modality), (String)"modality");
        return modality;
    }

    private static final PsiElement getPsiElement(@NotNull DeclarationDescriptorWithSource $receiver) {
        SourceElement sourceElement = $receiver.getSource();
        if (!(sourceElement instanceof PsiSourceElement)) {
            sourceElement = null;
        }
        PsiSourceElement psiSourceElement = (PsiSourceElement)sourceElement;
        return psiSourceElement != null ? psiSourceElement.getPsi() : null;
    }

    private static final JvmDeclarationOrigin getOtherOrigin(@NotNull IrField $receiver) {
        return JvmDeclarationOriginKt.OtherOrigin(ClassCodegenKt.getPsiElement($receiver.getDescriptor()), $receiver.getDescriptor());
    }

    @NotNull
    public static final JvmDeclarationOrigin getOtherOrigin(@NotNull IrFunction $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return JvmDeclarationOriginKt.OtherOrigin(ClassCodegenKt.getPsiElement($receiver.getDescriptor()), $receiver.getDescriptor());
    }

    @NotNull
    public static final /* synthetic */ JvmDeclarationOrigin access$getOtherOrigin$p(@NotNull IrField $receiver) {
        return ClassCodegenKt.getOtherOrigin($receiver);
    }

    @Nullable
    public static final /* synthetic */ PsiElement access$getPsiElement$p(@NotNull DeclarationDescriptorWithSource $receiver) {
        return ClassCodegenKt.getPsiElement($receiver);
    }
}

