/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;

public abstract class HierarchicalMethodSignature
extends MethodSignatureBackedByPsiMethod {
    public HierarchicalMethodSignature(@NotNull MethodSignatureBackedByPsiMethod signature) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/com/intellij/psi/HierarchicalMethodSignature", "<init>"));
        }
        super(signature.getMethod(), signature.getSubstitutor(), signature.isRaw(), HierarchicalMethodSignature.getParameterTypes(signature.getMethod()), signature.getTypeParameters());
    }

    @NotNull
    private static PsiType[] getParameterTypes(PsiMethod method) {
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiType[] paramTypes = PsiType.createArray(parameters2.length);
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypes[i] = parameters2[i].getType();
        }
        if (paramTypes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/HierarchicalMethodSignature", "getParameterTypes"));
        }
        return paramTypes;
    }

    @NotNull
    public abstract List<HierarchicalMethodSignature> getSuperSignatures();

    @NotNull
    public List<HierarchicalMethodSignature> getInaccessibleSuperSignatures() {
        List<HierarchicalMethodSignature> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/HierarchicalMethodSignature", "getInaccessibleSuperSignatures"));
        }
        return list2;
    }
}

