/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.scope.processor;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.JavaScopeProcessorEvent;
import org.jetbrains.kotlin.com.intellij.psi.scope.NameHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.FilterScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public class ConflictFilterProcessor
extends FilterScopeProcessor<CandidateInfo>
implements NameHint {
    private final PsiConflictResolver[] myResolvers;
    private JavaResolveResult[] myCachedResult;
    protected String myName;
    protected final PsiElement myPlace;
    protected final PsiFile myPlaceFile;

    public ConflictFilterProcessor(String name, @NotNull ElementFilter filter2, @NotNull PsiConflictResolver[] resolvers, @NotNull List<CandidateInfo> container2, @NotNull PsiElement place, PsiFile placeFile) {
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/ConflictFilterProcessor", "<init>"));
        }
        if (resolvers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvers", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/ConflictFilterProcessor", "<init>"));
        }
        if (container2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/ConflictFilterProcessor", "<init>"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/ConflictFilterProcessor", "<init>"));
        }
        super(filter2, container2);
        this.myResolvers = resolvers;
        this.myName = name;
        this.myPlace = place;
        this.myPlaceFile = placeFile;
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/ConflictFilterProcessor", "execute"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/ConflictFilterProcessor", "execute"));
        }
        JavaResolveResult[] cachedResult = this.myCachedResult;
        if (cachedResult != null && cachedResult.length == 1 && cachedResult[0].isAccessible()) {
            return false;
        }
        if (this.myName == null || PsiUtil.checkName(element, this.myName, this.myPlace)) {
            return super.execute(element, state2);
        }
        return true;
    }

    @Override
    protected void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/ConflictFilterProcessor", "add"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/ConflictFilterProcessor", "add"));
        }
        this.add(new CandidateInfo(element, substitutor2));
    }

    protected void add(CandidateInfo info) {
        this.myCachedResult = null;
        this.myResults.add(info);
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/ConflictFilterProcessor", "handleEvent"));
        }
        if (event == JavaScopeProcessorEvent.CHANGE_LEVEL && this.myName != null) {
            this.getResult();
        }
    }

    @NotNull
    public JavaResolveResult[] getResult() {
        JavaResolveResult[] cachedResult = this.myCachedResult;
        if (cachedResult == null) {
            List<CandidateInfo> conflicts = this.getResults();
            if (!conflicts.isEmpty()) {
                for (PsiConflictResolver resolver2 : this.myResolvers) {
                    CandidateInfo candidate = resolver2.resolveConflict(conflicts);
                    if (candidate == null) continue;
                    conflicts.clear();
                    conflicts.add(candidate);
                    break;
                }
            }
            cachedResult = conflicts.toArray(new JavaResolveResult[conflicts.size()]);
            this.myCachedResult = cachedResult;
        }
        if (cachedResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/ConflictFilterProcessor", "getResult"));
        }
        return cachedResult;
    }

    @Override
    public String getName(@NotNull ResolveState state2) {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/ConflictFilterProcessor", "getName"));
        }
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/ConflictFilterProcessor", "getHint"));
        }
        if (hintKey == NameHint.KEY) {
            return (T)(this.myName != null ? this : null);
        }
        return super.getHint(hintKey);
    }
}

