/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.scope.processor;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.NameHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class MethodResolveProcessor
implements ElementClassHint,
NameHint,
PsiScopeProcessor {
    private final String myNameHint;
    private final List<PsiMethod> myMethods = new ArrayList<PsiMethod>();

    public MethodResolveProcessor() {
        this.myNameHint = null;
    }

    public MethodResolveProcessor(String name) {
        this.myNameHint = name;
    }

    public PsiMethod[] getMethods() {
        return this.myMethods.toArray(new PsiMethod[this.myMethods.size()]);
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolveProcessor", "execute"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolveProcessor", "execute"));
        }
        if (element instanceof PsiMethod) {
            ContainerUtil.addIfNotNull(this.myMethods, (PsiMethod)element);
        }
        return true;
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolveProcessor", "getHint"));
        }
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        if (hintKey == NameHint.KEY && this.myNameHint != null) {
            return (T)this;
        }
        return null;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolveProcessor", "handleEvent"));
        }
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        return kind == ElementClassHint.DeclarationKind.METHOD;
    }

    public static PsiMethod[] findMethod(PsiClass psiClass, String methodName) {
        MethodResolveProcessor processor = new MethodResolveProcessor(methodName);
        psiClass.processDeclarations(processor, ResolveState.initial(), null, psiClass);
        return processor.getMethods();
    }

    public static PsiMethod[] getAllMethods(PsiClass psiClass) {
        MethodResolveProcessor processor = new MethodResolveProcessor();
        psiClass.processDeclarations(processor, ResolveState.initial(), null, psiClass);
        return processor.getMethods();
    }

    @Override
    @Nullable
    public String getName(@NotNull ResolveState state2) {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolveProcessor", "getName"));
        }
        return this.myNameHint;
    }
}

