/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/resolve/JsTypeSpecificityComparator;", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "()V", "checkOnlyDynamicFlexibleType", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isDefinitelyLessSpecific", "", "specific", "general", "js.frontend"})
public final class JsTypeSpecificityComparator
implements TypeSpecificityComparator {
    public static final JsTypeSpecificityComparator INSTANCE;

    private final void checkOnlyDynamicFlexibleType(KotlinType type2) {
        if (FlexibleTypesKt.isFlexible(type2)) {
            boolean bl = DynamicTypesKt.isDynamic(type2);
            if (_Assertions.ENABLED && !bl) {
                String string = "Unexpected flexible type in Js: " + type2;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
    }

    @Override
    public boolean isDefinitelyLessSpecific(@NotNull KotlinType specific, @NotNull KotlinType general) {
        Intrinsics.checkParameterIsNotNull((Object)specific, (String)"specific");
        Intrinsics.checkParameterIsNotNull((Object)general, (String)"general");
        this.checkOnlyDynamicFlexibleType(specific);
        this.checkOnlyDynamicFlexibleType(general);
        return DynamicTypesKt.isDynamic(specific) && !DynamicTypesKt.isDynamic(general);
    }

    private JsTypeSpecificityComparator() {
        INSTANCE = this;
    }

    static {
        new JsTypeSpecificityComparator();
    }
}

