/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionsDataFlowExtras;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/RuntimeAssertionsTypeChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkType", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "frontend.java"})
public final class RuntimeAssertionsTypeChecker
implements AdditionalTypeChecker {
    public static final RuntimeAssertionsTypeChecker INSTANCE;

    @Override
    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)expressionType, (String)"expressionType");
        Intrinsics.checkParameterIsNotNull((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkParameterIsNotNull(c, (String)"c");
        if (TypeUtils.noExpectedType(c.expectedType)) {
            return;
        }
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"c.expectedType");
        RuntimeAssertionInfo assertionInfo = RuntimeAssertionInfo.Companion.create(kotlinType, expressionType, new RuntimeAssertionsDataFlowExtras(c, DataFlowValueFactory.createDataFlowValue(expression2, expressionType, c), expression2));
        if (assertionInfo != null) {
            c.trace.record(JvmBindingContextSlices.RUNTIME_ASSERTION_INFO, expression2, assertionInfo);
        }
    }

    private RuntimeAssertionsTypeChecker() {
        INSTANCE = this;
    }

    static {
        new RuntimeAssertionsTypeChecker();
    }

    @Override
    public void checkReceiver(@NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, boolean safeAccess, @NotNull CallResolutionContext<?> c) {
        Intrinsics.checkParameterIsNotNull((Object)receiverParameter, (String)"receiverParameter");
        Intrinsics.checkParameterIsNotNull((Object)receiverArgument, (String)"receiverArgument");
        Intrinsics.checkParameterIsNotNull(c, (String)"c");
        AdditionalTypeChecker.DefaultImpls.checkReceiver(this, receiverParameter, receiverArgument, safeAccess, c);
    }
}

