/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.resolve.calls.KotlinResolutionConfigurationKt;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.tower.KotlinToResolvedCallTransformerKt;
import org.jetbrains.kotlin.types.KotlinType;

public class OverloadResolutionResultsUtil {
    @NotNull
    public static <D extends CallableDescriptor> OverloadResolutionResults<D> ambiguity(OverloadResolutionResults<D> results1, OverloadResolutionResults<D> results2) {
        ArrayList resultingCalls = Lists.newArrayList();
        resultingCalls.addAll(results1.getResultingCalls());
        resultingCalls.addAll(results2.getResultingCalls());
        return OverloadResolutionResultsImpl.ambiguity(resultingCalls);
    }

    @Nullable
    public static <D extends CallableDescriptor> KotlinType getResultingType(@NotNull OverloadResolutionResults<D> results, @NotNull ContextDependency contextDependency) {
        ResolvedCall<D> resultingCall = OverloadResolutionResultsUtil.getResultingCall(results, contextDependency);
        return resultingCall != null ? resultingCall.getResultingDescriptor().getReturnType() : null;
    }

    @Nullable
    public static <D extends CallableDescriptor> ResolvedCall<D> getResultingCall(@NotNull OverloadResolutionResults<D> results, @NotNull ContextDependency contextDependency) {
        if (results.isSingleResult() && contextDependency == ContextDependency.INDEPENDENT) {
            ResolvedCall<D> resultingCall = results.getResultingCall();
            if (!KotlinResolutionConfigurationKt.getUSE_NEW_INFERENCE() ? !((MutableResolvedCall)resultingCall).hasInferredReturnType() : KotlinToResolvedCallTransformerKt.isNewNotCompleted(resultingCall)) {
                return null;
            }
        }
        return results.isSingleResult() ? results.getResultingCall() : null;
    }
}

