/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Iconable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaDirectoryService;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.kotlin.com.intellij.psi.impl.ElementBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.ElementPresentationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.ResolveScopeManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.ScopedClassHierarchy;
import org.jetbrains.kotlin.com.intellij.psi.impl.TypeCorrector;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.ClassInnerStuffCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiImmediateClassType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassFilter;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.NameHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.FilterScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.MethodResolverProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.PackageScope;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.ParameterizedCachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.ParameterizedCachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.ui.IconDeferrer;
import org.jetbrains.kotlin.com.intellij.ui.RowIcon;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.PairProcessor;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentFactoryMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.HashSet;
import org.jetbrains.kotlin.gnu.trove.THashMap;
import org.jetbrains.kotlin.gnu.trove.THashSet;

public class PsiClassImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiClassImplUtil");
    private static final Key<ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass>> MAP_IN_CLASS_KEY = Key.create("MAP_KEY");
    private static final Function<ClassIconRequest, Icon> FULL_ICON_EVALUATOR = r -> {
        if (!((ClassIconRequest)r).psiClass.isValid() || ((ClassIconRequest)r).psiClass.getProject().isDisposed()) {
            return null;
        }
        boolean isLocked = BitUtil.isSet(((ClassIconRequest)r).flags, 2) && !((ClassIconRequest)r).psiClass.isWritable();
        Icon symbolIcon = ((ClassIconRequest)r).symbolIcon != null ? ((ClassIconRequest)r).symbolIcon : ElementPresentationUtil.getClassIconOfKind(((ClassIconRequest)r).psiClass, ElementPresentationUtil.getClassKind(((ClassIconRequest)r).psiClass));
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(symbolIcon, ((ClassIconRequest)r).psiClass, isLocked);
        Icon result2 = ElementPresentationUtil.addVisibilityIcon(((ClassIconRequest)r).psiClass, ((ClassIconRequest)r).flags, baseIcon);
        Iconable.LastComputedIcon.put(((ClassIconRequest)r).psiClass, result2, ((ClassIconRequest)r).flags);
        return result2;
    };

    private PsiClassImplUtil() {
    }

    @NotNull
    public static PsiField[] getAllFields(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getAllFields"));
        }
        List<PsiField> map2 = PsiClassImplUtil.getAllByMap(aClass2, MemberType.FIELD);
        PsiField[] psiFieldArray = map2.toArray(new PsiField[map2.size()]);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getAllFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiMethod[] getAllMethods(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getAllMethods"));
        }
        List<PsiMethod> methods2 = PsiClassImplUtil.getAllByMap(aClass2, MemberType.METHOD);
        PsiMethod[] psiMethodArray = methods2.toArray(new PsiMethod[methods2.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getAllMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiClass[] getAllInnerClasses(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getAllInnerClasses"));
        }
        List<PsiClass> classes2 = PsiClassImplUtil.getAllByMap(aClass2, MemberType.CLASS);
        PsiClass[] psiClassArray = classes2.toArray(new PsiClass[classes2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getAllInnerClasses"));
        }
        return psiClassArray;
    }

    @Nullable
    public static PsiField findFieldByName(@NotNull PsiClass aClass2, String name, boolean checkBases) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findFieldByName"));
        }
        List<PsiMember> byMap = PsiClassImplUtil.findByMap(aClass2, name, checkBases, MemberType.FIELD);
        return byMap.isEmpty() ? null : (PsiField)byMap.get(0);
    }

    @NotNull
    public static PsiMethod[] findMethodsByName(@NotNull PsiClass aClass2, String name, boolean checkBases) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findMethodsByName"));
        }
        List<PsiMember> methods2 = PsiClassImplUtil.findByMap(aClass2, name, checkBases, MemberType.METHOD);
        PsiMethod[] psiMethodArray = methods2.toArray(new PsiMethod[methods2.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findMethodsByName"));
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass aClass2, @NotNull PsiMethod patternMethod, boolean checkBases) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findMethodBySignature"));
        }
        if (patternMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMethod", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findMethodBySignature"));
        }
        List<PsiMethod> result2 = PsiClassImplUtil.findMethodsBySignature(aClass2, patternMethod, checkBases, true);
        return result2.isEmpty() ? null : result2.get(0);
    }

    @NotNull
    public static PsiMethod[] findMethodsBySignature(@NotNull PsiClass aClass2, @NotNull PsiMethod patternMethod, boolean checkBases) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        if (patternMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMethod", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        List<PsiMethod> methods2 = PsiClassImplUtil.findMethodsBySignature(aClass2, patternMethod, checkBases, false);
        PsiMethod[] psiMethodArray = methods2.toArray(new PsiMethod[methods2.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        return psiMethodArray;
    }

    @NotNull
    private static List<PsiMethod> findMethodsBySignature(@NotNull PsiClass aClass2, @NotNull PsiMethod patternMethod, boolean checkBases, boolean stopOnFirst) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        if (patternMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMethod", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        PsiMethod[] methodsByName = aClass2.findMethodsByName(patternMethod.getName(), checkBases);
        if (methodsByName.length == 0) {
            List<PsiMethod> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
            }
            return list2;
        }
        SmartList<PsiMethod> methods2 = new SmartList<PsiMethod>();
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : methodsByName) {
            PsiClass superClass = method.getContainingClass();
            PsiSubstitutor substitutor2 = checkBases && !aClass2.equals(superClass) && superClass != null ? TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass2, PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
            MethodSignature signature = method.getSignature(substitutor2);
            if (!signature.equals(patternSignature)) continue;
            methods2.add(method);
            if (stopOnFirst) break;
        }
        SmartList<PsiMethod> smartList = methods2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findMethodsBySignature"));
        }
        return smartList;
    }

    @Nullable
    public static PsiClass findInnerByName(@NotNull PsiClass aClass2, String name, boolean checkBases) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findInnerByName"));
        }
        List<PsiMember> byMap = PsiClassImplUtil.findByMap(aClass2, name, checkBases, MemberType.CLASS);
        return byMap.isEmpty() ? null : (PsiClass)byMap.get(0);
    }

    @NotNull
    private static List<PsiMember> findByMap(@NotNull PsiClass aClass2, String name, boolean checkBases, @NotNull MemberType type2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
        }
        if (name == null) {
            List<PsiMember> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
            }
            return list2;
        }
        if (checkBases) {
            PsiMember[] list3 = PsiClassImplUtil.getMap(aClass2, type2).get(name);
            if (list3 == null) {
                List<PsiMember> list4 = Collections.emptyList();
                if (list4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
                }
                return list4;
            }
            List<PsiMember> list5 = Arrays.asList(list3);
            if (list5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
            }
            return list5;
        }
        PsiNameIdentifierOwner[] members = null;
        switch (type2) {
            case METHOD: {
                members = aClass2.getMethods();
                break;
            }
            case CLASS: {
                members = aClass2.getInnerClasses();
                break;
            }
            case FIELD: {
                members = aClass2.getFields();
            }
        }
        ArrayList<PsiMember> list6 = new ArrayList<PsiMember>();
        for (PsiNameIdentifierOwner member : members) {
            if (!name.equals(member.getName())) continue;
            list6.add((PsiMember)((Object)member));
        }
        ArrayList<PsiMember> arrayList = list6;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findByMap"));
        }
        return arrayList;
    }

    @NotNull
    public static <T extends PsiMember> List<Pair<T, PsiSubstitutor>> getAllWithSubstitutorsByMap(@NotNull PsiClass aClass2, @NotNull MemberType type2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getAllWithSubstitutorsByMap"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getAllWithSubstitutorsByMap"));
        }
        List<Pair<T, PsiSubstitutor>> list2 = PsiClassImplUtil.withSubstitutors(aClass2, PsiClassImplUtil.getMap(aClass2, type2).get("Intellij-IDEA-ALL"));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getAllWithSubstitutorsByMap"));
        }
        return list2;
    }

    @NotNull
    private static <T extends PsiMember> List<T> getAllByMap(@NotNull PsiClass aClass2, @NotNull MemberType type2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getAllByMap"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getAllByMap"));
        }
        List<Pair<T, PsiSubstitutor>> pairs = PsiClassImplUtil.getAllWithSubstitutorsByMap(aClass2, type2);
        ArrayList<PsiMember> ret = new ArrayList<PsiMember>(pairs.size());
        for (int i = 0; i < pairs.size(); ++i) {
            Pair<T, PsiSubstitutor> pair = pairs.get(i);
            PsiMember t = (PsiMember)pair.getFirst();
            LOG.assertTrue(t != null, aClass2);
            ret.add(t);
        }
        ArrayList<PsiMember> arrayList = ret;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getAllByMap"));
        }
        return arrayList;
    }

    private static Map<String, PsiMember[]> getMap(@NotNull PsiClass aClass2, @NotNull MemberType type2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getMap"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getMap"));
        }
        ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> value = PsiClassImplUtil.getValues(aClass2);
        return (Map)value.getValue(aClass2).get(aClass2.getResolveScope()).get((Object)type2);
    }

    @NotNull
    private static ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> getValues(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getValues"));
        }
        ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> value = aClass2.getUserData(MAP_IN_CLASS_KEY);
        if (value == null) {
            value = CachedValuesManager.getManager(aClass2.getProject()).createParameterizedCachedValue(ByNameCachedValueProvider.INSTANCE, false);
            if (aClass2.isPhysical()) {
                value = ((UserDataHolderEx)((Object)aClass2)).putUserDataIfAbsent(MAP_IN_CLASS_KEY, value);
            }
        }
        ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> parameterizedCachedValue = value;
        if (parameterizedCachedValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getValues"));
        }
        return parameterizedCachedValue;
    }

    public static Icon getClassIcon(int flags, @NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getClassIcon"));
        }
        return PsiClassImplUtil.getClassIcon(flags, aClass2, null);
    }

    public static Icon getClassIcon(int flags, @NotNull PsiClass aClass2, @Nullable Icon symbolIcon) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getClassIcon"));
        }
        Icon base = Iconable.LastComputedIcon.get(aClass2, flags);
        if (base == null) {
            if (symbolIcon == null) {
                symbolIcon = ElementPresentationUtil.getClassIconOfKind(aClass2, ElementPresentationUtil.getBasicClassKind(aClass2));
            }
            RowIcon baseIcon = ElementBase.createLayeredIcon(aClass2, symbolIcon, 0);
            base = ElementPresentationUtil.addVisibilityIcon(aClass2, flags, baseIcon);
        }
        return IconDeferrer.getInstance().defer(base, new ClassIconRequest(aClass2, flags, symbolIcon), FULL_ICON_EVALUATOR);
    }

    @NotNull
    public static SearchScope getClassUseScope(@NotNull PsiClass aClass2) {
        PsiDirectory dir;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            LocalSearchScope localSearchScope = new LocalSearchScope(aClass2);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
            }
            return localSearchScope;
        }
        GlobalSearchScope maximalUseScope = ResolveScopeManager.getElementUseScope(aClass2);
        PsiFile file2 = aClass2.getContainingFile();
        if (PsiImplUtil.isInServerPage(file2)) {
            GlobalSearchScope globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
            }
            return globalSearchScope;
        }
        PsiClass containingClass = aClass2.getContainingClass();
        if (aClass2.hasModifierProperty("public") || aClass2.hasModifierProperty("protected")) {
            SearchScope searchScope = containingClass == null ? maximalUseScope : containingClass.getUseScope();
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
            }
            return searchScope;
        }
        if (aClass2.hasModifierProperty("private") || aClass2 instanceof PsiTypeParameter) {
            PsiClass topClass = PsiUtil.getTopLevelClass(aClass2);
            LocalSearchScope localSearchScope = new LocalSearchScope(topClass == null ? aClass2.getContainingFile() : topClass);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
            }
            return localSearchScope;
        }
        PsiPackage aPackage = null;
        if (file2 instanceof PsiJavaFile) {
            aPackage = JavaPsiFacade.getInstance(aClass2.getProject()).findPackage(((PsiJavaFile)file2).getPackageName());
        }
        if (aPackage == null && (dir = file2.getContainingDirectory()) != null) {
            aPackage = JavaDirectoryService.getInstance().getPackage(dir);
        }
        if (aPackage != null) {
            SearchScope scope = PackageScope.packageScope(aPackage, false);
            SearchScope searchScope = scope = ((SearchScope)scope).intersectWith(maximalUseScope);
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
            }
            return searchScope;
        }
        LocalSearchScope localSearchScope = new LocalSearchScope(file2);
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getClassUseScope"));
        }
        return localSearchScope;
    }

    public static boolean isMainOrPremainMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "isMainOrPremainMethod"));
        }
        if (!PsiType.VOID.equals(method.getReturnType())) {
            return false;
        }
        String name = method.getName();
        if (!("main".equals(name) || "premain".equals(name) || "agentmain".equals(name))) {
            return false;
        }
        PsiElementFactory factory2 = JavaPsiFacade.getInstance(method.getProject()).getElementFactory();
        MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
        try {
            MethodSignature main2 = PsiClassImplUtil.createSignatureFromText(factory2, "void main(String[] args);");
            if (MethodSignatureUtil.areSignaturesEqual(signature, main2)) {
                return true;
            }
            MethodSignature premain = PsiClassImplUtil.createSignatureFromText(factory2, "void premain(String args, java.lang.instrument.Instrumentation i);");
            if (MethodSignatureUtil.areSignaturesEqual(signature, premain)) {
                return true;
            }
            MethodSignature agentmain = PsiClassImplUtil.createSignatureFromText(factory2, "void agentmain(String args, java.lang.instrument.Instrumentation i);");
            if (MethodSignatureUtil.areSignaturesEqual(signature, agentmain)) {
                return true;
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
        return false;
    }

    @NotNull
    private static MethodSignature createSignatureFromText(@NotNull PsiElementFactory factory2, @NotNull String text2) {
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "createSignatureFromText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "createSignatureFromText"));
        }
        MethodSignature methodSignature = factory2.createMethodFromText(text2, null).getSignature(PsiSubstitutor.EMPTY);
        if (methodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "createSignatureFromText"));
        }
        return methodSignature;
    }

    public static boolean processDeclarationsInEnum(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, @NotNull ClassInnerStuffCache innerStuffCache) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInEnum"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInEnum"));
        }
        if (innerStuffCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerStuffCache", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInEnum"));
        }
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            PsiMethod method;
            NameHint nameHint = processor.getHint(NameHint.KEY);
            if ((nameHint == null || "values".equals(nameHint.getName(state2))) && (method = innerStuffCache.getValuesMethod()) != null && !processor.execute(method, ResolveState.initial())) {
                return false;
            }
            if ((nameHint == null || "valueOf".equals(nameHint.getName(state2))) && (method = innerStuffCache.getValueOfMethod()) != null && !processor.execute(method, ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    public static boolean processDeclarationsInClass(@NotNull PsiClass aClass2, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, @Nullable Set<PsiClass> visited2, PsiElement last, @NotNull PsiElement place, @NotNull LanguageLevel languageLevel, boolean isRaw) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        return PsiClassImplUtil.processDeclarationsInClass(aClass2, processor, state2, visited2, last, place, languageLevel, isRaw, place.getResolveScope());
    }

    private static boolean processDeclarationsInClass(@NotNull PsiClass aClass2, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, @Nullable Set<PsiClass> visited2, PsiElement last, @NotNull PsiElement place, @NotNull LanguageLevel languageLevel, boolean isRaw, @NotNull GlobalSearchScope resolveScope) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClass"));
        }
        if (last instanceof PsiTypeParameterList || last instanceof PsiModifierList && aClass2.getModifierList() == last) {
            return true;
        }
        if (visited2 != null && visited2.contains(aClass2)) {
            return true;
        }
        PsiSubstitutor substitutor2 = state2.get(PsiSubstitutor.KEY);
        isRaw = isRaw || PsiUtil.isRawSubstitutor(aClass2, substitutor2);
        NameHint nameHint = processor.getHint(NameHint.KEY);
        if (nameHint != null) {
            String name = nameHint.getName(state2);
            return PsiClassImplUtil.processCachedMembersByName(aClass2, processor, state2, visited2, last, place, isRaw, substitutor2, PsiClassImplUtil.getValues(aClass2).getValue(aClass2).get(resolveScope), name, languageLevel);
        }
        return PsiClassImplUtil.processDeclarationsInClassNotCached(aClass2, processor, state2, visited2, last, place, isRaw, languageLevel, resolveScope);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean processCachedMembersByName(final @NotNull PsiClass aClass2, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, @Nullable Set<PsiClass> visited2, PsiElement last, final @NotNull PsiElement place, final boolean isRaw, final @NotNull PsiSubstitutor substitutor2, @NotNull MembersMap value, String name, final @NotNull LanguageLevel languageLevel) {
        PsiClass containingClass;
        boolean resolved;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processCachedMembersByName"));
        }
        Function<PsiMember, PsiSubstitutor> finalSubstitutor = new Function<PsiMember, PsiSubstitutor>(){
            final ScopedClassHierarchy hierarchy;
            final PsiElementFactory factory;
            {
                this.hierarchy = ScopedClassHierarchy.getHierarchy(aClass2, place.getResolveScope());
                this.factory = JavaPsiFacade.getInstance(aClass2.getProject()).getElementFactory();
            }

            @Override
            public PsiSubstitutor fun(PsiMember member) {
                PsiClass containingClass;
                PsiSubstitutor superSubstitutor = this.hierarchy.getSuperMembersSubstitutor(containingClass = ObjectUtils.assertNotNull(member.getContainingClass()), languageLevel);
                PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(containingClass, superSubstitutor == null ? PsiSubstitutor.EMPTY : superSubstitutor, aClass2, substitutor2, this.factory, languageLevel);
                return member instanceof PsiMethod ? PsiClassImplUtil.checkRaw(isRaw, this.factory, (PsiMethod)member, finalSubstitutor) : finalSubstitutor;
            }
        };
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) {
            PsiField fieldByName = aClass2.findFieldByName(name, false);
            if (fieldByName != null) {
                processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass2);
                if (!processor.execute(fieldByName, state2)) {
                    return false;
                }
            } else {
                Map allFieldsMap = (Map)value.get((Object)MemberType.FIELD);
                PsiMember[] list2 = (PsiMember[])allFieldsMap.get(name);
                if (list2 != null) {
                    resolved = false;
                    for (PsiMember candidateField : list2) {
                        containingClass = candidateField.getContainingClass();
                        if (containingClass == null) {
                            LOG.error("No class for field " + candidateField.getName() + " of " + candidateField.getClass());
                            continue;
                        }
                        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                        if (processor.execute(candidateField, state2.put(PsiSubstitutor.KEY, finalSubstitutor.fun(candidateField)))) continue;
                        resolved = true;
                    }
                    if (resolved) {
                        return false;
                    }
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            if (last != null && last.getContext() == aClass2) {
                if (last instanceof PsiClass && !processor.execute(last, state2)) {
                    return false;
                }
                PsiTypeParameterList list3 = aClass2.getTypeParameterList();
                if (list3 != null && !list3.processDeclarations(processor, state2, last, place)) {
                    return false;
                }
            }
            if (!(last instanceof PsiReferenceList)) {
                PsiClass classByName = aClass2.findInnerClassByName(name, false);
                if (classByName != null) {
                    processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass2);
                    if (!processor.execute(classByName, state2)) {
                        return false;
                    }
                } else {
                    Map allClassesMap = (Map)value.get((Object)MemberType.CLASS);
                    PsiMember[] list2 = (PsiMember[])allClassesMap.get(name);
                    if (list2 != null) {
                        resolved = false;
                        for (PsiMember inner : list2) {
                            containingClass = inner.getContainingClass();
                            if (containingClass == null) continue;
                            processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                            if (processor.execute(inner, state2.put(PsiSubstitutor.KEY, finalSubstitutor.fun(inner)))) continue;
                            resolved = true;
                        }
                        if (resolved) {
                            return false;
                        }
                    }
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            MethodResolverProcessor methodResolverProcessor;
            if (processor instanceof MethodResolverProcessor && (methodResolverProcessor = (MethodResolverProcessor)processor).isConstructor()) {
                PsiMethod[] constructors2 = aClass2.getConstructors();
                methodResolverProcessor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass2);
                for (PsiMember psiMember : constructors2) {
                    if (methodResolverProcessor.execute(psiMember, state2)) continue;
                    return false;
                }
                return true;
            }
            Map allMethodsMap = (Map)value.get((Object)MemberType.METHOD);
            PsiMember[] list4 = (PsiMember[])allMethodsMap.get(name);
            if (list4 != null) {
                void var18_26;
                boolean resolved2 = false;
                PsiMember[] psiMemberArray = list4;
                int n = psiMemberArray.length;
                boolean bl = false;
                while (var18_26 < n) {
                    PsiMember candidate2 = psiMemberArray[var18_26];
                    ProgressIndicatorProvider.checkCanceled();
                    PsiMethod candidateMethod = (PsiMethod)candidate2;
                    if (!(processor instanceof MethodResolverProcessor && candidateMethod.isConstructor() != ((MethodResolverProcessor)processor).isConstructor() || (containingClass = candidateMethod.getContainingClass()) == null || visited2 != null && visited2.contains(containingClass))) {
                        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                        if (!processor.execute(candidateMethod, state2.put(PsiSubstitutor.KEY, finalSubstitutor.fun(candidateMethod)))) {
                            resolved2 = true;
                        }
                    }
                    ++var18_26;
                }
                if (resolved2) {
                    return false;
                }
                if (visited2 != null) {
                    void var18_28;
                    psiMemberArray = list4;
                    n = psiMemberArray.length;
                    boolean bl2 = false;
                    while (var18_28 < n) {
                        PsiMember aList = psiMemberArray[var18_28];
                        visited2.add(aList.getContainingClass());
                        ++var18_28;
                    }
                }
            }
        }
        return true;
    }

    private static PsiSubstitutor checkRaw(boolean isRaw, @NotNull PsiElementFactory factory2, @NotNull PsiMethod candidateMethod, @NotNull PsiSubstitutor substitutor2) {
        PsiClass containingClass;
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "checkRaw"));
        }
        if (candidateMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateMethod", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "checkRaw"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "checkRaw"));
        }
        if (isRaw && !candidateMethod.hasModifierProperty("static") && (containingClass = candidateMethod.getContainingClass()) != null && containingClass.hasTypeParameters()) {
            PsiTypeParameter[] methodTypeParameters = candidateMethod.getTypeParameters();
            substitutor2 = factory2.createRawSubstitutor(substitutor2, methodTypeParameters);
        }
        return substitutor2;
    }

    public static PsiSubstitutor obtainFinalSubstitutor(@NotNull PsiClass candidateClass, @NotNull PsiSubstitutor candidateSubstitutor, @NotNull PsiClass aClass2, @NotNull PsiSubstitutor substitutor2, @NotNull PsiElementFactory elementFactory, @NotNull LanguageLevel languageLevel) {
        if (candidateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (candidateSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (elementFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementFactory", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "obtainFinalSubstitutor"));
        }
        if (PsiUtil.isRawSubstitutor(aClass2, substitutor2)) {
            return elementFactory.createRawSubstitutor(candidateClass).putAll(substitutor2);
        }
        PsiClassType containingType = elementFactory.createType(candidateClass, candidateSubstitutor, languageLevel);
        PsiType type2 = substitutor2.substitute(containingType);
        if (!(type2 instanceof PsiClassType)) {
            return candidateSubstitutor;
        }
        return ((PsiClassType)type2).resolveGenerics().getSubstitutor();
    }

    private static boolean processDeclarationsInClassNotCached(@NotNull PsiClass aClass2, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, @Nullable Set<PsiClass> visited2, PsiElement last, @NotNull PsiElement place, boolean isRaw, @NotNull LanguageLevel languageLevel, @NotNull GlobalSearchScope resolveScope) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processDeclarationsInClassNotCached"));
        }
        if (visited2 == null) {
            visited2 = new THashSet<PsiClass>();
        }
        if (!visited2.add(aClass2)) {
            return true;
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass2);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        NameHint nameHint = processor.getHint(NameHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) {
            if (nameHint != null) {
                PsiField fieldByName = aClass2.findFieldByName(nameHint.getName(state2), false);
                if (fieldByName != null && !processor.execute(fieldByName, state2)) {
                    return false;
                }
            } else {
                PsiField[] fields2;
                for (PsiField field : fields2 = aClass2.getFields()) {
                    if (processor.execute(field, state2)) continue;
                    return false;
                }
            }
        }
        PsiElementFactory factory2 = JavaPsiFacade.getInstance(aClass2.getProject()).getElementFactory();
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            PsiMethod[] methods2;
            PsiSubstitutor baseSubstitutor = state2.get(PsiSubstitutor.KEY);
            for (PsiMethod method : methods2 = nameHint != null ? aClass2.findMethodsByName(nameHint.getName(state2), false) : aClass2.getMethods()) {
                ResolveState methodState;
                PsiSubstitutor finalSubstitutor2 = PsiClassImplUtil.checkRaw(isRaw, factory2, method, baseSubstitutor);
                ResolveState resolveState = methodState = finalSubstitutor2 == baseSubstitutor ? state2 : state2.put(PsiSubstitutor.KEY, finalSubstitutor2);
                if (processor.execute(method, methodState)) continue;
                return false;
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiTypeParameterList list2;
            if (last != null && last.getContext() == aClass2 && (list2 = aClass2.getTypeParameterList()) != null && !list2.processDeclarations(processor, ResolveState.initial(), last, place)) {
                return false;
            }
            if (!(last instanceof PsiReferenceList) && !(last instanceof PsiModifierList)) {
                if (nameHint != null) {
                    PsiClass inner = aClass2.findInnerClassByName(nameHint.getName(state2), false);
                    if (inner != null && !processor.execute(inner, state2)) {
                        return false;
                    }
                } else {
                    PsiClass[] inners;
                    for (PsiClass inner : inners = aClass2.getInnerClasses()) {
                        if (processor.execute(inner, state2)) continue;
                        return false;
                    }
                }
            }
        }
        if (last instanceof PsiReferenceList) {
            return true;
        }
        Set<PsiClass> visited1 = visited2;
        return PsiClassImplUtil.processSuperTypes(aClass2, state2.get(PsiSubstitutor.KEY), factory2, languageLevel, resolveScope, (superClass, finalSubstitutor) -> {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "lambda$processDeclarationsInClassNotCached$1"));
            }
            if (state2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "lambda$processDeclarationsInClassNotCached$1"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "lambda$processDeclarationsInClassNotCached$1"));
            }
            if (languageLevel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "lambda$processDeclarationsInClassNotCached$1"));
            }
            if (resolveScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "lambda$processDeclarationsInClassNotCached$1"));
            }
            return PsiClassImplUtil.processDeclarationsInClass(superClass, processor, state2.put(PsiSubstitutor.KEY, finalSubstitutor), visited1, last, place, languageLevel, isRaw, resolveScope);
        });
    }

    @Nullable
    public static <T extends PsiType> T correctType(@Nullable T originalType, @NotNull GlobalSearchScope resolveScope) {
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "correctType"));
        }
        if (originalType == null || !Registry.is("java.correct.class.type.by.place.resolve.scope")) {
            return originalType;
        }
        return new TypeCorrector(resolveScope).correctType(originalType);
    }

    public static List<PsiClassType.ClassResolveResult> getScopeCorrectedSuperTypes(PsiClass aClass2, GlobalSearchScope resolveScope) {
        return ScopedClassHierarchy.getHierarchy(aClass2, resolveScope).getImmediateSupersWithCapturing();
    }

    static boolean processSuperTypes(@NotNull PsiClass aClass2, PsiSubstitutor substitutor2, @NotNull PsiElementFactory factory2, @NotNull LanguageLevel languageLevel, GlobalSearchScope resolveScope, PairProcessor<PsiClass, PsiSubstitutor> processor) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processSuperTypes"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processSuperTypes"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "processSuperTypes"));
        }
        boolean resolved = false;
        for (PsiClassType.ClassResolveResult superTypeResolveResult : PsiClassImplUtil.getScopeCorrectedSuperTypes(aClass2, resolveScope)) {
            PsiClass superClass = superTypeResolveResult.getElement();
            assert (superClass != null);
            PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(superClass, superTypeResolveResult.getSubstitutor(), aClass2, substitutor2, factory2, languageLevel);
            if (processor.process(superClass, finalSubstitutor)) continue;
            resolved = true;
        }
        return !resolved;
    }

    @Nullable
    public static PsiClass getSuperClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSuperClass"));
        }
        if (psiClass.isInterface()) {
            return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
        }
        if (psiClass.isEnum()) {
            return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Enum");
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass == null || baseClass.isInterface()) {
                return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
            }
            return baseClass;
        }
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return null;
        }
        PsiClassType[] referenceElements = psiClass.getExtendsListTypes();
        if (referenceElements.length == 0) {
            return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
        }
        PsiClass psiResolved = referenceElements[0].resolve();
        return psiResolved == null ? PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object") : psiResolved;
    }

    @Nullable
    private static PsiClass findSpecialSuperClass(@NotNull PsiClass psiClass, String className2) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findSpecialSuperClass"));
        }
        return JavaPsiFacade.getInstance(psiClass.getProject()).findClass(className2, psiClass.getResolveScope());
    }

    @NotNull
    public static PsiClass[] getSupers(@NotNull PsiClass psiClass) {
        PsiClass[] supers;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSupers"));
        }
        for (PsiClass aSuper : supers = PsiClassImplUtil.getSupersInner(psiClass)) {
            LOG.assertTrue(aSuper != null);
        }
        if (supers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSupers"));
        }
        return supers;
    }

    @NotNull
    private static PsiClass[] getSupersInner(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
        }
        PsiClassType[] extendsListTypes = psiClass.getExtendsListTypes();
        if (psiClass.isInterface()) {
            PsiClass[] psiClassArray = PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass, true);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
            }
            return psiClassArray;
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClass[] psiClassArray;
            PsiAnonymousClass psiAnonymousClass = (PsiAnonymousClass)psiClass;
            PsiClassType baseClassReference = psiAnonymousClass.getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null) {
                if (baseClass.isInterface()) {
                    PsiClass[] psiClassArray2;
                    PsiClass objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
                    if (objectClass != null) {
                        PsiClass[] psiClassArray3 = new PsiClass[2];
                        psiClassArray3[0] = objectClass;
                        psiClassArray2 = psiClassArray3;
                        psiClassArray3[1] = baseClass;
                    } else {
                        PsiClass[] psiClassArray4 = new PsiClass[1];
                        psiClassArray2 = psiClassArray4;
                        psiClassArray4[0] = baseClass;
                    }
                    if (psiClassArray2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
                    }
                    return psiClassArray2;
                }
                PsiClass[] psiClassArray5 = new PsiClass[]{baseClass};
                if (psiClassArray5 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
                }
                return psiClassArray5;
            }
            PsiClass objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
            if (objectClass != null) {
                PsiClass[] psiClassArray6 = new PsiClass[1];
                psiClassArray = psiClassArray6;
                psiClassArray6[0] = objectClass;
            } else {
                psiClassArray = PsiClass.EMPTY_ARRAY;
            }
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
            }
            return psiClassArray;
        }
        if (psiClass instanceof PsiTypeParameter) {
            if (extendsListTypes.length == 0) {
                PsiClass[] psiClassArray;
                PsiClass objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
                if (objectClass != null) {
                    PsiClass[] psiClassArray7 = new PsiClass[1];
                    psiClassArray = psiClassArray7;
                    psiClassArray7[0] = objectClass;
                } else {
                    psiClassArray = PsiClass.EMPTY_ARRAY;
                }
                if (psiClassArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
                }
                return psiClassArray;
            }
            PsiClass[] psiClassArray = PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass, false);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
            }
            return psiClassArray;
        }
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        PsiClass[] interfaces = PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass, false);
        PsiClass superClass = PsiClassImplUtil.getSuperClass(psiClass);
        if (superClass == null) {
            if (interfaces == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
            }
            return interfaces;
        }
        PsiClass[] types = new PsiClass[interfaces.length + 1];
        types[0] = superClass;
        System.arraycopy(interfaces, 0, types, 1, interfaces.length);
        if (types == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSupersInner"));
        }
        return types;
    }

    @NotNull
    public static PsiClassType[] getSuperTypes(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSuperTypes"));
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass == null || !baseClass.isInterface()) {
                PsiClassType[] psiClassTypeArray = new PsiClassType[]{baseClassType};
                if (psiClassTypeArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSuperTypes"));
                }
                return psiClassTypeArray;
            }
            PsiClassType objectType = PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{objectType, baseClassType};
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSuperTypes"));
            }
            return psiClassTypeArray;
        }
        PsiClassType[] extendsTypes = psiClass.getExtendsListTypes();
        PsiClassType[] implementsTypes = psiClass.getImplementsListTypes();
        boolean hasExtends = extendsTypes.length != 0;
        int extendsListLength = extendsTypes.length + (hasExtends ? 0 : 1);
        PsiClassType[] result2 = new PsiClassType[extendsListLength + implementsTypes.length];
        System.arraycopy(extendsTypes, 0, result2, 0, extendsTypes.length);
        if (!hasExtends) {
            PsiClassType objectType;
            if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
                if (PsiClassType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSuperTypes"));
                }
                return PsiClassType.EMPTY_ARRAY;
            }
            PsiManager manager = psiClass.getManager();
            result2[0] = objectType = PsiType.getJavaLangObject(manager, psiClass.getResolveScope());
        }
        System.arraycopy(implementsTypes, 0, result2, extendsListLength, implementsTypes.length);
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSuperTypes"));
        }
        return result2;
    }

    @NotNull
    private static PsiClassType getAnnotationSuperType(@NotNull PsiClass psiClass, @NotNull PsiElementFactory factory2) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getAnnotationSuperType"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getAnnotationSuperType"));
        }
        PsiClassType psiClassType = factory2.createTypeByFQClassName("java.lang.annotation.Annotation", psiClass.getResolveScope());
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getAnnotationSuperType"));
        }
        return psiClassType;
    }

    private static PsiClassType getEnumSuperType(@NotNull PsiClass psiClass, @NotNull PsiElementFactory factory2) {
        PsiClassType superType;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getEnumSuperType"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getEnumSuperType"));
        }
        PsiClass enumClass2 = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Enum");
        if (enumClass2 == null) {
            try {
                superType = (PsiClassType)factory2.createTypeFromText("java.lang.Enum", null);
            }
            catch (IncorrectOperationException e) {
                superType = null;
            }
        } else {
            PsiTypeParameter[] typeParameters2 = enumClass2.getTypeParameters();
            PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
            if (typeParameters2.length == 1) {
                substitutor2 = substitutor2.put(typeParameters2[0], factory2.createType(psiClass));
            }
            superType = new PsiImmediateClassType(enumClass2, substitutor2);
        }
        return superType;
    }

    @NotNull
    public static PsiClass[] getInterfaces(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
        }
        PsiClassType[] referencedTypes = typeParameter.getExtendsListTypes();
        if (referencedTypes.length == 0) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>(referencedTypes.length);
        for (PsiClassType referencedType : referencedTypes) {
            PsiClass psiClass = referencedType.resolve();
            if (psiClass == null || !psiClass.isInterface()) continue;
            result2.add(psiClass);
        }
        PsiClass[] psiClassArray = result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
        }
        return psiClassArray;
    }

    @NotNull
    public static PsiClass[] getInterfaces(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
        }
        if (psiClass.isInterface()) {
            PsiClass[] psiClassArray = PsiClassImplUtil.resolveClassReferenceList(psiClass.getExtendsListTypes(), psiClass, false);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
            }
            return psiClassArray;
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClass[] psiClassArray;
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null && baseClass.isInterface()) {
                PsiClass[] psiClassArray2 = new PsiClass[1];
                psiClassArray = psiClassArray2;
                psiClassArray2[0] = baseClass;
            } else {
                psiClassArray = PsiClass.EMPTY_ARRAY;
            }
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
            }
            return psiClassArray;
        }
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        PsiClass[] psiClassArray = PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass, false);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getInterfaces"));
        }
        return psiClassArray;
    }

    @NotNull
    private static PsiClass[] resolveClassReferenceList(@NotNull PsiClassType[] listOfTypes, @NotNull PsiClass psiClass, boolean includeObject) {
        if (listOfTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOfTypes", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "resolveClassReferenceList"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "resolveClassReferenceList"));
        }
        PsiClass objectClass = null;
        if (includeObject && (objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object")) == null) {
            includeObject = false;
        }
        if (listOfTypes.length == 0) {
            if (includeObject) {
                PsiClass[] psiClassArray = new PsiClass[]{objectClass};
                if (psiClassArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "resolveClassReferenceList"));
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "resolveClassReferenceList"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        int referenceCount = listOfTypes.length;
        if (includeObject) {
            ++referenceCount;
        }
        PsiClass[] resolved = new PsiClass[referenceCount];
        int resolvedCount = 0;
        if (includeObject) {
            resolved[resolvedCount++] = objectClass;
        }
        for (PsiClassType reference : listOfTypes) {
            PsiClass refResolved = reference.resolve();
            if (refResolved == null) continue;
            resolved[resolvedCount++] = refResolved;
        }
        if (resolvedCount < referenceCount) {
            PsiClass[] shorter = new PsiClass[resolvedCount];
            System.arraycopy(resolved, 0, shorter, 0, resolvedCount);
            resolved = shorter;
        }
        if (resolved == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "resolveClassReferenceList"));
        }
        return resolved;
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(@NotNull PsiClass psiClass, String name, boolean checkBases) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findMethodsAndTheirSubstitutorsByName"));
        }
        if (!checkBases) {
            PsiMethod[] methodsByName = psiClass.findMethodsByName(name, false);
            ArrayList<Pair<PsiMethod, PsiSubstitutor>> ret = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>(methodsByName.length);
            for (PsiMethod method : methodsByName) {
                ret.add(Pair.create(method, PsiSubstitutor.EMPTY));
            }
            ArrayList<Pair<PsiMethod, PsiSubstitutor>> arrayList = ret;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findMethodsAndTheirSubstitutorsByName"));
            }
            return arrayList;
        }
        PsiMember[] list2 = PsiClassImplUtil.getMap(psiClass, MemberType.METHOD).get(name);
        if (list2 == null) {
            List<Pair<PsiMethod, PsiSubstitutor>> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findMethodsAndTheirSubstitutorsByName"));
            }
            return list3;
        }
        List<Pair<PsiMethod, PsiSubstitutor>> list4 = PsiClassImplUtil.withSubstitutors(psiClass, list2);
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "findMethodsAndTheirSubstitutorsByName"));
        }
        return list4;
    }

    @NotNull
    private static <T extends PsiMember> List<Pair<T, PsiSubstitutor>> withSubstitutors(@NotNull PsiClass psiClass, PsiMember[] members) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "withSubstitutors"));
        }
        ScopedClassHierarchy hierarchy = ScopedClassHierarchy.getHierarchy(psiClass, psiClass.getResolveScope());
        LanguageLevel level = PsiUtil.getLanguageLevel(psiClass);
        List<Pair<T, PsiSubstitutor>> list2 = ContainerUtil.map(members, member -> {
            PsiClass containingClass = member.getContainingClass();
            PsiSubstitutor substitutor2 = containingClass == null ? null : hierarchy.getSuperMembersSubstitutor(containingClass, level);
            return Pair.create(member, substitutor2 == null ? PsiSubstitutor.EMPTY : substitutor2);
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "withSubstitutors"));
        }
        return list2;
    }

    @NotNull
    public static PsiClassType[] getExtendsListTypes(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
        }
        if (psiClass.isEnum()) {
            PsiClassType[] psiClassTypeArray;
            PsiClassType enumSuperType = PsiClassImplUtil.getEnumSuperType(psiClass, JavaPsiFacade.getInstance(psiClass.getProject()).getElementFactory());
            if (enumSuperType == null) {
                psiClassTypeArray = PsiClassType.EMPTY_ARRAY;
            } else {
                PsiClassType[] psiClassTypeArray2 = new PsiClassType[1];
                psiClassTypeArray = psiClassTypeArray2;
                psiClassTypeArray2[0] = enumSuperType;
            }
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
            }
            return psiClassTypeArray;
        }
        if (psiClass.isAnnotationType()) {
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{PsiClassImplUtil.getAnnotationSuperType(psiClass, JavaPsiFacade.getInstance(psiClass.getProject()).getElementFactory())};
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
            }
            return psiClassTypeArray;
        }
        PsiType upperBound = InferenceSession.getUpperBound(psiClass);
        if (upperBound == null && psiClass instanceof PsiTypeParameter) {
            upperBound = LambdaUtil.getFunctionalTypeMap().get(psiClass);
        }
        if (upperBound instanceof PsiIntersectionType) {
            PsiType[] conjuncts = ((PsiIntersectionType)upperBound).getConjuncts();
            ArrayList<PsiClassType> result2 = new ArrayList<PsiClassType>();
            for (PsiType conjunct : conjuncts) {
                if (!(conjunct instanceof PsiClassType)) continue;
                result2.add((PsiClassType)conjunct);
            }
            PsiClassType[] psiClassTypeArray = result2.toArray(new PsiClassType[result2.size()]);
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
            }
            return psiClassTypeArray;
        }
        if (upperBound instanceof PsiClassType) {
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{(PsiClassType)upperBound};
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
            }
            return psiClassTypeArray;
        }
        PsiReferenceList extendsList = psiClass.getExtendsList();
        if (extendsList != null) {
            PsiClassType[] psiClassTypeArray = extendsList.getReferencedTypes();
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
            }
            return psiClassTypeArray;
        }
        if (PsiClassType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getExtendsListTypes"));
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    @NotNull
    public static PsiClassType[] getImplementsListTypes(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getImplementsListTypes"));
        }
        PsiReferenceList extendsList = psiClass.getImplementsList();
        if (extendsList != null) {
            PsiClassType[] psiClassTypeArray = extendsList.getReferencedTypes();
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getImplementsListTypes"));
            }
            return psiClassTypeArray;
        }
        if (PsiClassType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getImplementsListTypes"));
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    static boolean isInExtendsList(@NotNull PsiClass psiClass, @NotNull PsiClass baseClass, @Nullable String baseName, @NotNull PsiManager manager) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "isInExtendsList"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "isInExtendsList"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "isInExtendsList"));
        }
        if (psiClass.isEnum()) {
            return "java.lang.Enum".equals(baseClass.getQualifiedName());
        }
        if (psiClass.isAnnotationType()) {
            return "java.lang.annotation.Annotation".equals(baseClass.getQualifiedName());
        }
        PsiType upperBound = InferenceSession.getUpperBound(psiClass);
        if (upperBound == null && psiClass instanceof PsiTypeParameter) {
            upperBound = LambdaUtil.getFunctionalTypeMap().get(psiClass);
        }
        if (upperBound instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)upperBound).getConjuncts()) {
                if (!(conjunct instanceof PsiClassType) || !((PsiClassType)conjunct).getClassName().equals(baseName) || !baseClass.equals(((PsiClassType)conjunct).resolve())) continue;
                return true;
            }
            return false;
        }
        if (upperBound instanceof PsiClassType) {
            return ((PsiClassType)upperBound).getClassName().equals(baseName) && baseClass.equals(((PsiClassType)upperBound).resolve());
        }
        return PsiClassImplUtil.isInReferenceList(psiClass.getExtendsList(), baseClass, baseName, manager);
    }

    static boolean isInReferenceList(@Nullable PsiReferenceList list2, @NotNull PsiClass baseClass, @Nullable String baseName, @NotNull PsiManager manager) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "isInReferenceList"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "isInReferenceList"));
        }
        if (list2 == null) {
            return false;
        }
        if (list2 instanceof StubBasedPsiElement) {
            Object stub = ((StubBasedPsiElement)((Object)list2)).getStub();
            if (stub instanceof PsiClassReferenceListStub && baseName != null) {
                PsiClassReferenceListStub classStub = (PsiClassReferenceListStub)stub;
                String[] names2 = classStub.getReferencedNames();
                for (int i = 0; i < names2.length; ++i) {
                    PsiClassType[] referencedTypes;
                    PsiClass resolved;
                    String name = names2[i];
                    int typeParam = name.indexOf(60);
                    if (typeParam != -1) {
                        name = name.substring(0, typeParam);
                    }
                    if (!name.endsWith(baseName) || !manager.areElementsEquivalent(baseClass, resolved = (referencedTypes = classStub.getReferencedTypes())[i].resolve())) continue;
                    return true;
                }
                return false;
            }
            if (stub != null) {
                for (PsiClassType type2 : list2.getReferencedTypes()) {
                    if (!Comparing.equal(type2.getClassName(), baseName) || !manager.areElementsEquivalent(baseClass, type2.resolve())) continue;
                    return true;
                }
                return false;
            }
        }
        if (list2.getLanguage() == JavaLanguage.INSTANCE) {
            for (PsiJavaCodeReferenceElement referenceElement : list2.getReferenceElements()) {
                if (!Comparing.strEqual(baseName, referenceElement.getReferenceName()) || !manager.areElementsEquivalent(baseClass, referenceElement.resolve())) continue;
                return true;
            }
            return false;
        }
        for (PsiClassType type3 : list2.getReferencedTypes()) {
            if (!Comparing.equal(type3.getClassName(), baseName) || !manager.areElementsEquivalent(baseClass, type3.resolve())) continue;
            return true;
        }
        return false;
    }

    public static boolean isClassEquivalentTo(@NotNull PsiClass aClass2, PsiElement another) {
        PsiFile original2;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "isClassEquivalentTo"));
        }
        if (aClass2 == another) {
            return true;
        }
        if (!(another instanceof PsiClass)) {
            return false;
        }
        String name1 = aClass2.getName();
        if (name1 == null) {
            return false;
        }
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiClass)another).getName();
        if (name2 == null) {
            return false;
        }
        if (name1.hashCode() != name2.hashCode()) {
            return false;
        }
        if (!name1.equals(name2)) {
            return false;
        }
        String qName1 = aClass2.getQualifiedName();
        String qName2 = ((PsiClass)another).getQualifiedName();
        if (qName1 == null || qName2 == null) {
            if (qName1 != qName2) {
                return false;
            }
            if (aClass2 instanceof PsiTypeParameter && another instanceof PsiTypeParameter) {
                PsiTypeParameter p1 = (PsiTypeParameter)aClass2;
                PsiTypeParameter p2 = (PsiTypeParameter)another;
                return p1.getIndex() == p2.getIndex() && (aClass2.getManager().areElementsEquivalent(p1.getOwner(), p2.getOwner()) || TypeConversionUtil.areSameFreshVariables(p1, p2));
            }
            return false;
        }
        if (qName1.hashCode() != qName2.hashCode() || !qName1.equals(qName2)) {
            return false;
        }
        if (aClass2.getOriginalElement().equals(another.getOriginalElement())) {
            return true;
        }
        PsiFile file1 = aClass2.getContainingFile().getOriginalFile();
        PsiFile file2 = another.getContainingFile().getOriginalFile();
        PsiFile original1 = file1.getUserData(PsiFileFactory.ORIGINAL_FILE);
        if (original1 == (original2 = file2.getUserData(PsiFileFactory.ORIGINAL_FILE)) && original1 != null || original1 == file2 || original2 == file1 || file1 == file2) {
            return PsiClassImplUtil.compareClassSeqNumber(aClass2, (PsiClass)another);
        }
        FileIndexFacade fileIndex = ServiceManager.getService(file1.getProject(), FileIndexFacade.class);
        VirtualFile vfile1 = file1.getViewProvider().getVirtualFile();
        VirtualFile vfile2 = file2.getViewProvider().getVirtualFile();
        boolean lib1 = fileIndex.isInLibraryClasses(vfile1);
        boolean lib2 = fileIndex.isInLibraryClasses(vfile2);
        return !(!fileIndex.isInSource(vfile1) && !lib1 || !fileIndex.isInSource(vfile2) && !lib2);
    }

    private static boolean compareClassSeqNumber(@NotNull PsiClass aClass2, @NotNull PsiClass another) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "compareClassSeqNumber"));
        }
        if (another == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "another", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "compareClassSeqNumber"));
        }
        int index1 = PsiClassImplUtil.getSeqNumber(aClass2);
        if (index1 == -1) {
            return true;
        }
        int index2 = PsiClassImplUtil.getSeqNumber(another);
        return index1 == index2;
    }

    private static int getSeqNumber(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "getSeqNumber"));
        }
        PsiElement parent2 = aClass2.getParent();
        if (parent2 == null) {
            return -1;
        }
        int seqNo = 0;
        for (PsiElement child : parent2.getChildren()) {
            if (child == aClass2) {
                return seqNo;
            }
            if (!(child instanceof PsiClass) || !Comparing.strEqual(aClass2.getName(), ((PsiClass)child).getName())) continue;
            ++seqNo;
        }
        return -1;
    }

    public static boolean isFieldEquivalentTo(@NotNull PsiField field, PsiElement another) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "isFieldEquivalentTo"));
        }
        if (!(another instanceof PsiField)) {
            return false;
        }
        String name1 = field.getName();
        if (name1 == null) {
            return false;
        }
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiField)another).getName();
        if (!name1.equals(name2)) {
            return false;
        }
        PsiClass aClass1 = field.getContainingClass();
        PsiClass aClass2 = ((PsiField)another).getContainingClass();
        return aClass1 != null && aClass2 != null && field.getManager().areElementsEquivalent(aClass1, aClass2);
    }

    public static boolean isMethodEquivalentTo(@NotNull PsiMethod method1, PsiElement another) {
        PsiParameter[] parameters2;
        if (method1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method1", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "isMethodEquivalentTo"));
        }
        if (method1 == another) {
            return true;
        }
        if (!(another instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method2 = (PsiMethod)another;
        if (!another.isValid()) {
            return false;
        }
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        PsiClass aClass1 = method1.getContainingClass();
        PsiClass aClass2 = method2.getContainingClass();
        PsiManager manager = method1.getManager();
        if (aClass1 == null || aClass2 == null || !manager.areElementsEquivalent(aClass1, aClass2)) {
            return false;
        }
        PsiParameter[] parameters1 = method1.getParameterList().getParameters();
        if (parameters1.length != (parameters2 = method2.getParameterList().getParameters()).length) {
            return false;
        }
        for (int i = 0; i < parameters1.length; ++i) {
            PsiType type2;
            PsiParameter parameter1 = parameters1[i];
            PsiParameter parameter2 = parameters2[i];
            PsiType type1 = parameter1.getType();
            if (PsiClassImplUtil.compareParamTypes(manager, type1, type2 = parameter2.getType(), new HashSet<String>())) continue;
            return false;
        }
        return true;
    }

    private static boolean compareParamTypes(@NotNull PsiManager manager, @NotNull PsiType type1, @NotNull PsiType type2, Set<String> visited2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "compareParamTypes"));
        }
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "compareParamTypes"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil", "compareParamTypes"));
        }
        if (type1 instanceof PsiArrayType) {
            PsiType componentType2;
            PsiType componentType1;
            return type2 instanceof PsiArrayType && PsiClassImplUtil.compareParamTypes(manager, componentType1 = ((PsiArrayType)type1).getComponentType(), componentType2 = ((PsiArrayType)type2).getComponentType(), visited2);
        }
        if (!(type1 instanceof PsiClassType) || !(type2 instanceof PsiClassType)) {
            return type1.equals(type2);
        }
        PsiClass class1 = ((PsiClassType)type1).resolve();
        PsiClass class2 = ((PsiClassType)type2).resolve();
        visited2.add(type1.getCanonicalText());
        visited2.add(type2.getCanonicalText());
        if (class1 instanceof PsiTypeParameter && class2 instanceof PsiTypeParameter) {
            PsiClassType[] eTypes2;
            if (!Comparing.equal(class1.getName(), class2.getName()) || ((PsiTypeParameter)class1).getIndex() != ((PsiTypeParameter)class2).getIndex()) {
                return false;
            }
            PsiClassType[] eTypes1 = class1.getExtendsListTypes();
            if (eTypes1.length != (eTypes2 = class2.getExtendsListTypes()).length) {
                return false;
            }
            for (int i = 0; i < eTypes1.length; ++i) {
                PsiClassType eType1 = eTypes1[i];
                PsiClassType eType2 = eTypes2[i];
                if (visited2.contains(eType1.getCanonicalText()) || visited2.contains(eType2.getCanonicalText())) {
                    return false;
                }
                if (PsiClassImplUtil.compareParamTypes(manager, eType1, eType2, visited2)) continue;
                return false;
            }
            return true;
        }
        return manager.areElementsEquivalent(class1, class2);
    }

    private static class ByNameCachedValueProvider
    implements ParameterizedCachedValueProvider<Map<GlobalSearchScope, MembersMap>, PsiClass> {
        private static final ByNameCachedValueProvider INSTANCE = new ByNameCachedValueProvider();

        private ByNameCachedValueProvider() {
        }

        @Override
        public CachedValueProvider.Result<Map<GlobalSearchScope, MembersMap>> compute(final @NotNull PsiClass myClass) {
            if (myClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil$ByNameCachedValueProvider", "compute"));
            }
            ConcurrentFactoryMap<GlobalSearchScope, MembersMap> map2 = new ConcurrentFactoryMap<GlobalSearchScope, MembersMap>(){

                @Override
                @Nullable
                protected MembersMap create(GlobalSearchScope resolveScope) {
                    return new MembersMap(myClass, resolveScope);
                }
            };
            return CachedValueProvider.Result.create(map2, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        }
    }

    private static class MembersMap
    extends ConcurrentFactoryMap<MemberType, Map<String, PsiMember[]>> {
        private final PsiClass myPsiClass;
        private final GlobalSearchScope myResolveScope;

        MembersMap(PsiClass psiClass, GlobalSearchScope scope) {
            this.myPsiClass = psiClass;
            this.myResolveScope = scope;
        }

        @Override
        @Nullable
        protected Map<String, PsiMember[]> create(final MemberType key) {
            final THashMap map2 = ContainerUtil.newTroveMap();
            final ArrayList allMembers = ContainerUtil.newArrayList();
            map2.put("Intellij-IDEA-ALL", allMembers);
            ElementClassFilter filter2 = key == MemberType.CLASS ? ElementClassFilter.CLASS : (key == MemberType.METHOD ? ElementClassFilter.METHOD : ElementClassFilter.FIELD);
            final ElementClassHint classHint = new ElementClassHint(){

                @Override
                public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
                    return key == MemberType.CLASS && kind == ElementClassHint.DeclarationKind.CLASS || key == MemberType.FIELD && (kind == ElementClassHint.DeclarationKind.FIELD || kind == ElementClassHint.DeclarationKind.ENUM_CONST) || key == MemberType.METHOD && kind == ElementClassHint.DeclarationKind.METHOD;
                }
            };
            FilterScopeProcessor<MethodCandidateInfo> processor = new FilterScopeProcessor<MethodCandidateInfo>((ElementFilter)filter2){

                @Override
                protected void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor2) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil$MembersMap$2", "add"));
                    }
                    if (substitutor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil$MembersMap$2", "add"));
                    }
                    if (key == MemberType.CLASS && element instanceof PsiClass || key == MemberType.METHOD && element instanceof PsiMethod || key == MemberType.FIELD && element instanceof PsiField) {
                        allMembers.add((PsiMember)element);
                        String currentName = ((PsiMember)element).getName();
                        List listByName = (List)map2.get(currentName);
                        if (listByName == null) {
                            listByName = ContainerUtil.newSmartList();
                            map2.put(currentName, listByName);
                        }
                        listByName.add((PsiMember)element);
                    }
                }

                @Override
                public <K> K getHint(@NotNull Key<K> hintKey) {
                    if (hintKey == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil$MembersMap$2", "getHint"));
                    }
                    return (K)(ElementClassHint.KEY == hintKey ? classHint : super.getHint(hintKey));
                }
            };
            PsiClassImplUtil.processDeclarationsInClassNotCached(this.myPsiClass, processor, ResolveState.initial(), null, null, this.myPsiClass, false, PsiUtil.getLanguageLevel(this.myPsiClass), this.myResolveScope);
            THashMap<String, PsiMember[]> result2 = ContainerUtil.newTroveMap();
            for (String name : map2.keySet()) {
                result2.put(name, ((List)map2.get(name)).toArray(PsiMember.EMPTY_ARRAY));
            }
            return result2;
        }
    }

    private static class ClassIconRequest {
        @NotNull
        private final PsiClass psiClass;
        private final int flags;
        private final Icon symbolIcon;

        private ClassIconRequest(@NotNull PsiClass psiClass, int flags, Icon symbolIcon) {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiClassImplUtil$ClassIconRequest", "<init>"));
            }
            this.psiClass = psiClass;
            this.flags = flags;
            this.symbolIcon = symbolIcon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassIconRequest)) {
                return false;
            }
            ClassIconRequest that = (ClassIconRequest)o;
            return this.flags == that.flags && this.psiClass.equals(that.psiClass);
        }

        public int hashCode() {
            int result2 = this.psiClass.hashCode();
            result2 = 31 * result2 + this.flags;
            return result2;
        }
    }

    public static enum MemberType {
        CLASS,
        FIELD,
        METHOD;

    }
}

