/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileWithStubSupport;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IndexingStampInfo;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ObjectStubTree;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTree;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTreeBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.UpToDateStubIndexMismatch;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public abstract class StubTreeLoader {
    public static StubTreeLoader getInstance() {
        return ServiceManager.getService(StubTreeLoader.class);
    }

    @Nullable
    public abstract ObjectStubTree readOrBuild(Project var1, VirtualFile var2, @Nullable PsiFile var3);

    @Nullable
    public abstract ObjectStubTree readFromVFile(Project var1, VirtualFile var2);

    public boolean isStubReloadingProhibited() {
        return false;
    }

    public abstract void rebuildStubTree(VirtualFile var1);

    public abstract boolean canHaveStub(VirtualFile var1);

    protected boolean hasPsiInManyProjects(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "hasPsiInManyProjects"));
        }
        return false;
    }

    @Nullable
    protected IndexingStampInfo getIndexingStampInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "getIndexingStampInfo"));
        }
        return null;
    }

    @NotNull
    public RuntimeException stubTreeAndIndexDoNotMatch(@NotNull String _message, @NotNull ObjectStubTree stubTree, @NotNull PsiFileWithStubSupport psiFile) {
        if (_message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_message", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "stubTreeAndIndexDoNotMatch"));
        }
        if (stubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubTree", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "stubTreeAndIndexDoNotMatch"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "stubTreeAndIndexDoNotMatch"));
        }
        VirtualFile file2 = psiFile.getViewProvider().getVirtualFile();
        StubTree stubTreeFromIndex = (StubTree)this.readFromVFile(psiFile.getProject(), file2);
        boolean compiled = psiFile instanceof PsiCompiledElement;
        Document document = compiled ? null : FileDocumentManager.getInstance().getDocument(file2);
        IndexingStampInfo indexingStampInfo = this.getIndexingStampInfo(file2);
        boolean upToDate = indexingStampInfo != null && indexingStampInfo.isUpToDate(document, file2, psiFile);
        String msg = _message + "\nPlease report the problem to JetBrains with the files attached\n";
        if (upToDate) {
            msg = msg + "INDEXED VERSION IS THE CURRENT ONE";
        }
        msg = msg + " file=" + psiFile;
        msg = msg + ", file.class=" + psiFile.getClass();
        msg = msg + ", file.lang=" + psiFile.getLanguage();
        msg = msg + ", modStamp=" + psiFile.getModificationStamp();
        if (!compiled) {
            String text2 = psiFile.getText();
            PsiFile fromText = PsiFileFactory.getInstance(psiFile.getProject()).createFileFromText(psiFile.getName(), psiFile.getFileType(), (CharSequence)text2);
            if (fromText.getLanguage().equals(psiFile.getLanguage())) {
                boolean consistent = DebugUtil.psiToString(psiFile, true).equals(DebugUtil.psiToString(fromText, true));
                msg = consistent ? msg + "\n tree consistent" : msg + "\n AST INCONSISTENT, perhaps after incremental reparse; " + fromText;
            }
        }
        msg = msg + "\n stub debugInfo=" + stubTree.getDebugInfo();
        msg = msg + "\nlatestIndexedStub=" + stubTreeFromIndex;
        if (stubTreeFromIndex != null) {
            msg = msg + "\n   same size=" + (stubTree.getPlainList().size() == stubTreeFromIndex.getPlainList().size());
            msg = msg + "\n   debugInfo=" + stubTreeFromIndex.getDebugInfo();
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        msg = msg + "\n viewProvider=" + viewProvider;
        msg = msg + "\n viewProvider stamp: " + viewProvider.getModificationStamp();
        msg = msg + "; file stamp: " + file2.getModificationStamp();
        msg = msg + "; file modCount: " + file2.getModificationCount();
        msg = msg + "; file length: " + file2.getLength();
        if (document != null) {
            msg = msg + "\n doc saved: " + !FileDocumentManager.getInstance().isDocumentUnsaved(document);
            msg = msg + "; doc stamp: " + document.getModificationStamp();
            msg = msg + "; doc size: " + document.getTextLength();
            msg = msg + "; committed: " + PsiDocumentManager.getInstance(psiFile.getProject()).isCommitted(document);
        }
        msg = msg + "\nin many projects: " + this.hasPsiInManyProjects(file2);
        msg = msg + "\nindexing info: " + indexingStampInfo;
        Attachment[] attachments = StubTreeLoader.createAttachments(stubTree, psiFile, file2, stubTreeFromIndex);
        RuntimeExceptionWithAttachments runtimeExceptionWithAttachments = upToDate ? StubTreeLoader.handleUpToDateMismatch(msg, attachments) : new RuntimeExceptionWithAttachments(msg, attachments);
        if (runtimeExceptionWithAttachments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "stubTreeAndIndexDoNotMatch"));
        }
        return runtimeExceptionWithAttachments;
    }

    private static UpToDateStubIndexMismatch handleUpToDateMismatch(@NotNull String message, Attachment[] attachments) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "handleUpToDateMismatch"));
        }
        return new UpToDateStubIndexMismatch(message, attachments);
    }

    @NotNull
    private static Attachment[] createAttachments(@NotNull ObjectStubTree stubTree, @NotNull PsiFileWithStubSupport psiFile, VirtualFile file2, @Nullable StubTree stubTreeFromIndex) {
        if (stubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubTree", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "createAttachments"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "createAttachments"));
        }
        ArrayList<Attachment> attachments = ContainerUtil.newArrayList();
        attachments.add(new Attachment(file2.getPath() + "_file.txt", psiFile instanceof PsiCompiledElement ? "compiled" : psiFile.getText()));
        attachments.add(new Attachment("stubTree.txt", ((PsiFileStubImpl)stubTree.getRoot()).printTree()));
        if (stubTreeFromIndex != null) {
            attachments.add(new Attachment("stubTreeFromIndex.txt", ((PsiFileStubImpl)stubTreeFromIndex.getRoot()).printTree()));
        }
        Attachment[] attachmentArray = attachments.toArray(Attachment.EMPTY_ARRAY);
        if (attachmentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "createAttachments"));
        }
        return attachmentArray;
    }

    public static String getFileViewProviderMismatchDiagnostics(@NotNull FileViewProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeLoader", "getFileViewProviderMismatchDiagnostics"));
        }
        Function<PsiFile, String> fileClassName = file2 -> file2.getClass().getSimpleName();
        Function<Pair, String> stubRootToString = pair -> "(" + ((IStubFileElementType)pair.first).toString() + ", " + ((IStubFileElementType)pair.first).getLanguage() + " -> " + (String)fileClassName.fun((PsiFile)pair.second) + ")";
        List<Pair<IStubFileElementType, PsiFile>> roots2 = StubTreeBuilder.getStubbedRoots(provider);
        return "path = " + provider.getVirtualFile().getPath() + ", stubBindingRoot = " + fileClassName.fun(provider.getStubBindingRoot()) + ", languages = [" + StringUtil.join(provider.getLanguages(), Language::getID, ", ") + "], fileTypes = [" + StringUtil.join(provider.getAllFiles(), file2 -> file2.getFileType().getName(), ", ") + "], files = [" + StringUtil.join(provider.getAllFiles(), fileClassName, ", ") + "], roots = [" + StringUtil.join(roots2, stubRootToString, ", ") + "]";
    }
}

