/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.io.Closeable;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;
import org.jetbrains.kotlin.container.ComponentDescriptor;
import org.jetbrains.kotlin.container.ComponentRegistry;
import org.jetbrains.kotlin.container.ComponentResolveContext;
import org.jetbrains.kotlin.container.ComponentStorageState;
import org.jetbrains.kotlin.container.ContainerConsistencyException;
import org.jetbrains.kotlin.container.DataStructuresKt;
import org.jetbrains.kotlin.container.DefaultInstanceComponentDescriptor;
import org.jetbrains.kotlin.container.DefaultSingletonTypeComponentDescriptor;
import org.jetbrains.kotlin.container.ImplicitSingletonTypeComponentDescriptor;
import org.jetbrains.kotlin.container.InvalidCardinalityException;
import org.jetbrains.kotlin.container.MethodBinding;
import org.jetbrains.kotlin.container.ResolveKt;
import org.jetbrains.kotlin.container.SetterInfo;
import org.jetbrains.kotlin.container.ValueDescriptor;
import org.jetbrains.kotlin.container.ValueResolveContext;
import org.jetbrains.kotlin.container.ValueResolver;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005J4\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002J\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u001fH\u0002J\u0006\u0010 \u001a\u00020\u0016J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u000e\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0&H\u0002J\u001e\u0010'\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u00182\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)H\u0002J\u0018\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0017\u001a\u00020-H\u0002J\u001e\u0010*\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0\u001fH\u0002J$\u0010/\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u001fH\u0002J\u0018\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020-H\u0002J#\u00102\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u00103\u001a\b\u0012\u0004\u0012\u00020\b0&H\u0000\u00a2\u0006\u0002\b4J\u001a\u00105\u001a\u0004\u0018\u0001062\u0006\u00101\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020-H\u0016J\u001c\u00107\u001a\b\u0012\u0004\u0012\u000206082\u0006\u00101\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020-R*\u0010\u0006\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/container/ComponentStorage;", "Lorg/jetbrains/kotlin/container/ValueResolver;", "myId", "", "parent", "(Ljava/lang/String;Lorg/jetbrains/kotlin/container/ComponentStorage;)V", "dependencies", "Lorg/jetbrains/kotlin/com/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "kotlin.jvm.PlatformType", "Ljava/lang/reflect/Type;", "descriptors", "Ljava/util/LinkedHashSet;", "registry", "Lorg/jetbrains/kotlin/container/ComponentRegistry;", "state", "Lorg/jetbrains/kotlin/container/ComponentStorageState;", "getState", "()Lorg/jetbrains/kotlin/container/ComponentStorageState;", "setState", "(Lorg/jetbrains/kotlin/container/ComponentStorageState;)V", "collectAdhocComponents", "", "context", "Lorg/jetbrains/kotlin/container/ComponentResolveContext;", "descriptor", "visitedTypes", "Ljava/util/HashSet;", "adhocDescriptors", "compose", "composeDescriptors", "", "dispose", "disposeDescriptor", "dump", "printer", "Ljava/io/PrintStream;", "getDescriptorsInDisposeOrder", "", "getImplicitlyDefinedDependency", "rawType", "Ljava/lang/Class;", "injectProperties", "instance", "", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "components", "inspectDependenciesAndRegisterAdhoc", "registerDependency", "request", "registerDescriptors", "items", "registerDescriptors$container", "resolve", "Lorg/jetbrains/kotlin/container/ValueDescriptor;", "resolveMultiple", "", "container"})
public final class ComponentStorage
implements ValueResolver {
    @NotNull
    private ComponentStorageState state;
    private final ComponentRegistry registry;
    private final LinkedHashSet<ComponentDescriptor> descriptors;
    private final MultiMap<ComponentDescriptor, Type> dependencies;
    private final String myId;

    @NotNull
    public final ComponentStorageState getState() {
        return this.state;
    }

    public final void setState(@NotNull ComponentStorageState componentStorageState) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)componentStorageState), (String)"<set-?>");
        this.state = componentStorageState;
    }

    @Override
    @Nullable
    public ValueDescriptor resolve(@NotNull Type request, @NotNull ValueResolveContext context) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)ComponentStorageState.Initial))) {
            throw (Throwable)new ContainerConsistencyException("Container was not composed before resolving");
        }
        Collection<ComponentDescriptor> entry = this.registry.tryGetEntry(request);
        Collection<ComponentDescriptor> collection = entry;
        if (!collection.isEmpty()) {
            this.registerDependency(request, context);
            if (entry.size() > 1) {
                throw (Throwable)new InvalidCardinalityException("Request " + request + " cannot be satisfied because there is more than one type registered", entry);
            }
            return (ValueDescriptor)CollectionsKt.singleOrNull((Iterable)entry);
        }
        return null;
    }

    private final void registerDependency(Type request, ValueResolveContext context) {
        ValueDescriptor descriptor2;
        if (context instanceof ComponentResolveContext && (descriptor2 = ((ComponentResolveContext)context).getRequestingDescriptor()) instanceof ComponentDescriptor) {
            this.dependencies.putValue((ComponentDescriptor)descriptor2, request);
        }
    }

    public final void dump(@NotNull PrintStream printer) {
        Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
        PrintStream $receiver = printer;
        String heading = "Container: " + this.myId;
        $receiver.println(heading);
        $receiver.println(StringsKt.repeat((CharSequence)"=", (int)heading.length()));
        $receiver.println();
        Iterable $receiver$iv = this.getDescriptorsInDisposeOrder();
        for (Object element$iv : $receiver$iv) {
            ComponentDescriptor descriptor2 = (ComponentDescriptor)element$iv;
            $receiver.println(descriptor2);
            Collection<Type> collection = this.dependencies.get(descriptor2);
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"dependencies[descriptor]");
            Iterable $receiver$iv2 = collection;
            for (Object element$iv2 : $receiver$iv2) {
                Type it = (Type)element$iv2;
                $receiver.print("   -> ");
                String typeName = it.toString();
                $receiver.print(StringsKt.substringBefore$default((String)typeName, (String)" ", null, (int)2, null));
                $receiver.print(" ");
                $receiver.print(StringsKt.substringAfterLast$default((String)typeName, (String)".", null, (int)2, null));
                Type type2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"it");
                Collection<ComponentDescriptor> resolve2 = this.registry.tryGetEntry(type2);
                $receiver.print(" as ");
                $receiver.print(resolve2);
                $receiver.println();
            }
            $receiver.println();
        }
    }

    @NotNull
    public final Iterable<ValueDescriptor> resolveMultiple(@NotNull Type request, @NotNull ValueResolveContext context) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.registerDependency(request, context);
        return this.registry.tryGetEntry(request);
    }

    public final void registerDescriptors$container(@NotNull ComponentResolveContext context, @NotNull List<? extends ComponentDescriptor> items) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)ComponentStorageState.Disposed))) {
            throw (Throwable)new ContainerConsistencyException("Cannot register descriptors in " + (Object)((Object)this.state) + " state");
        }
        for (ComponentDescriptor componentDescriptor : items) {
            this.descriptors.add(componentDescriptor);
        }
        if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)ComponentStorageState.Initialized))) {
            this.composeDescriptors(context, (Collection<? extends ComponentDescriptor>)items);
        }
    }

    public final void compose(@NotNull ComponentResolveContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)ComponentStorageState.Initial)) ^ true) {
            throw (Throwable)new ContainerConsistencyException("Container " + this.myId + " was already composed.");
        }
        this.state = ComponentStorageState.Initialized;
        this.composeDescriptors(context, (Collection<? extends ComponentDescriptor>)this.descriptors);
    }

    private final void composeDescriptors(ComponentResolveContext context, Collection<? extends ComponentDescriptor> descriptors) {
        if (descriptors.isEmpty()) {
            return;
        }
        this.registry.addAll(descriptors);
        LinkedHashSet<ComponentDescriptor> implicits = this.inspectDependenciesAndRegisterAdhoc(context, descriptors);
        this.injectProperties(context, CollectionsKt.plus(descriptors, (Iterable)implicits));
    }

    private final void injectProperties(ComponentResolveContext context, Collection<? extends ComponentDescriptor> components) {
        for (ComponentDescriptor componentDescriptor : components) {
            if (!componentDescriptor.getShouldInjectProperties()) continue;
            this.injectProperties(componentDescriptor.getValue(), context.getContainer().createResolveContext(componentDescriptor));
        }
    }

    private final LinkedHashSet<ComponentDescriptor> inspectDependenciesAndRegisterAdhoc(ComponentResolveContext context, Collection<? extends ComponentDescriptor> descriptors) {
        LinkedHashSet<ComponentDescriptor> adhoc = new LinkedHashSet<ComponentDescriptor>();
        HashSet<Type> visitedTypes = new HashSet<Type>();
        for (ComponentDescriptor componentDescriptor : descriptors) {
            this.collectAdhocComponents(context, componentDescriptor, visitedTypes, adhoc);
        }
        this.registry.addAll((Collection<? extends ComponentDescriptor>)adhoc);
        return adhoc;
    }

    private final void collectAdhocComponents(ComponentResolveContext context, ComponentDescriptor descriptor2, HashSet<Type> visitedTypes, LinkedHashSet<ComponentDescriptor> adhocDescriptors) {
        Collection<Type> dependencies2 = descriptor2.getDependencies(context);
        for (Type type2 : dependencies2) {
            Class clazz;
            Class it;
            Class rawType;
            Object object;
            Class clazz2;
            Collection<ComponentDescriptor> entry;
            if (!visitedTypes.add(type2) || !(entry = this.registry.tryGetEntry(type2)).isEmpty()) continue;
            Type type3 = type2;
            if (type3 instanceof Class) {
                clazz2 = (Class)type2;
            } else if (type3 instanceof ParameterizedType) {
                Type type4 = ((ParameterizedType)type2).getRawType();
                if (!(type4 instanceof Class)) {
                    type4 = null;
                }
                clazz2 = (Class)type4;
            } else {
                clazz2 = null;
            }
            if ((object = (rawType = clazz2)) == null || (object = this.getImplicitlyDefinedDependency(context, it = (clazz = object))) == null) {
                continue;
            }
            Object implicitDependency = object;
            adhocDescriptors.add((ComponentDescriptor)implicitDependency);
            this.collectAdhocComponents(context, (ComponentDescriptor)implicitDependency, visitedTypes, adhocDescriptors);
        }
    }

    private final ComponentDescriptor getImplicitlyDefinedDependency(ComponentResolveContext context, Class<?> rawType) {
        if (!Modifier.isAbstract(rawType.getModifiers()) && !rawType.isPrimitive()) {
            return new ImplicitSingletonTypeComponentDescriptor(context.getContainer(), rawType);
        }
        Class<?> defaultImplementation = CacheKt.getInfo(rawType).getDefaultImplementation();
        if (defaultImplementation != null && CacheKt.getInfo(defaultImplementation).getConstructorInfo() != null) {
            return new DefaultSingletonTypeComponentDescriptor(context.getContainer(), defaultImplementation);
        }
        if (defaultImplementation != null) {
            DefaultInstanceComponentDescriptor defaultInstanceComponentDescriptor;
            Object object = defaultImplementation.getField("INSTANCE");
            if (object != null && (object = ((Field)object).get(null)) != null) {
                Object object2;
                Object p1 = object2 = object;
                defaultInstanceComponentDescriptor = new DefaultInstanceComponentDescriptor(p1);
            } else {
                defaultInstanceComponentDescriptor = null;
            }
            return defaultInstanceComponentDescriptor;
        }
        return null;
    }

    private final void injectProperties(Object instance, ValueResolveContext context) {
        ClassInfo classInfo = CacheKt.getInfo(instance.getClass());
        Iterable $receiver$iv = classInfo.getSetterInfos();
        for (Object element$iv : $receiver$iv) {
            SetterInfo $method = (SetterInfo)element$iv;
            Method method = $method.component1();
            MethodBinding methodBinding = ResolveKt.bindToMethod(method, context);
            methodBinding.invoke(instance);
        }
    }

    public final void dispose() {
        if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)ComponentStorageState.Initialized)) ^ true) {
            if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)ComponentStorageState.Initial))) {
                return;
            }
            throw (Throwable)new ContainerConsistencyException("Component container cannot be disposed in the " + (Object)((Object)this.state) + " state.");
        }
        this.state = ComponentStorageState.Disposing;
        List<ComponentDescriptor> disposeList = this.getDescriptorsInDisposeOrder();
        for (ComponentDescriptor descriptor2 : disposeList) {
            this.disposeDescriptor(descriptor2);
        }
        this.state = ComponentStorageState.Disposed;
    }

    private final List<ComponentDescriptor> getDescriptorsInDisposeOrder() {
        return DataStructuresKt.topologicalSort((Iterable)this.descriptors, (Function1)new Function1<ComponentDescriptor, ArrayList<ComponentDescriptor>>(this){
            final /* synthetic */ ComponentStorage this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ArrayList<ComponentDescriptor> invoke(@NotNull ComponentDescriptor it) {
                void var2_2;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ArrayList<ComponentDescriptor> dependent = new ArrayList<ComponentDescriptor>();
                for (Type interfaceType : ComponentStorage.access$getDependencies$p(this.this$0).get(it)) {
                    ComponentRegistry componentRegistry = ComponentStorage.access$getRegistry$p(this.this$0);
                    Type type2 = interfaceType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"interfaceType");
                    for (ComponentDescriptor dependency : componentRegistry.tryGetEntry(type2)) {
                        dependent.add(dependency);
                    }
                }
                return var2_2;
            }
            {
                this.this$0 = componentStorage;
                super(1);
            }
        });
    }

    private final void disposeDescriptor(ComponentDescriptor descriptor2) {
        if (descriptor2 instanceof Closeable) {
            ((Closeable)((Object)descriptor2)).close();
        }
    }

    public ComponentStorage(@NotNull String myId, @Nullable ComponentStorage parent2) {
        Intrinsics.checkParameterIsNotNull((Object)myId, (String)"myId");
        this.myId = myId;
        this.state = ComponentStorageState.Initial;
        this.registry = new ComponentRegistry();
        ComponentStorage componentStorage = parent2;
        if (componentStorage != null) {
            ComponentStorage componentStorage2;
            ComponentStorage it = componentStorage2 = componentStorage;
            this.registry.addAll(it.registry);
        }
        this.descriptors = new LinkedHashSet();
        this.dependencies = MultiMap.createLinkedSet();
    }

    @NotNull
    public static final /* synthetic */ MultiMap access$getDependencies$p(ComponentStorage $this) {
        return $this.dependencies;
    }

    @NotNull
    public static final /* synthetic */ ComponentRegistry access$getRegistry$p(ComponentStorage $this) {
        return $this.registry;
    }
}

