/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.declarations;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNullable;
import org.jetbrains.kotlin.storage.StorageManager;

public abstract class AbstractDeclarationProviderFactory
implements DeclarationProviderFactory {
    private final MemoizedFunctionToNullable<FqName, PackageMemberDeclarationProvider> packageDeclarationProviders;

    public AbstractDeclarationProviderFactory(@NotNull StorageManager storageManager) {
        this.packageDeclarationProviders = storageManager.createMemoizedFunctionWithNullableValues(this::createPackageMemberDeclarationProvider);
    }

    @Nullable
    protected abstract PackageMemberDeclarationProvider createPackageMemberDeclarationProvider(@NotNull FqName var1);

    @Override
    public PackageMemberDeclarationProvider getPackageMemberDeclarationProvider(@NotNull FqName packageFqName) {
        return (PackageMemberDeclarationProvider)this.packageDeclarationProviders.invoke(packageFqName);
    }

    @Override
    public void diagnoseMissingPackageFragment(@NotNull FqName fqName2, @Nullable KtFile file2) {
        String message = "Cannot find package fragment " + fqName2;
        if (file2 != null) {
            message = message + "\nvFile = " + file2.getVirtualFilePath() + ", file package = '" + file2.getPackageFqName() + "'";
        }
        throw new IllegalStateException(message);
    }
}

