/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\"\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0004`\tH\u0002J4\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\"\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0004`\tH\u0002J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/RedundantGotoMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "getLastTargetJumpInsn", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "jumpInsn", "labelsToReplace", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "Lkotlin/collections/HashMap;", "rewriteLabelIfNeeded", "", "transform", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "backend"})
public final class RedundantGotoMethodTransformer
extends MethodTransformer {
    /*
     * WARNING - void declaration
     */
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        Object[] $receiver = objectArray = methodNode.instructions.toArray();
        ArraysKt.reverse((Object[])$receiver);
        Object[] insns2 = objectArray;
        ArrayList<Object> insnsToRemove = new ArrayList<Object>();
        HashSet<Object> currentLabels = new HashSet<Object>();
        HashMap<LabelNode, JumpInsnNode> labelsToReplace = new HashMap<LabelNode, JumpInsnNode>();
        JumpInsnNode pendingGoto = null;
        int n = insns2.length;
        for (int i = 0; i < n; ++i) {
            Object object = insns2[i];
            if (object instanceof LabelNode) {
                currentLabels.add(object);
                if (pendingGoto != null) {
                    JumpInsnNode jumpInsnNode;
                    JumpInsnNode it = jumpInsnNode;
                    Map map2 = labelsToReplace;
                    Object object2 = object;
                    JumpInsnNode jumpInsnNode2 = it;
                    map2.put(object2, jumpInsnNode2);
                }
                continue;
            }
            Object object3 = object;
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"insn");
            if (((AbstractInsnNode)object3).getOpcode() == 167) {
                pendingGoto = (JumpInsnNode)object;
                if (currentLabels.contains(((JumpInsnNode)object).label)) {
                    insnsToRemove.add(object);
                    continue;
                }
                currentLabels.clear();
                continue;
            }
            if (object instanceof LineNumberNode) {
                pendingGoto = null;
                continue;
            }
            if (!UtilKt.isMeaningful((AbstractInsnNode)object)) continue;
            currentLabels.clear();
            pendingGoto = null;
        }
        if (!labelsToReplace.isEmpty()) {
            void $receiver$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)insns2, (String)"insns");
            Object[] objectArray2 = insns2;
            Object[] object = objectArray2;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof JumpInsnNode)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable = (List)destination$iv$iv;
            for (Object element$iv : iterable) {
                JumpInsnNode it = (JumpInsnNode)element$iv;
                this.rewriteLabelIfNeeded(it, labelsToReplace);
            }
        }
        for (AbstractInsnNode abstractInsnNode : insnsToRemove) {
            methodNode.instructions.remove(abstractInsnNode);
        }
    }

    private final void rewriteLabelIfNeeded(JumpInsnNode jumpInsn, HashMap<LabelNode, JumpInsnNode> labelsToReplace) {
        LabelNode lastTargetLabel = this.getLastTargetJumpInsn((JumpInsnNode)jumpInsn, labelsToReplace).label;
        if (Intrinsics.areEqual((Object)lastTargetLabel, (Object)jumpInsn.label) ^ true) {
            jumpInsn.label = lastTargetLabel;
        }
    }

    private final JumpInsnNode getLastTargetJumpInsn(JumpInsnNode jumpInsn, HashMap<LabelNode, JumpInsnNode> labelsToReplace) {
        JumpInsnNode jumpInsnNode = labelsToReplace.get(jumpInsn.label);
        if (jumpInsnNode != null) {
            JumpInsnNode jumpInsnNode2;
            JumpInsnNode it;
            JumpInsnNode jumpInsnNode3 = it = (jumpInsnNode2 = jumpInsnNode);
            Intrinsics.checkExpressionValueIsNotNull((Object)jumpInsnNode3, (String)"it");
            return this.getLastTargetJumpInsn(jumpInsnNode3, labelsToReplace);
        }
        return jumpInsn;
    }
}

