/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.lower.DefaultArgumentStubGenerator;
import org.jetbrains.kotlin.backend.common.lower.InitializersLowering;
import org.jetbrains.kotlin.backend.common.lower.InnerClassConstructorCallsLowering;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesLowering;
import org.jetbrains.kotlin.backend.common.lower.KCallableNamePropertyLowering;
import org.jetbrains.kotlin.backend.common.lower.LateinitLowering;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.common.lower.LocalNameProvider;
import org.jetbrains.kotlin.backend.common.lower.PropertiesLowering;
import org.jetbrains.kotlin.backend.common.lower.SharedVariablesLowering;
import org.jetbrains.kotlin.backend.common.lower.TailrecLowering;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.lower.BridgeLowering;
import org.jetbrains.kotlin.backend.jvm.lower.ConstAndJvmFieldPropertiesLowering;
import org.jetbrains.kotlin.backend.jvm.lower.EnumClassLowering;
import org.jetbrains.kotlin.backend.jvm.lower.FileClassLowering;
import org.jetbrains.kotlin.backend.jvm.lower.InterfaceDelegationLowering;
import org.jetbrains.kotlin.backend.jvm.lower.InterfaceLowering;
import org.jetbrains.kotlin.backend.jvm.lower.ObjectClassLowering;
import org.jetbrains.kotlin.backend.jvm.lower.SingletonReferencesLowering;
import org.jetbrains.kotlin.backend.jvm.lower.StaticDefaultFunctionLowering;
import org.jetbrains.kotlin.backend.jvm.lower.SyntheticAccessorLowering;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsVisitor;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.NameUtils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmLower;", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend"})
public final class JvmLower {
    @NotNull
    private final JvmBackendContext context;

    public final void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        new FileClassLowering(this.context).lower(irFile);
        new KCallableNamePropertyLowering(this.context).lower(irFile);
        new LateinitLowering(this.context, true).lower(irFile);
        new ConstAndJvmFieldPropertiesLowering().lower(irFile);
        new PropertiesLowering().lower(irFile);
        LowerKt.runOnFilePostfix(new DefaultArgumentStubGenerator(this.context, false), irFile);
        LowerKt.runOnFilePostfix(new StaticDefaultFunctionLowering(this.context.getState()), irFile);
        LowerKt.runOnFilePostfix(new InterfaceLowering(this.context.getState()), irFile);
        LowerKt.runOnFilePostfix(new InterfaceDelegationLowering(this.context.getState()), irFile);
        LowerKt.runOnFilePostfix(new SharedVariablesLowering(this.context), irFile);
        LowerKt.runOnFilePostfix(new InnerClassesLowering(this.context), irFile);
        LowerKt.runOnFilePostfix(new InnerClassConstructorCallsLowering(this.context), irFile);
        LowerKt.runOnFilePostfix(new LocalDeclarationsLowering(this.context, new LocalNameProvider(){

            @NotNull
            public String localName(@NotNull DeclarationDescriptor descriptor2) {
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                return NameUtils.sanitizeAsJavaIdentifier(LocalNameProvider.DefaultImpls.localName(this, descriptor2));
            }
        }), irFile);
        LowerKt.runOnFilePostfix(new EnumClassLowering(this.context), irFile);
        new ObjectClassLowering(this.context).lower(irFile);
        LowerKt.runOnFilePostfix(new InitializersLowering(this.context, JvmLoweredDeclarationOrigin.CLASS_STATIC_INITIALIZER.INSTANCE, true), irFile);
        LowerKt.runOnFilePostfix(new SingletonReferencesLowering(this.context), irFile);
        new SyntheticAccessorLowering(this.context).lower(irFile);
        LowerKt.runOnFilePostfix(new BridgeLowering(this.context), irFile);
        LowerKt.runOnFilePostfix(new TailrecLowering(this.context), irFile);
        IrElementVisitorVoidKt.acceptVoid(irFile, new PatchDeclarationParentsVisitor());
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public JvmLower(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

