/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.lexer;

import java.io.IOException;
import java.io.Reader;
import org.jetbrains.kotlin.com.intellij.lexer.FlexLexer;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;

class _KDocLexer
implements FlexLexer {
    public static final int YYEOF = -1;
    public static final int YYINITIAL = 0;
    public static final int LINE_BEGINNING = 2;
    public static final int CONTENTS_BEGINNING = 4;
    public static final int TAG_BEGINNING = 6;
    public static final int TAG_TEXT_BEGINNING = 8;
    public static final int CONTENTS = 10;
    public static final int CODE_BLOCK = 12;
    public static final int CODE_BLOCK_LINE_BEGINNING = 14;
    public static final int CODE_BLOCK_CONTENTS_BEGINNING = 16;
    public static final int INDENTED_CODE_BLOCK = 18;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 6, 6};
    static final char[] ZZ_CMAP_Z = _KDocLexer.zzUnpackCMap("\u0001\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0003\t\u0001\n\u0006\u000b\u0001\f\u0013\u000b\u0001\r\u0001\u000b\u0001\u000e\u0001\t\n\u000b\u0001\u000f\b\t\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u00142\t\u0001\u0015\n\t)\u000b\u0001\u0016\u0014\t\u0001\u0017\u0381\t");
    static final char[] ZZ_CMAP_Y = _KDocLexer.zzUnpackCMap("\u0001\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\u0001\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\u000b\u0001\f\u0013\u000b\u0001\r\u0001\u0001\u0007\u000b\u0001\u000e\u0001\u000f\u0001\u0010\b\u0001\u0001\u0011\u0001\u0012\u0001\u000b\u0001\u0013\u0001\u000b\u0001\u0014\u0002\u000b\u0001\u0015\b\u000b\u0001\u0016\u0003\u000b\u0001\u0014\u0002\u000b\u0001\u0017\u0001\u000b\u0002\u0001\u0001\u0018\u0001\u000b\u0001\u0019\u0001\u0018\u0001\u000b\u0001\u001a\u0004\u0001\u0001\u000b\u0001\u001b\u0001\u001c\u0002\u0001\u0001\u0018\u0002\u001b\u0001\u0001\u0001\u001d\u0001\u0018\u0005\u000b\u0001\u001e\u0001\u001f\u0001 \u0001\u0001\u0001!\u0001\u000b\u0001\u0001\u0001\"\u0003\u0001\u0002\u000b\u0001#\u0001$\u0014\u0001\u0001%\u0002\u000b\u0001&\u0001\u0001\u0001'\u0001\u000f\u0001\u0001\u0001(\u0001)\u0001*\u0001+\u0001\u0001\u0001,\u0001\u000f\u0001-\u0001.\u0001)\u0001*\u0001/\u0001\u0001\u00010\u0001\u0001\u00011\u00012\u0001\u0013\u0001*\u00013\u0001\u0001\u00014\u0001\u000f\u0001$\u0001(\u0001)\u0001*\u00013\u0001\u0001\u0001,\u0001\u000f\u0001$\u00015\u00016\u00017\u00018\u0003\u0001\u00019\u0001:\u0001!\u0001*\u0001;\u0002\u0001\u0001\u000f\u0001\u0001\u0001:\u0001!\u0001*\u0001<\u0001\u0001\u0001=\u0001\u000f\u0001\u0001\u0001:\u0001!\u0001*\u0001>\u0002\u0001\u0001\u000f\u0001\u0001\u0001?\u0001@\u0001\u000b\u0001A\u0001\r\u0003\u0001\u0001\u0018\u0002\u000b\u0001B\u0001\r\u0003\u0001\u0001C\u0001D\u0001E\u0001F\u0001G\u0001H\u0002\u0001\u00014\u0003\u0001\u0001I\u0001\u000b\u0001\u001b\u0001\u0001\u0001J\u0007\u0001\u0002\u000b\u0001K\u0002\u0001\u0001#\u0004\u0001\u0002\u000b\u0001#\u0002\u000b\u0001L\u0005\u000b\u0001M\u0004\u000b\u0001N\u0004\u000b\u0001>\u0001\f\u0003\u000b\u0002O\u0002\u000b\u0001O\u0001\u000b\u0001\u0014\u0002P\u0001\f\u0001\u0014\u0001\u000b\u0001\u0014\u0001P\u0002\u000b\u0001\f\u0001\u001b\u0004\u0001\u0005\u000b\u0001Q\u0001\u0018%\u000b\u0001R\u0001\r\u0001\u0018\u0001\u001b\u0004\u000b\u0001S\u00014\u0001T\u0001\u000f\u0001\u000b\u0001\u000f\u0001\u000b\u0001\u000f\u0001T\u00014\u0003\u000b\u0001-\u0001\u0001\u0001U\u0004\u0001\u0005\u000b\u0001\u001a\u0002\u000b\u0001L\u0005\u0001\u0001\u000b\u0001V\u0003\u0001\u0001\u000b\u0001W\u0001Q8\u0001\u0006\u000b\u0001X\t\u0001\t\u000b\u0001X\u0005\u000b\u0001>\u0001\u000b\u0001Y\u0002\u000b\u0001Y\u0001Z\u0001\u000b\u0001W\u0003\u000b\u0001[\u0001\\\u0001]\u0001V\u0001\\\u0002\u0001\u0001^\u0001_\u00014\u0001`\u0001\u0001\u0001a\u0002\u0001\u0001\u000b\u0001\u000f\u0004\u0001\u0001b\u0001c\u0001d\u0001e\u0001f\u0001\u0001\u0002\u000b\u0001-g\u0001\u0001g\u0001\u0001\u0001h\u0001i\u0001\u0018\u0004\u000b\u0001j\u0001\u0018\u0005\u000b\u0001?\u0001\u000b\u0001V\u0001\u0018\u0004\u000b\u0001\u0014\u0001\u0001\u0001\u000b\u0001\u001a\u0003\u0001\u0001\u000b \u0001[\u000b\u0001#\u0004\u0001Z\u000b\u0001#\u0005\u0001\b\u000b\u0001V7\u0001:\u000b\u0001-\u0015\u0001\u0012\u000b\u0001W\u0003\u000b\u0001\u001b\t\u0001\u0001\r\u0001k\u0001*\u0001l\u0001m\u0006\u000b\u0001\u000f\u0001\u0001\u0001n\u0015\u000b\u0001W\u0001\u0001\u0004\u000b\u0001o\u0002\u000b\u0001\u001a\u0002\u0001\u0001V\u0003\u0001\u0001p\u0001\"\u0001\u0001\u00019\u0001q\u0007\u000b\u0001V\u0001`\u0001\u0001\u0001\u0018\u0001r\u0001\u0018\u0001\u001b\u0001?\u0004\u000b\u0001\u0014\u0001s\u0001t\u0001u\u0001\u0001\u0001v\u0001\u000b\u0001\f\u0001w\u0002W\u0002\u0001\u0007\u000b\u0001\u001b \u0001\u0001\u000b\u0001\u0014\u0001\u0001\u0001\u000b\u0001\u001b\u0003\u0001\u0001\u000b\u0001W\u0006\u0001\t\u000b\u0001W6\u0001\u0001x\u0002\u000b\u0001y<\u0001\u0005\u000b\u0001q\u0003\u000b\u0001T\u0001z\u0001{\u0001|\u0003\u000b\u0001}\u0001~\u0001\u000b\u0001\u007f\u0001\u0080\u0001!\u0014\u000b\u0001\u0081\u0001\u000b\u0001!\u0001\u0082\u0001\u000b\u0001\u0082\u0001\u000b\u0001q\u0001\u000b\u0001q\u0001\u0014\u0001\u000b\u0001\u0014\u0001\u000b\u0001*\u0001\u000b\u0001*\u0001\u000b\u0001\u0083\u0003\u0001-\u000b\u0001\r\u0012\u0001!\u000b\u0001W\u001e\u0001");
    static final char[] ZZ_CMAP_A = _KDocLexer.zzUnpackCMap("\t\u0000\u0001\u0001\u0001\t\u0001\n\u0001\u000b\u0001\n\u0012\u0000\u0001\u000f\u0003\u0000\u0001\u0003\u0003\u0000\u0001\u0011\u0001\u0012\u0001\r\u0003\u0000\u0001\u0004\u0001\f\n\u0002\u0006\u0000\u0001\u000e\u001a\u0003\u0001\u0005\u0001\u0010\u0001\u0006\u0001\u0000\u0001\u0003\u0001\u0007\u001a\u0003\u0003\u0000\u0001\b\u0006\u0000\u0001\n\f\u0000\u0004\u0003\u0004\u0000\u0001\u0003\n\u0000\u0001\u0003\u0004\u0000\u0001\u0003\u0005\u0000\u0017\u0003\u0001\u0000\u000f\u0003\t\u0000\u0002\u0003\u0004\u0000\f\u0003\u000e\u0000\u0005\u0003\t\u0000\u0001\u0003\u000b\u0000\u0001\u0003\u000b\u0000\u0001\u0003\u0001\u0000\u0003\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0001\u0000\u001c\u0003\u0001\u0000\u0006\u0003\u0001\u0000\u0005\u0003\u0004\u0000\u0002\u0003\b\u0000\f\u0003\u0002\u0000\u0002\u0003\u0007\u0000\u0016\u0003\u0002\u0000\u0001\u0003\u0006\u0000\b\u0003\b\u0000\u000b\u0003\u0005\u0000\u0003\u0003\u001b\u0000\u0006\u0003\u0001\u0000\u0001\u0003\u000f\u0000\u0002\u0003\u0007\u0000\u0002\u0003\n\u0000\u0003\u0003\u0002\u0000\u0002\u0003\u0001\u0000\u000e\u0003\r\u0000\t\u0003\u000b\u0000\u0001\u0003\u0012\u0000\u0016\u0003\u0003\u0000\u0001\u0003\u0002\u0000\u0001\u0003\u0007\u0000\b\u0003\u0005\u0000\b\u0003\u0002\u0000\u0002\u0003\u0002\u0000\u0016\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0001\u0003\u0003\u0000\u0004\u0003\u0003\u0000\u0001\u0003\u000e\u0000\u0002\u0003\u0001\u0000\u0005\u0003\u0011\u0000\u0006\u0003\u0004\u0000\u0002\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0002\u0003\u000f\u0000\u0004\u0003\u0001\u0000\u0001\u0003\u0003\u0000\u0003\u0003\u0010\u0000\t\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0005\u0003\u0003\u0000\u0001\u0003\u0002\u0000\u0001\u0003\u0012\u0000\u0001\u0003\u0001\u0000\u0006\u0003\u0003\u0000\u0003\u0003\u0001\u0000\u0004\u0003\u0003\u0000\u0002\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0002\u0003\u0003\u0000\u0002\u0003\u0003\u0000\u0003\u0003\u0003\u0000\b\u0003\u0001\u0000\u0003\u0003\u000f\u0000\u0001\u0003\u000b\u0000\b\u0003\u0001\u0000\u0006\u0003\u0001\u0000\u0005\u0003\u0006\u0000\u0004\u0003\u0001\u0000\u0005\u0003\u0003\u0000\u0001\u0003\u0010\u0000\u0001\u0003\u0001\u0000\n\u0003\u000b\u0000\u0012\u0003\u0003\u0000\b\u0003\u0001\u0000\t\u0003\u0001\u0000\u0001\u0003\u0002\u0000\u0001\u0003\u0001\u0000\u0002\u0003\u000b\u0000\u0001\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0001\u0003\u0002\u0000\u0002\u0003\u0001\u0000\u0001\u0003\u0002\u0000\u0001\u0003\u0006\u0000\u0004\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0003\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0002\u0000\u0002\u0003\u0001\u0000\u0004\u0003\u0001\u0000\u0002\u0003\t\u0000\u0001\u0003\u0002\u0000\u0005\u0003\u0001\u0000\u0001\u0003\u0015\u0000\u0002\u0003\u0002\u0000\b\u0003\u0001\u0000\u0007\u0003\b\u0000\u0004\u0003\u0004\u0000\u0002\u0003\u0001\u0000\u0005\u0003\u0001\u0000\u0002\u0003\u0005\u0000\t\u0003\u0007\u0000\n\u0003\u0005\u0000\u0004\u0003\u0005\u0000\u000f\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0002\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0002\u0000\u0007\u0003\u0001\u0000\u0005\u0003\u000b\u0000\r\u0003\u0002\u0000\f\u0003\u0003\u0000\u000f\u0003\u0001\u0000\u0002\u0003\u0007\u0000\u0001\u0003\u0003\u0000\u0002\u0003\u0003\u0000\r\u0003\u0003\u0000\u000e\u0003\u0002\u0000\f\u0003\u0004\u0000\u0006\u0003\u0002\u0000\u0006\u0003\u0002\u0000\b\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0006\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0001\u0003\u0003\u0000\u0003\u0003\u0001\u0000\u0007\u0003\u0003\u0000\u0004\u0003\u0002\u0000\u0006\u0003\f\u0000\u0002\n\u0015\u0000\u0001\u0003\u0004\u0000\u0001\u0003\f\u0000\u0001\u0003\r\u0000\u0001\u0003\u0002\u0000\u0001\u0003\u0004\u0000\u0001\u0003\u0002\u0000\n\u0003\u0001\u0000\u0001\u0003\u0003\u0000\u0005\u0003\u0006\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0004\u0003\u0001\u0000\u0003\u0003\u0001\u0000\u0007\u0003\u0003\u0000\u0003\u0003\u0005\u0000\u0005\u0003\u000b\u0000\u0003\u0003\t\u0000\t\u0003\u0007\u0000\u0005\u0003\u0002\u0000\u0005\u0003\u0003\u0000\u0007\u0003\u0006\u0000\u0003\u0003\u0003\u0000\u0005\u0003\u0005\u0000\u0001\u0003\u0001\u0000\b\u0003\u0001\u0000\u0005\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0002\u0003\u0001\u0000\n\u0003\u0003\u0000\r\u0003\u0002\u0000\u000e\u0003\u0003\u0000\u0002\u0003\u000b\u0000\u0005\u0003\u0001\u0000\u0015\u0003\u0004\u0000\u0001\u0003\u0002\u0000\u0006\u0003\u0002\u0000\u0006\u0003\u0002\u0000\u0006\u0003\u0002\u0000\u0003\u0003\u0003\u0000\u0002\u0003\u0003\u0000\u0002\u0003\t\u0000\f\u0003\u0001\u0000\u000e\u0003\u0001\u0000\u0002\u0003\u0001\u0000\u0007\u0003\u0002\u0000\u0001\u0003\u0001\u0000\f\u0003\u0001\u0000\u0002\u0003\u0003\u0000\u0001\u0003\u0002\u0000\u0001\u0003\u0002\u0000\u0001\u0003\u0002\u0000\u0002\u0003\u0002\u0000\u0004\u0003\u0001\u0000\f\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0011\u0003\u0001\u0000\u0004\u0003\u0002\u0000\b\u0003\u0001\u0000\u0007\u0003\u0001\u0000\f\u0003\u0001\u0000\u0004\u0003\u0001\u0000\u0005\u0003\u0001\u0000\u0001\u0003\u0003\u0000\n\u0003\u0004\u0000\u0013\u0003\u0001\u0000\u0007\u0003\u0001\u0000\u0006\u0003\u0006\u0000");
    private static final int[] ZZ_ACTION = _KDocLexer.zzUnpackAction();
    private static final int[] ZZ_ROWMAP = _KDocLexer.zzUnpackRowMap();
    private static final int[] ZZ_TRANS = _KDocLexer.zzUnpackTrans();
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = _KDocLexer.zzUnpackAttribute();
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private CharSequence zzBuffer = "";
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;

    public static int ZZ_CMAP(int ch) {
        return ZZ_CMAP_A[ZZ_CMAP_Y[ZZ_CMAP_Z[ch >> 10] << 6 | ch >> 4 & 0x3F] << 4 | ch & 0xF];
    }

    private static int[] zzUnpackAction() {
        int[] result2 = new int[63];
        int offset2 = 0;
        offset2 = _KDocLexer.zzUnpackAction("\t\u0000\u0003\u0001\u0001\u0002\u0001\u0003\u0003\u0002\u0001\u0004\u0001\u0005\u0001\u0004\u0003\u0002\u0001\u0006\u0001\u0007\u0002\u0002\u0001\b\u0001\t\u0003\b\u0001\n\u0001\u0000\u0001\u000b\u0006\u0000\u0001\u0004\u0001\f\u0001\r\u0004\u0000\u0001\u000e\u0002\u0000\u0001\u000f\u0001\u0004\u0001\u0010\u0001\u0011\u0001\u0000\u0002\u0012\u0001\u0000\u0001\u0013\u0001\u0003\u0001\u0014\u0001\u0013", offset2, result2);
        return result2;
    }

    private static int zzUnpackAction(String packed, int offset2, int[] result2) {
        int i = 0;
        int j = offset2;
        int l = packed.length();
        while (i < l) {
            int count2 = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result2[j++] = value;
            } while (--count2 > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result2 = new int[63];
        int offset2 = 0;
        offset2 = _KDocLexer.zzUnpackRowMap("\u0000\u0000\u0000\u0013\u0000&\u00009\u0000L\u0000_\u0000r\u0000\u0085\u0000\u0098\u0000\u00ab\u0000\u00be\u0000\u00d1\u0000\u00ab\u0000\u00e4\u0000\u00f7\u0000\u010a\u0000\u011d\u0000\u0130\u0000\u0143\u0000\u0156\u0000\u0169\u0000\u00d1\u0000\u017c\u0000\u018f\u0000\u01a2\u0000\u01b5\u0000\u01c8\u0000\u00ab\u0000\u01db\u0000\u00d1\u0000\u01ee\u0000\u0201\u0000\u0214\u0000\u0227\u0000\u00ab\u0000\u00d1\u0000\u023a\u0000\u024d\u0000\u0260\u0000\u0273\u0000\u0286\u0000\u0299\u0000\u00ab\u0000\u02ac\u0000\u02bf\u0000\u02d2\u0000\u02e5\u0000\u02f8\u0000\u00ab\u0000\u030b\u0000\u031e\u0000\u0331\u0000\u0344\u0000\u00ab\u0000\u00ab\u0000\u0357\u0000\u023a\u0000\u0260\u0000\u036a\u0000\u023a\u0000\u0344\u0000\u037d\u0000\u00ab", offset2, result2);
        return result2;
    }

    private static int zzUnpackRowMap(String packed, int offset2, int[] result2) {
        int i = 0;
        int j = offset2;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result2[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result2 = new int[912];
        int offset2 = 0;
        offset2 = _KDocLexer.zzUnpackTrans("\t\n\u0003\u0000\u0001\u000b\u0001\f\u0005\n\u0001\r\u0001\u000e\u0003\r\u0001\u000f\u0001\r\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0000\u0001\u0012\u0001\r\u0001\u0013\u0001\r\u0001\u0014\u0001\u0015\u0003\r\u0001\u000e\u0003\r\u0001\u000f\u0001\r\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0000\u0001\u0012\u0001\r\u0001\u0016\u0001\u0017\u0001\u0014\u0001\u0015\u0003\r\u0001\u0018\u0001\r\u0001\u0019\u0001\r\u0001\u001a\u0003\r\u0001\u0018\u0001\u0000\u0001\u0018\u0001\r\u0001\u0016\u0001\r\u0001\u0018\u0004\r\u0001\u0018\u0003\r\u0001\u001b\u0003\r\u0001\u0018\u0001\u0000\u0001\u0018\u0001\r\u0001\u0016\u0001\r\u0001\u0018\u0004\r\u0001\u000e\u0003\r\u0001\u000f\u0001\r\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0000\u0001\u0012\u0001\r\u0001\u0016\u0001\r\u0001\u0014\u0001\u0015\u0002\r\u0001\u001c\u0001\u001d\u0007\u001c\u0001\u001d\u0001\u0000\u0001\u001d\u0001\u001c\u0001\u001e\u0001\u001c\u0001\u001d\u0004\u001c\u0001\u001d\u0005\u001c\u0001\u001f\u0001 \u0001\u001d\u0001\u0000\u0001\u001d\u0001\u001c\u0001!\u0001\u001c\u0001\u001d\u0004\u001c\u0001\u001d\u0005\u001c\u0001\u001f\u0001 \u0001\u001d\u0001\u0000\u0001\u001d\u0001\u001c\u0001\u001e\u0001\u001c\u0001\u001d\u0003\u001c \u0000\u0001\"\u0011\u0000\u0001#\u0001$\u0006\u0000\u0001\u000e\u0007\u0000\u0001\u0012\u0001\u0000\u0001\u0012\u0003\u0000\u0001\u0012\u0003\u0000\u0003%\u0001&\u0001%\u0001\u0000\u0001'\f%\u0007\u0000\u0001(\u0013\u0000\u0001)\u000b\u0000\u0001\u0012\u0007\u0000\u0001\u0012\u0001\u0000\u0001\u0012\u0003\u0000\u0001\u0012\u000f\u0000\u0001#\u0001\u0013\u0006\u0000\u0001\u0012\u0007\u0000\u0001\u0012\u0001\u0000\u0001\u0012\u0003\u0000\u0001*\b\u0000\u0002+\u000f\u0000\u0001,\u0010\u0000\u0001\u0018\u0007\u0000\u0001\u0018\u0001\u0000\u0001\u0018\u0003\u0000\u0001\u0018\u0005\u0000\u0003\u0019\u0011\u0000\u0001-\u0012\u0000\u0001.\u0010\u0000\u0001\u001d\u0007\u0000\u0001\u001d\u0001\u0000\u0001\u001d\u0003\u0000\u0001\u001d\n\u0000\u0001/\u0013\u0000\u00010\u0016\u0000\u0001#\u0001!\u0012\u0000\u00011\u0005\u0000\u0005%\u0001\u0000\u0001'\u000e%\u0003&\u0001\u0000\u00012\u0011%\u0001\u0000\u0001'\n%\u00013\u0001%\u0007\u0000\u00014\u0013\u0000\u00014\u000b\u0000\u0001\u0012\u0007\u0000\u0001\u0012\u0001\u0000\u0001\u0012\u0003\u0000\u00015\u0005\u0000\u0002,\u0011\u0000\u0003-\u0001\u0000\u00016\u000e\u0000\u0003.\u0001\u0000\u00017\u0013\u0000\u00018\u0013\u0000\u00018\n\u0000\u00059\u0001\u0000\u0001:\n9\u00013\u00019\u00053\u0001;\f3\u0001<\t4\u0003\u0000\u00074\u0001\u0000\u0001\u0012\u0007\u0000\u0001\u0012\u0001\u0000\u0001\u0012\u0003\u0000\u0001=\u0004\u0000\u00018\u0007\u0000\u0001>\u0001\u0000\u00018\u0003\u0000\u00018\u0003\u0000\u0012;\u0001?\u0001\u0000\u0001>\t\u0000\u0001>\u0003\u0000\u0001>\u0003\u0000", offset2, result2);
        return result2;
    }

    private static int zzUnpackTrans(String packed, int offset2, int[] result2) {
        int i = 0;
        int j = offset2;
        int l = packed.length();
        while (i < l) {
            int count2 = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result2[j++] = --value;
            } while (--count2 > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result2 = new int[63];
        int offset2 = 0;
        offset2 = _KDocLexer.zzUnpackAttribute("\t\u0000\u0001\t\u0002\u0001\u0001\t\u000e\u0001\u0001\t\u0005\u0001\u0001\u0000\u0001\t\u0006\u0000\u0001\u0001\u0001\t\u0001\u0001\u0004\u0000\u0001\t\u0002\u0000\u0002\u0001\u0002\t\u0001\u0000\u0002\u0001\u0001\u0000\u0003\u0001\u0001\t", offset2, result2);
        return result2;
    }

    private static int zzUnpackAttribute(String packed, int offset2, int[] result2) {
        int i = 0;
        int j = offset2;
        int l = packed.length();
        while (i < l) {
            int count2 = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result2[j++] = value;
            } while (--count2 > 0);
        }
        return j;
    }

    public _KDocLexer() {
        this(null);
    }

    private boolean isLastToken() {
        return this.zzMarkedPos == this.zzBuffer.length();
    }

    private boolean yytextContainLineBreaks() {
        return CharArrayUtil.containLineBreaks(this.zzBuffer, this.zzStartRead, this.zzMarkedPos);
    }

    _KDocLexer(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        int size = 0;
        int length = packed.length();
        for (int i = 0; i < length; i += 2) {
            size += packed.charAt(i);
        }
        char[] map2 = new char[size];
        int i = 0;
        int j = 0;
        while (i < packed.length()) {
            int count2 = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map2[j++] = value;
            } while (--count2 > 0);
        }
        return map2;
    }

    public final int getTokenStart() {
        return this.zzStartRead;
    }

    @Override
    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    @Override
    public void reset(CharSequence buffer, int start, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzMarkedPos = this.zzStartRead = start;
        this.zzCurrentPos = this.zzStartRead;
        this.zzAtEOF = false;
        this.zzAtBOL = true;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    @Override
    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
            return;
        }
    }

    @Override
    public IElementType advance() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block42: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + _KDocLexer.ZZ_CMAP(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    return TokenType.BAD_CHARACTER;
                }
                case 21: {
                    continue block42;
                }
                case 2: {
                    this.yybegin(10);
                    return KDocTokens.TEXT;
                }
                case 22: {
                    continue block42;
                }
                case 3: {
                    if (this.yystate() == 4) {
                        this.yybegin(18);
                        return KDocTokens.CODE_BLOCK_TEXT;
                    }
                }
                case 23: {
                    continue block42;
                }
                case 4: {
                    if (this.yytextContainLineBreaks()) {
                        this.yybegin(2);
                        return TokenType.WHITE_SPACE;
                    }
                    this.yybegin(this.yystate() == 4 ? 4 : 10);
                    return KDocTokens.TEXT;
                }
                case 24: {
                    continue block42;
                }
                case 5: {
                    this.yybegin(4);
                    return KDocTokens.LEADING_ASTERISK;
                }
                case 25: {
                    continue block42;
                }
                case 6: {
                    if (this.yytextContainLineBreaks()) {
                        this.yybegin(2);
                    }
                    return TokenType.WHITE_SPACE;
                }
                case 26: {
                    continue block42;
                }
                case 7: {
                    this.yybegin(8);
                    return KDocTokens.MARKDOWN_LINK;
                }
                case 27: {
                    continue block42;
                }
                case 8: {
                    this.yybegin(this.yystate() == 18 ? 18 : 12);
                    return KDocTokens.CODE_BLOCK_TEXT;
                }
                case 28: {
                    continue block42;
                }
                case 9: {
                    if (this.yytextContainLineBreaks()) {
                        this.yybegin(this.yystate() == 18 ? 2 : 14);
                        return TokenType.WHITE_SPACE;
                    }
                    return KDocTokens.CODE_BLOCK_TEXT;
                }
                case 29: {
                    continue block42;
                }
                case 10: {
                    this.yybegin(16);
                    return KDocTokens.LEADING_ASTERISK;
                }
                case 30: {
                    continue block42;
                }
                case 11: {
                    if (this.isLastToken()) {
                        return KDocTokens.END;
                    }
                    return KDocTokens.TEXT;
                }
                case 31: {
                    continue block42;
                }
                case 12: {
                    this.yybegin(10);
                    return KDocTokens.MARKDOWN_ESCAPED_CHAR;
                }
                case 32: {
                    continue block42;
                }
                case 13: {
                    KDocKnownTag tag = KDocKnownTag.Companion.findByTagName(this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos));
                    this.yybegin(tag != null && tag.isReferenceRequired() ? 6 : 8);
                    return KDocTokens.TAG_NAME;
                }
                case 33: {
                    continue block42;
                }
                case 14: {
                    this.yybegin(4);
                    return KDocTokens.START;
                }
                case 34: {
                    continue block42;
                }
                case 15: {
                    this.yybegin(14);
                    return KDocTokens.TEXT;
                }
                case 35: {
                    continue block42;
                }
                case 16: {
                    this.yybegin(8);
                    return KDocTokens.MARKDOWN_LINK;
                }
                case 36: {
                    continue block42;
                }
                case 17: {
                    this.yybegin(10);
                    return KDocTokens.MARKDOWN_LINK;
                }
                case 37: {
                    continue block42;
                }
                case 18: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzMarkedPos, -1);
                    this.yybegin(10);
                    return KDocTokens.MARKDOWN_LINK;
                }
                case 38: {
                    continue block42;
                }
                case 19: {
                    this.yybegin(10);
                    return KDocTokens.MARKDOWN_INLINE_LINK;
                }
                case 39: {
                    continue block42;
                }
                case 20: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 3);
                    this.yybegin(10);
                    return KDocTokens.TEXT;
                }
                case 40: {
                    continue block42;
                }
            }
            this.zzScanError(1);
        }
    }
}

