/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.LabelNameRefreshingVisitor;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"aliasArgumentsIfNeeded", "", "context", "Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "arguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "parameters", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "source", "", "refreshLabelNames", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "node", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "renameLocalNames", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "js.translator"})
public final class NamingUtilsKt {
    public static final void aliasArgumentsIfNeeded(@NotNull NamingContext context, @NotNull List<? extends JsExpression> arguments2, @NotNull List<JsParameter> parameters2, @Nullable Object source) {
        Collection $i$a$1$require2;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        Intrinsics.checkParameterIsNotNull(parameters2, (String)"parameters");
        boolean bl2 = bl = arguments2.size() <= parameters2.size();
        if (!bl) {
            String string = "arguments.size (" + arguments2.size() + ") should be less or equal to parameters.size (" + parameters2.size() + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        List defaultParams = new ArrayList();
        for (Collection $i$a$1$require2 : CollectionsKt.zip((Iterable)arguments2, (Iterable)parameters2)) {
            JsNameRef replacement;
            JsName jsName;
            JsName paramName;
            JsExpression arg = (JsExpression)$i$a$1$require2.component1();
            JsParameter param = (JsParameter)$i$a$1$require2.component2();
            if (JsAstUtils.isUndefinedExpression(arg)) {
                Collection collection = defaultParams;
                collection.add(param);
                continue;
            }
            JsName jsName2 = paramName = param.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName2, (String)"paramName");
            JsName $receiver = jsName = JsScope.declareTemporaryName(jsName2.getIdent());
            MetadataProperties.setStaticRef($receiver, arg);
            JsName jsName3 = $receiver;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName3, (String)"this");
            context.newVar(jsName3, arg.deepCopy(), source);
            JsNameRef jsNameRef = replacement = jsName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"replacement");
            jsNameRef.setSource(arg.getSource());
            context.replaceName(paramName, replacement);
        }
        $i$a$1$require2 = defaultParams;
        Iterator iterator2 = parameters2.subList(arguments2.size(), parameters2.size());
        CollectionsKt.addAll((Collection)$i$a$1$require2, (Iterable)((Object)iterator2));
        for (JsParameter defaultParam : defaultParams) {
            JsName paramName;
            JsName jsName = paramName = defaultParam.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"paramName");
            JsName freshName = JsScope.declareTemporaryName(jsName.getIdent());
            freshName.copyMetadataFrom(paramName);
            JsName jsName4 = freshName;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName4, (String)"freshName");
            NamingContext.newVar$default(context, jsName4, null, source, 2, null);
            JsNameRef jsNameRef = freshName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"freshName.makeRef()");
            context.replaceName(paramName, jsNameRef);
        }
    }

    public static final void renameLocalNames(@NotNull NamingContext context, @NotNull JsFunction function2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        JsBlock jsBlock = function2.getBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"function.body");
        for (JsName name : CollectUtilsKt.collectDefinedNames(jsBlock)) {
            JsName jsName;
            JsName $receiver = jsName = JsScope.declareTemporaryName(name.getIdent());
            MetadataProperties.setStaticRef($receiver, MetadataProperties.getStaticRef(name));
            JsName temporaryName = jsName;
            JsNameRef jsNameRef = temporaryName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"temporaryName.makeRef()");
            context.replaceName(name, jsNameRef);
        }
    }

    @NotNull
    public static final JsNode refreshLabelNames(@NotNull JsNode node, @NotNull JsScope scope) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        if (!(scope instanceof JsFunctionScope)) {
            throw (Throwable)((Object)new AssertionError((Object)"JsFunction is expected to have JsFunctionScope"));
        }
        LabelNameRefreshingVisitor visitor2 = new LabelNameRefreshingVisitor((JsFunctionScope)scope);
        JsNode jsNode = visitor2.accept(node);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNode, (String)"visitor.accept(node)");
        return jsNode;
    }
}

