/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.InlineChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\"\u0010\u0003\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/InlineCheckerWrapper;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "checkersCache", "Ljava/lang/ref/WeakReference;", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "getChecker", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "frontend"})
public final class InlineCheckerWrapper
implements CallChecker {
    private WeakReference<Map<DeclarationDescriptor, CallChecker>> checkersCache;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (context.isAnnotationContext()) {
            return;
        }
        for (DeclarationDescriptor parentDescriptor = context.getScope().getOwnerDescriptor(); parentDescriptor != null; parentDescriptor = parentDescriptor.getContainingDeclaration()) {
            if (!InlineUtil.isInline(parentDescriptor)) continue;
            CallChecker checker = this.getChecker((FunctionDescriptor)parentDescriptor);
            checker.check(resolvedCall2, reportOn, context);
        }
    }

    private final CallChecker getChecker(FunctionDescriptor descriptor2) {
        Object object;
        WeakReference<Object> weakReference;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> map2;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> weakReference2 = this.checkersCache;
        if (weakReference2 == null || (weakReference2 = (Map)weakReference2.get()) == null) {
            weakReference2 = map2 = (Map)new HashMap();
        }
        if ((weakReference = this.checkersCache) == null) {
            weakReference = new WeakReference<Object>(map2);
        }
        this.checkersCache = weakReference;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> weakReference3 = map2;
        Intrinsics.checkExpressionValueIsNotNull((Object)weakReference3, (String)"map");
        WeakReference<Map<DeclarationDescriptor, CallChecker>> $receiver$iv = weakReference3;
        Object value$iv = $receiver$iv.get(descriptor2);
        if (value$iv == null) {
            CallChecker answer$iv = new InlineChecker(descriptor2);
            $receiver$iv.put(descriptor2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CallChecker)object;
    }
}

