/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom.input.sax;

import java.io.IOException;
import java.io.Reader;
import org.jetbrains.kotlin.org.jdom.Document;
import org.jetbrains.kotlin.org.jdom.JDOMException;
import org.jetbrains.kotlin.org.jdom.input.JDOMParseException;
import org.jetbrains.kotlin.org.jdom.input.sax.SAXEngine;
import org.jetbrains.kotlin.org.jdom.input.sax.SAXHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SAXBuilderEngine
implements SAXEngine {
    private final XMLReader saxParser;
    private final SAXHandler saxHandler;
    private final boolean validating;

    public SAXBuilderEngine(XMLReader reader, SAXHandler handler2, boolean validating) {
        this.saxParser = reader;
        this.saxHandler = handler2;
        this.validating = validating;
    }

    public Document build(InputSource in) throws JDOMException, IOException {
        try {
            this.saxParser.parse(in);
            Document document = this.saxHandler.getDocument();
            return document;
        }
        catch (SAXParseException e) {
            String systemId;
            Document doc = this.saxHandler.getDocument();
            if (!doc.hasRootElement()) {
                doc = null;
            }
            if ((systemId = e.getSystemId()) != null) {
                throw new JDOMParseException("Error on line " + e.getLineNumber() + " of document " + systemId + ": " + e.getMessage(), e, doc);
            }
            throw new JDOMParseException("Error on line " + e.getLineNumber() + ": " + e.getMessage(), e, doc);
        }
        catch (SAXException e) {
            throw new JDOMParseException("Error in building: " + e.getMessage(), e, this.saxHandler.getDocument());
        }
        finally {
            this.saxHandler.reset();
        }
    }

    @Override
    public Document build(Reader characterStream) throws JDOMException, IOException {
        return this.build(new InputSource(characterStream));
    }
}

