/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.editor.impl;

import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ReadAction;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuardImpl;
import org.jetbrains.kotlin.com.intellij.openapi.command.CommandProcessor;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.RangeMarker;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ReadOnlyModificationException;
import org.jetbrains.kotlin.com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentListener;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.DocumentEx;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.RangeMarkerEx;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.FrozenDocument;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.LineSet;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.LockFreeCOWSortedArray;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.PersistentRangeMarker;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.RangeMarkerTree;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.ShutDownTracker;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.LocalTimeCounter;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.text.ImmutableCharSequence;

public class DocumentImpl
extends UserDataHolderBase
implements DocumentEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.impl.DocumentImpl");
    private final LockFreeCOWSortedArray<DocumentListener> myDocumentListeners;
    private final List<DocumentBulkUpdateListener> myBulkDocumentInternalListeners;
    private final RangeMarkerTree<RangeMarkerEx> myRangeMarkers;
    private final RangeMarkerTree<RangeMarkerEx> myPersistentRangeMarkers;
    private final List<RangeMarker> myGuardedBlocks;
    private final Object myLineSetLock;
    private volatile LineSet myLineSet;
    private volatile ImmutableCharSequence myText;
    private volatile SoftReference<String> myTextString;
    private volatile FrozenDocument myFrozen;
    private boolean myIsReadOnly;
    private volatile boolean isStripTrailingSpacesEnabled;
    private volatile long myModificationStamp;
    private final PropertyChangeSupport myPropertyChangeSupport;
    private final List<Object> myReadOnlyListeners;
    private int myCheckGuardedBlocks;
    private boolean myGuardsSuppressed;
    private boolean myEventsHandling;
    private final boolean myAssertThreading;
    private volatile boolean myDoingBulkUpdate;
    private volatile boolean myAcceptSlashR;
    private boolean myChangeInProgress;
    private volatile int myBufferSize;
    private final CharSequence myMutableCharSequence;
    private final AtomicInteger sequence;
    static final Key<Reference<RangeMarkerTree<RangeMarkerEx>>> RANGE_MARKERS_KEY = Key.create("RANGE_MARKERS_KEY");
    static final Key<Reference<RangeMarkerTree<RangeMarkerEx>>> PERSISTENT_RANGE_MARKERS_KEY = Key.create("PERSISTENT_RANGE_MARKERS_KEY");
    private static final ReferenceQueue<RangeMarkerTree<RangeMarkerEx>> rmTreeQueue = new ReferenceQueue();

    public DocumentImpl(@NotNull CharSequence chars) {
        if (chars == null) {
            DocumentImpl.$$$reportNull$$$0(1);
        }
        this(chars, false);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean forUseInNonAWTThread) {
        if (chars == null) {
            DocumentImpl.$$$reportNull$$$0(2);
        }
        this(chars, false, forUseInNonAWTThread);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean acceptSlashR, boolean forUseInNonAWTThread) {
        if (chars == null) {
            DocumentImpl.$$$reportNull$$$0(3);
        }
        this.myDocumentListeners = new LockFreeCOWSortedArray<DocumentListener>(PrioritizedDocumentListener.COMPARATOR, DocumentListener.ARRAY_FACTORY);
        this.myBulkDocumentInternalListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRangeMarkers = new RangeMarkerTree(this);
        this.myPersistentRangeMarkers = new RangeMarkerTree(this);
        this.myGuardedBlocks = new ArrayList<RangeMarker>();
        this.myLineSetLock = new String("line set lock");
        this.isStripTrailingSpacesEnabled = true;
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myReadOnlyListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMutableCharSequence = new CharSequence(){

            @Override
            public int length() {
                return DocumentImpl.this.myText.length();
            }

            @Override
            public char charAt(int index2) {
                return DocumentImpl.this.myText.charAt(index2);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return DocumentImpl.this.myText.subSequence(start, end);
            }

            @Override
            @NotNull
            public String toString() {
                String string = DocumentImpl.this.doGetText();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/DocumentImpl$1", "toString"));
            }
        };
        this.sequence = new AtomicInteger();
        this.setAcceptSlashR(acceptSlashR);
        this.assertValidSeparators(chars);
        this.myText = CharArrayUtil.createImmutableCharSequence(chars);
        this.setCyclicBufferSize(0);
        this.setModificationStamp(LocalTimeCounter.currentTime());
        this.myAssertThreading = !forUseInNonAWTThread;
    }

    public boolean setAcceptSlashR(boolean accept) {
        try {
            boolean bl = this.myAcceptSlashR;
            return bl;
        }
        finally {
            this.myAcceptSlashR = accept;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LineSet getLineSet() {
        LineSet lineSet = this.myLineSet;
        if (lineSet == null) {
            Object object = this.myLineSetLock;
            synchronized (object) {
                lineSet = this.myLineSet;
                if (lineSet == null) {
                    this.myLineSet = lineSet = LineSet.createLineSet(this.myText);
                }
            }
        }
        return lineSet;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        if (this.myIsReadOnly != isReadOnly) {
            this.myIsReadOnly = isReadOnly;
            this.myPropertyChangeSupport.firePropertyChange("writable", !isReadOnly, isReadOnly);
        }
    }

    @Override
    public boolean isWritable() {
        return !this.myIsReadOnly;
    }

    private RangeMarkerTree<RangeMarkerEx> treeFor(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            DocumentImpl.$$$reportNull$$$0(13);
        }
        return rangeMarker instanceof PersistentRangeMarker ? this.myPersistentRangeMarkers : this.myRangeMarkers;
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            DocumentImpl.$$$reportNull$$$0(14);
        }
        return this.treeFor(rangeMarker).removeInterval(rangeMarker);
    }

    public RangeMarker getRangeGuard(int start, int end) {
        for (RangeMarker block : this.myGuardedBlocks) {
            if (!DocumentImpl.rangesIntersect(start, end, true, true, block.getStartOffset(), block.getEndOffset(), block.isGreedyToLeft(), block.isGreedyToRight())) continue;
            return block;
        }
        return null;
    }

    private static boolean rangesIntersect(int start0, int end0, boolean start0Inclusive, boolean end0Inclusive, int start1, int end1, boolean start1Inclusive, boolean end1Inclusive) {
        if (start0 > start1 || start0 == start1 && !start0Inclusive) {
            if (end1 == start0) {
                return start0Inclusive && end1Inclusive;
            }
            return end1 > start0;
        }
        if (end0 == start1) {
            return start1Inclusive && end0Inclusive;
        }
        return end0 > start1;
    }

    @Override
    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myModificationStamp = modificationStamp;
        this.myFrozen = null;
    }

    private void trimToSize() {
        if (this.myBufferSize != 0 && this.getTextLength() > this.myBufferSize) {
            this.deleteString(0, this.getTextLength() - this.myBufferSize);
        }
    }

    public void deleteString(int startOffset, int endOffset) {
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException(this);
        }
        if (startOffset == endOffset) {
            return;
        }
        RangeMarker marker = this.getRangeGuard(startOffset, endOffset);
        if (marker != null) {
            this.throwGuardedFragment(marker, startOffset, this.myText.subSequence(startOffset, endOffset), "");
        }
        ImmutableCharSequence newText = this.myText.delete(startOffset, endOffset);
        ImmutableCharSequence oldString = this.myText.subtext(startOffset, endOffset);
        this.updateText(newText, startOffset, oldString, "", false, LocalTimeCounter.currentTime(), startOffset, endOffset - startOffset);
    }

    @Override
    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            DocumentImpl.$$$reportNull$$$0(22);
        }
        this.replaceString(startOffset, endOffset, s, LocalTimeCounter.currentTime(), false);
    }

    private void replaceString(int startOffset, int endOffset, @NotNull CharSequence s, long newModificationStamp, boolean bl) {
        ImmutableCharSequence newText;
        boolean wholeTextReplaced;
        int newEndInString;
        int newStartInString;
        if (s == null) {
            DocumentImpl.$$$reportNull$$$0(23);
        }
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException(this);
        }
        int initialStartOffset = startOffset;
        int initialOldLength = endOffset - startOffset;
        int newStringLength = s.length();
        ImmutableCharSequence chars = this.myText;
        for (newStartInString = 0; newStartInString < newStringLength && startOffset < endOffset && s.charAt(newStartInString) == chars.charAt(startOffset); ++startOffset, ++newStartInString) {
        }
        for (newEndInString = newStringLength; endOffset > startOffset && newEndInString > newStartInString && s.charAt(newEndInString - 1) == chars.charAt(endOffset - 1); --newEndInString, --endOffset) {
        }
        if (startOffset == 0 && endOffset == this.getTextLength()) {
            wholeTextReplaced = true;
        }
        CharSequence changedPart = s.subSequence(newStartInString, newEndInString);
        ImmutableCharSequence sToDelete = this.myText.subtext(startOffset, endOffset);
        RangeMarker guard = this.getRangeGuard(startOffset, endOffset);
        if (guard != null) {
            this.throwGuardedFragment(guard, startOffset, sToDelete, changedPart);
        }
        if (wholeTextReplaced && s instanceof ImmutableCharSequence) {
            newText = (ImmutableCharSequence)s;
        } else {
            newText = this.myText.delete(startOffset, endOffset).insert(startOffset, changedPart);
            changedPart = newText.subtext(startOffset, startOffset + changedPart.length());
        }
        this.updateText(newText, startOffset, sToDelete, changedPart, wholeTextReplaced, newModificationStamp, initialStartOffset, initialOldLength);
        this.trimToSize();
    }

    private void assertBounds(int startOffset, int endOffset) {
        if (startOffset < 0 || startOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong startOffset: " + startOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < 0 || endOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong endOffset: " + endOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < startOffset) {
            throw new IllegalArgumentException("endOffset < startOffset: " + endOffset + " < " + startOffset + "; documentLength: " + this.getTextLength());
        }
    }

    private void assertWriteAccess() {
        Application application;
        if (this.myAssertThreading && (application = ApplicationManager.getApplication()) != null) {
            application.assertWriteAccessAllowed();
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(this);
            if (file2 != null && file2.isInLocalFileSystem()) {
                ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
            }
        }
    }

    private void assertValidSeparators(@NotNull CharSequence s) {
        if (s == null) {
            DocumentImpl.$$$reportNull$$$0(24);
        }
        if (this.myAcceptSlashR) {
            return;
        }
        StringUtil.assertValidSeparators(s);
    }

    private void assertNotNestedModification() throws IllegalStateException {
        if (this.myChangeInProgress) {
            throw new IllegalStateException("Detected document modification from DocumentListener");
        }
    }

    private void throwGuardedFragment(@NotNull RangeMarker guard, int offset2, @NotNull CharSequence oldString, @NotNull CharSequence newString) {
        if (guard == null) {
            DocumentImpl.$$$reportNull$$$0(25);
        }
        if (oldString == null) {
            DocumentImpl.$$$reportNull$$$0(26);
        }
        if (newString == null) {
            DocumentImpl.$$$reportNull$$$0(27);
        }
        if (this.myCheckGuardedBlocks > 0 && !this.myGuardsSuppressed) {
            DocumentEventImpl event = new DocumentEventImpl(this, offset2, oldString, newString, this.myModificationStamp, false);
            throw new ReadOnlyFragmentModificationException(event, guard);
        }
    }

    @Override
    public void suppressGuardedExceptions() {
        this.myGuardsSuppressed = true;
    }

    @Override
    public void unSuppressGuardedExceptions() {
        this.myGuardsSuppressed = false;
    }

    @Override
    public boolean isInEventsHandling() {
        return this.myEventsHandling;
    }

    public void clearLineModificationFlags() {
        this.myLineSet = this.getLineSet().clearModificationFlags();
        this.myFrozen = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateText(@NotNull ImmutableCharSequence newText, int offset2, @NotNull CharSequence oldString, @NotNull CharSequence newString, boolean wholeTextReplaced, long newModificationStamp, int initialStartOffset, int n) {
        if (newText == null) {
            DocumentImpl.$$$reportNull$$$0(29);
        }
        if (oldString == null) {
            DocumentImpl.$$$reportNull$$$0(30);
        }
        if (newString == null) {
            DocumentImpl.$$$reportNull$$$0(31);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("updating document " + this + ".\nNext string:'" + newString + "'\nOld string:'" + oldString + "'");
        }
        this.assertNotNestedModification();
        this.myChangeInProgress = true;
        DelayedExceptions exceptions = new DelayedExceptions();
        try {
            void initialOldLength;
            DocumentEventImpl event = new DocumentEventImpl(this, offset2, oldString, newString, this.myModificationStamp, wholeTextReplaced, initialStartOffset, (int)initialOldLength);
            this.beforeChangedUpdate(event, exceptions);
            this.myTextString = null;
            ImmutableCharSequence prevText = this.myText;
            this.myText = newText;
            this.sequence.incrementAndGet();
            this.changedUpdate(event, newModificationStamp, prevText, exceptions);
        }
        finally {
            this.myChangeInProgress = false;
            exceptions.rethrowPCE();
        }
    }

    @Override
    public int getModificationSequence() {
        return this.sequence.get();
    }

    private void beforeChangedUpdate(DocumentEvent event, DelayedExceptions exceptions) {
        FileDocumentManager manager;
        VirtualFile file2;
        Application app = ApplicationManager.getApplication();
        if (app != null && (file2 = (manager = FileDocumentManager.getInstance()).getFile(this)) != null && !file2.isValid()) {
            LOG.error("File of this document has been deleted: " + file2);
        }
        this.assertInsideCommand();
        this.getLineSet();
        if (!ShutDownTracker.isShutdownHookRunning()) {
            DocumentListener[] listeners = this.getListeners();
            for (int i = listeners.length - 1; i >= 0; --i) {
                try {
                    listeners[i].beforeDocumentChange(event);
                    continue;
                }
                catch (Throwable e) {
                    exceptions.register(e);
                }
            }
        }
        this.myEventsHandling = true;
    }

    private void assertInsideCommand() {
        if (!this.myAssertThreading) {
            return;
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        if (!commandProcessor.isUndoTransparentActionInProgress() && commandProcessor.getCurrentCommand() == null) {
            throw new IncorrectOperationException("Must not change document outside command or undo-transparent action. See com.intellij.openapi.command.WriteCommandAction or com.intellij.openapi.command.CommandProcessor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void changedUpdate(@NotNull DocumentEvent event, long newModificationStamp, @NotNull CharSequence prevText, DelayedExceptions delayedExceptions) {
        if (event == null) {
            DocumentImpl.$$$reportNull$$$0(32);
        }
        if (prevText == null) {
            DocumentImpl.$$$reportNull$$$0(33);
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(event.toString());
            }
            assert (event.getOldFragment().length() == event.getOldLength()) : "event.getOldFragment().length() = " + event.getOldFragment().length() + "; event.getOldLength() = " + event.getOldLength();
            assert (event.getNewFragment().length() == event.getNewLength()) : "event.getNewFragment().length() = " + event.getNewFragment().length() + "; event.getNewLength() = " + event.getNewLength();
            assert (prevText.length() + event.getNewLength() - event.getOldLength() == this.getTextLength()) : "prevText.length() = " + prevText.length() + "; event.getNewLength() = " + event.getNewLength() + "; event.getOldLength() = " + event.getOldLength() + "; getTextLength() = " + this.getTextLength();
            this.myLineSet = this.getLineSet().update(prevText, event.getOffset(), event.getOffset() + event.getOldLength(), event.getNewFragment(), event.isWholeTextReplaced());
            assert (this.getTextLength() == this.myLineSet.getLength()) : "getTextLength() = " + this.getTextLength() + "; myLineSet.getLength() = " + this.myLineSet.getLength();
            this.myFrozen = null;
            this.setModificationStamp(newModificationStamp);
            if (!ShutDownTracker.isShutdownHookRunning()) {
                DocumentListener[] listeners;
                for (DocumentListener listener : listeners = this.getListeners()) {
                    try {
                        listener.documentChanged(event);
                    }
                    catch (Throwable e) {
                        void exceptions;
                        exceptions.register(e);
                    }
                }
            }
        }
        finally {
            this.myEventsHandling = false;
        }
    }

    @Override
    @NotNull
    public String getText() {
        String string = ReadAction.compute(this::doGetText);
        if (string == null) {
            DocumentImpl.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private String doGetText() {
        String s = SoftReference.dereference(this.myTextString);
        if (s == null) {
            s = this.myText.toString();
            this.myTextString = new SoftReference<String>(s);
        }
        String string = s;
        if (string == null) {
            DocumentImpl.$$$reportNull$$$0(35);
        }
        return string;
    }

    @Override
    public int getTextLength() {
        return this.myText.length();
    }

    @Override
    @NotNull
    public CharSequence getCharsSequence() {
        CharSequence charSequence = this.myMutableCharSequence;
        if (charSequence == null) {
            DocumentImpl.$$$reportNull$$$0(38);
        }
        return charSequence;
    }

    @Override
    @NotNull
    public CharSequence getImmutableCharSequence() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            DocumentImpl.$$$reportNull$$$0(39);
        }
        return immutableCharSequence;
    }

    @Override
    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            DocumentImpl.$$$reportNull$$$0(40);
        }
        if (ArrayUtil.contains(listener, this.getListeners())) {
            LOG.error("Already registered: " + listener);
        }
        this.myDocumentListeners.add(listener);
    }

    @Override
    public int getLineNumber(int offset2) {
        return this.getLineSet().findLineIndex(offset2);
    }

    @Override
    public final int getLineStartOffset(int line) {
        if (line == 0) {
            return 0;
        }
        return this.getLineSet().getLineStart(line);
    }

    @Override
    public final int getLineEndOffset(int line) {
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result2 = this.getLineSet().getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result2 >= 0);
        return result2;
    }

    public final int getLineSeparatorLength(int line) {
        int separatorLength = this.getLineSet().getSeparatorLength(line);
        assert (separatorLength >= 0);
        return separatorLength;
    }

    @Override
    public final int getLineCount() {
        int lineCount = this.getLineSet().getLineCount();
        assert (lineCount >= 0);
        return lineCount;
    }

    @NotNull
    private DocumentListener[] getListeners() {
        DocumentListener[] documentListenerArray = this.myDocumentListeners.getArray();
        if (documentListenerArray == null) {
            DocumentImpl.$$$reportNull$$$0(47);
        }
        return documentListenerArray;
    }

    public void setCyclicBufferSize(int bufferSize) {
        assert (bufferSize >= 0) : bufferSize;
        this.myBufferSize = bufferSize;
    }

    @Override
    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            DocumentImpl.$$$reportNull$$$0(52);
        }
        Runnable runnable = () -> {
            if (text2 == null) {
                DocumentImpl.$$$reportNull$$$0(58);
            }
            this.replaceString(0, this.getTextLength(), text2, LocalTimeCounter.currentTime(), true);
        };
        if (CommandProcessor.getInstance().isUndoTransparentActionInProgress()) {
            runnable.run();
        } else {
            CommandProcessor.getInstance().executeCommand(null, runnable, "", DocCommandGroupId.noneGroupId(this));
        }
        this.clearLineModificationFlags();
    }

    @Override
    public final boolean isInBulkUpdate() {
        return this.myDoingBulkUpdate;
    }

    public String toString() {
        return "DocumentImpl[" + FileDocumentManager.getInstance().getFile(this) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FrozenDocument freeze() {
        FrozenDocument frozen = this.myFrozen;
        if (frozen == null) {
            Object object = this.myLineSetLock;
            synchronized (object) {
                frozen = this.myFrozen;
                if (frozen == null) {
                    this.myFrozen = frozen = new FrozenDocument(this.myText, this.myLineSet, this.myModificationStamp, SoftReference.dereference(this.myTextString));
                }
            }
        }
        FrozenDocument frozenDocument = frozen;
        if (frozenDocument == null) {
            DocumentImpl.$$$reportNull$$$0(57);
        }
        return frozenDocument;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 16: 
            case 18: 
            case 19: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 46: 
            case 47: 
            case 53: 
            case 56: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 16: 
            case 18: 
            case 19: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 46: 
            case 47: 
            case 53: 
            case 56: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 16: 
            case 18: 
            case 19: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 46: 
            case 47: 
            case 53: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/DocumentImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsets";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "guard";
                break;
            }
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldString";
                break;
            }
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newString";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretLines";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevText";
                break;
            }
            case 36: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/DocumentImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeMarkerForVirtualFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createGuardedBlock";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getGuardedBlocks";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeMarker";
                break;
            }
            case 34: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetText";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsSequence";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmutableCharSequence";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineIterator";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "freeze";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "documentCreatedFrom";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "areRangeMarkersRetainedFor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSaveRMTree";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRangeMarkerForVirtualFile";
                break;
            }
            case 10: 
            case 16: 
            case 18: 
            case 19: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 46: 
            case 47: 
            case 53: 
            case 56: 
            case 57: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "stripTrailingSpaces";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMaxSpacesToLeave";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "treeFor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeRangeMarker";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerRangeMarker";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeGuardedBlock";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "insertString";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "replaceString";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "assertValidSeparators";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "throwGuardedFragment";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "clearLineModificationFlagsExcept";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "changedUpdate";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentListener";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "removeDocumentListener";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addInternalBulkModeListener";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "removeInternalBulkModeListener";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addEditReadOnlyListener";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "removeEditReadOnlyListener";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processRangeMarkers";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "processRangeMarkersOverlappingWith";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setText$3";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getText$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 16: 
            case 18: 
            case 19: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 46: 
            case 47: 
            case 53: 
            case 56: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DelayedExceptions {
        Throwable myException;

        private DelayedExceptions() {
        }

        void register(Throwable e) {
            if (this.myException == null) {
                this.myException = e;
            } else {
                this.myException.addSuppressed(e);
            }
            if (!(e instanceof ProcessCanceledException)) {
                LOG.error(e);
            } else if (DocumentImpl.this.myAssertThreading) {
                LOG.error("ProcessCanceledException must not be thrown from document listeners for real document", new Throwable(e));
            }
        }

        void rethrowPCE() {
            if (this.myException instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)this.myException;
            }
        }
    }
}

