/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.BuiltInsProviderKt;
import org.jetbrains.kotlin.resolve.calls.components.SimpleArgumentsChecksKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.model.ArgumentConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.LHSArgumentConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableForLambdaReturnType;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.CollectionLiteralKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.EagerCallableReferenceAtom;
import org.jetbrains.kotlin.resolve.calls.model.FunctionExpression;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.LHSResult;
import org.jetbrains.kotlin.resolve.calls.model.LambdaKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.LambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.resolve.calls.model.NotCallableExpectedType;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCollectionLiteralAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedLambdaAtom;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\b\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a*\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\r2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001a\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a,\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0002\u001a0\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00172\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0015\u001a\u001e\u0010\u0019\u001a\u0002H\u001a\"\n\b\u0000\u0010\u001a\u0018\u0001*\u00020\u001b*\u00020\u001bH\u0080\b\u00a2\u0006\u0002\u0010\u001c\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u001f"}, d2={"extraLambdaInfo", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedLambdaAtom;", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/LambdaKotlinCallArgument;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "extractLambdaInfoFromFunctionalType", "extractLambdaParameters", "", "preprocessCallableReference", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferenceKotlinCallArgument;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "preprocessCollectionLiteralArgument", "collectionLiteralArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/CollectionLiteralKotlinCallArgument;", "preprocessLambdaArgument", "forceResolution", "", "resolveKtPrimitive", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "isReceiver", "requireIs", "T", "", "(Ljava/lang/Object;)Ljava/lang/Object;", "transformToResolvedLambda", "Lorg/jetbrains/kotlin/resolve/calls/model/LambdaWithTypeVariableAsExpectedTypeAtom;", "resolution"})
public final class PostponeArgumentsChecksKt {
    @NotNull
    public static final ResolvedAtom resolveKtPrimitive(@NotNull ConstraintSystemBuilder csBuilder, @NotNull KotlinCallArgument argument, @Nullable UnwrappedType expectedType, @NotNull KotlinDiagnosticsHolder diagnosticsHolder, boolean isReceiver) {
        ResolvedAtom resolvedAtom;
        Intrinsics.checkParameterIsNotNull((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticsHolder, (String)"diagnosticsHolder");
        KotlinCallArgument kotlinCallArgument = argument;
        if (kotlinCallArgument instanceof SimpleKotlinCallArgument) {
            resolvedAtom = SimpleArgumentsChecksKt.checkSimpleArgument(csBuilder, (SimpleKotlinCallArgument)argument, expectedType, diagnosticsHolder, isReceiver);
        } else if (kotlinCallArgument instanceof LambdaKotlinCallArgument) {
            resolvedAtom = PostponeArgumentsChecksKt.preprocessLambdaArgument$default(csBuilder, (LambdaKotlinCallArgument)argument, expectedType, false, 8, null);
        } else if (kotlinCallArgument instanceof CallableReferenceKotlinCallArgument) {
            resolvedAtom = PostponeArgumentsChecksKt.preprocessCallableReference(csBuilder, (CallableReferenceKotlinCallArgument)argument, expectedType, diagnosticsHolder);
        } else if (kotlinCallArgument instanceof CollectionLiteralKotlinCallArgument) {
            resolvedAtom = PostponeArgumentsChecksKt.preprocessCollectionLiteralArgument((CollectionLiteralKotlinCallArgument)argument, expectedType);
        } else {
            Void void_ = ArgumentsUtilsKt.unexpectedArgument(argument);
            throw null;
        }
        return resolvedAtom;
    }

    private static final ResolvedAtom preprocessLambdaArgument(ConstraintSystemBuilder csBuilder, LambdaKotlinCallArgument argument, UnwrappedType expectedType, boolean forceResolution) {
        ResolvedLambdaAtom resolvedArgument;
        if (expectedType != null && !forceResolution && csBuilder.isTypeVariable(expectedType)) {
            return new LambdaWithTypeVariableAsExpectedTypeAtom(argument, expectedType);
        }
        ResolvedLambdaAtom resolvedLambdaAtom = PostponeArgumentsChecksKt.extractLambdaInfoFromFunctionalType(expectedType, argument);
        if (resolvedLambdaAtom == null) {
            resolvedLambdaAtom = resolvedArgument = PostponeArgumentsChecksKt.extraLambdaInfo(expectedType, argument, csBuilder);
        }
        if (expectedType != null) {
            SimpleType lambdaType = FunctionTypesKt.createFunctionType(BuiltInsProviderKt.getBuiltIns(csBuilder), Annotations.Companion.getEMPTY(), resolvedArgument.getReceiver(), resolvedArgument.getParameters(), null, resolvedArgument.getReturnType(), resolvedArgument.isSuspend());
            csBuilder.addSubtypeConstraint(lambdaType, expectedType, new ArgumentConstraintPosition(argument));
        }
        return resolvedArgument;
    }

    static /* synthetic */ ResolvedAtom preprocessLambdaArgument$default(ConstraintSystemBuilder constraintSystemBuilder, LambdaKotlinCallArgument lambdaKotlinCallArgument, UnwrappedType unwrappedType, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return PostponeArgumentsChecksKt.preprocessLambdaArgument(constraintSystemBuilder, lambdaKotlinCallArgument, unwrappedType, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final ResolvedLambdaAtom extraLambdaInfo(UnwrappedType expectedType, LambdaKotlinCallArgument argument, ConstraintSystemBuilder csBuilder) {
        List list2;
        Object object;
        Object it;
        KotlinBuiltIns builtIns2 = BuiltInsProviderKt.getBuiltIns(csBuilder);
        UnwrappedType unwrappedType = expectedType;
        boolean isSuspend = unwrappedType != null ? FunctionTypesKt.isSuspendFunctionType(unwrappedType) : false;
        boolean isFunctionSupertype = expectedType != null && KotlinBuiltIns.isNotNullOrNullableFunctionSupertype(expectedType);
        LambdaKotlinCallArgument $this$safeAs$iv = argument;
        boolean $i$f$safeAs = false;
        LambdaKotlinCallArgument lambdaKotlinCallArgument = $this$safeAs$iv;
        if (!(lambdaKotlinCallArgument instanceof FunctionExpression)) {
            lambdaKotlinCallArgument = null;
        }
        FunctionExpression argumentAsFunctionExpression = (FunctionExpression)lambdaKotlinCallArgument;
        TypeVariableForLambdaReturnType typeVariable2 = new TypeVariableForLambdaReturnType(argument, builtIns2, "_L");
        FunctionExpression functionExpression = argumentAsFunctionExpression;
        UnwrappedType receiverType = functionExpression != null ? functionExpression.getReceiverType() : null;
        Object object2 = argumentAsFunctionExpression;
        if (object2 == null || (object2 = object2.getReturnType()) == null) {
            Object object3 = expectedType;
            if (object3 != null && (object3 = ((KotlinType)object3).getArguments()) != null && (object3 = (TypeProjection)CollectionsKt.singleOrNull((List)object3)) != null && (object3 = object3.getType()) != null && (object3 = ((KotlinType)object3).unwrap()) != null) {
                Object object4 = object3;
                boolean bl = false;
                boolean bl2 = false;
                it = object4;
                boolean bl3 = false;
                object2 = isFunctionSupertype ? object4 : null;
            } else {
                object2 = object = null;
            }
        }
        if (object2 == null) {
            object = typeVariable2.getDefaultType();
        }
        Object returnType2 = object;
        UnwrappedType[] unwrappedTypeArray = argument.getParametersTypes();
        if (unwrappedTypeArray != null) {
            void $this$mapTo$iv$iv;
            UnwrappedType[] $this$map$iv = unwrappedTypeArray;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var16_24 = $this$mapTo$iv$iv;
            int n = ((void)var16_24).length;
            for (int i = 0; i < n; ++i) {
                void it2;
                void item$iv$iv;
                void var20_29 = item$iv$iv = var16_24[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                UnwrappedType unwrappedType2 = it2;
                if (unwrappedType2 == null) {
                    SimpleType simpleType2 = builtIns2.getNothingType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.nothingType");
                    unwrappedType2 = simpleType2;
                }
                void var23_32 = unwrappedType2;
                collection.add(var23_32);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List parameters2 = list2;
        boolean newTypeVariableUsed = Intrinsics.areEqual((Object)returnType2, (Object)typeVariable2.getDefaultType());
        if (newTypeVariableUsed) {
            csBuilder.registerVariable(typeVariable2);
        }
        TypeVariableForLambdaReturnType typeVariableForLambdaReturnType = typeVariable2;
        Object object5 = returnType2;
        List list3 = parameters2;
        UnwrappedType unwrappedType3 = receiverType;
        boolean bl = isSuspend;
        LambdaKotlinCallArgument lambdaKotlinCallArgument2 = argument;
        boolean bl4 = false;
        boolean bl5 = false;
        TypeVariableForLambdaReturnType it3 = typeVariableForLambdaReturnType;
        boolean bl6 = false;
        TypeVariableForLambdaReturnType typeVariableForLambdaReturnType2 = newTypeVariableUsed ? typeVariableForLambdaReturnType : null;
        UnwrappedType unwrappedType4 = expectedType;
        TypeVariableForLambdaReturnType typeVariableForLambdaReturnType3 = typeVariableForLambdaReturnType2;
        Object object6 = object5;
        List list4 = list3;
        UnwrappedType unwrappedType5 = unwrappedType3;
        boolean bl7 = bl;
        LambdaKotlinCallArgument lambdaKotlinCallArgument3 = lambdaKotlinCallArgument2;
        return new ResolvedLambdaAtom(lambdaKotlinCallArgument3, bl7, unwrappedType5, list4, (UnwrappedType)object6, typeVariableForLambdaReturnType3, unwrappedType4);
    }

    private static final ResolvedLambdaAtom extractLambdaInfoFromFunctionalType(UnwrappedType expectedType, LambdaKotlinCallArgument argument) {
        Object object;
        Object receiverType;
        FunctionExpression argumentAsFunctionExpression;
        Object object2;
        if (expectedType == null || !FunctionTypesKt.isBuiltinFunctionalType(expectedType)) {
            return null;
        }
        List<UnwrappedType> parameters2 = PostponeArgumentsChecksKt.extractLambdaParameters(expectedType, argument);
        LambdaKotlinCallArgument $this$safeAs$iv = argument;
        boolean $i$f$safeAs = false;
        LambdaKotlinCallArgument lambdaKotlinCallArgument = $this$safeAs$iv;
        if (!(lambdaKotlinCallArgument instanceof FunctionExpression)) {
            lambdaKotlinCallArgument = null;
        }
        if ((object2 = (argumentAsFunctionExpression = (FunctionExpression)lambdaKotlinCallArgument)) == null || (object2 = object2.getReceiverType()) == null) {
            KotlinType kotlinType2 = FunctionTypesKt.getReceiverTypeFromFunctionType(expectedType);
            object2 = receiverType = kotlinType2 != null ? kotlinType2.unwrap() : null;
        }
        if ((object = argumentAsFunctionExpression) == null || (object = object.getReturnType()) == null) {
            object = FunctionTypesKt.getReturnTypeFromFunctionType(expectedType).unwrap();
        }
        Object returnType2 = object;
        return new ResolvedLambdaAtom(argument, FunctionTypesKt.isSuspendFunctionType(expectedType), (UnwrappedType)receiverType, parameters2, (UnwrappedType)returnType2, null, expectedType);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<UnwrappedType> extractLambdaParameters(UnwrappedType expectedType, LambdaKotlinCallArgument argument) {
        void $this$mapIndexedTo$iv$iv;
        UnwrappedType[] parametersTypes = argument.getParametersTypes();
        List<TypeProjection> expectedParameters = FunctionTypesKt.getValueParameterTypesFromFunctionType(expectedType);
        if (parametersTypes == null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = expectedParameters;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                UnwrappedType unwrappedType = it.getType().unwrap();
                collection.add(unwrappedType);
            }
            return (List)destination$iv$iv;
        }
        UnwrappedType[] $this$mapIndexed$iv = parametersTypes;
        boolean $i$f$mapIndexed = false;
        UnwrappedType[] $this$mapTo$iv$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            UnwrappedType unwrappedType;
            void type2;
            int n = index$iv$iv++;
            void var14_27 = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UnwrappedType unwrappedType2 = type2;
            if (unwrappedType2 == null) {
                void index2;
                Object object = (TypeProjection)CollectionsKt.getOrNull(expectedParameters, (int)index2);
                unwrappedType2 = object != null && (object = object.getType()) != null ? ((KotlinType)object).unwrap() : (unwrappedType = null);
            }
            if (unwrappedType2 == null) {
                SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(expectedType).getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"expectedType.builtIns.nullableAnyType");
                unwrappedType = simpleType2;
            }
            void var18_25 = unwrappedType;
            collection.add(var18_25);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final ResolvedLambdaAtom transformToResolvedLambda(@NotNull LambdaWithTypeVariableAsExpectedTypeAtom $this$transformToResolvedLambda, @NotNull ConstraintSystemBuilder csBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)$this$transformToResolvedLambda, (String)"$this$transformToResolvedLambda");
        Intrinsics.checkParameterIsNotNull((Object)csBuilder, (String)"csBuilder");
        TypeSubstitutorMarker typeSubstitutorMarker = csBuilder.buildCurrentSubstitutor();
        if (typeSubstitutorMarker == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor");
        }
        UnwrappedType fixedExpectedType = ((NewTypeSubstitutor)typeSubstitutorMarker).safeSubstitute($this$transformToResolvedLambda.getExpectedType());
        ResolvedAtom resolvedAtom = PostponeArgumentsChecksKt.preprocessLambdaArgument(csBuilder, $this$transformToResolvedLambda.getAtom(), fixedExpectedType, true);
        if (resolvedAtom == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ResolvedLambdaAtom");
        }
        ResolvedLambdaAtom resolvedLambdaAtom = (ResolvedLambdaAtom)resolvedAtom;
        $this$transformToResolvedLambda.setAnalyzed(resolvedLambdaAtom);
        return resolvedLambdaAtom;
    }

    /*
     * WARNING - void declaration
     */
    private static final ResolvedAtom preprocessCallableReference(ConstraintSystemBuilder csBuilder, CallableReferenceKotlinCallArgument argument, UnwrappedType expectedType, KotlinDiagnosticsHolder diagnosticsHolder) {
        Object v0;
        EagerCallableReferenceAtom result2;
        block8: {
            result2 = new EagerCallableReferenceAtom(argument, expectedType);
            if (expectedType == null) {
                return result2;
            }
            Iterable $this$firstOrNull$iv = csBuilder.getProperSuperTypeConstructors(expectedType);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                void $this$requireIs$iv;
                TypeConstructorMarker it = (TypeConstructorMarker)element$iv;
                boolean bl = false;
                TypeConstructorMarker typeConstructorMarker = it;
                ReflectionTypes.Companion companion = ReflectionTypes.Companion;
                boolean $i$f$requireIs = false;
                boolean bl2 = $this$requireIs$iv instanceof TypeConstructor;
                boolean bl3 = false;
                boolean bl4 = false;
                bl4 = false;
                boolean bl5 = false;
                if (!bl2) {
                    boolean bl6 = false;
                    String string = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                void var20_28 = $this$requireIs$iv;
                if (!(!companion.isPossibleExpectedCallableType((TypeConstructor)var20_28))) continue;
                v0 = element$iv;
                break block8;
            }
            v0 = null;
        }
        TypeConstructorMarker notCallableTypeConstructor = v0;
        Object $this$safeAs$iv = argument.getLhsResult();
        boolean $i$f$safeAs = false;
        Object object = $this$safeAs$iv;
        if (!(object instanceof LHSResult.Type)) {
            object = null;
        }
        LHSResult.Type type2 = (LHSResult.Type)object;
        if (type2 != null) {
            $this$safeAs$iv = type2;
            $i$f$safeAs = false;
            boolean bl = false;
            LHSResult it = $this$safeAs$iv;
            boolean bl7 = false;
            UnwrappedType lhsType = ArgumentsUtilsKt.getStableType(((LHSResult.Type)it).getUnboundDetailedReceiver());
            if (ReflectionTypes.Companion.isNumberedTypeWithOneOrMoreNumber(expectedType)) {
                UnwrappedType lhsTypeVariable = ((TypeProjection)CollectionsKt.first(expectedType.getArguments())).getType().unwrap();
                csBuilder.addSubtypeConstraint(lhsType, lhsTypeVariable, new LHSArgumentConstraintPosition(((LHSResult.Type)it).getQualifier()));
            }
        }
        if (notCallableTypeConstructor != null) {
            void $this$requireIs$iv;
            $this$safeAs$iv = notCallableTypeConstructor;
            UnwrappedType unwrappedType = expectedType;
            CallableReferenceKotlinCallArgument callableReferenceKotlinCallArgument = argument;
            KotlinDiagnosticsHolder kotlinDiagnosticsHolder = diagnosticsHolder;
            boolean $i$f$requireIs = false;
            boolean bl = $this$requireIs$iv instanceof TypeConstructor;
            boolean bl8 = false;
            boolean bl9 = false;
            bl9 = false;
            boolean bl10 = false;
            if (!bl) {
                boolean bl11 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            void var26_34 = $this$requireIs$iv;
            TypeConstructor typeConstructor2 = (TypeConstructor)var26_34;
            UnwrappedType unwrappedType2 = unwrappedType;
            CallableReferenceKotlinCallArgument callableReferenceKotlinCallArgument2 = callableReferenceKotlinCallArgument;
            kotlinDiagnosticsHolder.addDiagnostic(new NotCallableExpectedType(callableReferenceKotlinCallArgument2, unwrappedType2, typeConstructor2));
        }
        return result2;
    }

    private static final ResolvedAtom preprocessCollectionLiteralArgument(CollectionLiteralKotlinCallArgument collectionLiteralArgument, UnwrappedType expectedType) {
        return new ResolvedCollectionLiteralAtom(collectionLiteralArgument, expectedType);
    }
}

