/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ir.DescriptorBasedUtilsKt;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.DescriptorReferenceFlags;
import org.jetbrains.kotlin.backend.common.serialization.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.backend.common.serialization.proto.DescriptorReference;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.UniqId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorReferenceSerializer;", "", "declarationTable", "Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "serializeString", "Lkotlin/Function1;", "", "", "serializeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "", "skipExpects", "", "(Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Z)V", "getDeclarationTable", "()Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "getSerializeFqName", "()Lkotlin/jvm/functions/Function1;", "getSerializeString", "getSkipExpects", "()Z", "extractPackageAndClassFqns", "Lkotlin/Pair;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isEnumSpecialMember", "serializeDescriptorReference", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/DescriptorReference;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ir.serialization.common"})
public class DescriptorReferenceSerializer {
    @NotNull
    private final DeclarationTable declarationTable;
    @NotNull
    private final Function1<String, Integer> serializeString;
    @NotNull
    private final Function1<FqName, List<Integer>> serializeFqName;
    private final boolean skipExpects;

    private final boolean isEnumSpecialMember(DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof SimpleFunctionDescriptor)) {
            return false;
        }
        return DescriptorFactory.isEnumValueOfMethod((FunctionDescriptor)descriptor2) || DescriptorFactory.isEnumValuesMethod((FunctionDescriptor)descriptor2);
    }

    @Nullable
    public final Pair<FqName, FqName> extractPackageAndClassFqns(@NotNull DeclarationDescriptor descriptor2) {
        Object object;
        DeclarationDescriptor containingDeclaration;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        DeclarationDescriptor declarationDescriptor = containingDeclaration = descriptor2.getContainingDeclaration();
        if (declarationDescriptor instanceof ClassDescriptor) {
            ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)containingDeclaration);
            if (classId == null) {
                return null;
            }
            ClassId classId2 = classId;
            FqName fqName2 = classId2.getPackageFqName();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.packageFqName");
            FqName fqName3 = classId2.getRelativeClassName();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"classId.relativeClassName");
            object = new Pair((Object)fqName2, (Object)fqName3);
        } else if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            object = new Pair<FqName, FqName>((Object)((PackageFragmentDescriptor)containingDeclaration).getFqName(), (Object)FqName.ROOT);
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            object = !(descriptor2 instanceof TypeParameterDescriptor) ? null : this.extractPackageAndClassFqns(containingDeclaration);
        } else {
            return null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final DescriptorReference serializeDescriptorReference(@NotNull IrDeclaration declaration2) {
        void packageFqName;
        UniqId uniqId;
        String string2;
        IrElement typeParameterContainer;
        IrDeclaration discoverableDescriptorsDeclaration;
        IrDeclaration irDeclaration2;
        IrDeclaration realDeclaration;
        IrDeclaration irDeclaration3;
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        DeclarationDescriptor descriptor2 = declaration2.getDescriptor();
        if (!this.declarationTable.isExportedDeclaration(declaration2)) {
            IrDeclaration irDeclaration4 = declaration2;
            if (!(irDeclaration4 instanceof IrDeclarationWithVisibility)) {
                irDeclaration4 = null;
            }
            IrDeclarationWithVisibility irDeclarationWithVisibility = (IrDeclarationWithVisibility)irDeclaration4;
            if (!Intrinsics.areEqual((Object)(irDeclarationWithVisibility != null ? irDeclarationWithVisibility.getVisibility() : null), (Object)Visibilities.INVISIBLE_FAKE)) {
                return null;
            }
        }
        if (declaration2 instanceof IrAnonymousInitializer) {
            return null;
        }
        if (descriptor2 instanceof ParameterDescriptor || descriptor2 instanceof VariableDescriptor && !(descriptor2 instanceof PropertyDescriptor)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        if (declarationDescriptor == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.containingDeclaration!!");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        Pair<FqName, FqName> pair = this.extractPackageAndClassFqns(descriptor2);
        if (pair == null) {
            return null;
        }
        Pair<FqName, FqName> pair2 = pair;
        FqName fqName2 = (FqName)pair2.component1();
        FqName classFqName = (FqName)pair2.component2();
        boolean isAccessor = AdditionalIrUtilsKt.isAccessor(declaration2);
        boolean isBackingField = declaration2 instanceof IrField && ((IrField)declaration2).getCorrespondingPropertySymbol() != null;
        boolean isFakeOverride = Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE);
        boolean isDefaultConstructor = descriptor2 instanceof ClassConstructorDescriptor && containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.OBJECT;
        boolean isEnumEntry = descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY;
        boolean isEnumSpecial = this.isEnumSpecialMember(descriptor2);
        boolean isTypeParameter = declaration2 instanceof IrTypeParameter;
        if (containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.ENUM_ENTRY && !isFakeOverride) {
            return null;
        }
        if (isFakeOverride) {
            IrElement irElement;
            IrDeclaration irDeclaration5 = declaration2;
            if (irDeclaration5 instanceof IrSimpleFunction) {
                irElement = IrFakeOverrideUtilsKt.resolveFakeOverrideMaybeAbstract((IrSimpleFunction)declaration2);
            } else if (irDeclaration5 instanceof IrField) {
                irElement = IrFakeOverrideUtilsKt.resolveFakeOverride((IrField)declaration2);
            } else if (irDeclaration5 instanceof IrProperty) {
                irElement = IrFakeOverrideUtilsKt.resolveFakeOverrideMaybeAbstract((IrProperty)declaration2);
            } else {
                String string3 = "Unexpected fake override declaration";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            irDeclaration3 = (IrDeclaration)irElement;
        } else {
            irDeclaration3 = realDeclaration = declaration2;
        }
        if (isAccessor) {
            IrDeclaration irDeclaration6 = realDeclaration;
            if (irDeclaration6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
            }
            IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)irDeclaration6).getCorrespondingPropertySymbol();
            if (irPropertySymbol == null) {
                Intrinsics.throwNpe();
            }
            irDeclaration2 = (IrDeclaration)irPropertySymbol.getOwner();
        } else if (isBackingField) {
            IrDeclaration irDeclaration7 = realDeclaration;
            if (irDeclaration7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrField");
            }
            IrPropertySymbol irPropertySymbol = ((IrField)irDeclaration7).getCorrespondingPropertySymbol();
            if (irPropertySymbol == null) {
                Intrinsics.throwNpe();
            }
            irDeclaration2 = (IrDeclaration)irPropertySymbol.getOwner();
        } else {
            irDeclaration2 = discoverableDescriptorsDeclaration = isDefaultConstructor || isEnumEntry ? null : realDeclaration;
        }
        if (isTypeParameter) {
            IrElement irElement;
            IrDeclarationParent parent2 = declaration2.getParent();
            IrDeclarationParent irDeclarationParent = parent2;
            if (irDeclarationParent instanceof IrClass) {
                irElement = parent2;
            } else if (irDeclarationParent instanceof IrSimpleFunction) {
                Object object = ((IrSimpleFunction)parent2).getCorrespondingPropertySymbol();
                irElement = object != null && (object = (IrProperty)object.getOwner()) != null ? (IrElement)object : (IrElement)parent2;
            } else if (irDeclarationParent instanceof IrConstructor) {
                irElement = parent2;
            } else {
                String string4 = "unknown type parameter container type";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string4.toString());
            }
            typeParameterContainer = irElement;
            string2 = ((IrDeclarationWithName)typeParameterContainer).getDescriptor().getName().asString();
        } else {
            string2 = descriptor2.getName().toString();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"if (isTypeParameter) {\n \u2026escriptor.name.toString()");
        String nameString = string2;
        IrDeclaration irDeclaration8 = discoverableDescriptorsDeclaration;
        if (irDeclaration8 != null) {
            typeParameterContainer = irDeclaration8;
            boolean bl = false;
            boolean bl2 = false;
            IrElement it = typeParameterContainer;
            boolean bl3 = false;
            uniqId = UniqId.box-impl(this.declarationTable.uniqIdByDeclaration((IrDeclaration)it));
        } else {
            uniqId = null;
        }
        UniqId uniqId2 = uniqId;
        DescriptorReference.Builder proto = DescriptorReference.newBuilder().addAllPackageFqName((Iterable)this.serializeFqName.invoke((Object)packageFqName)).addAllClassFqName((Iterable)this.serializeFqName.invoke((Object)classFqName)).setName(((Number)this.serializeString.invoke((Object)nameString)).intValue());
        int flags = DescriptorReferenceFlags.IS_FAKE_OVERRIDE.encode(isFakeOverride) | DescriptorReferenceFlags.IS_BACKING_FIELD.encode(isBackingField) | DescriptorReferenceFlags.IS_GETTER.encode(AdditionalIrUtilsKt.isGetter(declaration2)) | DescriptorReferenceFlags.IS_SETTER.encode(AdditionalIrUtilsKt.isSetter(declaration2)) | DescriptorReferenceFlags.IS_DEFAULT_CONSTRUCTOR.encode(isDefaultConstructor) | DescriptorReferenceFlags.IS_ENUM_ENTRY.encode(isEnumEntry) | DescriptorReferenceFlags.IS_ENUM_SPECIAL.encode(isEnumSpecial) | DescriptorReferenceFlags.IS_TYPE_PARAMETER.encode(isTypeParameter) | DescriptorReferenceFlags.IS_EXPECT.encode(!this.skipExpects && DescriptorBasedUtilsKt.isProperExpect(declaration2));
        DescriptorReference.Builder builder = proto;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"proto");
        builder.setFlags(flags);
        if (uniqId2 != null) {
            proto.setUniqIdIndex(uniqId2.unbox-impl());
        }
        return proto.build();
    }

    @NotNull
    public final DeclarationTable getDeclarationTable() {
        return this.declarationTable;
    }

    @NotNull
    public final Function1<String, Integer> getSerializeString() {
        return this.serializeString;
    }

    @NotNull
    public final Function1<FqName, List<Integer>> getSerializeFqName() {
        return this.serializeFqName;
    }

    public final boolean getSkipExpects() {
        return this.skipExpects;
    }

    public DescriptorReferenceSerializer(@NotNull DeclarationTable declarationTable, @NotNull Function1<? super String, Integer> serializeString, @NotNull Function1<? super FqName, ? extends List<Integer>> serializeFqName, boolean skipExpects) {
        Intrinsics.checkParameterIsNotNull((Object)declarationTable, (String)"declarationTable");
        Intrinsics.checkParameterIsNotNull(serializeString, (String)"serializeString");
        Intrinsics.checkParameterIsNotNull(serializeFqName, (String)"serializeFqName");
        this.declarationTable = declarationTable;
        this.serializeString = serializeString;
        this.serializeFqName = serializeFqName;
        this.skipExpects = skipExpects;
    }
}

