/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaSourceUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.CharTable;

public class PsiExpressionListImpl
extends CompositePsiElement
implements PsiExpressionList {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiExpressionListImpl");
    private volatile PsiExpression[] myExpressions;

    public PsiExpressionListImpl() {
        super(JavaElementType.EXPRESSION_LIST);
    }

    @Override
    @NotNull
    public PsiExpression[] getExpressions() {
        PsiExpression[] expressions = this.myExpressions;
        if (expressions == null && (expressions = (PsiExpression[])this.getChildrenAsPsiElements(ElementType.EXPRESSION_BIT_SET, PsiExpression.ARRAY_FACTORY)).length > 10) {
            this.myExpressions = expressions;
        }
        if (expressions == null) {
            PsiExpressionListImpl.$$$reportNull$$$0(0);
        }
        return expressions;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myExpressions = null;
    }

    @Override
    public int getExpressionCount() {
        PsiExpression[] expressions = this.myExpressions;
        if (expressions != null) {
            return expressions.length;
        }
        return this.countChildren(ElementType.EXPRESSION_BIT_SET);
    }

    @Override
    public boolean isEmpty() {
        return this.findChildByType(ElementType.EXPRESSION_BIT_SET) == null;
    }

    @Override
    @NotNull
    public PsiType[] getExpressionTypes() {
        PsiExpression[] expressions = this.getExpressions();
        PsiType[] types2 = PsiType.createArray(expressions.length);
        for (int i = 0; i < types2.length; ++i) {
            types2[i] = expressions[i].getType();
        }
        if (types2 == null) {
            PsiExpressionListImpl.$$$reportNull$$$0(1);
        }
        return types2;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 24: {
                return this.getFirstChildNode() != null && this.getFirstChildNode().getElementType() == JavaTokenType.LPARENTH ? this.getFirstChildNode() : null;
            }
            case 25: 
        }
        if (this.getLastChildNode() != null && this.getLastChildNode().getElementType() == JavaTokenType.RPARENTH) {
            return this.getLastChildNode();
        }
        return null;
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiExpressionListImpl.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.COMMA) {
            return 23;
        }
        if (i == JavaTokenType.LPARENTH) {
            return 24;
        }
        if (i == JavaTokenType.RPARENTH) {
            return 25;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 59;
        }
        return 0;
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor2, Boolean before) {
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
        if (anchor2 == null) {
            LeafElement lparenth;
            if (before == null || before.booleanValue()) {
                anchor2 = this.findChildByRole(25);
                if (anchor2 == null) {
                    lparenth = Factory.createSingleLeafElement(JavaTokenType.LPARENTH, "(", 0, 1, treeCharTab, this.getManager());
                    super.addInternal(lparenth, lparenth, null, Boolean.FALSE);
                    LeafElement rparenth = Factory.createSingleLeafElement(JavaTokenType.RPARENTH, ")", 0, 1, treeCharTab, this.getManager());
                    super.addInternal(rparenth, rparenth, null, Boolean.TRUE);
                    anchor2 = this.findChildByRole(25);
                    LOG.assertTrue(anchor2 != null);
                }
                before = Boolean.TRUE;
            } else {
                anchor2 = this.findChildByRole(24);
                if (anchor2 == null) {
                    lparenth = Factory.createSingleLeafElement(JavaTokenType.LPARENTH, "(", 0, 1, treeCharTab, this.getManager());
                    super.addInternal(lparenth, lparenth, null, Boolean.FALSE);
                    LeafElement rparenth = Factory.createSingleLeafElement(JavaTokenType.RPARENTH, ")", 0, 1, treeCharTab, this.getManager());
                    super.addInternal(rparenth, rparenth, null, Boolean.TRUE);
                    anchor2 = this.findChildByRole(24);
                    LOG.assertTrue(anchor2 != null);
                }
                before = Boolean.FALSE;
            }
        }
        TreeElement firstAdded = super.addInternal(first, last, anchor2, before);
        if (ElementType.EXPRESSION_BIT_SET.contains(first.getElementType())) {
            JavaSourceUtil.addSeparatingComma(this, first, ElementType.EXPRESSION_BIT_SET);
        }
        return firstAdded;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            PsiExpressionListImpl.$$$reportNull$$$0(3);
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            JavaSourceUtil.deleteSeparatingComma(this, child);
        }
        super.deleteChildInternal(child);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiExpressionListImpl.$$$reportNull$$$0(4);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitExpressionList(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiExpressionList";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiExpressionListImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionTypes";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiExpressionListImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

