/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.builder;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableBiMap;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirTargetElement;
import org.jetbrains.kotlin.fir.FirWhenSubject;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.builder.FirRawContractDescriptionBuilder;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirAnonymousObjectBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyAccessorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirRegularClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenSubjectExpression;
import org.jetbrains.kotlin.fir.expressions.LogicOperationKind;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBinaryLogicExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallableReferenceAccessBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirComparisonExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirElseIfTrueConditionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirExpressionStubBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirOperatorCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirQualifiedAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirReturnExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThisReceiverExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenBranchBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenSubjectExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWrappedDelegateExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.expressions.impl.FirStubStatement;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.builder.FirDelegateFieldReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirImplicitThisReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.SymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirDelegateFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirImplicitTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty0TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty1TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty2TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty0TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty1TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty2TypeRef;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u009e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\u0018\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u001c\u0010\u000f\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011\u001a,\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017\u001a8\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u001a\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\u0010\u001c\u001a\u0016\u0010\u001d\u001a\u00020\u001e*\u00020\u00172\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0002\u001a0\u0010\u001f\u001a\u00020 *\u00020\u00172\b\u0010!\u001a\u0004\u0018\u00010\r2\b\u0010\"\u001a\u0004\u0018\u00010\r2\u0006\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0001H\u0002\u001a\u001c\u0010%\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010'\u0012\u0006\u0012\u0004\u0018\u00010(0&*\u0004\u0018\u00010'\u001a@\u0010)\u001a\u00020**\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u00020\u001e2\b\u00102\u001a\u0004\u0018\u00010\u0017\u001a.\u00103\u001a\u000204*\u00020\u00172\u0006\u0010#\u001a\u00020\u00172\u0006\u00105\u001a\u0002062\b\u0010\"\u001a\u0004\u0018\u00010\r2\b\u0010!\u001a\u0004\u0018\u00010\r\u001a.\u00107\u001a\u00020 *\u00020\u00172\u0006\u0010#\u001a\u00020\u00172\u0006\u00108\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010\r2\b\u0010!\u001a\u0004\u0018\u00010\r\u001a$\u00109\u001a\u00020:*\u00020\u00172\u0006\u0010;\u001a\u00020\u00172\u0006\u0010<\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010\r\u001a,\u0010=\u001a\u00020>*\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010;\u001a\u00020\u00172\u0006\u0010?\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010\r\u001a\n\u0010@\u001a\u00020\u001e*\u00020'\u001a\u0011\u0010A\u001a\u0004\u0018\u00010\u0006*\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\f\u0010B\u001a\u0004\u0018\u00010\u0001*\u000206\u001a\n\u0010C\u001a\u00020D*\u000206\u001a\f\u0010E\u001a\u0004\u0018\u00010\u0001*\u000206\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"DELEGATED_SETTER_PARAM", "Lorg/jetbrains/kotlin/name/Name;", "GET_VALUE", "PROVIDE_DELEGATE", "SET_VALUE", "escapedStringToCharacter", "", "text", "", "(Ljava/lang/String;)Ljava/lang/Character;", "generateAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "name", "generateResolvedAccessExpression", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "generateTemporaryVariable", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "specialName", "initializer", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "translateEscape", "c", "(C)Ljava/lang/Character;", "checkReceiver", "", "createConventionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "operationReferenceSource", "baseSource", "argument", "conventionName", "extractContractDescriptionIfPossible", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "generateAccessorsByDelegate", "", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirPropertyBuilder;", "delegateBuilder", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirWrappedDelegateExpressionBuilder;", "ownerClassBuilder", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;", "isExtension", "stubMode", "receiver", "generateComparisonExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "operatorToken", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "generateContainsOperation", "inverted", "generateLazyLogicalOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "other", "isAnd", "generateNotNullOrOther", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "caseId", "isContractPresentFirCheck", "parseCharacter", "toBinaryName", "toFirOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "toUnaryName", "fir-common"})
public final class ConversionUtilsKt {
    private static final Name GET_VALUE;
    private static final Name SET_VALUE;
    private static final Name PROVIDE_DELEGATE;
    private static final Name DELEGATED_SETTER_PARAM;

    @Nullable
    public static final Character parseCharacter(@NotNull String $this$parseCharacter) {
        Intrinsics.checkNotNullParameter((Object)$this$parseCharacter, (String)"$this$parseCharacter");
        if ($this$parseCharacter.length() < 2 || $this$parseCharacter.charAt(0) != '\'' || $this$parseCharacter.charAt($this$parseCharacter.length() - 1) != '\'') {
            return null;
        }
        CharSequence charSequence = $this$parseCharacter;
        int n = 1;
        int n2 = $this$parseCharacter.length() - 1;
        boolean bl = false;
        String string2 = ((String)charSequence).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String text2 = string2;
        charSequence = text2;
        n = 0;
        if (charSequence.length() == 0) {
            return null;
        }
        return text2.charAt(0) != '\\' ? (text2.length() == 1 ? Character.valueOf(text2.charAt(0)) : null) : ConversionUtilsKt.escapedStringToCharacter(text2);
    }

    @Nullable
    public static final Character escapedStringToCharacter(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        CharSequence charSequence = text2;
        boolean bl = false;
        boolean bl2 = charSequence.length() > 0 && text2.charAt(0) == '\\';
        bl = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl3 = false;
            String string2 = "Only escaped sequences must be passed to this routine: " + text2;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        String string3 = text2;
        int n = 1;
        int n2 = 0;
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String escape = string4;
        switch (escape.length()) {
            case 0: {
                return null;
            }
            case 1: {
                Character c = ConversionUtilsKt.translateEscape(escape.charAt(0));
                if (c == null) {
                    return null;
                }
                return Character.valueOf(c.charValue());
            }
            case 5: {
                if (escape.charAt(0) != 'u') break;
                try {
                    String string5 = escape;
                    n2 = 1;
                    boolean bl4 = false;
                    String string6 = string5;
                    if (string6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.substring(n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                    Integer intValue = Integer.valueOf(string7, 16);
                    return Character.valueOf((char)intValue.intValue());
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
            }
        }
        return null;
    }

    @Nullable
    public static final Character translateEscape(char c) {
        Character c2;
        switch (c) {
            case 't': {
                c2 = Character.valueOf('\t');
                break;
            }
            case 'b': {
                c2 = Character.valueOf('\b');
                break;
            }
            case 'n': {
                c2 = Character.valueOf('\n');
                break;
            }
            case 'r': {
                c2 = Character.valueOf('\r');
                break;
            }
            case '\'': {
                c2 = Character.valueOf('\'');
                break;
            }
            case '\"': {
                c2 = Character.valueOf('\"');
                break;
            }
            case '\\': {
                c2 = Character.valueOf('\\');
                break;
            }
            case '$': {
                c2 = Character.valueOf('$');
                break;
            }
            default: {
                c2 = null;
            }
        }
        return c2;
    }

    @Nullable
    public static final Name toBinaryName(@NotNull IElementType $this$toBinaryName) {
        Intrinsics.checkNotNullParameter((Object)$this$toBinaryName, (String)"$this$toBinaryName");
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.BINARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue(immutableBiMap, (String)"OperatorConventions.BINARY_OPERATION_NAMES");
        Map map2 = immutableBiMap;
        boolean bl = false;
        return (Name)map2.get($this$toBinaryName);
    }

    @Nullable
    public static final Name toUnaryName(@NotNull IElementType $this$toUnaryName) {
        Intrinsics.checkNotNullParameter((Object)$this$toUnaryName, (String)"$this$toUnaryName");
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.UNARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue(immutableBiMap, (String)"OperatorConventions.UNARY_OPERATION_NAMES");
        Map map2 = immutableBiMap;
        boolean bl = false;
        return (Name)map2.get($this$toUnaryName);
    }

    @NotNull
    public static final FirOperation toFirOperation(@NotNull IElementType $this$toFirOperation) {
        FirOperation firOperation;
        Intrinsics.checkNotNullParameter((Object)$this$toFirOperation, (String)"$this$toFirOperation");
        IElementType iElementType = $this$toFirOperation;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT)) {
            firOperation = FirOperation.LT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT)) {
            firOperation = FirOperation.GT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
            firOperation = FirOperation.LT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ)) {
            firOperation = FirOperation.GT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ)) {
            firOperation = FirOperation.EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
            firOperation = FirOperation.NOT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQEQ)) {
            firOperation = FirOperation.IDENTITY;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQEQEQ)) {
            firOperation = FirOperation.NOT_IDENTITY;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQ)) {
            firOperation = FirOperation.ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ)) {
            firOperation = FirOperation.PLUS_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ)) {
            firOperation = FirOperation.MINUS_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MULTEQ)) {
            firOperation = FirOperation.TIMES_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIVEQ)) {
            firOperation = FirOperation.DIV_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERCEQ)) {
            firOperation = FirOperation.REM_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.AS_KEYWORD)) {
            firOperation = FirOperation.AS;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.AS_SAFE)) {
            firOperation = FirOperation.SAFE_AS;
        } else {
            throw (Throwable)((Object)new AssertionError((Object)$this$toFirOperation.toString()));
        }
        return firOperation;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirWhenExpression generateNotNullOrOther(@NotNull FirExpression $this$generateNotNullOrOther, @NotNull FirSession session, @NotNull FirExpression other, @NotNull String caseId, @Nullable FirSourceElement baseSource) {
        void $this$buildElseIfTrueCondition;
        FirElseIfTrueConditionBuilder $this$buildOperatorCall;
        Intrinsics.checkNotNullParameter((Object)$this$generateNotNullOrOther, (String)"$this$generateNotNullOrOther");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)caseId, (String)"caseId");
        Name name = Name.special('<' + caseId + '>');
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.special(\"<$caseId>\")");
        Name subjectName = name;
        FirVariable subjectVariable = ConversionUtilsKt.generateTemporaryVariable$default(session, baseSource, subjectName, $this$generateNotNullOrOther, null, 16, null);
        FirWhenSubject subject = new FirWhenSubject();
        boolean $i$f$buildWhenSubjectExpression = false;
        boolean bl = false;
        FirWhenSubjectExpressionBuilder firWhenSubjectExpressionBuilder = new FirWhenSubjectExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirWhenSubjectExpressionBuilder $this$buildWhenSubjectExpression = firWhenSubjectExpressionBuilder;
        boolean bl4 = false;
        $this$buildWhenSubjectExpression.setSource(baseSource);
        $this$buildWhenSubjectExpression.setWhenSubject(subject);
        FirWhenSubjectExpression subjectExpression = firWhenSubjectExpressionBuilder.build();
        boolean $i$f$buildWhenExpression = false;
        boolean bl5 = false;
        FirWhenExpressionBuilder firWhenExpressionBuilder = new FirWhenExpressionBuilder();
        bl2 = false;
        bl3 = false;
        FirWhenExpressionBuilder $this$buildWhenExpression = firWhenExpressionBuilder;
        boolean bl6 = false;
        $this$buildWhenExpression.setSource(baseSource);
        $this$buildWhenExpression.setSubject($this$generateNotNullOrOther);
        $this$buildWhenExpression.setSubjectVariable(subjectVariable);
        Collection collection = $this$buildWhenExpression.getBranches();
        boolean $i$f$buildWhenBranch22 = false;
        boolean bl7 = false;
        FirWhenBranchBuilder firWhenBranchBuilder = new FirWhenBranchBuilder();
        boolean bl8 = false;
        boolean bl9 = false;
        FirWhenBranchBuilder $this$buildWhenBranch = firWhenBranchBuilder;
        boolean bl10 = false;
        $this$buildWhenBranch.setSource(baseSource);
        boolean $i$f$buildOperatorCall = false;
        boolean bl11 = false;
        FirOperatorCallBuilder firOperatorCallBuilder = new FirOperatorCallBuilder();
        boolean bl12 = false;
        boolean bl13 = false;
        FirOperatorCallBuilder firOperatorCallBuilder2 = firOperatorCallBuilder;
        FirWhenBranchBuilder firWhenBranchBuilder2 = $this$buildWhenBranch;
        boolean bl14 = false;
        ((FirOperatorCallBuilder)((Object)$this$buildOperatorCall)).setSource(baseSource);
        ((FirOperatorCallBuilder)((Object)$this$buildOperatorCall)).setOperation(FirOperation.EQ);
        ((FirOperatorCallBuilder)((Object)$this$buildOperatorCall)).setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(subjectExpression, FirConstExpressionBuilderKt.buildConstExpression$default(baseSource, FirConstKind.Null.INSTANCE, null, null, 8, null)));
        Unit unit = Unit.INSTANCE;
        firWhenBranchBuilder2.setCondition(firOperatorCallBuilder.build());
        FirStatement statement$iv = other;
        boolean $i$f$buildSingleExpressionBlock22 = false;
        $this$buildWhenBranch.setResult(new FirSingleExpressionBlock(statement$iv));
        FirWhenBranch $i$f$buildWhenBranch22 = firWhenBranchBuilder.build();
        boolean bl15 = false;
        collection.add($i$f$buildWhenBranch22);
        collection = $this$buildWhenExpression.getBranches();
        boolean $i$f$buildWhenBranch = false;
        bl15 = false;
        FirWhenBranchBuilder firWhenBranchBuilder3 = new FirWhenBranchBuilder();
        bl8 = false;
        bl9 = false;
        $this$buildWhenBranch = firWhenBranchBuilder3;
        boolean bl16 = false;
        $this$buildWhenBranch.setSource(other.getSource());
        boolean $i$f$buildElseIfTrueCondition = false;
        $i$f$buildSingleExpressionBlock22 = false;
        FirElseIfTrueConditionBuilder $i$f$buildSingleExpressionBlock22 = new FirElseIfTrueConditionBuilder();
        bl12 = false;
        bl13 = false;
        $this$buildOperatorCall = $i$f$buildSingleExpressionBlock22;
        firWhenBranchBuilder2 = $this$buildWhenBranch;
        boolean bl17 = false;
        $this$buildElseIfTrueCondition.setSource(baseSource);
        unit = Unit.INSTANCE;
        firWhenBranchBuilder2.setCondition($i$f$buildSingleExpressionBlock22.build());
        statement$iv = ConversionUtilsKt.generateResolvedAccessExpression(baseSource, subjectVariable);
        boolean $i$f$buildSingleExpressionBlock = false;
        $this$buildWhenBranch.setResult(new FirSingleExpressionBlock(statement$iv));
        FirWhenBranch firWhenBranch = firWhenBranchBuilder3.build();
        boolean bl18 = false;
        collection.add(firWhenBranch);
        FirWhenExpression firWhenExpression = firWhenExpressionBuilder.build();
        boolean bl19 = false;
        bl2 = false;
        FirWhenExpression it = firWhenExpression;
        boolean bl20 = false;
        subject.bind(it);
        return firWhenExpression;
    }

    @NotNull
    public static final FirBinaryLogicExpression generateLazyLogicalOperation(@NotNull FirExpression $this$generateLazyLogicalOperation, @NotNull FirExpression other, boolean isAnd, @Nullable FirSourceElement baseSource) {
        Intrinsics.checkNotNullParameter((Object)$this$generateLazyLogicalOperation, (String)"$this$generateLazyLogicalOperation");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$buildBinaryLogicExpression = false;
        boolean bl = false;
        FirBinaryLogicExpressionBuilder firBinaryLogicExpressionBuilder = new FirBinaryLogicExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirBinaryLogicExpressionBuilder $this$buildBinaryLogicExpression = firBinaryLogicExpressionBuilder;
        boolean bl4 = false;
        $this$buildBinaryLogicExpression.setSource(baseSource);
        $this$buildBinaryLogicExpression.setLeftOperand($this$generateLazyLogicalOperation);
        $this$buildBinaryLogicExpression.setRightOperand(other);
        $this$buildBinaryLogicExpression.setKind(isAnd ? LogicOperationKind.AND : LogicOperationKind.OR);
        return firBinaryLogicExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirFunctionCall generateContainsOperation(@NotNull FirExpression $this$generateContainsOperation, @NotNull FirExpression argument, boolean inverted, @Nullable FirSourceElement baseSource, @Nullable FirSourceElement operationReferenceSource) {
        void $this$buildSimpleNamedReference;
        Intrinsics.checkNotNullParameter((Object)$this$generateContainsOperation, (String)"$this$generateContainsOperation");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        FirFunctionCall containsCall = ConversionUtilsKt.createConventionCall($this$generateContainsOperation, operationReferenceSource, baseSource, argument, OperatorNameConventions.CONTAINS);
        if (!inverted) {
            return containsCall;
        }
        boolean $i$f$buildFunctionCall = false;
        boolean bl = false;
        FirFunctionCallBuilder firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirFunctionCallBuilder $this$buildFunctionCall = firFunctionCallBuilder;
        boolean bl4 = false;
        $this$buildFunctionCall.setSource(baseSource);
        boolean $i$f$buildSimpleNamedReference = false;
        boolean bl5 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$buildFunctionCall;
        boolean bl8 = false;
        $this$buildSimpleNamedReference.setSource(operationReferenceSource);
        $this$buildSimpleNamedReference.setName(OperatorNameConventions.NOT);
        Unit unit = Unit.INSTANCE;
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$buildFunctionCall.setExplicitReceiver(containsCall);
        return firFunctionCallBuilder.build();
    }

    @NotNull
    public static final FirComparisonExpression generateComparisonExpression(@NotNull FirExpression $this$generateComparisonExpression, @NotNull FirExpression argument, @NotNull IElementType operatorToken, @Nullable FirSourceElement baseSource, @Nullable FirSourceElement operationReferenceSource) {
        FirOperation firOperation;
        Intrinsics.checkNotNullParameter((Object)$this$generateComparisonExpression, (String)"$this$generateComparisonExpression");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)operatorToken, (String)"operatorToken");
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.COMPARISON_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"OperatorConventions.COMPARISON_OPERATIONS");
        boolean bl = CollectionsKt.contains((Iterable)immutableSet, (Object)operatorToken);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = operatorToken + " is not in " + OperatorConventions.COMPARISON_OPERATIONS;
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        FirFunctionCall compareToCall = ConversionUtilsKt.createConventionCall($this$generateComparisonExpression, operationReferenceSource, baseSource, argument, OperatorNameConventions.COMPARE_TO);
        IElementType iElementType = operatorToken;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT)) {
            firOperation = FirOperation.LT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT)) {
            firOperation = FirOperation.GT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
            firOperation = FirOperation.LT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ)) {
            firOperation = FirOperation.GT_EQ;
        } else {
            String string3 = "Unknown " + operatorToken;
            boolean bl5 = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        FirOperation firOperation2 = firOperation;
        boolean $i$f$buildComparisonExpression = false;
        boolean bl6 = false;
        FirComparisonExpressionBuilder firComparisonExpressionBuilder = new FirComparisonExpressionBuilder();
        boolean bl7 = false;
        boolean bl8 = false;
        FirComparisonExpressionBuilder $this$buildComparisonExpression = firComparisonExpressionBuilder;
        boolean bl9 = false;
        $this$buildComparisonExpression.setSource(baseSource);
        $this$buildComparisonExpression.setOperation(firOperation2);
        $this$buildComparisonExpression.setCompareToCall(compareToCall);
        return firComparisonExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirFunctionCall createConventionCall(FirExpression $this$createConventionCall, FirSourceElement operationReferenceSource, FirSourceElement baseSource, FirExpression argument, Name conventionName) {
        void $this$buildSimpleNamedReference;
        boolean $i$f$buildFunctionCall = false;
        boolean bl = false;
        FirFunctionCallBuilder firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirFunctionCallBuilder $this$buildFunctionCall = firFunctionCallBuilder;
        boolean bl4 = false;
        $this$buildFunctionCall.setSource(baseSource);
        boolean $i$f$buildSimpleNamedReference = false;
        boolean bl5 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$buildFunctionCall;
        boolean bl8 = false;
        $this$buildSimpleNamedReference.setSource(operationReferenceSource);
        $this$buildSimpleNamedReference.setName(conventionName);
        Unit unit = Unit.INSTANCE;
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$buildFunctionCall.setExplicitReceiver($this$createConventionCall);
        $this$buildFunctionCall.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(argument));
        return firFunctionCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirQualifiedAccessExpression generateAccessExpression(@Nullable FirSourceElement source, @NotNull Name name) {
        void $this$buildSimpleNamedReference;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        boolean $i$f$buildQualifiedAccessExpression = false;
        boolean bl = false;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder = new FirQualifiedAccessExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirQualifiedAccessExpressionBuilder $this$buildQualifiedAccessExpression = firQualifiedAccessExpressionBuilder;
        boolean bl4 = false;
        $this$buildQualifiedAccessExpression.setSource(source);
        boolean $i$f$buildSimpleNamedReference = false;
        boolean bl5 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2 = $this$buildQualifiedAccessExpression;
        boolean bl8 = false;
        $this$buildSimpleNamedReference.setSource(source);
        $this$buildSimpleNamedReference.setName(name);
        Unit unit = Unit.INSTANCE;
        firQualifiedAccessExpressionBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        return firQualifiedAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirQualifiedAccessExpression generateResolvedAccessExpression(@Nullable FirSourceElement source, @NotNull FirVariable<?> variable2) {
        void $this$buildResolvedNamedReference;
        Intrinsics.checkNotNullParameter(variable2, (String)"variable");
        boolean $i$f$buildQualifiedAccessExpression = false;
        boolean bl = false;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder = new FirQualifiedAccessExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirQualifiedAccessExpressionBuilder $this$buildQualifiedAccessExpression = firQualifiedAccessExpressionBuilder;
        boolean bl4 = false;
        $this$buildQualifiedAccessExpression.setSource(source);
        boolean $i$f$buildResolvedNamedReference = false;
        boolean bl5 = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2 = $this$buildQualifiedAccessExpression;
        boolean bl8 = false;
        $this$buildResolvedNamedReference.setSource(source);
        $this$buildResolvedNamedReference.setName(variable2.getName());
        $this$buildResolvedNamedReference.setResolvedSymbol((AbstractFirBasedSymbol)variable2.getSymbol());
        Unit unit = Unit.INSTANCE;
        firQualifiedAccessExpressionBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
        return firQualifiedAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirVariable<?> generateTemporaryVariable(@NotNull FirSession session, @Nullable FirSourceElement source, @NotNull Name name, @NotNull FirExpression initializer2, @Nullable FirTypeRef typeRef) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)initializer2, (String)"initializer");
        boolean $i$f$buildProperty = false;
        boolean bl = false;
        FirPropertyBuilder firPropertyBuilder = new FirPropertyBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirPropertyBuilder $this$buildProperty = firPropertyBuilder;
        boolean bl4 = false;
        $this$buildProperty.setSource(source);
        $this$buildProperty.setSession(session);
        $this$buildProperty.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
        FirPropertyBuilder firPropertyBuilder2 = $this$buildProperty;
        FirTypeRef firTypeRef = typeRef;
        if (firTypeRef == null) {
            void $this$buildImplicitTypeRef;
            boolean $i$f$buildImplicitTypeRef = false;
            boolean bl5 = false;
            FirImplicitTypeRefBuilder firImplicitTypeRefBuilder = new FirImplicitTypeRefBuilder();
            boolean bl6 = false;
            boolean bl7 = false;
            FirImplicitTypeRefBuilder firImplicitTypeRefBuilder2 = firImplicitTypeRefBuilder;
            FirPropertyBuilder firPropertyBuilder3 = firPropertyBuilder2;
            boolean bl8 = false;
            $this$buildImplicitTypeRef.setSource(source);
            Unit unit = Unit.INSTANCE;
            firPropertyBuilder2 = firPropertyBuilder3;
            firTypeRef = firImplicitTypeRefBuilder.build();
        }
        firPropertyBuilder2.setReturnTypeRef(firTypeRef);
        $this$buildProperty.setName(name);
        $this$buildProperty.setInitializer(initializer2);
        $this$buildProperty.setSymbol(new FirPropertySymbol(name));
        $this$buildProperty.setVar(false);
        $this$buildProperty.setLocal(true);
        Visibility visibility = Visibilities.LOCAL;
        Intrinsics.checkNotNullExpressionValue((Object)visibility, (String)"Visibilities.LOCAL");
        $this$buildProperty.setStatus(new FirDeclarationStatusImpl(visibility, Modality.FINAL));
        return firPropertyBuilder.build();
    }

    public static /* synthetic */ FirVariable generateTemporaryVariable$default(FirSession firSession, FirSourceElement firSourceElement, Name name, FirExpression firExpression2, FirTypeRef firTypeRef, int n, Object object) {
        if ((n & 0x10) != 0) {
            firTypeRef = null;
        }
        return ConversionUtilsKt.generateTemporaryVariable(firSession, firSourceElement, name, firExpression2, firTypeRef);
    }

    @NotNull
    public static final FirVariable<?> generateTemporaryVariable(@NotNull FirSession session, @Nullable FirSourceElement source, @NotNull String specialName, @NotNull FirExpression initializer2) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)specialName, (String)"specialName");
        Intrinsics.checkNotNullParameter((Object)initializer2, (String)"initializer");
        Name name = Name.special('<' + specialName + '>');
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.special(\"<$specialName>\")");
        return ConversionUtilsKt.generateTemporaryVariable$default(session, source, name, initializer2, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final void generateAccessorsByDelegate(@NotNull FirPropertyBuilder $this$generateAccessorsByDelegate, @Nullable FirWrappedDelegateExpressionBuilder delegateBuilder, @Nullable FirClassBuilder ownerClassBuilder, @NotNull FirSession session, boolean isExtension, boolean stubMode, @Nullable FirExpression receiver) {
        boolean bl;
        Object object;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        Unit unit;
        Object $this$buildSimpleNamedReference22;
        FirImplicitTypeRefBuilder firImplicitTypeRefBuilder;
        boolean bl2;
        boolean bl3;
        Object object2;
        FirExpression firExpression2;
        FirWrappedDelegateExpressionBuilder firWrappedDelegateExpressionBuilder;
        Unit unit2;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder2;
        boolean bl4;
        Intrinsics.checkNotNullParameter((Object)$this$generateAccessorsByDelegate, (String)"$this$generateAccessorsByDelegate");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (delegateBuilder == null) {
            return;
        }
        FirDelegateFieldSymbol<FirProperty> firDelegateFieldSymbol = new FirDelegateFieldSymbol<FirProperty>($this$generateAccessorsByDelegate.getSymbol().getCallableId());
        boolean bl5 = false;
        boolean bl6 = false;
        FirDelegateFieldSymbol<FirProperty> it = firDelegateFieldSymbol;
        boolean bl7 = false;
        $this$generateAccessorsByDelegate.setDelegateFieldSymbol(it);
        FirDelegateFieldSymbol<FirProperty> delegateFieldSymbol = firDelegateFieldSymbol;
        FirClassBuilder firClassBuilder = ownerClassBuilder;
        FirClassSymbol ownerSymbol = firClassBuilder instanceof FirAnonymousObjectBuilder ? (FirClassSymbol)((FirAnonymousObjectBuilder)ownerClassBuilder).getSymbol() : (firClassBuilder instanceof FirRegularClassBuilder ? (FirClassSymbol)((FirRegularClassBuilder)ownerClassBuilder).getSymbol() : null);
        boolean isMember = ownerSymbol != null;
        Function0<FirExpression> $fun$thisRef$1 = new Function0<FirExpression>($this$generateAccessorsByDelegate, ownerSymbol, delegateBuilder, ownerClassBuilder, isExtension){
            final /* synthetic */ FirPropertyBuilder $this_generateAccessorsByDelegate;
            final /* synthetic */ FirClassSymbol $ownerSymbol;
            final /* synthetic */ FirWrappedDelegateExpressionBuilder $delegateBuilder;
            final /* synthetic */ FirClassBuilder $ownerClassBuilder;
            final /* synthetic */ boolean $isExtension;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FirExpression invoke() {
                FirExpression firExpression2;
                if (this.$ownerSymbol != null) {
                    void $this$buildResolvedTypeRef;
                    Object object;
                    FirResolvedTypeRefBuilder $this$buildImplicitThisReference;
                    boolean $i$f$buildThisReceiverExpression = false;
                    boolean bl = false;
                    FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    FirThisReceiverExpressionBuilder $this$buildThisReceiverExpression = firThisReceiverExpressionBuilder;
                    boolean bl4 = false;
                    $this$buildThisReceiverExpression.setSource(this.$delegateBuilder.getSource());
                    boolean $i$f$buildImplicitThisReference = false;
                    boolean bl5 = false;
                    FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder = new FirImplicitThisReferenceBuilder();
                    boolean bl6 = false;
                    boolean bl7 = false;
                    FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder2 = firImplicitThisReferenceBuilder;
                    FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder2 = $this$buildThisReceiverExpression;
                    boolean bl8 = false;
                    ((FirImplicitThisReferenceBuilder)((Object)$this$buildImplicitThisReference)).setBoundSymbol(this.$ownerSymbol);
                    Unit unit = Unit.INSTANCE;
                    firThisReceiverExpressionBuilder2.setCalleeReference(firImplicitThisReferenceBuilder.build());
                    boolean $i$f$buildResolvedTypeRef = false;
                    boolean bl9 = false;
                    FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
                    bl6 = false;
                    bl7 = false;
                    $this$buildImplicitThisReference = firResolvedTypeRefBuilder;
                    firThisReceiverExpressionBuilder2 = $this$buildThisReceiverExpression;
                    boolean bl10 = false;
                    FirClassBuilder firClassBuilder = this.$ownerClassBuilder;
                    if (!(firClassBuilder instanceof FirRegularClassBuilder)) {
                        firClassBuilder = null;
                    }
                    int typeParameterNumber = (object = (FirRegularClassBuilder)firClassBuilder) != null && (object = ((FirRegularClassBuilder)object).getTypeParameters()) != null ? object.size() : 0;
                    FirClassSymbol firClassSymbol = this.$ownerSymbol;
                    Intrinsics.checkNotNullExpressionValue((Object)firClassSymbol, (String)"ownerSymbol");
                    $this$buildResolvedTypeRef.setType(SymbolUtilsKt.constructStarProjectedType(firClassSymbol, typeParameterNumber));
                    unit = Unit.INSTANCE;
                    firThisReceiverExpressionBuilder2.setTypeRef(firResolvedTypeRefBuilder.build());
                    firExpression2 = firThisReceiverExpressionBuilder.build();
                } else if (this.$isExtension) {
                    void $this$buildImplicitThisReference;
                    boolean $i$f$buildThisReceiverExpression = false;
                    boolean bl = false;
                    FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
                    boolean bl11 = false;
                    boolean bl12 = false;
                    FirThisReceiverExpressionBuilder $this$buildThisReceiverExpression = firThisReceiverExpressionBuilder;
                    boolean bl13 = false;
                    $this$buildThisReceiverExpression.setSource(this.$delegateBuilder.getSource());
                    boolean $i$f$buildImplicitThisReference = false;
                    boolean bl14 = false;
                    FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder = new FirImplicitThisReferenceBuilder();
                    boolean bl15 = false;
                    boolean bl16 = false;
                    FirImplicitThisReferenceBuilder $this$buildResolvedTypeRef = firImplicitThisReferenceBuilder;
                    FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder3 = $this$buildThisReceiverExpression;
                    boolean bl17 = false;
                    $this$buildImplicitThisReference.setBoundSymbol(this.$this_generateAccessorsByDelegate.getSymbol());
                    Unit unit = Unit.INSTANCE;
                    firThisReceiverExpressionBuilder3.setCalleeReference(firImplicitThisReferenceBuilder.build());
                    firExpression2 = firThisReceiverExpressionBuilder.build();
                } else {
                    firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, FirConstKind.Null.INSTANCE, null, null, 8, null);
                }
                return firExpression2;
            }
            {
                this.$this_generateAccessorsByDelegate = firPropertyBuilder;
                this.$ownerSymbol = firClassSymbol;
                this.$delegateBuilder = firWrappedDelegateExpressionBuilder;
                this.$ownerClassBuilder = firClassBuilder;
                this.$isExtension = bl;
                super(0);
            }
        };
        Function0<FirQualifiedAccessExpression> $fun$delegateAccess$2 = new Function0<FirQualifiedAccessExpression>(delegateBuilder, delegateFieldSymbol, ownerSymbol, $fun$thisRef$1){
            final /* synthetic */ FirWrappedDelegateExpressionBuilder $delegateBuilder;
            final /* synthetic */ FirDelegateFieldSymbol $delegateFieldSymbol;
            final /* synthetic */ FirClassSymbol $ownerSymbol;
            final /* synthetic */ generateAccessorsByDelegate.1 $thisRef$1;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FirQualifiedAccessExpression invoke() {
                void $this$buildDelegateFieldReference;
                boolean $i$f$buildQualifiedAccessExpression = false;
                boolean bl = false;
                FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder = new FirQualifiedAccessExpressionBuilder();
                boolean bl2 = false;
                boolean bl3 = false;
                FirQualifiedAccessExpressionBuilder $this$buildQualifiedAccessExpression = firQualifiedAccessExpressionBuilder;
                boolean bl4 = false;
                $this$buildQualifiedAccessExpression.setSource(this.$delegateBuilder.getSource());
                boolean $i$f$buildDelegateFieldReference = false;
                boolean bl5 = false;
                FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder = new FirDelegateFieldReferenceBuilder();
                boolean bl6 = false;
                boolean bl7 = false;
                FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder2 = firDelegateFieldReferenceBuilder;
                FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2 = $this$buildQualifiedAccessExpression;
                boolean bl8 = false;
                $this$buildDelegateFieldReference.setResolvedSymbol(this.$delegateFieldSymbol);
                Unit unit = Unit.INSTANCE;
                firQualifiedAccessExpressionBuilder2.setCalleeReference(firDelegateFieldReferenceBuilder.build());
                if (this.$ownerSymbol != null) {
                    $this$buildQualifiedAccessExpression.setDispatchReceiver((FirExpression)this.$thisRef$1.invoke());
                }
                return firQualifiedAccessExpressionBuilder.build();
            }
            {
                this.$delegateBuilder = firWrappedDelegateExpressionBuilder;
                this.$delegateFieldSymbol = firDelegateFieldSymbol;
                this.$ownerSymbol = firClassSymbol;
                this.$thisRef$1 = var4_4;
                super(0);
            }
        };
        boolean isVar = $this$generateAccessorsByDelegate.isVar();
        Function0<FirCallableReferenceAccess> $fun$propertyRef$3 = new Function0<FirCallableReferenceAccess>($this$generateAccessorsByDelegate, delegateBuilder, isMember, isExtension, isVar){
            final /* synthetic */ FirPropertyBuilder $this_generateAccessorsByDelegate;
            final /* synthetic */ FirWrappedDelegateExpressionBuilder $delegateBuilder;
            final /* synthetic */ boolean $isMember;
            final /* synthetic */ boolean $isExtension;
            final /* synthetic */ boolean $isVar;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FirCallableReferenceAccess invoke() {
                void $this$buildResolvedNamedReference;
                boolean $i$f$buildCallableReferenceAccess = false;
                boolean bl = false;
                FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder = new FirCallableReferenceAccessBuilder();
                boolean bl2 = false;
                boolean bl3 = false;
                FirCallableReferenceAccessBuilder $this$buildCallableReferenceAccess = firCallableReferenceAccessBuilder;
                boolean bl4 = false;
                $this$buildCallableReferenceAccess.setSource(this.$delegateBuilder.getSource());
                boolean $i$f$buildResolvedNamedReference = false;
                boolean bl5 = false;
                FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
                boolean bl6 = false;
                boolean bl7 = false;
                FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder;
                FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder2 = $this$buildCallableReferenceAccess;
                boolean bl8 = false;
                $this$buildResolvedNamedReference.setSource(this.$delegateBuilder.getSource());
                $this$buildResolvedNamedReference.setName(this.$this_generateAccessorsByDelegate.getName());
                $this$buildResolvedNamedReference.setResolvedSymbol(this.$this_generateAccessorsByDelegate.getSymbol());
                Unit unit = Unit.INSTANCE;
                firCallableReferenceAccessBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
                $this$buildCallableReferenceAccess.setTypeRef(!this.$isMember && !this.$isExtension ? (this.$isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty0TypeRef(null, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty0TypeRef(null, ConeStarProjection.INSTANCE)) : (this.$isMember && this.$isExtension ? (this.$isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty2TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty2TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE)) : (this.$isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty1TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty1TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE))));
                return firCallableReferenceAccessBuilder.build();
            }
            {
                this.$this_generateAccessorsByDelegate = firPropertyBuilder;
                this.$delegateBuilder = firWrappedDelegateExpressionBuilder;
                this.$isMember = bl;
                this.$isExtension = bl2;
                this.$isVar = bl3;
                super(0);
            }
        };
        FirWrappedDelegateExpressionBuilder firWrappedDelegateExpressionBuilder2 = delegateBuilder;
        if (stubMode) {
            boolean $i$f$buildExpressionStub22 = false;
            boolean bl8 = false;
            FirExpressionStubBuilder firExpressionStubBuilder = new FirExpressionStubBuilder();
            bl4 = false;
            boolean bl9 = false;
            FirExpressionStubBuilder firExpressionStubBuilder2 = firExpressionStubBuilder;
            firAnnotationContainerBuilder2 = firWrappedDelegateExpressionBuilder2;
            unit2 = Unit.INSTANCE;
            firWrappedDelegateExpressionBuilder = firAnnotationContainerBuilder2;
            firExpression2 = firExpressionStubBuilder.build();
        } else {
            void $this$buildFunctionCall22;
            boolean $i$f$buildFunctionCall = false;
            boolean $i$f$buildExpressionStub22 = false;
            FirFunctionCallBuilder $i$f$buildExpressionStub22 = new FirFunctionCallBuilder();
            boolean bl10 = false;
            bl4 = false;
            FirFunctionCallBuilder firFunctionCallBuilder = $i$f$buildExpressionStub22;
            firAnnotationContainerBuilder2 = firWrappedDelegateExpressionBuilder2;
            boolean bl11 = false;
            $this$buildFunctionCall22.setExplicitReceiver(receiver);
            boolean $i$f$buildSimpleNamedReference = false;
            boolean bl12 = false;
            object2 = new FirSimpleNamedReferenceBuilder();
            bl3 = false;
            bl2 = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = object2;
            firImplicitTypeRefBuilder = $this$buildFunctionCall22;
            boolean bl13 = false;
            ((FirSimpleNamedReferenceBuilder)$this$buildSimpleNamedReference22).setSource(delegateBuilder.getSource());
            ((FirSimpleNamedReferenceBuilder)$this$buildSimpleNamedReference22).setName(PROVIDE_DELEGATE);
            unit = Unit.INSTANCE;
            ((FirFunctionCallBuilder)((Object)firImplicitTypeRefBuilder)).setCalleeReference(((FirSimpleNamedReferenceBuilder)object2).build());
            $this$buildFunctionCall22.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList((FirExpression)$fun$thisRef$1.invoke(), (FirExpression)$fun$propertyRef$3.invoke()));
            unit2 = Unit.INSTANCE;
            firWrappedDelegateExpressionBuilder = firAnnotationContainerBuilder2;
            firExpression2 = $i$f$buildExpressionStub22.build();
        }
        firWrappedDelegateExpressionBuilder.setDelegateProvider(firExpression2);
        $this$generateAccessorsByDelegate.setDelegate(delegateBuilder.build());
        if (stubMode) {
            return;
        }
        if ($this$generateAccessorsByDelegate.getGetter() == null || $this$generateAccessorsByDelegate.getGetter() instanceof FirDefaultPropertyAccessor) {
            void it2;
            void $this$buildSimpleNamedReference;
            void $this$buildFunctionCall;
            void $this$buildReturnExpression;
            void $this$buildPropertyAccessor;
            FirFunctionTarget returnTarget = new FirFunctionTarget(null, false);
            boolean $i$f$buildPropertyAccessor = false;
            boolean bl14 = false;
            FirPropertyAccessorBuilder firPropertyAccessorBuilder = new FirPropertyAccessorBuilder();
            bl4 = false;
            boolean $this$buildFunctionCall22 = false;
            FirPropertyAccessorBuilder bl11 = firPropertyAccessorBuilder;
            firAnnotationContainerBuilder2 = $this$generateAccessorsByDelegate;
            boolean bl15 = false;
            $this$buildPropertyAccessor.setSession(session);
            $this$buildPropertyAccessor.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            boolean $i$f$buildImplicitTypeRef = false;
            bl3 = false;
            FirImplicitTypeRefBuilder firImplicitTypeRefBuilder2 = new FirImplicitTypeRefBuilder();
            bl2 = false;
            boolean $this$buildSimpleNamedReference22 = false;
            firImplicitTypeRefBuilder = firImplicitTypeRefBuilder2;
            void bl13 = $this$buildPropertyAccessor;
            unit = Unit.INSTANCE;
            bl13.setReturnTypeRef(firImplicitTypeRefBuilder2.build());
            $this$buildPropertyAccessor.setGetter(true);
            Visibility visibility = Visibilities.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)visibility, (String)"Visibilities.UNKNOWN");
            $this$buildPropertyAccessor.setStatus(new FirDeclarationStatusImpl(visibility, Modality.FINAL));
            $this$buildPropertyAccessor.setSymbol(new FirPropertyAccessorSymbol());
            boolean $i$f$buildReturnExpression = false;
            boolean bl16 = false;
            object2 = new FirReturnExpressionBuilder();
            bl3 = false;
            bl2 = false;
            $this$buildSimpleNamedReference22 = object2;
            bl13 = $this$buildPropertyAccessor;
            boolean bl17 = false;
            boolean $i$f$buildFunctionCall = false;
            boolean bl18 = false;
            firAnnotationContainerBuilder = new FirFunctionCallBuilder();
            boolean bl19 = false;
            boolean bl20 = false;
            FirAnnotationContainerBuilder firAnnotationContainerBuilder3 = firAnnotationContainerBuilder;
            void var35_80 = $this$buildReturnExpression;
            boolean bl21 = false;
            $this$buildFunctionCall.setSource(delegateBuilder.getSource());
            $this$buildFunctionCall.setExplicitReceiver((FirExpression)$fun$delegateAccess$2.invoke());
            boolean $i$f$buildSimpleNamedReference = false;
            boolean bl22 = false;
            object = new FirSimpleNamedReferenceBuilder();
            boolean bl23 = false;
            bl = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = object;
            void var42_96 = $this$buildFunctionCall;
            boolean bl24 = false;
            $this$buildSimpleNamedReference.setSource(delegateBuilder.getSource());
            $this$buildSimpleNamedReference.setName(GET_VALUE);
            Unit unit3 = Unit.INSTANCE;
            var42_96.setCalleeReference(((FirSimpleNamedReferenceBuilder)object).build());
            $this$buildFunctionCall.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList((FirExpression)$fun$thisRef$1.invoke(), (FirExpression)$fun$propertyRef$3.invoke()));
            Unit unit4 = Unit.INSTANCE;
            var35_80.setResult(((FirFunctionCallBuilder)firAnnotationContainerBuilder).build());
            $this$buildReturnExpression.setTarget(returnTarget);
            Unit unit5 = Unit.INSTANCE;
            FirStatement firStatement = ((FirReturnExpressionBuilder)object2).build();
            bl13.setBody(new FirSingleExpressionBlock(firStatement));
            unit2 = Unit.INSTANCE;
            FirPropertyAccessor firPropertyAccessor = firPropertyAccessorBuilder.build();
            boolean bl25 = false;
            bl4 = false;
            FirPropertyAccessor $this$buildFunctionCall22 = firPropertyAccessor;
            boolean bl26 = false;
            returnTarget.bind((FirTargetElement)it2);
            unit2 = Unit.INSTANCE;
            ((FirPropertyBuilder)firAnnotationContainerBuilder2).setGetter(firPropertyAccessor);
        }
        if (isVar && ($this$generateAccessorsByDelegate.getSetter() == null || $this$generateAccessorsByDelegate.getSetter() instanceof FirDefaultPropertyAccessor)) {
            void $this$buildResolvedNamedReference;
            void $this$buildArgumentList;
            FirArgumentListBuilder $this$buildSimpleNamedReference;
            void $this$buildFunctionCall;
            void $this$buildPropertyAccessor;
            boolean $i$f$buildPropertyAccessor = false;
            boolean bl27 = false;
            FirPropertyAccessorBuilder firPropertyAccessorBuilder = new FirPropertyAccessorBuilder();
            boolean bl28 = false;
            bl4 = false;
            FirPropertyAccessorBuilder it2 = firPropertyAccessorBuilder;
            firAnnotationContainerBuilder2 = $this$generateAccessorsByDelegate;
            boolean bl29 = false;
            $this$buildPropertyAccessor.setSession(session);
            $this$buildPropertyAccessor.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$buildPropertyAccessor.setReturnTypeRef(session.getBuiltinTypes().getUnitType());
            $this$buildPropertyAccessor.setGetter(false);
            Visibility visibility = Visibilities.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)visibility, (String)"Visibilities.UNKNOWN");
            $this$buildPropertyAccessor.setStatus(new FirDeclarationStatusImpl(visibility, Modality.FINAL));
            boolean $i$f$buildValueParameter22 = false;
            boolean bl30 = false;
            FirValueParameterBuilder firValueParameterBuilder = new FirValueParameterBuilder();
            bl3 = false;
            bl2 = false;
            FirAnnotationContainerBuilder $this$buildValueParameter = firValueParameterBuilder;
            boolean bl31 = false;
            $this$buildValueParameter.setSession(session);
            $this$buildValueParameter.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            boolean $i$f$buildImplicitTypeRef = false;
            boolean bl32 = false;
            FirImplicitTypeRefBuilder firImplicitTypeRefBuilder3 = new FirImplicitTypeRefBuilder();
            boolean bl33 = false;
            boolean bl34 = false;
            FirImplicitTypeRefBuilder $i$f$buildFunctionCall = firImplicitTypeRefBuilder3;
            firAnnotationContainerBuilder = $this$buildValueParameter;
            Unit unit6 = Unit.INSTANCE;
            ((FirValueParameterBuilder)firAnnotationContainerBuilder).setReturnTypeRef(firImplicitTypeRefBuilder3.build());
            $this$buildValueParameter.setName(DELEGATED_SETTER_PARAM);
            $this$buildValueParameter.setSymbol(new FirVariableSymbol<FirValueParameter>($this$generateAccessorsByDelegate.getName()));
            $this$buildValueParameter.setCrossinline(false);
            $this$buildValueParameter.setNoinline(false);
            $this$buildValueParameter.setVararg(false);
            FirValueParameter parameter = firValueParameterBuilder.build();
            Collection $i$f$buildValueParameter22 = $this$buildPropertyAccessor.getValueParameters();
            boolean bl35 = false;
            $i$f$buildValueParameter22.add(parameter);
            $this$buildPropertyAccessor.setSymbol(new FirPropertyAccessorSymbol());
            boolean $i$f$buildFunctionCall2 = false;
            bl35 = false;
            FirFunctionCallBuilder firFunctionCallBuilder = new FirFunctionCallBuilder();
            bl3 = false;
            bl2 = false;
            $this$buildValueParameter = firFunctionCallBuilder;
            void var36_82 = $this$buildPropertyAccessor;
            boolean bl36 = false;
            $this$buildFunctionCall.setExplicitReceiver((FirExpression)$fun$delegateAccess$2.invoke());
            boolean $i$f$buildSimpleNamedReference = false;
            boolean bl37 = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
            bl33 = false;
            bl34 = false;
            FirSimpleNamedReferenceBuilder $receiver = firSimpleNamedReferenceBuilder;
            firAnnotationContainerBuilder = $this$buildFunctionCall;
            boolean bl38 = false;
            ((FirSimpleNamedReferenceBuilder)((Object)$this$buildSimpleNamedReference)).setName(SET_VALUE);
            Unit unit7 = Unit.INSTANCE;
            ((FirFunctionCallBuilder)firAnnotationContainerBuilder).setCalleeReference(firSimpleNamedReferenceBuilder.build());
            boolean $i$f$buildArgumentList = false;
            boolean bl39 = false;
            FirArgumentListBuilder firArgumentListBuilder = new FirArgumentListBuilder();
            bl33 = false;
            bl34 = false;
            $this$buildSimpleNamedReference = firArgumentListBuilder;
            firAnnotationContainerBuilder = $this$buildFunctionCall;
            boolean bl40 = false;
            object = $this$buildArgumentList.getArguments();
            Object object3 = $fun$thisRef$1.invoke();
            bl = false;
            object.add(object3);
            object = $this$buildArgumentList.getArguments();
            object3 = $fun$propertyRef$3.invoke();
            bl = false;
            object.add(object3);
            object = $this$buildArgumentList.getArguments();
            boolean $i$f$buildQualifiedAccessExpression = false;
            bl = false;
            FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder = new FirQualifiedAccessExpressionBuilder();
            boolean bl41 = false;
            boolean bl42 = false;
            FirQualifiedAccessExpressionBuilder $this$buildQualifiedAccessExpression = firQualifiedAccessExpressionBuilder;
            boolean bl43 = false;
            boolean $i$f$buildResolvedNamedReference = false;
            boolean bl44 = false;
            FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
            boolean bl45 = false;
            boolean bl46 = false;
            FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder;
            FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2 = $this$buildQualifiedAccessExpression;
            boolean bl47 = false;
            $this$buildResolvedNamedReference.setName(DELEGATED_SETTER_PARAM);
            $this$buildResolvedNamedReference.setResolvedSymbol((AbstractFirBasedSymbol)parameter.getSymbol());
            Unit unit8 = Unit.INSTANCE;
            firQualifiedAccessExpressionBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
            FirQualifiedAccessExpression firQualifiedAccessExpression = firQualifiedAccessExpressionBuilder.build();
            boolean bl48 = false;
            object.add(firQualifiedAccessExpression);
            unit7 = Unit.INSTANCE;
            ((FirFunctionCallBuilder)firAnnotationContainerBuilder).setArgumentList(firArgumentListBuilder.build());
            Unit unit9 = Unit.INSTANCE;
            FirStatement firStatement = firFunctionCallBuilder.build();
            var36_82.setBody(new FirSingleExpressionBlock(firStatement));
            unit2 = Unit.INSTANCE;
            ((FirPropertyBuilder)firAnnotationContainerBuilder2).setSetter(firPropertyAccessorBuilder.build());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<FirBlock, FirContractDescription> extractContractDescriptionIfPossible(@Nullable FirBlock $this$extractContractDescriptionIfPossible) {
        void $this$buildRawContractDescription;
        if ($this$extractContractDescriptionIfPossible == null) {
            return TuplesKt.to(null, null);
        }
        if (!ConversionUtilsKt.isContractPresentFirCheck($this$extractContractDescriptionIfPossible)) {
            return TuplesKt.to((Object)$this$extractContractDescriptionIfPossible, null);
        }
        FirStatement firStatement = FirExpressionUtilKt.replaceFirstStatement($this$extractContractDescriptionIfPossible, FirStubStatement.INSTANCE);
        if (firStatement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirFunctionCall");
        }
        FirFunctionCall contractCall = (FirFunctionCall)firStatement;
        boolean $i$f$buildRawContractDescription = false;
        boolean bl = false;
        FirRawContractDescriptionBuilder firRawContractDescriptionBuilder = new FirRawContractDescriptionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirRawContractDescriptionBuilder firRawContractDescriptionBuilder2 = firRawContractDescriptionBuilder;
        FirBlock firBlock = $this$extractContractDescriptionIfPossible;
        boolean bl4 = false;
        $this$buildRawContractDescription.setSource(contractCall.getSource());
        $this$buildRawContractDescription.setContractCall(contractCall);
        Unit unit = Unit.INSTANCE;
        return TuplesKt.to((Object)firBlock, (Object)firRawContractDescriptionBuilder.build());
    }

    public static final boolean isContractPresentFirCheck(@NotNull FirBlock $this$isContractPresentFirCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$isContractPresentFirCheck, (String)"$this$isContractPresentFirCheck");
        FirStatement firStatement = (FirStatement)CollectionsKt.firstOrNull($this$isContractPresentFirCheck.getStatements());
        if (firStatement == null) {
            return false;
        }
        FirStatement firstStatement = firStatement;
        FirStatement firStatement2 = firstStatement;
        if (!(firStatement2 instanceof FirFunctionCall)) {
            firStatement2 = null;
        }
        FirFunctionCall firFunctionCall = (FirFunctionCall)firStatement2;
        if (firFunctionCall == null) {
            return false;
        }
        FirFunctionCall contractCall = firFunctionCall;
        if (Intrinsics.areEqual((Object)contractCall.getCalleeReference().getName().asString(), (Object)"contract") ^ true) {
            return false;
        }
        FirExpression firExpression2 = contractCall.getExplicitReceiver();
        if (!(firExpression2 instanceof FirQualifiedAccessExpression)) {
            firExpression2 = null;
        }
        FirQualifiedAccessExpression firQualifiedAccessExpression = (FirQualifiedAccessExpression)firExpression2;
        if (firQualifiedAccessExpression == null) {
            return true;
        }
        FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
        if (!ConversionUtilsKt.checkReceiver(contractCall, "contracts")) {
            return false;
        }
        if (!ConversionUtilsKt.checkReceiver(receiver, "kotlin")) {
            return false;
        }
        FirExpression firExpression3 = receiver.getExplicitReceiver();
        if (!(firExpression3 instanceof FirQualifiedAccessExpression)) {
            firExpression3 = null;
        }
        FirQualifiedAccessExpression firQualifiedAccessExpression2 = (FirQualifiedAccessExpression)firExpression3;
        if (firQualifiedAccessExpression2 == null) {
            return false;
        }
        FirQualifiedAccessExpression receiverOfReceiver = firQualifiedAccessExpression2;
        return receiverOfReceiver.getExplicitReceiver() == null;
    }

    private static final boolean checkReceiver(FirExpression $this$checkReceiver, String name) {
        Object object;
        if (!($this$checkReceiver instanceof FirQualifiedAccessExpression)) {
            return false;
        }
        FirExpression firExpression2 = ((FirQualifiedAccessExpression)$this$checkReceiver).getExplicitReceiver();
        if (!(firExpression2 instanceof FirQualifiedAccessExpression)) {
            firExpression2 = null;
        }
        FirQualifiedAccessExpression firQualifiedAccessExpression = (FirQualifiedAccessExpression)firExpression2;
        if (firQualifiedAccessExpression == null) {
            return false;
        }
        FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
        FirReference firReference = receiver.getCalleeReference();
        if (!(firReference instanceof FirNamedReference)) {
            firReference = null;
        }
        if ((object = (FirNamedReference)firReference) == null || (object = ((FirNamedReference)object).getName()) == null || (object = ((Name)object).asString()) == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"(receiver.calleeReferenc\u2026sString() ?: return false");
        Object receiverName = object;
        return Intrinsics.areEqual((Object)receiverName, (Object)name);
    }

    static {
        Name name = Name.identifier("getValue");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(\"getValue\")");
        GET_VALUE = name;
        Name name2 = Name.identifier("setValue");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.identifier(\"setValue\")");
        SET_VALUE = name2;
        Name name3 = Name.identifier("provideDelegate");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"Name.identifier(\"provideDelegate\")");
        PROVIDE_DELEGATE = name3;
        Name name4 = Name.special("<set-?>");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"Name.special(\"<set-?>\")");
        DELEGATED_SETTER_PARAM = name4;
    }
}

