/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.bindingContextUtil;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00020\r*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f\u001a?\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\b\b\u0000\u0010\u0012*\u00020\u000f*\u00020\u00052\"\u0010\u0013\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00120\u00150\u0014\"\n\u0012\u0006\b\u0001\u0012\u0002H\u00120\u0015\u00a2\u0006\u0002\u0010\u0016\u001a\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0018*\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u0007*\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u001e\u001a\u00020\u001f*\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010 \u001a\u00020\u001f*\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010!\u001a\u00020\u001f*\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003\u001a*\u0010\"\u001a\u00020#\"\u000e\b\u0000\u0010$*\b\u0012\u0004\u0012\u0002H$0%*\b\u0012\u0004\u0012\u0002H$0%2\b\u0010&\u001a\u0004\u0018\u00010\u0019\u001a\u001c\u0010'\u001a\u00020#*\u00020(2\u0006\u0010)\u001a\u00020*2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a8\u0006+"}, d2={"getEnclosingDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "getEnclosingFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getAbbreviatedTypeOrType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "getDataFlowInfoAfter", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "position", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getDataFlowInfoBefore", "getParentOfTypeCodeFragmentAware", "T", "parentClasses", "", "Ljava/lang/Class;", "(Lorg/jetbrains/kotlin/psi/KtElement;[Ljava/lang/Class;)Lcom/intellij/psi/PsiElement;", "getReferenceTargets", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getTargetFunction", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "getTargetFunctionDescriptor", "isUsedAsExpression", "", "isUsedAsResultOfLambda", "isUsedAsStatement", "recordDataFlowInfo", "", "C", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "expression", "recordScope", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "frontend"})
public final class BindingContextUtilsKt {
    @Nullable
    public static final FunctionDescriptor getTargetFunctionDescriptor(@NotNull KtReturnExpression $this$getTargetFunctionDescriptor, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$getTargetFunctionDescriptor, (String)"$this$getTargetFunctionDescriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtSimpleNameExpression targetLabel = $this$getTargetFunctionDescriptor.getTargetLabel();
        if (targetLabel != null) {
            SimpleFunctionDescriptor simpleFunctionDescriptor;
            PsiElement psiElement = (PsiElement)context2.get(BindingContext.LABEL_TARGET, targetLabel);
            if (psiElement != null) {
                PsiElement psiElement2 = psiElement;
                boolean bl = false;
                boolean bl2 = false;
                PsiElement it = psiElement2;
                boolean bl3 = false;
                simpleFunctionDescriptor = (SimpleFunctionDescriptor)context2.get(BindingContext.FUNCTION, it);
            } else {
                simpleFunctionDescriptor = null;
            }
            return simpleFunctionDescriptor;
        }
        PsiElement $this$getNonStrictParentOfType$iv = $this$getTargetFunctionDescriptor;
        boolean $i$f$getNonStrictParentOfType = false;
        DeclarationDescriptor declarationDescriptor = context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtDeclarationWithBody.class, false));
        FunctionDescriptor functionDescriptor = DescriptorUtils.getParentOfType(declarationDescriptor, FunctionDescriptor.class, false);
        if (functionDescriptor == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"DescriptorUtils.getParen\u2026e)\n        ?: return null");
        FunctionDescriptor containingFunctionDescriptor = functionDescriptor;
        return (FunctionDescriptor)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile((Sequence)SequencesKt.generateSequence((Object)containingFunctionDescriptor, (Function1)getTargetFunctionDescriptor.2.INSTANCE), (Function1)getTargetFunctionDescriptor.3.INSTANCE));
    }

    @Nullable
    public static final KtCallableDeclaration getTargetFunction(@NotNull KtReturnExpression $this$getTargetFunction, @NotNull BindingContext context2) {
        KtCallableDeclaration ktCallableDeclaration;
        Intrinsics.checkNotNullParameter((Object)$this$getTargetFunction, (String)"$this$getTargetFunction");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FunctionDescriptor functionDescriptor = BindingContextUtilsKt.getTargetFunctionDescriptor($this$getTargetFunction, context2);
        if (functionDescriptor != null) {
            FunctionDescriptor functionDescriptor2 = functionDescriptor;
            boolean bl = false;
            boolean bl2 = false;
            FunctionDescriptor it = functionDescriptor2;
            boolean bl3 = false;
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(it);
            if (!(psiElement instanceof KtCallableDeclaration)) {
                psiElement = null;
            }
            ktCallableDeclaration = (KtCallableDeclaration)psiElement;
        } else {
            ktCallableDeclaration = null;
        }
        return ktCallableDeclaration;
    }

    public static final boolean isUsedAsExpression(@NotNull KtExpression $this$isUsedAsExpression, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$isUsedAsExpression, (String)"$this$isUsedAsExpression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Boolean bl = (Boolean)context2.get(BindingContext.USED_AS_EXPRESSION, $this$isUsedAsExpression);
        if (bl == null) {
            String string2;
            StringBuilder stringBuilder2 = new StringBuilder().append("BindingContext returned null for Boolean slice: ");
            if (Intrinsics.areEqual((Object)context2, (Object)BindingContext.EMPTY)) {
                string2 = "BindingContext.EMPTY";
            } else {
                String string3 = context2.getClass().toString();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.javaClass.toString()");
            }
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder2.append(string2).toString()));
        }
        return bl;
    }

    public static final boolean isUsedAsResultOfLambda(@NotNull KtExpression $this$isUsedAsResultOfLambda, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$isUsedAsResultOfLambda, (String)"$this$isUsedAsResultOfLambda");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object v = context2.get(BindingContext.USED_AS_RESULT_OF_LAMBDA, $this$isUsedAsResultOfLambda);
        Intrinsics.checkNotNull(v);
        return (Boolean)v;
    }

    public static final boolean isUsedAsStatement(@NotNull KtExpression $this$isUsedAsStatement, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$isUsedAsStatement, (String)"$this$isUsedAsStatement");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return !BindingContextUtilsKt.isUsedAsExpression($this$isUsedAsStatement, context2);
    }

    public static final <C extends ResolutionContext<C>> void recordDataFlowInfo(@NotNull ResolutionContext<C> $this$recordDataFlowInfo, @Nullable KtExpression expression2) {
        Intrinsics.checkNotNullParameter($this$recordDataFlowInfo, (String)"$this$recordDataFlowInfo");
        if (expression2 == null) {
            return;
        }
        KotlinTypeInfo typeInfo = (KotlinTypeInfo)$this$recordDataFlowInfo.trace.get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        if (typeInfo != null) {
            BindingTrace bindingTrace = $this$recordDataFlowInfo.trace;
            DataFlowInfo dataFlowInfo = $this$recordDataFlowInfo.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, typeInfo.replaceDataFlowInfo(dataFlowInfo));
        } else if (Intrinsics.areEqual((Object)$this$recordDataFlowInfo.dataFlowInfo, (Object)DataFlowInfo.Companion.getEMPTY()) ^ true) {
            BindingTrace bindingTrace = $this$recordDataFlowInfo.trace;
            DataFlowInfo dataFlowInfo = $this$recordDataFlowInfo.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, TypeInfoFactoryKt.noTypeInfo(dataFlowInfo));
        }
    }

    public static final void recordScope(@NotNull BindingTrace $this$recordScope, @NotNull LexicalScope scope2, @Nullable KtElement element) {
        Intrinsics.checkNotNullParameter((Object)$this$recordScope, (String)"$this$recordScope");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        if (element != null) {
            HierarchicalScope hierarchicalScope = ScopeUtilsKt.takeSnapshot(scope2);
            if (hierarchicalScope == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.LexicalScope");
            }
            $this$recordScope.record(BindingContext.LEXICAL_SCOPE, element, (LexicalScope)hierarchicalScope);
        }
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfoAfter(@NotNull BindingContext $this$getDataFlowInfoAfter, @NotNull PsiElement position) {
        Intrinsics.checkNotNullParameter((Object)$this$getDataFlowInfoAfter, (String)"$this$getDataFlowInfoAfter");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        for (PsiElement element : PsiUtilsKt.getParentsWithSelf(position)) {
            Object object;
            PsiElement psiElement = element;
            if (!(psiElement instanceof KtExpression)) {
                psiElement = null;
            }
            if ((object = (KtExpression)psiElement) == null) continue;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            PsiElement parent2 = it.getParent();
            KotlinTypeInfo kotlinTypeInfo = parent2 instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)it, (Object)((KtQualifiedExpression)parent2).getSelectorExpression()) ? null : (KotlinTypeInfo)$this$getDataFlowInfoAfter.get(BindingContext.EXPRESSION_TYPE_INFO, it);
            object = kotlinTypeInfo;
            if (kotlinTypeInfo == null) continue;
            object2 = object;
            bl = false;
            bl2 = false;
            it = object2;
            boolean bl4 = false;
            return ((KotlinTypeInfo)it).getDataFlowInfo();
        }
        return DataFlowInfo.Companion.getEMPTY();
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfoBefore(@NotNull BindingContext $this$getDataFlowInfoBefore, @NotNull PsiElement position) {
        Intrinsics.checkNotNullParameter((Object)$this$getDataFlowInfoBefore, (String)"$this$getDataFlowInfoBefore");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        for (PsiElement element : PsiUtilsKt.getParentsWithSelf(position)) {
            Object object;
            PsiElement psiElement = element;
            if (!(psiElement instanceof KtExpression)) {
                psiElement = null;
            }
            if ((object = (KtExpression)psiElement) == null) continue;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            object = (DataFlowInfo)$this$getDataFlowInfoBefore.get(BindingContext.DATA_FLOW_INFO_BEFORE, it);
            if (object == null) continue;
            object2 = object;
            bl = false;
            bl2 = false;
            it = object2;
            boolean bl4 = false;
            Object object3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"it");
            return object3;
        }
        return DataFlowInfo.Companion.getEMPTY();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Collection<DeclarationDescriptor> getReferenceTargets(@NotNull KtExpression $this$getReferenceTargets, @NotNull BindingContext context2) {
        Object object;
        boolean bl;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)$this$getReferenceTargets, (String)"$this$getReferenceTargets");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        DeclarationDescriptor targetDescriptor = $this$getReferenceTargets instanceof KtReferenceExpression ? (DeclarationDescriptor)context2.get(BindingContext.REFERENCE_TARGET, $this$getReferenceTargets) : null;
        Object object3 = targetDescriptor;
        if (object3 != null) {
            object2 = object3;
            bl = false;
            boolean bl2 = false;
            DeclarationDescriptor it = object2;
            boolean bl3 = false;
            object3 = CollectionsKt.listOf((Object)it);
            if (object3 != null) {
                object = (Collection)object3;
                return object;
            }
        }
        object2 = (Collection)context2.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, $this$getReferenceTargets);
        bl = false;
        object = object2;
        if (object != null) {
            return object;
        }
        object = CollectionsKt.emptyList();
        return object;
    }

    @Nullable
    public static final KotlinType getAbbreviatedTypeOrType(@NotNull KtTypeReference $this$getAbbreviatedTypeOrType, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$getAbbreviatedTypeOrType, (String)"$this$getAbbreviatedTypeOrType");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KotlinType kotlinType = (KotlinType)context2.get(BindingContext.ABBREVIATED_TYPE, $this$getAbbreviatedTypeOrType);
        if (kotlinType == null) {
            kotlinType = (KotlinType)context2.get(BindingContext.TYPE, $this$getAbbreviatedTypeOrType);
        }
        return kotlinType;
    }

    @Nullable
    public static final KotlinType getAbbreviatedTypeOrType(@NotNull KtTypeElement $this$getAbbreviatedTypeOrType, @NotNull BindingContext context2) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$getAbbreviatedTypeOrType, (String)"$this$getAbbreviatedTypeOrType");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiElement parent2 = $this$getAbbreviatedTypeOrType.getParent();
        if (parent2 instanceof KtTypeReference) {
            kotlinType = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeReference)parent2, context2);
        } else if (parent2 instanceof KtNullableType) {
            KotlinType outerType = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeElement)parent2, context2);
            if ($this$getAbbreviatedTypeOrType instanceof KtNullableType) {
                kotlinType = outerType;
            } else {
                KotlinType kotlinType2 = outerType;
                kotlinType = kotlinType2 != null ? TypeUtilsKt.makeNotNullable(kotlinType2) : null;
            }
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    @Nullable
    public static final <T extends PsiElement> T getParentOfTypeCodeFragmentAware(@NotNull KtElement $this$getParentOfTypeCodeFragmentAware, Class<? extends T> ... parentClasses) {
        PsiElement context2;
        Intrinsics.checkNotNullParameter((Object)$this$getParentOfTypeCodeFragmentAware, (String)"$this$getParentOfTypeCodeFragmentAware");
        Intrinsics.checkNotNullParameter(parentClasses, (String)"parentClasses");
        T t = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfTypeCodeFragmentAware, Arrays.copyOf(parentClasses, parentClasses.length));
        if (t != null) {
            T t2 = t;
            boolean bl = false;
            boolean bl2 = false;
            T it = t2;
            boolean bl3 = false;
            return it;
        }
        PsiFile containingFile = $this$getParentOfTypeCodeFragmentAware.getContainingFile();
        if (containingFile instanceof KtCodeFragment && (context2 = ((KtCodeFragment)containingFile).getContext()) != null) {
            return PsiTreeUtil.getParentOfType(context2, Arrays.copyOf(parentClasses, parentClasses.length));
        }
        return null;
    }

    @NotNull
    public static final DeclarationDescriptor getEnclosingDescriptor(@NotNull BindingContext context2, @NotNull KtElement element) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)BindingContextUtilsKt.getParentOfTypeCodeFragmentAware(element, KtNamedDeclaration.class);
        if (ktNamedDeclaration == null) {
            throw (Throwable)new KotlinExceptionWithAttachments("No parent KtNamedDeclaration for of type " + element.getClass()).withAttachment("element.kt", element.getText());
        }
        KtNamedDeclaration declaration2 = ktNamedDeclaration;
        if (declaration2 instanceof KtFunctionLiteral) {
            declarationDescriptor = BindingContextUtilsKt.getEnclosingDescriptor(context2, declaration2);
        } else {
            DeclarationDescriptor declarationDescriptor2 = context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration2);
            if (declarationDescriptor2 == null) {
                KtNamedDeclaration ktNamedDeclaration2 = declaration2;
                throw (Throwable)new KotlinExceptionWithAttachments("No descriptor for named declaration of type " + (ktNamedDeclaration2 != null ? ktNamedDeclaration2.getClass() : null)).withAttachment("declaration.kt", declaration2.getText());
            }
            declarationDescriptor = declarationDescriptor2;
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor2, (String)"context.get(DECLARATION_\u2026on.kt\", declaration.text)");
        }
        return declarationDescriptor;
    }

    @Nullable
    public static final FunctionDescriptor getEnclosingFunctionDescriptor(@NotNull BindingContext context2, @NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtTypeParameterListOwner functionOrClass = (KtTypeParameterListOwner)BindingContextUtilsKt.getParentOfTypeCodeFragmentAware(element, KtFunction.class, KtClassOrObject.class);
        DeclarationDescriptor descriptor2 = context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, functionOrClass);
        return functionOrClass instanceof KtFunction ? (descriptor2 instanceof FunctionDescriptor ? (FunctionDescriptor)descriptor2 : null) : (FunctionDescriptor)(descriptor2 instanceof ClassDescriptor ? ((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor() : null);
    }
}

