/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\u0004*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/InlineParameterChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "reportIncorrectInline", "Lorg/jetbrains/kotlin/psi/KtParameter;", "modifierToken", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "frontend"})
public final class InlineParameterChecker
implements DeclarationChecker {
    public static final InlineParameterChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (!(declaration2 instanceof KtFunction)) break block5;
            boolean inline = declaration2.hasModifier(KtTokens.INLINE_KEYWORD);
            for (KtParameter parameter : ((KtFunction)declaration2).getValueParameters()) {
                VariableDescriptor parameterDescriptor;
                block7: {
                    block6: {
                        parameterDescriptor = (VariableDescriptor)context2.getTrace().get(BindingContext.VALUE_PARAMETER, parameter);
                        if (!inline) break block6;
                        if (parameterDescriptor == null) break block7;
                        KotlinType kotlinType = parameterDescriptor.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"parameterDescriptor.type");
                        if (FunctionTypesKt.isBuiltinFunctionalType(kotlinType)) break block7;
                    }
                    KtParameter ktParameter = parameter;
                    Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"parameter");
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.NOINLINE_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"KtTokens.NOINLINE_KEYWORD");
                    this.reportIncorrectInline(ktParameter, ktModifierKeywordToken, context2.getTrace());
                    KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.CROSSINLINE_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken2, (String)"KtTokens.CROSSINLINE_KEYWORD");
                    this.reportIncorrectInline(parameter, ktModifierKeywordToken2, context2.getTrace());
                }
                if (!inline || parameter.hasModifier(KtTokens.NOINLINE_KEYWORD) || parameter.hasModifier(KtTokens.CROSSINLINE_KEYWORD)) continue;
                Annotated annotated = parameterDescriptor;
                if (annotated == null || (annotated = annotated.getType()) == null) continue;
                if (!FunctionTypesKt.isSuspendFunctionType((KotlinType)annotated)) continue;
                if (declaration2.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
                    PsiElement modifier;
                    KtModifierList modifierList2;
                    KtTypeReference typeReference;
                    KtParameter ktParameter = parameter;
                    Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"parameter");
                    Intrinsics.checkNotNull((Object)ktParameter.getTypeReference());
                    Intrinsics.checkNotNullExpressionValue((Object)typeReference, (String)"parameter.typeReference!!");
                    Intrinsics.checkNotNull((Object)typeReference.getModifierList());
                    Intrinsics.checkNotNullExpressionValue((Object)modifierList2, (String)"typeReference.modifierList!!");
                    Intrinsics.checkNotNull((Object)modifierList2.getModifier(KtTokens.SUSPEND_KEYWORD));
                    Intrinsics.checkNotNullExpressionValue((Object)modifier, (String)"modifierList.getModifier\u2026Tokens.SUSPEND_KEYWORD)!!");
                    context2.getTrace().report(Errors.REDUNDANT_INLINE_SUSPEND_FUNCTION_TYPE.on(modifier));
                    continue;
                }
                context2.getTrace().report(Errors.INLINE_SUSPEND_FUNCTION_TYPE_UNSUPPORTED.on((KtParameter)((PsiElement)parameter)));
            }
        }
    }

    private final void reportIncorrectInline(KtParameter $this$reportIncorrectInline, KtModifierKeywordToken modifierToken, DiagnosticSink diagnosticHolder) {
        block0: {
            PsiElement modifier;
            KtModifierList ktModifierList = $this$reportIncorrectInline.getModifierList();
            PsiElement psiElement = modifier = ktModifierList != null ? ktModifierList.getModifier(modifierToken) : null;
            if (psiElement == null) break block0;
            PsiElement psiElement2 = psiElement;
            boolean bl = false;
            boolean bl2 = false;
            PsiElement it = psiElement2;
            boolean bl3 = false;
            diagnosticHolder.report(Errors.ILLEGAL_INLINE_PARAMETER_MODIFIER.on(modifier, modifierToken));
        }
    }

    private InlineParameterChecker() {
    }

    static {
        InlineParameterChecker inlineParameterChecker;
        INSTANCE = inlineParameterChecker = new InlineParameterChecker();
    }
}

