/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallExpressionResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionInformation;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiOperation;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArgumentsImpl;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.checkers.UnderscoreChecker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.UnsignedErrorValueTypeConstant;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.EnumCompatibilityCheckerKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.LabelResolver;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.SenselessComparisonChecker;
import org.jetbrains.kotlin.types.expressions.TypeReconstructionUtil;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.expressions.unqualifiedSuper.UnqualifiedSuperKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public class BasicExpressionTypingVisitor
extends ExpressionTypingVisitor {
    private static final TokenSet BARE_TYPES_ALLOWED = TokenSet.create(KtTokens.AS_KEYWORD, KtTokens.AS_SAFE);
    private static final Pattern FP_LITERAL_PARTS = Pattern.compile("(?:([_\\d]*)\\.?([_\\d]*)e?[+-]?([_\\d]*))[f]?");

    protected BasicExpressionTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        if (facade == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(0);
        }
        super(facade);
    }

    private static boolean isLValueOrUnsafeReceiver(@NotNull KtSimpleNameExpression expression2) {
        PsiElement parent2;
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(1);
        }
        if ((parent2 = PsiTreeUtil.skipParentsOfType(expression2, KtParenthesizedExpression.class)) instanceof KtQualifiedExpression) {
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)parent2;
            return qualifiedExpression.getOperationSign() == KtTokens.DOT && qualifiedExpression.getReceiverExpression() == KtPsiUtil.deparenthesize(expression2);
        }
        return BasicExpressionTypingVisitor.isLValue(expression2, parent2);
    }

    public static boolean isLValue(@NotNull KtSimpleNameExpression expression2, @Nullable PsiElement parent2) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(2);
        }
        if (!(parent2 instanceof KtBinaryExpression)) {
            return false;
        }
        KtBinaryExpression binaryExpression = (KtBinaryExpression)parent2;
        if (!OperatorConventions.BINARY_OPERATION_NAMES.containsKey(binaryExpression.getOperationToken()) && !KtTokens.ALL_ASSIGNMENTS.contains(binaryExpression.getOperationToken())) {
            return false;
        }
        return PsiTreeUtil.isAncestor(binaryExpression.getLeft(), expression2, false);
    }

    private static boolean isDangerousWithNull(@NotNull KtSimpleNameExpression expression2, @NotNull ExpressionTypingContext context2) {
        PsiElement parent2;
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(3);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(4);
        }
        if ((parent2 = PsiTreeUtil.skipParentsOfType(expression2, KtParenthesizedExpression.class)) instanceof KtUnaryExpression) {
            KtUnaryExpression unaryExpression = (KtUnaryExpression)parent2;
            return unaryExpression.getOperationToken() == KtTokens.EXCLEXCL;
        }
        if (parent2 instanceof KtBinaryExpressionWithTypeRHS) {
            KtBinaryExpressionWithTypeRHS binaryExpression = (KtBinaryExpressionWithTypeRHS)parent2;
            KotlinType type2 = context2.trace.get(BindingContext.TYPE, binaryExpression.getRight());
            return type2 != null && !type2.isMarkedNullable() && binaryExpression.getOperationReference().getReferencedNameElementType() == KtTokens.AS_KEYWORD;
        }
        return false;
    }

    private void checkNull(@NotNull KtSimpleNameExpression expression2, @NotNull ExpressionTypingContext context2, @Nullable KotlinType type2) {
        DataFlowValue dataFlowValue2;
        Nullability nullability;
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(5);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(6);
        }
        if (type2 != null && !KotlinTypeKt.isError(type2) && !BasicExpressionTypingVisitor.isLValueOrUnsafeReceiver(expression2) && !(nullability = context2.dataFlowInfo.getStableNullability(dataFlowValue2 = this.components.dataFlowValueFactory.createDataFlowValue(expression2, type2, context2))).canBeNonNull() && nullability.canBeNull()) {
            if (BasicExpressionTypingVisitor.isDangerousWithNull(expression2, context2)) {
                context2.trace.report(Errors.ALWAYS_NULL.on(expression2));
            } else {
                context2.trace.record(BindingContext.SMARTCAST_NULL, expression2);
            }
        }
    }

    @Override
    public KotlinTypeInfo visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(7);
        }
        ReservedCheckingKt.checkReservedYield(expression2, context2.trace);
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        KotlinTypeInfo typeInfo = callExpressionResolver.getSimpleNameExpressionTypeInfo(expression2, null, null, context2);
        this.checkNull(expression2, context2, typeInfo.getType());
        this.components.constantExpressionEvaluator.evaluateExpression(expression2, context2.trace, context2.expectedType);
        return this.components.dataFlowAnalyzer.checkType(typeInfo, (KtExpression)expression2, (ResolutionContext)context2);
    }

    @Override
    public KotlinTypeInfo visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, ExpressionTypingContext context2) {
        KtExpression innerExpression;
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(8);
        }
        if ((innerExpression = expression2.getExpression()) == null) {
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        KotlinTypeInfo result2 = this.facade.getTypeInfo(innerExpression, context2);
        KotlinType resultType = result2.getType();
        if (resultType != null) {
            DataFlowValue innerValue = this.components.dataFlowValueFactory.createDataFlowValue(innerExpression, resultType, context2);
            DataFlowValue resultValue = this.components.dataFlowValueFactory.createDataFlowValue(expression2, resultType, context2);
            result2 = result2.replaceDataFlowInfo(result2.getDataFlowInfo().assign(resultValue, innerValue, this.components.languageVersionSettings));
        }
        return result2;
    }

    @Override
    public KotlinTypeInfo visitConstantExpression(@NotNull KtConstantExpression expression2, ExpressionTypingContext context2) {
        ConstantValue constantValue;
        CompileTimeConstantChecker constantChecker;
        boolean hasError;
        CompileTimeConstant<?> compileTimeConstant;
        IElementType elementType;
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(9);
        }
        if ((elementType = expression2.getNode().getElementType()) == KtNodeTypes.CHARACTER_CONSTANT || elementType == KtNodeTypes.INTEGER_CONSTANT || elementType == KtNodeTypes.FLOAT_CONSTANT) {
            BasicExpressionTypingVisitor.checkLiteralPrefixAndSuffix(expression2, context2);
        }
        if (elementType == KtNodeTypes.INTEGER_CONSTANT || elementType == KtNodeTypes.FLOAT_CONSTANT) {
            this.checkUnderscores(expression2, elementType, context2);
        }
        if ((compileTimeConstant = this.components.constantExpressionEvaluator.evaluateExpression(expression2, context2.trace, context2.expectedType)) instanceof UnsignedErrorValueTypeConstant) {
            ErrorValue.ErrorValueWithMessage value2 = ((UnsignedErrorValueTypeConstant)compileTimeConstant).getErrorValue();
            context2.trace.report(Errors.UNSIGNED_LITERAL_WITHOUT_DECLARATIONS_ON_CLASSPATH.on(expression2));
            return TypeInfoFactoryKt.createTypeInfo((KotlinType)value2.getType(this.components.moduleDescriptor), context2);
        }
        if (!(compileTimeConstant instanceof IntegerValueTypeConstant) && (hasError = (constantChecker = new CompileTimeConstantChecker(context2, this.components.moduleDescriptor, false)).checkConstantExpressionType(constantValue = compileTimeConstant != null ? ((TypedCompileTimeConstant)compileTimeConstant).getConstantValue() : null, expression2, context2.expectedType))) {
            return TypeInfoFactoryKt.createTypeInfo(constantValue != null ? constantValue.getType(this.components.moduleDescriptor) : this.getDefaultType(elementType), context2);
        }
        assert (compileTimeConstant != null) : "CompileTimeConstant should be evaluated for constant expression or an error should be recorded " + expression2.getText();
        return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(compileTimeConstant, expression2, context2);
    }

    private void checkUnderscores(@NotNull KtConstantExpression expression2, @NotNull IElementType elementType, @NotNull ExpressionTypingContext context2) {
        List<String> parts;
        String text2;
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(10);
        }
        if (elementType == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(11);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(12);
        }
        if (!(text2 = expression2.getText().toLowerCase()).contains("_")) {
            return;
        }
        if (!this.components.languageVersionSettings.supportsFeature(LanguageFeature.UnderscoresInNumericLiterals)) {
            context2.trace.report(Errors.UNSUPPORTED_FEATURE.on(expression2, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.UnderscoresInNumericLiterals), (Object)this.components.languageVersionSettings)));
            return;
        }
        if (elementType == KtNodeTypes.INTEGER_CONSTANT) {
            int start = 0;
            int end = expression2.getText().length();
            if (text2.startsWith("0x") || text2.startsWith("0b")) {
                start += 2;
            }
            if (StringUtil.endsWithChar(text2, 'l')) {
                --end;
            }
            parts = Collections.singletonList(text2.substring(start, end));
        } else {
            Matcher matcher2 = FP_LITERAL_PARTS.matcher(text2);
            parts = new ArrayList<String>();
            if (matcher2.matches()) {
                for (int i = 0; i < matcher2.groupCount(); ++i) {
                    parts.add(matcher2.group(i + 1));
                }
            }
        }
        for (String part : parts) {
            if (part == null || !part.startsWith("_") && !part.endsWith("_")) continue;
            context2.trace.report(Errors.ILLEGAL_UNDERSCORE.on(expression2));
            return;
        }
    }

    @NotNull
    public KotlinType getDefaultType(IElementType constantType) {
        KotlinBuiltIns builtIns = this.components.builtIns;
        if (constantType == KtNodeTypes.INTEGER_CONSTANT) {
            SimpleType simpleType2 = builtIns.getIntType();
            if (simpleType2 == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(13);
            }
            return simpleType2;
        }
        if (constantType == KtNodeTypes.FLOAT_CONSTANT) {
            SimpleType simpleType3 = builtIns.getDoubleType();
            if (simpleType3 == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(14);
            }
            return simpleType3;
        }
        if (constantType == KtNodeTypes.BOOLEAN_CONSTANT) {
            SimpleType simpleType4 = builtIns.getBooleanType();
            if (simpleType4 == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(15);
            }
            return simpleType4;
        }
        if (constantType == KtNodeTypes.CHARACTER_CONSTANT) {
            SimpleType simpleType5 = builtIns.getCharType();
            if (simpleType5 == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(16);
            }
            return simpleType5;
        }
        if (constantType == KtNodeTypes.NULL) {
            SimpleType simpleType6 = builtIns.getNullableNothingType();
            if (simpleType6 == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(17);
            }
            return simpleType6;
        }
        throw new IllegalArgumentException("Unsupported constant type: " + constantType);
    }

    @Override
    public KotlinTypeInfo visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(18);
        }
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtExpression left = expression2.getLeft();
        KtTypeReference right = expression2.getRight();
        if (right == null) {
            return this.facade.getTypeInfo(left, contextWithNoExpectedType).clearType();
        }
        IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
        boolean allowBareTypes = BARE_TYPES_ALLOWED.contains(operationType);
        TypeResolutionContext typeResolutionContext = new TypeResolutionContext(context2.scope, context2.trace, true, allowBareTypes, context2.isDebuggerContext);
        PossiblyBareType possiblyBareTarget = this.components.typeResolver.resolvePossiblyBareType(typeResolutionContext, right);
        KotlinTypeInfo typeInfo = this.facade.getTypeInfo(left, contextWithNoExpectedType);
        KotlinType subjectType = typeInfo.getType();
        KotlinType targetType = TypeReconstructionUtil.reconstructBareType(right, possiblyBareTarget, subjectType, context2.trace, this.components.builtIns);
        if (subjectType != null) {
            this.checkBinaryWithTypeRHS(expression2, context2, targetType, subjectType);
            DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
            if (operationType == KtTokens.AS_KEYWORD) {
                DataFlowValue value2 = this.components.dataFlowValueFactory.createDataFlowValue(left, subjectType, context2);
                typeInfo = typeInfo.replaceDataFlowInfo(dataFlowInfo.establishSubtyping(value2, targetType, this.components.languageVersionSettings));
            }
        }
        KotlinType result2 = operationType == KtTokens.AS_SAFE ? TypeUtils.makeNullable(targetType) : targetType;
        KotlinTypeInfo resultTypeInfo = this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(result2), (KtExpression)expression2, (ResolutionContext)context2);
        RttiExpressionInformation rttiInformation = new RttiExpressionInformation(expression2.getLeft(), subjectType, result2, operationType == KtTokens.AS_SAFE ? RttiOperation.SAFE_AS : RttiOperation.AS);
        for (RttiExpressionChecker checker : this.components.rttiExpressionCheckers) {
            checker.check(rttiInformation, expression2, context2.trace);
        }
        return resultTypeInfo;
    }

    private void checkBinaryWithTypeRHS(@NotNull KtBinaryExpressionWithTypeRHS expression2, @NotNull ExpressionTypingContext context2, @NotNull KotlinType targetType, @Nullable KotlinType actualType) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(19);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(20);
        }
        if (targetType == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(21);
        }
        if (actualType == null) {
            return;
        }
        KtSimpleNameExpression operationSign = expression2.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType != KtTokens.AS_KEYWORD && operationType != KtTokens.AS_SAFE) {
            context2.trace.report(Errors.UNSUPPORTED.on(operationSign, "binary operation with type RHS"));
            return;
        }
        this.checkForCastImpossibilityOrRedundancy(expression2, actualType, targetType, context2);
    }

    private void checkForCastImpossibilityOrRedundancy(KtBinaryExpressionWithTypeRHS expression2, KotlinType actualType, KotlinType targetType, ExpressionTypingContext context2) {
        if (actualType == null || TypeUtils.noExpectedType(targetType) || KotlinTypeKt.isError(targetType)) {
            return;
        }
        if (Boolean.TRUE.equals(context2.trace.get(BindingContext.CAST_TYPE_USED_AS_EXPECTED_TYPE, expression2))) {
            return;
        }
        if (DynamicTypesKt.isDynamic(targetType)) {
            KtTypeReference right = expression2.getRight();
            assert (right != null) : "We know target is dynamic, but RHS is missing";
            context2.trace.report(Errors.DYNAMIC_NOT_ALLOWED.on(right));
            return;
        }
        if (!CastDiagnosticsUtil.isCastPossible(actualType, targetType, this.components.platformToKotlinClassMap)) {
            context2.trace.report(Errors.CAST_NEVER_SUCCEEDS.on(expression2.getOperationReference()));
            return;
        }
        if (CastDiagnosticsUtil.INSTANCE.castIsUseless(expression2, context2, targetType, actualType)) {
            context2.trace.report(Errors.USELESS_CAST.on(expression2));
            return;
        }
        if (CastDiagnosticsUtil.isCastErased(actualType, targetType, KotlinTypeChecker.DEFAULT)) {
            context2.trace.report(Errors.UNCHECKED_CAST.on(expression2, actualType, targetType));
        }
    }

    @Override
    public KotlinTypeInfo visitThisExpression(@NotNull KtThisExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(22);
        }
        KotlinType result2 = null;
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = this.resolveToReceiver(expression2, context2, false);
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                break;
            }
            case NO_THIS: {
                context2.trace.report(Errors.NO_THIS.on(expression2));
                break;
            }
            case SUCCESS: {
                result2 = resolutionResult.getReceiverParameterDescriptor().getType();
                context2.trace.recordType(expression2.getInstanceReference(), result2);
            }
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(result2, context2, expression2);
    }

    @Override
    public KotlinTypeInfo visitSuperExpression(@NotNull KtSuperExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(23);
        }
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = this.resolveToReceiver(expression2, context2, true);
        if (!KtPsiUtil.isLHSOfDot(expression2)) {
            context2.trace.report(Errors.SUPER_IS_NOT_AN_EXPRESSION.on(expression2, expression2.getText()));
            return this.errorInSuper(expression2, context2);
        }
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                return this.errorInSuper(expression2, context2);
            }
            case NO_THIS: {
                context2.trace.report(Errors.SUPER_NOT_AVAILABLE.on(expression2));
                return this.errorInSuper(expression2, context2);
            }
            case SUCCESS: {
                KotlinType result2 = this.checkPossiblyQualifiedSuper(expression2, context2, resolutionResult.getReceiverParameterDescriptor());
                if (result2 != null) {
                    context2.trace.recordType(expression2.getInstanceReference(), result2);
                }
                return this.components.dataFlowAnalyzer.createCheckedTypeInfo(result2, context2, expression2);
            }
        }
        throw new IllegalStateException("Unknown code: " + (Object)((Object)resolutionResult.getCode()));
    }

    private KotlinTypeInfo errorInSuper(KtSuperExpression expression2, ExpressionTypingContext context2) {
        KtTypeReference superTypeQualifier = expression2.getSuperTypeQualifier();
        if (superTypeQualifier != null) {
            this.components.typeResolver.resolveType(context2.scope, superTypeQualifier, context2.trace, true);
        }
        return TypeInfoFactoryKt.noTypeInfo(context2);
    }

    private KotlinType checkPossiblyQualifiedSuper(KtSuperExpression expression2, ExpressionTypingContext context2, ReceiverParameterDescriptor thisReceiver2) {
        KtTypeReference superTypeQualifier;
        KotlinType thisType;
        KotlinType result2;
        block22: {
            TypeSubstitutor substitutor2;
            Collection<KotlinType> supertypes2;
            block19: {
                boolean validType;
                KtTypeArgumentList redundantTypeArguments;
                KotlinType supertype2;
                ClassifierDescriptor classifierCandidate;
                block21: {
                    block20: {
                        result2 = null;
                        thisType = thisReceiver2.getType();
                        supertypes2 = thisType.getConstructor().getSupertypes();
                        substitutor2 = TypeSubstitutor.create(thisType);
                        superTypeQualifier = expression2.getSuperTypeQualifier();
                        if (superTypeQualifier == null) break block19;
                        KtTypeElement typeElement = superTypeQualifier.getTypeElement();
                        classifierCandidate = null;
                        supertype2 = null;
                        redundantTypeArguments = null;
                        if (typeElement instanceof KtUserType) {
                            KtUserType userType = (KtUserType)typeElement;
                            if (userType.getTypeArguments().isEmpty()) {
                                classifierCandidate = this.components.typeResolver.resolveClass(context2.scope, userType, context2.trace, context2.isDebuggerContext);
                            } else {
                                supertype2 = this.components.typeResolver.resolveType(context2.scope, superTypeQualifier, context2.trace, true);
                                redundantTypeArguments = userType.getTypeArgumentList();
                            }
                        } else {
                            supertype2 = this.components.typeResolver.resolveType(context2.scope, superTypeQualifier, context2.trace, true);
                        }
                        if (classifierCandidate instanceof TypeAliasDescriptor) {
                            classifierCandidate = ((TypeAliasDescriptor)classifierCandidate).getClassDescriptor();
                        }
                        if (supertype2 == null) break block20;
                        if (!supertypes2.contains(supertype2)) break block21;
                        result2 = supertype2;
                        break block21;
                    }
                    if (classifierCandidate instanceof ClassDescriptor) {
                        ClassifierDescriptor superclass = classifierCandidate;
                        for (KotlinType declaredSupertype : supertypes2) {
                            if (!declaredSupertype.getConstructor().equals(superclass.getTypeConstructor())) continue;
                            result2 = substitutor2.safeSubstitute(declaredSupertype, Variance.INVARIANT);
                            break;
                        }
                    }
                }
                boolean validClassifier = classifierCandidate != null && !ErrorUtils.isError(classifierCandidate);
                boolean bl = validType = supertype2 != null && !KotlinTypeKt.isError(supertype2);
                if (result2 == null && (validClassifier || validType)) {
                    context2.trace.report(Errors.NOT_A_SUPERTYPE.on(superTypeQualifier));
                } else if (redundantTypeArguments != null) {
                    context2.trace.report(Errors.TYPE_ARGUMENTS_REDUNDANT_IN_SUPER_QUALIFIER.on(redundantTypeArguments));
                }
                if (result2 != null && (validClassifier || validType)) {
                    BasicExpressionTypingVisitor.checkResolvedExplicitlyQualifiedSupertype(context2.trace, result2, supertypes2, superTypeQualifier);
                }
                break block22;
            }
            if (UnqualifiedSuperKt.isPossiblyAmbiguousUnqualifiedSuper(expression2, supertypes2)) {
                Collection<KotlinType> supertypesResolvedFromContext = UnqualifiedSuperKt.resolveUnqualifiedSuperFromExpressionContext(expression2, supertypes2, this.components.builtIns.getAnyType());
                if (supertypesResolvedFromContext.size() == 1) {
                    KotlinType singleResolvedType = supertypesResolvedFromContext.iterator().next();
                    result2 = substitutor2.substitute(singleResolvedType, Variance.INVARIANT);
                } else if (supertypesResolvedFromContext.isEmpty()) {
                    result2 = this.components.builtIns.getAnyType();
                } else {
                    context2.trace.report(Errors.AMBIGUOUS_SUPER.on(expression2));
                }
            } else {
                KotlinType type2 = supertypes2.isEmpty() ? this.components.builtIns.getAnyType() : supertypes2.iterator().next();
                result2 = substitutor2.substitute(type2, Variance.INVARIANT);
            }
        }
        if (result2 != null) {
            if (DescriptorUtils.isInterface(thisType.getConstructor().getDeclarationDescriptor()) && DescriptorUtils.isClass(result2.getConstructor().getDeclarationDescriptor())) {
                context2.trace.report(Errors.SUPERCLASS_NOT_ACCESSIBLE_FROM_INTERFACE.on(expression2));
            }
            context2.trace.recordType(expression2.getInstanceReference(), result2);
            context2.trace.record(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference(), result2.getConstructor().getDeclarationDescriptor());
            context2.trace.record(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, expression2, thisType);
        }
        BindingContextUtilsKt.recordScope(context2.trace, context2.scope, superTypeQualifier);
        return result2;
    }

    private static void checkResolvedExplicitlyQualifiedSupertype(@NotNull BindingTrace trace, @NotNull KotlinType result2, @NotNull Collection<KotlinType> supertypes2, @NotNull KtTypeReference superTypeQualifier) {
        if (trace == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(24);
        }
        if (result2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(25);
        }
        if (supertypes2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(26);
        }
        if (superTypeQualifier == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(27);
        }
        if (supertypes2.size() > 1) {
            ClassifierDescriptor resultClassifierDescriptor = result2.getConstructor().getDeclarationDescriptor();
            for (KotlinType otherSupertype : supertypes2) {
                ClassifierDescriptor otherSupertypeClassifierDescriptor = otherSupertype.getConstructor().getDeclarationDescriptor();
                if (otherSupertypeClassifierDescriptor == resultClassifierDescriptor || !KotlinTypeChecker.DEFAULT.isSubtypeOf(otherSupertype, result2)) continue;
                trace.report(Errors.QUALIFIED_SUPERTYPE_EXTENDED_BY_OTHER_SUPERTYPE.on(superTypeQualifier, otherSupertype));
                break;
            }
        }
    }

    @NotNull
    private LabelResolver.LabeledReceiverResolutionResult resolveToReceiver(KtInstanceExpressionWithLabel expression2, ExpressionTypingContext context2, boolean onlyClassReceivers) {
        Name labelName = expression2.getLabelNameAsName();
        if (labelName != null) {
            LabelResolver.LabeledReceiverResolutionResult resolutionResult = LabelResolver.INSTANCE.resolveThisOrSuperLabel(expression2, context2, labelName);
            if (resolutionResult.success()) {
                ReceiverParameterDescriptor receiverParameterDescriptor = resolutionResult.getReceiverParameterDescriptor();
                this.recordThisOrSuperCallInTraceAndCallExtension(context2, receiverParameterDescriptor, expression2);
                if (onlyClassReceivers && !BasicExpressionTypingVisitor.isDeclaredInClass(receiverParameterDescriptor)) {
                    LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabelResolver.LabeledReceiverResolutionResult.Companion.labelResolutionSuccess(null);
                    if (labeledReceiverResolutionResult == null) {
                        BasicExpressionTypingVisitor.$$$reportNull$$$0(28);
                    }
                    return labeledReceiverResolutionResult;
                }
            }
            LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = resolutionResult;
            if (labeledReceiverResolutionResult == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(29);
            }
            return labeledReceiverResolutionResult;
        }
        ReceiverParameterDescriptor result2 = null;
        List<ReceiverParameterDescriptor> receivers = ScopeUtilsKt.getImplicitReceiversHierarchy(context2.scope);
        if (onlyClassReceivers) {
            for (ReceiverParameterDescriptor receiver : receivers) {
                if (!BasicExpressionTypingVisitor.isDeclaredInClass(receiver)) continue;
                result2 = receiver;
                break;
            }
        } else if (!receivers.isEmpty()) {
            result2 = receivers.get(0);
        }
        if (result2 != null) {
            context2.trace.record(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference(), result2.getContainingDeclaration());
            this.recordThisOrSuperCallInTraceAndCallExtension(context2, result2, expression2);
        }
        LabelResolver.LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabelResolver.LabeledReceiverResolutionResult.Companion.labelResolutionSuccess(result2);
        if (labeledReceiverResolutionResult == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(30);
        }
        return labeledReceiverResolutionResult;
    }

    private void recordThisOrSuperCallInTraceAndCallExtension(ExpressionTypingContext context2, ReceiverParameterDescriptor descriptor2, KtExpression expression2) {
        BindingTrace trace = context2.trace;
        Call call2 = CallMaker.makeCall(expression2, null, null, expression2, Collections.emptyList());
        ResolutionCandidate<ReceiverParameterDescriptor> resolutionCandidate = ResolutionCandidate.create(call2, descriptor2, null, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null);
        ResolvedCallImpl<ReceiverParameterDescriptor> resolvedCall2 = ResolvedCallImpl.create(resolutionCandidate, TemporaryBindingTrace.create(trace, "Fake trace for fake 'this' or 'super' resolved call"), TracingStrategy.EMPTY, new DataFlowInfoForArgumentsImpl(context2.dataFlowInfo, call2));
        resolvedCall2.markCallAsCompleted();
        trace.record(BindingContext.RESOLVED_CALL, call2, resolvedCall2);
        trace.record(BindingContext.CALL, expression2, call2);
        if (context2.trace.wantsDiagnostics()) {
            CallCheckerContext callCheckerContext = this.createCallCheckerContext(context2);
            for (CallChecker checker : this.components.callCheckers) {
                checker.check(resolvedCall2, expression2, callCheckerContext);
            }
        }
    }

    private static boolean isDeclaredInClass(ReceiverParameterDescriptor receiver) {
        return receiver.getContainingDeclaration() instanceof ClassDescriptor;
    }

    @Override
    public KotlinTypeInfo visitBlockExpression(@NotNull KtBlockExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(31);
        }
        return this.components.expressionTypingServices.getBlockReturnedType(expression2, context2, false);
    }

    @Override
    public KotlinTypeInfo visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, ExpressionTypingContext c) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(32);
        }
        return this.components.doubleColonExpressionResolver.visitClassLiteralExpression(expression2, c);
    }

    @Override
    public KotlinTypeInfo visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2, ExpressionTypingContext c) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(33);
        }
        return this.components.doubleColonExpressionResolver.visitCallableReferenceExpression(expression2, c);
    }

    @Override
    public KotlinTypeInfo visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(34);
        }
        KotlinType[] result2 = new KotlinType[1];
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(context2.trace, "trace to resolve object literal expression", expression2);
        ObservableBindingTrace traceAdapter = new ObservableBindingTrace(temporaryTrace);
        traceAdapter.addHandler(BindingContext.CLASS, (slice, declaration2, descriptor2) -> {
            if (slice == BindingContext.CLASS && declaration2 == expression2.getObjectDeclaration()) {
                result2[0] = this.components.wrappedTypeFactory.createRecursionIntolerantDeferredType(context2.trace, (Function0<? extends KotlinType>)((Function0)descriptor2::getDefaultType));
            }
        });
        this.components.localClassifierAnalyzer.processClassOrObject(null, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceBindingTrace(traceAdapter)).replaceContextDependency(ContextDependency.INDEPENDENT), context2.scope.getOwnerDescriptor(), expression2.getObjectDeclaration());
        temporaryTrace.commit();
        DataFlowInfo resultFlowInfo = context2.dataFlowInfo;
        for (KtSuperTypeListEntry specifier : expression2.getObjectDeclaration().getSuperTypeListEntries()) {
            KtSuperTypeCallEntry delegator;
            KotlinTypeInfo delegatorTypeInfo;
            if (!(specifier instanceof KtSuperTypeCallEntry) || (delegatorTypeInfo = context2.trace.get(BindingContext.EXPRESSION_TYPE_INFO, (delegator = (KtSuperTypeCallEntry)specifier).getCalleeExpression())) == null) continue;
            resultFlowInfo = resultFlowInfo.and(delegatorTypeInfo.getDataFlowInfo());
        }
        KotlinTypeInfo resultTypeInfo = this.components.dataFlowAnalyzer.checkType(TypeInfoFactoryKt.createTypeInfo(result2[0], resultFlowInfo), (KtExpression)expression2, (ResolutionContext)context2);
        context2.trace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, resultTypeInfo);
        context2.trace.record(BindingContext.PROCESSED, expression2);
        return resultTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitQualifiedExpression(@NotNull KtQualifiedExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(35);
        }
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        return callExpressionResolver.getQualifiedExpressionTypeInfo(expression2, context2);
    }

    @Override
    public KotlinTypeInfo visitCallExpression(@NotNull KtCallExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(36);
        }
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        return callExpressionResolver.getCallExpressionTypeInfo(expression2, context2);
    }

    @Override
    public KotlinTypeInfo visitUnaryExpression(@NotNull KtUnaryExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        KotlinType result2;
        OverloadResolutionResults<FunctionDescriptor> resolutionResults;
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(37);
        }
        ExpressionTypingContext context2 = ExpressionTypingUtils.isUnaryExpressionDependentOnExpectedType(expression2) ? contextWithExpectedType : (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtExpression baseExpression = expression2.getBaseExpression();
        if (baseExpression == null) {
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        KtSimpleNameExpression operationSign = expression2.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == KtTokens.EXCLEXCL) {
            return this.visitExclExclExpression(expression2, context2);
        }
        KotlinTypeInfo typeInfo = this.facade.safeGetTypeInfo(baseExpression, context2);
        KotlinType type2 = ExpressionTypingUtils.safeGetType(typeInfo);
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(baseExpression, type2, context2.trace.getBindingContext());
        Call call2 = CallMaker.makeCall((ReceiverValue)receiver, expression2);
        Name name = (Name)OperatorConventions.UNARY_OPERATION_NAMES.get(operationType);
        if (name == null) {
            context2.trace.report(Errors.UNSUPPORTED.on(operationSign, "visitUnaryExpression"));
            return typeInfo.clearType();
        }
        if ((operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS) && baseExpression instanceof KtArrayAccessExpression) {
            KtExpression stubExpression = ExpressionTypingUtils.createFakeExpressionOfType(baseExpression.getProject(), context2.trace, "e", type2);
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context2.trace, "trace to resolve array access set method for unary expression", expression2);
            ExpressionTypingContext newContext = (ExpressionTypingContext)context2.replaceBindingTrace(temporaryBindingTrace);
            this.resolveImplicitArrayAccessSetMethod((KtArrayAccessExpression)baseExpression, stubExpression, newContext, context2.trace);
        }
        if (!(resolutionResults = this.components.callResolver.resolveCallWithGivenName(context2, call2, expression2.getOperationReference(), name)).isSuccess()) {
            return typeInfo.clearType();
        }
        KotlinType returnType2 = resolutionResults.getResultingDescriptor().getReturnType();
        if (operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS) {
            assert (returnType2 != null) : "returnType is null for " + resolutionResults.getResultingDescriptor();
            if (KotlinBuiltIns.isUnit(returnType2)) {
                result2 = ErrorUtils.createErrorType(this.components.builtIns.getUnit().getName().asString());
                context2.trace.report(Errors.INC_DEC_SHOULD_NOT_RETURN_UNIT.on(operationSign));
            } else {
                KotlinType receiverType = receiver.getType();
                if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(returnType2, receiverType)) {
                    context2.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, name.asString(), receiverType, returnType2));
                } else {
                    context2.trace.record(BindingContext.VARIABLE_REASSIGNMENT, expression2);
                    KtExpression stubExpression = ExpressionTypingUtils.createFakeExpressionOfType(baseExpression.getProject(), context2.trace, "e", type2);
                    this.checkLValue(context2.trace, context2, baseExpression, stubExpression, expression2, false);
                }
                DataFlowValue receiverValue = this.components.dataFlowValueFactory.createDataFlowValue((ReceiverValue)call2.getExplicitReceiver(), contextWithExpectedType);
                if (expression2 instanceof KtPrefixExpression) {
                    result2 = returnType2;
                } else {
                    result2 = receiverType;
                    DataFlowValue returnValue = this.components.dataFlowValueFactory.createDataFlowValue(expression2, receiverType, contextWithExpectedType);
                    typeInfo = typeInfo.replaceDataFlowInfo(typeInfo.getDataFlowInfo().assign(returnValue, receiverValue, this.components.languageVersionSettings));
                }
            }
        } else {
            result2 = returnType2;
        }
        CompileTimeConstant<?> value2 = this.components.constantExpressionEvaluator.evaluateExpression(expression2, contextWithExpectedType.trace, contextWithExpectedType.expectedType);
        if (value2 != null) {
            return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value2, expression2, contextWithExpectedType);
        }
        return this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(result2), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType.replaceDataFlowInfo(typeInfo.getDataFlowInfo()));
    }

    private KotlinTypeInfo visitExclExclExpression(@NotNull KtUnaryExpression expression2, @NotNull ExpressionTypingContext context2) {
        KotlinType resultingType;
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(38);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(39);
        }
        KtExpression baseExpression = expression2.getBaseExpression();
        assert (baseExpression != null);
        KtSimpleNameExpression operationSign = expression2.getOperationReference();
        assert (operationSign.getReferencedNameElementType() == KtTokens.EXCLEXCL);
        Call call2 = ControlStructureTypingUtils.createCallForSpecialConstruction(expression2, expression2.getOperationReference(), Collections.singletonList(baseExpression));
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(call2, ControlStructureTypingUtils.ResolveConstruct.EXCL_EXCL, Collections.singletonList("baseExpr"), Collections.singletonList(true), context2, null);
        KotlinTypeInfo baseTypeInfo = BindingContextUtils.getRecordedTypeInfo(baseExpression, context2.trace.getBindingContext());
        boolean isFunctionLiteral = ArgumentTypeResolver.isFunctionLiteralArgument(baseExpression, context2);
        boolean isCallableReference = ArgumentTypeResolver.isCallableReferenceArgument(baseExpression, context2);
        if (isFunctionLiteral || isCallableReference) {
            DiagnosticFactory0<PsiElement> diagnosticFactory = isFunctionLiteral ? Errors.NOT_NULL_ASSERTION_ON_LAMBDA_EXPRESSION : Errors.NOT_NULL_ASSERTION_ON_CALLABLE_REFERENCE;
            context2.trace.report(diagnosticFactory.on(operationSign));
            if (baseTypeInfo == null) {
                return TypeInfoFactoryKt.createTypeInfo((KotlinType)ErrorUtils.createErrorType("Unresolved lambda expression"), context2);
            }
            return baseTypeInfo;
        }
        assert (baseTypeInfo != null) : "Base expression was not processed: " + expression2;
        KotlinType baseType = baseTypeInfo.getType();
        if (baseType == null) {
            return baseTypeInfo;
        }
        DataFlowInfo dataFlowInfo = baseTypeInfo.getDataFlowInfo();
        if (this.isKnownToBeNotNull(baseExpression, baseType, context2)) {
            context2.trace.report(Errors.UNNECESSARY_NOT_NULL_ASSERTION.on(operationSign, TypeUtils.makeNotNullable(baseType)));
        } else {
            DataFlowValue value2 = this.components.dataFlowValueFactory.createDataFlowValue(baseExpression, baseType, context2);
            baseTypeInfo = baseTypeInfo.replaceDataFlowInfo(dataFlowInfo.disequate(value2, DataFlowValue.nullValue(this.components.builtIns), this.components.languageVersionSettings));
        }
        KotlinType kotlinType = resultingType = this.components.languageVersionSettings.supportsFeature(LanguageFeature.NewInference) ? resolvedCall2.getResultingDescriptor().getReturnType() : TypeUtils.makeNotNullable(baseType);
        if (context2.contextDependency == ContextDependency.DEPENDENT) {
            return baseTypeInfo.replaceType(resultingType);
        }
        return this.components.dataFlowAnalyzer.checkType(baseTypeInfo.replaceType(resultingType), (KtExpression)expression2, (ResolutionContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
    }

    @Override
    public KotlinTypeInfo visitLabeledExpression(@NotNull KtLabeledExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(40);
        }
        return this.visitLabeledExpression(expression2, context2, false);
    }

    @NotNull
    public KotlinTypeInfo visitLabeledExpression(@NotNull KtLabeledExpression expression2, @NotNull ExpressionTypingContext context2, boolean isStatement) {
        KtExpression baseExpression;
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(41);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(42);
        }
        KtSimpleNameExpression labelExpression = expression2.getTargetLabel();
        ReservedCheckingKt.checkReservedYield(labelExpression, context2.trace);
        if (labelExpression != null) {
            PsiElement labelIdentifier = labelExpression.getIdentifier();
            UnderscoreChecker.INSTANCE.checkIdentifier(labelIdentifier, context2.trace, this.components.languageVersionSettings);
        }
        if ((baseExpression = expression2.getBaseExpression()) == null) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(43);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = this.facade.getTypeInfo(baseExpression, context2, isStatement);
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(44);
        }
        return kotlinTypeInfo;
    }

    private boolean isKnownToBeNotNull(@NotNull KtExpression expression2, @Nullable KotlinType ktType, @NotNull ExpressionTypingContext context2) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(45);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(46);
        }
        if (ktType == null) {
            return false;
        }
        if (KotlinTypeKt.isError(ktType) && !ErrorUtils.isUninferredParameter(ktType)) {
            return false;
        }
        if (!TypeUtils.isNullableType(ktType)) {
            return true;
        }
        DataFlowValue dataFlowValue2 = this.components.dataFlowValueFactory.createDataFlowValue(expression2, ktType, context2);
        return context2.dataFlowInfo.getStableNullability(dataFlowValue2) == Nullability.NOT_NULL;
    }

    public boolean checkLValue(@NotNull BindingTrace trace, @NotNull ExpressionTypingContext context2, @NotNull KtExpression expressionWithParenthesis, @Nullable KtExpression rightHandSide, @NotNull KtOperationExpression operationExpression, boolean arraySetMethodAlreadyResolved) {
        KtExpression selector;
        KtExpression reportOn;
        KtExpression expression2;
        if (trace == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(47);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(48);
        }
        if (expressionWithParenthesis == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(49);
        }
        if (operationExpression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(50);
        }
        if ((expression2 = KtPsiUtil.deparenthesize(expressionWithParenthesis)) instanceof KtArrayAccessExpression) {
            ResolvedCall<FunctionDescriptor> resolvedCall2;
            boolean methodSetIsResolved;
            BindingTrace traceWithIndexedLValue;
            KtArrayAccessExpression arrayAccessExpression = (KtArrayAccessExpression)expression2;
            KtExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            if (arrayExpression == null || rightHandSide == null) {
                return false;
            }
            if (!arraySetMethodAlreadyResolved) {
                TemporaryBindingTrace ignoreReportsTrace = TemporaryBindingTrace.create(trace, "Trace for checking set function");
                ExpressionTypingContext findSetterContext = (ExpressionTypingContext)context2.replaceBindingTrace(ignoreReportsTrace);
                KotlinTypeInfo info = this.resolveArrayAccessSetMethod(arrayAccessExpression, rightHandSide, findSetterContext, ignoreReportsTrace);
                traceWithIndexedLValue = ignoreReportsTrace;
                methodSetIsResolved = info.getType() != null;
            } else {
                traceWithIndexedLValue = trace;
                methodSetIsResolved = true;
            }
            IElementType operationType = operationExpression.getOperationReference().getReferencedNameElementType();
            if ((KtTokens.AUGMENTED_ASSIGNMENTS.contains(operationType) || operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS) && (resolvedCall2 = traceWithIndexedLValue.get(BindingContext.INDEXED_LVALUE_SET, expression2)) != null && trace.wantsDiagnostics()) {
                CallCheckerContext callCheckerContext = new CallCheckerContext(context2, this.components.deprecationResolver, this.components.moduleDescriptor, this.components.missingSupertypesResolver, trace);
                for (CallChecker checker : this.components.callCheckers) {
                    checker.check(resolvedCall2, expression2, callCheckerContext);
                }
                if (trace.get(BindingContext.INDEXED_LVALUE_SET, expression2) == null) {
                    trace.record(BindingContext.INDEXED_LVALUE_SET, expression2, resolvedCall2);
                }
            }
            return methodSetIsResolved;
        }
        VariableDescriptor variable2 = BindingContextUtils.extractVariableDescriptorFromReference(trace.getBindingContext(), expression2);
        boolean result2 = true;
        KtExpression ktExpression = reportOn = expression2 != null ? expression2 : expressionWithParenthesis;
        if (reportOn instanceof KtQualifiedExpression && (selector = ((KtQualifiedExpression)reportOn).getSelectorExpression()) != null) {
            reportOn = selector;
        }
        if (variable2 instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variable2;
            PropertySetterDescriptor setter2 = propertyDescriptor.getSetter();
            if (propertyDescriptor.isSetterProjectedOut()) {
                trace.report(Errors.SETTER_PROJECTED_OUT.on(reportOn, propertyDescriptor));
                result2 = false;
            } else if (setter2 != null) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getResolvedCall(expressionWithParenthesis, context2.trace.getBindingContext());
                assert (resolvedCall3 != null) : "Call is not resolved for property setter: " + PsiUtilsKt.getElementTextWithContext(expressionWithParenthesis);
                this.checkPropertySetterCall((ExpressionTypingContext)context2.replaceBindingTrace(trace), setter2, resolvedCall3, reportOn);
            }
        }
        if (variable2 == null) {
            trace.report(Errors.VARIABLE_EXPECTED.on(reportOn));
            result2 = false;
        } else if (!variable2.isVar()) {
            result2 = false;
        }
        return result2;
    }

    private void checkPropertySetterCall(@NotNull ExpressionTypingContext context2, @NotNull PropertySetterDescriptor descriptor2, @NotNull ResolvedCall<?> propertyResolvedCall, @NotNull KtExpression expression2) {
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(51);
        }
        if (descriptor2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(52);
        }
        if (propertyResolvedCall == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(53);
        }
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(54);
        }
        Call call2 = propertyResolvedCall.getCall();
        ResolutionCandidate<PropertySetterDescriptor> resolutionCandidate = ResolutionCandidate.create(call2, descriptor2, propertyResolvedCall.getDispatchReceiver(), propertyResolvedCall.getExplicitReceiverKind(), null);
        ResolvedCallImpl<PropertySetterDescriptor> resolvedCall2 = ResolvedCallImpl.create(resolutionCandidate, TemporaryBindingTrace.create(context2.trace, "Trace for fake property setter resolved call"), TracingStrategy.EMPTY, new DataFlowInfoForArgumentsImpl(propertyResolvedCall.getDataFlowInfoForArguments().getResultInfo(), call2));
        resolvedCall2.markCallAsCompleted();
        if (context2.trace.wantsDiagnostics()) {
            CallCheckerContext callCheckerContext = this.createCallCheckerContext(context2);
            for (CallChecker checker : this.components.callCheckers) {
                checker.check(resolvedCall2, expression2, callCheckerContext);
            }
        }
    }

    @NotNull
    private CallCheckerContext createCallCheckerContext(@NotNull ExpressionTypingContext context2) {
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(55);
        }
        return new CallCheckerContext(context2, this.components.deprecationResolver, this.components.moduleDescriptor, this.components.missingSupertypesResolver);
    }

    @Override
    public KotlinTypeInfo visitBinaryExpression(@NotNull KtBinaryExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        KotlinTypeInfo result2;
        Name referencedName;
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(56);
        }
        ExpressionTypingContext context2 = ExpressionTypingUtils.isBinaryExpressionDependentOnExpectedType(expression2) ? contextWithExpectedType : (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtOperationReferenceExpression operationSign = expression2.getOperationReference();
        KtExpression left = expression2.getLeft();
        KtExpression right = expression2.getRight();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == KtTokens.IDENTIFIER) {
            referencedName = operationSign.getReferencedNameAsName();
            result2 = this.getTypeInfoForBinaryCall(referencedName, context2, expression2);
        } else if (OperatorConventions.BINARY_OPERATION_NAMES.containsKey(operationType)) {
            referencedName = (Name)OperatorConventions.BINARY_OPERATION_NAMES.get(operationType);
            result2 = this.getTypeInfoForBinaryCall(referencedName, context2, expression2);
        } else {
            if (operationType == KtTokens.ELVIS) {
                return this.visitElvisExpression(expression2, context2);
            }
            if (operationType == KtTokens.EQ) {
                result2 = this.visitAssignment(expression2, context2);
            } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType)) {
                result2 = this.visitAssignmentOperation(expression2, context2);
            } else if (OperatorConventions.COMPARISON_OPERATIONS.contains(operationType)) {
                result2 = this.visitComparison(expression2, context2, operationSign);
            } else if (OperatorConventions.EQUALS_OPERATIONS.contains(operationType)) {
                result2 = this.visitEquality(expression2, context2, operationSign, left, right);
            } else if (OperatorConventions.IDENTITY_EQUALS_OPERATIONS.contains(operationType)) {
                this.ensureNonemptyIntersectionOfOperandTypes(expression2, context2);
                result2 = TypeInfoFactoryKt.createTypeInfo((KotlinType)this.components.builtIns.getBooleanType(), context2);
                BasicExpressionTypingVisitor.checkIdentityOnPrimitiveOrInlineClassTypes(expression2, context2);
            } else if (OperatorConventions.IN_OPERATIONS.contains(operationType)) {
                ValueArgument leftArgument = CallMaker.makeValueArgument(left, left != null ? left : operationSign);
                result2 = this.checkInExpression(expression2, operationSign, leftArgument, right, context2);
            } else if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey(operationType)) {
                result2 = this.visitBooleanOperationExpression(operationType, left, right, context2);
            } else {
                context2.trace.report(Errors.UNSUPPORTED.on(operationSign, "Unknown operation"));
                result2 = TypeInfoFactoryKt.noTypeInfo(context2);
            }
        }
        CompileTimeConstant<?> value2 = this.components.constantExpressionEvaluator.evaluateExpression(expression2, contextWithExpectedType.trace, contextWithExpectedType.expectedType);
        if (value2 != null) {
            return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value2, expression2, contextWithExpectedType);
        }
        return this.components.dataFlowAnalyzer.checkType(result2, (KtExpression)expression2, (ResolutionContext)contextWithExpectedType);
    }

    private static void checkIdentityOnPrimitiveOrInlineClassTypes(@NotNull KtBinaryExpression expression2, @NotNull ExpressionTypingContext context2) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(57);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(58);
        }
        if (expression2.getLeft() == null || expression2.getRight() == null) {
            return;
        }
        KotlinType leftType = context2.trace.getType(expression2.getLeft());
        KotlinType rightType = context2.trace.getType(expression2.getRight());
        if (leftType == null || rightType == null) {
            return;
        }
        if (KotlinTypeChecker.DEFAULT.equalTypes(leftType, rightType)) {
            if (KotlinBuiltIns.isPrimitiveType(leftType)) {
                context2.trace.report(Errors.DEPRECATED_IDENTITY_EQUALS.on(expression2, leftType, rightType));
            } else if (InlineClassesUtilsKt.isInlineClassType(leftType)) {
                context2.trace.report(Errors.FORBIDDEN_IDENTITY_EQUALS.on(expression2, leftType, rightType));
            }
        } else if (BasicExpressionTypingVisitor.isIdentityComparedWithImplicitBoxing(leftType, rightType) || BasicExpressionTypingVisitor.isIdentityComparedWithImplicitBoxing(rightType, leftType)) {
            context2.trace.report(Errors.IMPLICIT_BOXING_IN_IDENTITY_EQUALS.on(expression2, leftType, rightType));
        }
    }

    private static boolean isIdentityComparedWithImplicitBoxing(KotlinType leftType, KotlinType rightType) {
        return KotlinBuiltIns.isPrimitiveType(leftType) && !KotlinBuiltIns.isPrimitiveType(rightType) && KotlinTypeChecker.DEFAULT.isSubtypeOf(leftType, rightType);
    }

    private KotlinTypeInfo visitEquality(KtBinaryExpression expression2, ExpressionTypingContext context2, KtSimpleNameExpression operationSign, KtExpression left, KtExpression right) {
        if (right == null || left == null) {
            ExpressionTypingUtils.getTypeInfoOrNullType(right, context2, this.facade);
            ExpressionTypingUtils.getTypeInfoOrNullType(left, context2, this.facade);
            return TypeInfoFactoryKt.createTypeInfo((KotlinType)this.components.builtIns.getBooleanType(), context2);
        }
        KotlinTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, context2, this.facade);
        DataFlowInfo dataFlowInfo = leftTypeInfo.getDataFlowInfo();
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo);
        ExpressionReceiver receiver = this.createReceiverForEquals(left, contextWithDataFlow);
        List<FunctionDescriptor> equalsFunctions = this.findEqualsWithNullableAnyParameter(receiver, expression2);
        Call call2 = CallMaker.makeCallWithExpressions(expression2, receiver, null, operationSign, Collections.singletonList(right), Call.CallType.DEFAULT, true);
        OverloadResolutionResults<FunctionDescriptor> resolutionResults = this.components.callResolver.resolveEqualsCallWithGivenDescriptors(contextWithDataFlow, operationSign, receiver, call2, equalsFunctions);
        if (resolutionResults.isSuccess()) {
            FunctionDescriptor equals = resolutionResults.getResultingCall().getResultingDescriptor();
            if (this.ensureBooleanResult(operationSign, OperatorNameConventions.EQUALS, equals.getReturnType(), contextWithDataFlow)) {
                this.ensureNonemptyIntersectionOfOperandTypes(expression2, contextWithDataFlow);
            }
        } else if (resolutionResults.isAmbiguity()) {
            context2.trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on(operationSign, resolutionResults.getResultingCalls()));
        } else {
            context2.trace.report(Errors.EQUALS_MISSING.on(operationSign));
        }
        KotlinTypeInfo rightTypeInfo = this.facade.getTypeInfo(right, contextWithDataFlow);
        return rightTypeInfo.replaceType(this.components.builtIns.getBooleanType());
    }

    private ExpressionReceiver createReceiverForEquals(KtExpression left, ExpressionTypingContext context2) {
        KotlinType leftType = ExpressionTypingUtils.safeGetType(this.facade.safeGetTypeInfo(left, context2));
        KotlinType receiverType = KotlinBuiltIns.isNothingOrNullableNothing(leftType) ? this.components.builtIns.getNullableAnyType() : leftType;
        return ExpressionReceiver.Companion.create(left, receiverType, context2.trace.getBindingContext());
    }

    private List<FunctionDescriptor> findEqualsWithNullableAnyParameter(@NotNull ExpressionReceiver receiver, @NotNull KtBinaryExpression expression2) {
        if (receiver == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(59);
        }
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(60);
        }
        KotlinType refinedType = KotlinBuiltIns.isNothingOrNullableNothing(receiver.getType()) ? this.components.builtIns.getNullableAnyType() : receiver.getType();
        Collection<? extends SimpleFunctionDescriptor> equalsMembers = refinedType.getMemberScope().getContributedFunctions(OperatorNameConventions.EQUALS, new KotlinLookupLocation(expression2.getOperationReference()));
        return CollectionsKt.filter(equalsMembers, descriptor2 -> {
            if (ErrorUtils.isError(descriptor2)) {
                return true;
            }
            if (descriptor2.getValueParameters().size() != 1) {
                return false;
            }
            ValueParameterDescriptor valueParameter = descriptor2.getValueParameters().get(0);
            return KotlinBuiltIns.isNullableAny(valueParameter.getType());
        });
    }

    @NotNull
    private KotlinTypeInfo visitComparison(@NotNull KtBinaryExpression expression2, @NotNull ExpressionTypingContext context2, @NotNull KtSimpleNameExpression operationSign) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(61);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(62);
        }
        if (operationSign == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(63);
        }
        KotlinTypeInfo typeInfo = this.getTypeInfoForBinaryCall(OperatorNameConventions.COMPARE_TO, context2, expression2);
        KotlinType compareToReturnType = typeInfo.getType();
        SimpleType type2 = null;
        if (compareToReturnType != null && !KotlinTypeKt.isError(compareToReturnType)) {
            if (KotlinTypeChecker.DEFAULT.equalTypes(this.components.builtIns.getIntType(), compareToReturnType)) {
                type2 = this.components.builtIns.getBooleanType();
            } else {
                context2.trace.report(Errors.COMPARE_TO_TYPE_MISMATCH.on(operationSign, compareToReturnType));
            }
        }
        KotlinTypeInfo kotlinTypeInfo = typeInfo.replaceType(type2);
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(64);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinTypeInfo visitBooleanOperationExpression(@Nullable IElementType operationType, @Nullable KtExpression left, @Nullable KtExpression right, @NotNull ExpressionTypingContext context2) {
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(65);
        }
        SimpleType booleanType = this.components.builtIns.getBooleanType();
        KotlinTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, (ExpressionTypingContext)context2.replaceExpectedType(booleanType), this.facade);
        DataFlowInfo dataFlowInfo = leftTypeInfo.getDataFlowInfo();
        LexicalWritableScope leftScope = ExpressionTypingUtils.newWritableScopeImpl(context2, LexicalScopeKind.LEFT_BOOLEAN_EXPRESSION, this.facade.getComponents().overloadChecker);
        boolean isAnd = operationType == KtTokens.ANDAND;
        DataFlowInfo flowInfoLeft = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(left, isAnd, context2).and(dataFlowInfo);
        LexicalWritableScope rightScope = isAnd ? leftScope : ExpressionTypingUtils.newWritableScopeImpl(context2, LexicalScopeKind.RIGHT_BOOLEAN_EXPRESSION, this.facade.getComponents().overloadChecker);
        ExpressionTypingContext contextForRightExpr = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceDataFlowInfo(flowInfoLeft)).replaceScope(rightScope)).replaceExpectedType(booleanType);
        if (right != null) {
            this.facade.getTypeInfo(right, contextForRightExpr);
        }
        KotlinTypeInfo kotlinTypeInfo = leftTypeInfo.replaceType(booleanType);
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(66);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinTypeInfo visitElvisExpression(@NotNull KtBinaryExpression expression2, @NotNull ExpressionTypingContext contextWithExpectedType) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(67);
        }
        if (contextWithExpectedType == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(68);
        }
        ExpressionTypingContext context2 = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtExpression left = expression2.getLeft();
        KtExpression right = expression2.getRight();
        if (left == null || right == null) {
            ExpressionTypingUtils.getTypeInfoOrNullType(left, context2, this.facade);
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(69);
            }
            return kotlinTypeInfo;
        }
        Call call2 = ControlStructureTypingUtils.createCallForSpecialConstruction(expression2, expression2.getOperationReference(), Lists.newArrayList(left, right));
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(call2, ControlStructureTypingUtils.ResolveConstruct.ELVIS, Lists.newArrayList("left", "right"), Lists.newArrayList(true, false), contextWithExpectedType, null);
        KotlinTypeInfo leftTypeInfo = BindingContextUtils.getRecordedTypeInfo(left, context2.trace.getBindingContext());
        boolean isLeftFunctionLiteral = ArgumentTypeResolver.isFunctionLiteralArgument(left, context2);
        boolean isLeftCallableReference = ArgumentTypeResolver.isCallableReferenceArgument(left, context2);
        if (leftTypeInfo == null && (isLeftFunctionLiteral || isLeftCallableReference)) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(70);
            }
            return kotlinTypeInfo;
        }
        assert (leftTypeInfo != null) : "Left expression was not processed: " + expression2;
        KotlinType leftType = leftTypeInfo.getType();
        KotlinTypeInfo rightTypeInfo = BindingContextUtils.getRecordedTypeInfo(right, context2.trace.getBindingContext());
        if (rightTypeInfo == null && ArgumentTypeResolver.isFunctionLiteralOrCallableReference(right, context2)) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(71);
            }
            return kotlinTypeInfo;
        }
        assert (rightTypeInfo != null) : "Right expression was not processed: " + expression2;
        boolean loopBreakContinuePossible = leftTypeInfo.getJumpOutPossible() || rightTypeInfo.getJumpOutPossible();
        KotlinType rightType = rightTypeInfo.getType();
        DataFlowInfo dataFlowInfo = resolvedCall2.getDataFlowInfoForArguments().getInfo(call2.getValueArguments().get(1));
        KotlinType type2 = resolvedCall2.getResultingDescriptor().getReturnType();
        if (type2 == null || rightType == null || leftType == null && KotlinBuiltIns.isNothing(rightType)) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(dataFlowInfo);
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(72);
            }
            return kotlinTypeInfo;
        }
        if (leftType != null) {
            DataFlowValue leftValue = this.components.dataFlowValueFactory.createDataFlowValue(left, leftType, context2);
            DataFlowInfo rightDataFlowInfo = resolvedCall2.getDataFlowInfoForArguments().getResultInfo();
            boolean jumpInRight = KotlinBuiltIns.isNothing(rightType);
            DataFlowValue nullValue = DataFlowValue.nullValue(this.components.builtIns);
            if (jumpInRight || !rightDataFlowInfo.getStableNullability(leftValue).canBeNull()) {
                dataFlowInfo = dataFlowInfo.disequate(leftValue, nullValue, this.components.languageVersionSettings);
                if (left instanceof KtBinaryExpressionWithTypeRHS) {
                    dataFlowInfo = this.establishSubtypingForTypeRHS((KtBinaryExpressionWithTypeRHS)left, dataFlowInfo, context2, this.components.languageVersionSettings);
                }
            }
            DataFlowValue resultValue = this.components.dataFlowValueFactory.createDataFlowValue(expression2, type2, context2);
            dataFlowInfo = dataFlowInfo.assign(resultValue, leftValue, this.components.languageVersionSettings).disequate(resultValue, nullValue, this.components.languageVersionSettings);
            if (!jumpInRight) {
                DataFlowValue rightValue = this.components.dataFlowValueFactory.createDataFlowValue(right, rightType, context2);
                rightDataFlowInfo = rightDataFlowInfo.assign(resultValue, rightValue, this.components.languageVersionSettings);
                dataFlowInfo = dataFlowInfo.or(rightDataFlowInfo);
            }
        }
        if (!TypeUtils.isNullableType(rightType) && TypeUtils.isNullableType(type2)) {
            type2 = TypeUtils.makeNotNullable(type2);
        }
        if (context2.contextDependency == ContextDependency.DEPENDENT) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(type2, dataFlowInfo);
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(73);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkType(type2, (KtExpression)expression2, (ResolutionContext)contextWithExpectedType), dataFlowInfo, loopBreakContinuePossible, context2.dataFlowInfo);
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(74);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private DataFlowInfo establishSubtypingForTypeRHS(@NotNull KtBinaryExpressionWithTypeRHS left, @NotNull DataFlowInfo dataFlowInfo, @NotNull ExpressionTypingContext context2, @NotNull LanguageVersionSettings languageVersionSettings) {
        KtExpression underSafeAs;
        KotlinType underSafeAsType;
        IElementType operationType;
        if (left == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(75);
        }
        if (dataFlowInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(76);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(77);
        }
        if (languageVersionSettings == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(78);
        }
        if ((operationType = left.getOperationReference().getReferencedNameElementType()) == KtTokens.AS_SAFE && (underSafeAsType = context2.trace.getType(underSafeAs = left.getLeft())) != null) {
            DataFlowValue underSafeAsValue = this.components.dataFlowValueFactory.createDataFlowValue(underSafeAs, underSafeAsType, context2);
            KotlinType targetType = context2.trace.get(BindingContext.TYPE, left.getRight());
            if (targetType != null) {
                DataFlowInfo dataFlowInfo2 = dataFlowInfo.establishSubtyping(underSafeAsValue, targetType, languageVersionSettings);
                if (dataFlowInfo2 == null) {
                    BasicExpressionTypingVisitor.$$$reportNull$$$0(79);
                }
                return dataFlowInfo2;
            }
        }
        DataFlowInfo dataFlowInfo3 = dataFlowInfo;
        if (dataFlowInfo3 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(80);
        }
        return dataFlowInfo3;
    }

    @NotNull
    public KotlinTypeInfo checkInExpression(@NotNull KtElement callElement, @NotNull KtSimpleNameExpression operationSign, @NotNull ValueArgument leftArgument, @Nullable KtExpression right, @NotNull ExpressionTypingContext context2) {
        if (callElement == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(81);
        }
        if (operationSign == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(82);
        }
        if (leftArgument == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(83);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(84);
        }
        KtExpression left = leftArgument.getArgumentExpression();
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        if (right == null) {
            if (left != null) {
                this.facade.getTypeInfo(left, contextWithNoExpectedType);
            }
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(85);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo rightTypeInfo = this.facade.getTypeInfo(right, contextWithNoExpectedType);
        DataFlowInfo dataFlowInfo = rightTypeInfo.getDataFlowInfo();
        ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, right, contextWithNoExpectedType);
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo);
        Call containsCall = CallMaker.makeCall(callElement, receiver, null, operationSign, Collections.singletonList(leftArgument), Call.CallType.CONTAINS);
        OverloadResolutionResults<FunctionDescriptor> resolutionResult = this.components.callResolver.resolveCallWithGivenName(contextWithDataFlow, containsCall, operationSign, OperatorNameConventions.CONTAINS);
        KotlinType containsType = OverloadResolutionResultsUtil.getResultingType(resolutionResult, context2);
        this.ensureBooleanResult(operationSign, OperatorNameConventions.CONTAINS, containsType, context2);
        if (left != null) {
            dataFlowInfo = this.facade.getTypeInfo(left, contextWithDataFlow).getDataFlowInfo().and(dataFlowInfo);
            rightTypeInfo = rightTypeInfo.replaceDataFlowInfo(dataFlowInfo);
        }
        if (resolutionResult.isSuccess()) {
            KotlinTypeInfo kotlinTypeInfo = rightTypeInfo.replaceType(this.components.builtIns.getBooleanType());
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(86);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = rightTypeInfo.clearType();
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(87);
        }
        return kotlinTypeInfo;
    }

    private boolean ensureBooleanResult(KtExpression operationSign, Name name, KotlinType resultType, ExpressionTypingContext context2) {
        return this.ensureBooleanResultWithCustomSubject(operationSign, resultType, "'" + name + "'", context2);
    }

    private boolean ensureBooleanResultWithCustomSubject(KtExpression operationSign, KotlinType resultType, String subjectName, ExpressionTypingContext context2) {
        if (resultType != null && !this.components.builtIns.isBooleanOrSubtype(resultType)) {
            context2.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, subjectName, this.components.builtIns.getBooleanType(), resultType));
            return false;
        }
        return true;
    }

    private void ensureNonemptyIntersectionOfOperandTypes(KtBinaryExpression expression2, ExpressionTypingContext context2) {
        KotlinType rightType;
        KtExpression left = expression2.getLeft();
        if (left == null) {
            return;
        }
        KtExpression right = expression2.getRight();
        KotlinType leftType = this.facade.getTypeInfo(left, context2).getType();
        if (leftType != null && right != null && (rightType = this.facade.getTypeInfo(right, context2).getType()) != null) {
            if (TypeIntersector.isIntersectionEmpty(leftType, rightType)) {
                context2.trace.report(Errors.EQUALITY_NOT_APPLICABLE.on(expression2, expression2.getOperationReference(), leftType, rightType));
            } else {
                EnumCompatibilityCheckerKt.checkEnumsForCompatibility(context2, expression2, leftType, rightType);
            }
            SenselessComparisonChecker.checkSenselessComparisonWithNull(expression2, left, right, context2, (Function1<? super KtExpression, ? extends KotlinType>)((Function1)expr -> this.facade.getTypeInfo((KtExpression)expr, context2).getType()), (Function1<? super DataFlowValue, ? extends Nullability>)((Function1)context2.dataFlowInfo::getStableNullability));
        }
    }

    @NotNull
    private KotlinTypeInfo visitAssignmentOperation(KtBinaryExpression expression2, ExpressionTypingContext context2) {
        return this.assignmentIsNotAnExpressionError(expression2, context2);
    }

    @NotNull
    private KotlinTypeInfo visitAssignment(KtBinaryExpression expression2, ExpressionTypingContext context2) {
        return this.assignmentIsNotAnExpressionError(expression2, context2);
    }

    @NotNull
    private KotlinTypeInfo assignmentIsNotAnExpressionError(KtBinaryExpression expression2, ExpressionTypingContext context2) {
        this.facade.checkStatementType(expression2, context2);
        if (!context2.isDebuggerContext) {
            context2.trace.report(Errors.ASSIGNMENT_IN_EXPRESSION_CONTEXT.on(expression2));
        }
        KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(88);
        }
        return kotlinTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(89);
        }
        return this.components.dataFlowAnalyzer.checkType(this.resolveArrayAccessGetMethod(expression2, context2), (KtExpression)expression2, (ResolutionContext)context2);
    }

    @Override
    public KotlinTypeInfo visitCollectionLiteralExpression(@NotNull KtCollectionLiteralExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(90);
        }
        return this.components.collectionLiteralResolver.resolveCollectionLiteral(expression2, context2);
    }

    @Override
    public KotlinTypeInfo visitClass(@NotNull KtClass klass, ExpressionTypingContext context2) {
        if (klass == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(91);
        }
        this.components.localClassifierAnalyzer.processClassOrObject(null, (ExpressionTypingContext)context2.replaceContextDependency(ContextDependency.INDEPENDENT), context2.scope.getOwnerDescriptor(), klass);
        return BasicExpressionTypingVisitor.declarationInIllegalContext(klass, context2);
    }

    @NotNull
    private static KotlinTypeInfo declarationInIllegalContext(@NotNull KtDeclaration declaration2, @NotNull ExpressionTypingContext context2) {
        if (declaration2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(92);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(93);
        }
        context2.trace.report(Errors.DECLARATION_IN_ILLEGAL_CONTEXT.on(declaration2));
        KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(94);
        }
        return kotlinTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitProperty(@NotNull KtProperty property2, ExpressionTypingContext context2) {
        if (property2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(95);
        }
        this.components.localVariableResolver.process(property2, context2, context2.scope, this.facade);
        return BasicExpressionTypingVisitor.declarationInIllegalContext(property2, context2);
    }

    @NotNull
    private KotlinTypeInfo getTypeInfoForBinaryCall(@NotNull Name name, @NotNull ExpressionTypingContext context2, @NotNull KtBinaryExpression binaryExpression) {
        OverloadResolutionResults<Object> resolutionResults;
        KtExpression left;
        if (name == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(96);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(97);
        }
        if (binaryExpression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(98);
        }
        KotlinTypeInfo typeInfo = (left = binaryExpression.getLeft()) != null ? this.facade.getTypeInfo(left, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)) : TypeInfoFactoryKt.noTypeInfo(context2);
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context2.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        if (left != null) {
            ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, context2);
            resolutionResults = this.components.callResolver.resolveBinaryCall(contextWithDataFlow, receiver, binaryExpression, name);
        } else {
            resolutionResults = OverloadResolutionResultsImpl.nameNotFound();
        }
        if (resolutionResults.isSingleResult()) {
            typeInfo = typeInfo.replaceDataFlowInfo(resolutionResults.getResultingCall().getDataFlowInfoForArguments().getResultInfo());
        }
        KotlinTypeInfo kotlinTypeInfo = typeInfo.replaceType(OverloadResolutionResultsUtil.getResultingType(resolutionResults, context2));
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(99);
        }
        return kotlinTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitDeclaration(@NotNull KtDeclaration dcl, ExpressionTypingContext context2) {
        if (dcl == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(100);
        }
        return BasicExpressionTypingVisitor.declarationInIllegalContext(dcl, context2);
    }

    @Override
    public KotlinTypeInfo visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(101);
        }
        final ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        BasicExpressionTypingVisitor.checkLiteralPrefixAndSuffix(expression2, context2);
        class StringTemplateVisitor
        extends KtVisitorVoid {
            private KotlinTypeInfo typeInfo;

            StringTemplateVisitor() {
                this.typeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
            }

            @Override
            public void visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry) {
                KtExpression entryExpression;
                if (entry == null) {
                    StringTemplateVisitor.$$$reportNull$$$0(0);
                }
                if ((entryExpression = entry.getExpression()) != null) {
                    this.typeInfo = BasicExpressionTypingVisitor.this.facade.getTypeInfo(entryExpression, (ExpressionTypingContext)context2.replaceDataFlowInfo(this.typeInfo.getDataFlowInfo()));
                }
            }

            @Override
            public void visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry) {
                CompileTimeConstantChecker.CharacterWithDiagnostic value2;
                Diagnostic diagnostic;
                if (entry == null) {
                    StringTemplateVisitor.$$$reportNull$$$0(1);
                }
                if ((diagnostic = (value2 = CompileTimeConstantChecker.escapedStringToCharacter(entry.getText(), entry)).getDiagnostic()) != null) {
                    context2.trace.report(diagnostic);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "entry";
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor$1StringTemplateVisitor";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitStringTemplateEntryWithExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitEscapeStringTemplateEntry";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        StringTemplateVisitor visitor2 = new StringTemplateVisitor();
        for (KtStringTemplateEntry entry : expression2.getEntries()) {
            entry.accept(visitor2);
        }
        this.components.constantExpressionEvaluator.evaluateExpression(expression2, context2.trace, contextWithExpectedType.expectedType);
        return this.components.dataFlowAnalyzer.checkType(visitor2.typeInfo.replaceType(this.components.builtIns.getStringType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType);
    }

    private static void checkLiteralPrefixAndSuffix(@NotNull PsiElement expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(102);
        }
        if (expression2 instanceof StubBasedPsiElement && ((StubBasedPsiElement)expression2).getStub() != null) {
            return;
        }
        BasicExpressionTypingVisitor.checkLiteralPrefixOrSuffix(PsiTreeUtil.prevLeaf(expression2), context2);
        BasicExpressionTypingVisitor.checkLiteralPrefixOrSuffix(PsiTreeUtil.nextLeaf(expression2), context2);
    }

    private static void checkLiteralPrefixOrSuffix(PsiElement prefixOrSuffix, ExpressionTypingContext context2) {
        if (BasicExpressionTypingVisitor.illegalLiteralPrefixOrSuffix(prefixOrSuffix)) {
            context2.trace.report(Errors.UNSUPPORTED.on(prefixOrSuffix, "literal prefixes and suffixes"));
        }
    }

    private static boolean illegalLiteralPrefixOrSuffix(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        IElementType elementType = element.getNode().getElementType();
        return elementType == KtTokens.IDENTIFIER || elementType == KtTokens.INTEGER_LITERAL || elementType == KtTokens.FLOAT_LITERAL || elementType instanceof KtKeywordToken;
    }

    @Override
    public KotlinTypeInfo visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2, ExpressionTypingContext context2) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(103);
        }
        return this.visitAnnotatedExpression(expression2, context2, false);
    }

    public KotlinTypeInfo visitAnnotatedExpression(KtAnnotatedExpression expression2, ExpressionTypingContext context2, boolean isStatement) {
        this.resolveAnnotationsOnExpression(expression2, context2);
        KtExpression baseExpression = expression2.getBaseExpression();
        if (baseExpression == null) {
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        if (this.components.typeResolutionInterceptor.isEmpty()) {
            return this.facade.getTypeInfo(baseExpression, context2, isStatement);
        }
        KotlinType newExpectedType = this.components.typeResolutionInterceptor.interceptType(baseExpression, context2, context2.expectedType);
        KotlinTypeInfo resultTypeInfo = this.facade.getTypeInfo(baseExpression, newExpectedType == context2.expectedType ? context2 : (ExpressionTypingContext)context2.replaceExpectedType(newExpectedType), isStatement);
        KotlinType newResultType = this.components.typeResolutionInterceptor.interceptType(baseExpression, context2, resultTypeInfo.getType());
        this.components.dataFlowAnalyzer.checkType(newResultType, (KtExpression)expression2, (ResolutionContext)context2);
        return resultTypeInfo.getType() == newResultType ? resultTypeInfo : resultTypeInfo.replaceType(newResultType);
    }

    protected void resolveAnnotationsOnExpression(KtAnnotatedExpression expression2, ExpressionTypingContext context2) {
        if (BasicExpressionTypingVisitor.isAnnotatedExpressionInBlockLevelBinary(expression2)) {
            context2.trace.report(Errors.ANNOTATIONS_ON_BLOCK_LEVEL_EXPRESSION_ON_THE_SAME_LINE.on(expression2));
        }
        if (!(expression2.getBaseExpression() instanceof KtObjectLiteralExpression)) {
            this.components.annotationResolver.resolveAnnotationsWithArguments(context2.scope, expression2.getAnnotationEntries(), context2.trace);
        }
    }

    private static boolean isAnnotatedExpressionInBlockLevelBinary(KtAnnotatedExpression annotatedExpression) {
        PsiElement current = annotatedExpression;
        PsiElement parent2 = current.getParent();
        if (!(parent2 instanceof KtBinaryExpression)) {
            return false;
        }
        while (parent2 instanceof KtBinaryExpression) {
            if (((KtBinaryExpression)parent2).getLeft() != current) {
                return false;
            }
            current = parent2;
            parent2 = parent2.getParent();
        }
        return KtPsiUtil.isStatementContainer(parent2);
    }

    @Override
    public KotlinTypeInfo visitKtElement(@NotNull KtElement element, ExpressionTypingContext context2) {
        if (element == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(104);
        }
        context2.trace.report(Errors.UNSUPPORTED.on(element, this.getClass().getCanonicalName()));
        return TypeInfoFactoryKt.noTypeInfo(context2);
    }

    @NotNull
    KotlinTypeInfo resolveArrayAccessSetMethod(@NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull KtExpression rightHandSide, @NotNull ExpressionTypingContext context2, @NotNull BindingTrace traceForResolveResult) {
        if (arrayAccessExpression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(105);
        }
        if (rightHandSide == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(106);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(107);
        }
        if (traceForResolveResult == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(108);
        }
        return this.resolveArrayAccessSpecialMethod(arrayAccessExpression, rightHandSide, context2, traceForResolveResult, false, false);
    }

    @NotNull
    KotlinTypeInfo resolveImplicitArrayAccessSetMethod(@NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull KtExpression rightHandSide, @NotNull ExpressionTypingContext context2, @NotNull BindingTrace traceForResolveResult) {
        if (arrayAccessExpression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(109);
        }
        if (rightHandSide == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(110);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(111);
        }
        if (traceForResolveResult == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(112);
        }
        return this.resolveArrayAccessSpecialMethod(arrayAccessExpression, rightHandSide, context2, traceForResolveResult, false, true);
    }

    @NotNull
    KotlinTypeInfo resolveArrayAccessGetMethod(@NotNull KtArrayAccessExpression arrayAccessExpression, @NotNull ExpressionTypingContext context2) {
        if (arrayAccessExpression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(113);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(114);
        }
        return this.resolveArrayAccessSpecialMethod(arrayAccessExpression, null, context2, context2.trace, true, false);
    }

    @NotNull
    private KotlinTypeInfo resolveArrayAccessSpecialMethod(@NotNull KtArrayAccessExpression arrayAccessExpression, @Nullable KtExpression rightHandSide, @NotNull ExpressionTypingContext oldContext, @NotNull BindingTrace traceForResolveResult, boolean isGet, boolean isImplicit) {
        KtExpression arrayExpression;
        if (arrayAccessExpression == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(115);
        }
        if (oldContext == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(116);
        }
        if (traceForResolveResult == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(117);
        }
        if ((arrayExpression = arrayAccessExpression.getArrayExpression()) == null) {
            KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(oldContext);
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(118);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo arrayTypeInfo = this.facade.safeGetTypeInfo(arrayExpression, (ExpressionTypingContext)((ExpressionTypingContext)oldContext.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        KotlinType arrayType = ExpressionTypingUtils.safeGetType(arrayTypeInfo);
        ExpressionTypingContext context2 = (ExpressionTypingContext)oldContext.replaceDataFlowInfo(arrayTypeInfo.getDataFlowInfo());
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(arrayExpression, arrayType, context2.trace.getBindingContext());
        if (!isGet) assert (rightHandSide != null);
        Call call2 = isGet ? CallMaker.makeArrayGetCall(receiver, arrayAccessExpression, Call.CallType.ARRAY_GET_METHOD) : CallMaker.makeArraySetCall(receiver, arrayAccessExpression, rightHandSide, Call.CallType.ARRAY_SET_METHOD);
        OverloadResolutionResults<FunctionDescriptor> functionResults = this.components.callResolver.resolveCallWithGivenName(context2, call2, arrayAccessExpression, isGet ? OperatorNameConventions.GET : OperatorNameConventions.SET);
        List<KtExpression> indices = arrayAccessExpression.getIndexExpressions();
        KotlinTypeInfo resultTypeInfo = BasicExpressionTypingVisitor.computeAccumulatedInfoForArrayAccessExpression(arrayTypeInfo, indices, rightHandSide, isGet, context2, this.facade);
        if (isImplicit && !functionResults.isSuccess() || !functionResults.isSingleResult()) {
            traceForResolveResult.report(isGet ? Errors.NO_GET_METHOD.on(arrayAccessExpression) : Errors.NO_SET_METHOD.on(arrayAccessExpression));
            KotlinTypeInfo kotlinTypeInfo = resultTypeInfo.clearType();
            if (kotlinTypeInfo == null) {
                BasicExpressionTypingVisitor.$$$reportNull$$$0(119);
            }
            return kotlinTypeInfo;
        }
        if (isGet) {
            traceForResolveResult.record(BindingContext.INDEXED_LVALUE_GET, arrayAccessExpression, functionResults.getResultingCall());
        } else {
            traceForResolveResult.record(BindingContext.INDEXED_LVALUE_SET, arrayAccessExpression, functionResults.getResultingCall());
        }
        KotlinTypeInfo kotlinTypeInfo = resultTypeInfo.replaceType(functionResults.getResultingDescriptor().getReturnType());
        if (kotlinTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(120);
        }
        return kotlinTypeInfo;
    }

    private static KotlinTypeInfo computeAccumulatedInfoForArrayAccessExpression(@NotNull KotlinTypeInfo arrayTypeInfo, @NotNull List<KtExpression> indices, @Nullable KtExpression rightHandSide, boolean isGet, @NotNull ExpressionTypingContext context2, @NotNull ExpressionTypingInternals facade) {
        boolean forceResolve;
        if (arrayTypeInfo == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(121);
        }
        if (indices == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(122);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(123);
        }
        if (facade == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(124);
        }
        KotlinTypeInfo accumulatedTypeInfo = null;
        boolean bl = forceResolve = !context2.languageVersionSettings.supportsFeature(LanguageFeature.NewInference);
        if (!indices.isEmpty()) {
            accumulatedTypeInfo = BasicExpressionTypingVisitor.getTypeInfo(indices.get(indices.size() - 1), facade, context2, forceResolve);
        }
        if (!isGet && rightHandSide != null) {
            accumulatedTypeInfo = BasicExpressionTypingVisitor.getTypeInfo(rightHandSide, facade, context2, forceResolve);
        }
        return accumulatedTypeInfo != null ? accumulatedTypeInfo : arrayTypeInfo;
    }

    private static KotlinTypeInfo getTypeInfo(@NotNull KtExpression expression2, @NotNull ExpressionTypingInternals facade, @NotNull ExpressionTypingContext context2, boolean forceExpressionResolve) {
        if (expression2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(125);
        }
        if (facade == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(126);
        }
        if (context2 == null) {
            BasicExpressionTypingVisitor.$$$reportNull$$$0(127);
        }
        if (forceExpressionResolve) {
            return facade.getTypeInfo(expression2, context2);
        }
        return BindingContextUtils.getRecordedTypeInfo(expression2, context2.trace.getBindingContext());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 28: 
            case 29: 
            case 30: 
            case 43: 
            case 44: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 79: 
            case 80: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 94: 
            case 99: 
            case 118: 
            case 119: 
            case 120: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 28: 
            case 29: 
            case 30: 
            case 43: 
            case 44: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 79: 
            case 80: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 94: 
            case 99: 
            case 118: 
            case 119: 
            case 120: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 45: 
            case 54: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 67: 
            case 89: 
            case 90: 
            case 101: 
            case 102: 
            case 103: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 20: 
            case 39: 
            case 42: 
            case 46: 
            case 48: 
            case 51: 
            case 55: 
            case 58: 
            case 62: 
            case 65: 
            case 77: 
            case 84: 
            case 93: 
            case 97: 
            case 107: 
            case 111: 
            case 114: 
            case 123: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 28: 
            case 29: 
            case 30: 
            case 43: 
            case 44: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 79: 
            case 80: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 94: 
            case 99: 
            case 118: 
            case 119: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 24: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supertypes";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superTypeQualifier";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionWithParenthesis";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationExpression";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyResolvedCall";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 63: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationSign";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextWithExpectedType";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowInfo";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callElement";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftArgument";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dcl";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 105: 
            case 109: 
            case 113: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression";
                break;
            }
            case 106: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightHandSide";
                break;
            }
            case 108: 
            case 112: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceForResolveResult";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldContext";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayTypeInfo";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/BasicExpressionTypingVisitor";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultType";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToReceiver";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "visitLabeledExpression";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "visitComparison";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "visitBooleanOperationExpression";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "visitElvisExpression";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "establishSubtypingForTypeRHS";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "checkInExpression";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "assignmentIsNotAnExpressionError";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "declarationInIllegalContext";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInfoForBinaryCall";
                break;
            }
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArrayAccessSpecialMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isLValueOrUnsafeReceiver";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isLValue";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDangerousWithNull";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkNull";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitSimpleNameExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitParenthesizedExpression";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitConstantExpression";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkUnderscores";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 28: 
            case 29: 
            case 30: 
            case 43: 
            case 44: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 79: 
            case 80: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 94: 
            case 99: 
            case 118: 
            case 119: 
            case 120: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryWithTypeRHSExpression";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkBinaryWithTypeRHS";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitThisExpression";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitSuperExpression";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkResolvedExplicitlyQualifiedSupertype";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitBlockExpression";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitClassLiteralExpression";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitCallableReferenceExpression";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitObjectLiteralExpression";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitQualifiedExpression";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitCallExpression";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "visitUnaryExpression";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitExclExclExpression";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitLabeledExpression";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isKnownToBeNotNull";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "checkLValue";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "checkPropertySetterCall";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createCallCheckerContext";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryExpression";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "checkIdentityOnPrimitiveOrInlineClassTypes";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "findEqualsWithNullableAnyParameter";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "visitComparison";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "visitBooleanOperationExpression";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "visitElvisExpression";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "establishSubtypingForTypeRHS";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "checkInExpression";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayAccessExpression";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "visitCollectionLiteralExpression";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "visitClass";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "declarationInIllegalContext";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "visitProperty";
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getTypeInfoForBinaryCall";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "visitDeclaration";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "visitStringTemplateExpression";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "checkLiteralPrefixAndSuffix";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotatedExpression";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "visitKtElement";
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "resolveArrayAccessSetMethod";
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "resolveImplicitArrayAccessSetMethod";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "resolveArrayAccessGetMethod";
                break;
            }
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "resolveArrayAccessSpecialMethod";
                break;
            }
            case 121: 
            case 122: 
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "computeAccumulatedInfoForArrayAccessExpression";
                break;
            }
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "getTypeInfo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 28: 
            case 29: 
            case 30: 
            case 43: 
            case 44: 
            case 64: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 79: 
            case 80: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 94: 
            case 99: 
            case 118: 
            case 119: 
            case 120: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

