/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.common.MappingsKt;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesSupport;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.backend.js.JsMapping;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsInnerClassesSupport;", "Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "mapping", "Lorg/jetbrains/kotlin/ir/backend/js/JsMapping;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsMapping;Lorg/jetbrains/kotlin/ir/declarations/IrFactory;)V", "innerClassConstructors", "Lorg/jetbrains/kotlin/backend/common/Mapping$Delegate;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "originalInnerClassPrimaryConstructorByClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "outerThisFieldSymbols", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "createInnerClassConstructorWithOuterThisParameter", "oldConstructor", "getInnerClassConstructorWithOuterThisParameter", "innerClassConstructor", "getInnerClassOriginalPrimaryConstructorOrNull", "innerClass", "getOuterThisField", "backend.js"})
public final class JsInnerClassesSupport
implements InnerClassesSupport {
    private final Mapping.Delegate<IrClass, IrField> outerThisFieldSymbols;
    private final Mapping.Delegate<IrConstructor, IrConstructor> innerClassConstructors;
    private final Mapping.Delegate<IrClass, IrConstructor> originalInnerClassPrimaryConstructorByClass;
    private final IrFactory irFactory;

    @Override
    @NotNull
    public IrField getOuterThisField(@NotNull IrClass innerClass) {
        Intrinsics.checkNotNullParameter((Object)innerClass, (String)"innerClass");
        if (!innerClass.isInner()) {
            throw (Throwable)((Object)new AssertionError((Object)("Class is not inner: " + DumpIrTreeKt.dump$default(innerClass, false, 1, null))));
        }
        return MappingsKt.getOrPut(this.outerThisFieldSymbols, (IrDeclaration)innerClass, (Function0)new Function0<IrField>(this, innerClass){
            final /* synthetic */ JsInnerClassesSupport this$0;
            final /* synthetic */ IrClass $innerClass;

            @NotNull
            public final IrField invoke() {
                IrDeclarationParent irDeclarationParent = this.$innerClass.getParent();
                if (!(irDeclarationParent instanceof IrClass)) {
                    irDeclarationParent = null;
                }
                IrClass irClass2 = (IrClass)irDeclarationParent;
                if (irClass2 == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("No containing class for inner class " + DumpIrTreeKt.dump$default(this.$innerClass, false, 1, null))));
                }
                IrClass outerClass2 = irClass2;
                IrFactory $this$buildField$iv = JsInnerClassesSupport.access$getIrFactory$p(this.this$0);
                boolean $i$f$buildField = false;
                IrFieldBuilder irFieldBuilder = new IrFieldBuilder();
                boolean bl = false;
                boolean bl2 = false;
                IrFieldBuilder $this$run$iv = irFieldBuilder;
                boolean bl3 = false;
                IrFieldBuilder $this$buildField = $this$run$iv;
                boolean bl4 = false;
                $this$buildField.setOrigin(InnerClassesSupport.FIELD_FOR_OUTER_THIS.INSTANCE);
                Name name = Name.identifier("$this");
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(\"\\$this\")");
                $this$buildField.setName(name);
                $this$buildField.setType(IrUtilsKt.getDefaultType(outerClass2));
                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PROTECTED;
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"DescriptorVisibilities.PROTECTED");
                $this$buildField.setVisibility(descriptorVisibility);
                $this$buildField.setFinal(true);
                $this$buildField.setExternal(false);
                $this$buildField.setStatic(false);
                IrField irField = DeclarationBuildersKt.buildField($this$buildField$iv, $this$run$iv);
                boolean bl5 = false;
                boolean bl6 = false;
                IrField it = irField;
                boolean bl7 = false;
                it.setParent(this.$innerClass);
                return irField;
            }
            {
                this.this$0 = jsInnerClassesSupport;
                this.$innerClass = irClass2;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public IrConstructor getInnerClassConstructorWithOuterThisParameter(@NotNull IrConstructor innerClassConstructor) {
        Intrinsics.checkNotNullParameter((Object)innerClassConstructor, (String)"innerClassConstructor");
        IrDeclarationParent irDeclarationParent = innerClassConstructor.getParent();
        if (irDeclarationParent == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        }
        IrClass innerClass = (IrClass)irDeclarationParent;
        boolean bl = innerClass.isInner();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Class is not inner: " + innerClass;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        IrConstructor irConstructor2 = MappingsKt.getOrPut(this.innerClassConstructors, (IrDeclaration)innerClassConstructor, (Function0)new Function0<IrConstructor>(this, innerClassConstructor){
            final /* synthetic */ JsInnerClassesSupport this$0;
            final /* synthetic */ IrConstructor $innerClassConstructor;

            @NotNull
            public final IrConstructor invoke() {
                return JsInnerClassesSupport.access$createInnerClassConstructorWithOuterThisParameter(this.this$0, this.$innerClassConstructor);
            }
            {
                this.this$0 = jsInnerClassesSupport;
                this.$innerClassConstructor = irConstructor2;
                super(0);
            }
        });
        bl2 = false;
        boolean bl4 = false;
        IrConstructor it = irConstructor2;
        boolean bl5 = false;
        if (innerClassConstructor.isPrimary()) {
            this.originalInnerClassPrimaryConstructorByClass.set((IrClass)((IrDeclaration)innerClass), innerClassConstructor);
        }
        return irConstructor2;
    }

    @Override
    @Nullable
    public IrConstructor getInnerClassOriginalPrimaryConstructorOrNull(@NotNull IrClass innerClass) {
        Intrinsics.checkNotNullParameter((Object)innerClass, (String)"innerClass");
        boolean bl = innerClass.isInner();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Class is not inner: " + innerClass;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return this.originalInnerClassPrimaryConstructorByClass.get((IrClass)((IrDeclaration)innerClass));
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor createInnerClassConstructorWithOuterThisParameter(IrConstructor oldConstructor) {
        void $this$buildValueParameter;
        Object[] objectArray;
        IrDeclarationParent irDeclarationParent = oldConstructor.getParent();
        if (irDeclarationParent == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        }
        IrClass irClass2 = (IrClass)irDeclarationParent;
        IrDeclarationParent irDeclarationParent2 = irClass2.getParent();
        if (irDeclarationParent2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        }
        IrSimpleType outerThisType = IrUtilsKt.getDefaultType((IrClass)irDeclarationParent2);
        Object $this$buildConstructor$iv = this.irFactory;
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrDeclarationBuilder $this$run$iv = irFunctionBuilder;
        boolean bl3 = false;
        IrFunctionBuilder $this$buildConstructor = $this$run$iv;
        boolean bl4 = false;
        $this$buildConstructor.updateFrom(oldConstructor);
        $this$buildConstructor.setReturnType(oldConstructor.getReturnType());
        $this$buildConstructor$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv, $this$run$iv);
        $i$f$buildConstructor = false;
        boolean bl5 = false;
        Object it = $this$buildConstructor$iv;
        boolean bl6 = false;
        it.setParent(oldConstructor.getParent());
        Object newConstructor2 = $this$buildConstructor$iv;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTypeParametersFrom$default((IrTypeParametersContainer)newConstructor2, oldConstructor, null, null, 6, null);
        boolean $i$f$buildValueParameter = false;
        IrValueParameterBuilder irValueParameterBuilder = new IrValueParameterBuilder();
        boolean bl7 = false;
        bl2 = false;
        $this$run$iv = irValueParameterBuilder;
        boolean bl8 = false;
        $this$buildConstructor = $this$run$iv;
        int n = 0;
        Object[] objectArray2 = objectArray = new IrValueParameter[1];
        boolean bl9 = false;
        $this$buildValueParameter.setOrigin(JsIrBuilder.SYNTHESIZED_DECLARATION.INSTANCE);
        Name name = Name.identifier(Namer.INSTANCE.getOUTER_NAME());
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(Namer.OUTER_NAME)");
        $this$buildValueParameter.setName(name);
        $this$buildValueParameter.setIndex(0);
        $this$buildValueParameter.setType(outerThisType);
        Unit unit = Unit.INSTANCE;
        objectArray[n] = DeclarationBuildersKt.buildValueParameter(((IrDeclaration)newConstructor2).getFactory(), (IrValueParameterBuilder)$this$run$iv, (IrDeclarationParent)((Object)((IrDeclaration)newConstructor2)));
        List newValueParameters = CollectionsKt.mutableListOf((Object[])objectArray2);
        for (IrValueParameter p : oldConstructor.getValueParameters()) {
            Collection collection = newValueParameters;
            IrValueParameter irValueParameter = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(p, (IrFunction)newConstructor2, null, p.getIndex() + 1, 0, 0, null, null, null, null, null, false, false, 4090, null);
            boolean bl10 = false;
            collection.add(irValueParameter);
        }
        Object object = newConstructor2;
        ((IrFunction)object).setValueParameters(CollectionsKt.plus((Collection)((IrFunction)object).getValueParameters(), (Iterable)newValueParameters));
        return newConstructor2;
    }

    public JsInnerClassesSupport(@NotNull JsMapping mapping2, @NotNull IrFactory irFactory) {
        Intrinsics.checkNotNullParameter((Object)mapping2, (String)"mapping");
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        this.irFactory = irFactory;
        this.outerThisFieldSymbols = mapping2.getOuterThisFieldSymbols();
        this.innerClassConstructors = mapping2.getInnerClassConstructors();
        this.originalInnerClassPrimaryConstructorByClass = mapping2.getOriginalInnerClassPrimaryConstructorByClass();
    }

    public static final /* synthetic */ IrFactory access$getIrFactory$p(JsInnerClassesSupport $this) {
        return $this.irFactory;
    }

    public static final /* synthetic */ IrConstructor access$createInnerClassConstructorWithOuterThisParameter(JsInnerClassesSupport $this, IrConstructor oldConstructor) {
        return $this.createInnerClassConstructorWithOuterThisParameter(oldConstructor);
    }
}

