/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolverKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SingleCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.tower.NewCallArgumentsKt;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallsKt;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\f2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\r\u001a\u00020\f2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ImplicitNothingAsTypeParameterCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkAgainstNotNothingExpectedType", "", "checkByReturnPositionWithoutExpected", "findFunctionsWithImplicitNothingAndReport", "resolvedAtoms", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "getSubResolvedAtomsToAnalyze", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getResolvedCallAtom", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;", "frontend"})
public final class ImplicitNothingAsTypeParameterCallChecker
implements CallChecker {
    @NotNull
    public static final ImplicitNothingAsTypeParameterCallChecker INSTANCE;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkByReturnPositionWithoutExpected(ResolvedCall<?> resolvedCall2, PsiElement reportOn, CallCheckerContext context2) {
        void $this$mapTo$iv$iv;
        ValueParameterDescriptor it;
        Iterable $this$filterTo$iv$iv;
        Object resultingDescriptor = resolvedCall2.getResultingDescriptor();
        KotlinType kotlinType = context2.getResolutionContext().expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"context.resolutionContext.expectedType");
        KotlinType expectedType2 = kotlinType;
        Object obj = resultingDescriptor;
        Intrinsics.checkNotNullExpressionValue(obj, (String)"resultingDescriptor");
        KotlinType inferredReturnType = obj.getReturnType();
        Object obj2 = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj2, (String)"resolvedCall.resultingDescriptor");
        Object object = obj2.getDispatchReceiverParameter();
        boolean isBuiltinFunctionalType = object != null && (object = object.getValue()) != null && (object = object.getType()) != null && FunctionTypesKt.isBuiltinFunctionalType((KotlinType)object);
        if (inferredReturnType instanceof DeferredType) return false;
        if (isBuiltinFunctionalType) {
            return false;
        }
        if (GenericCandidateResolverKt.getSPECIAL_FUNCTION_NAMES().contains(resultingDescriptor.getName())) return false;
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"resolvedCall.call");
        List<KtTypeProjection> list2 = call2.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"resolvedCall.call.typeArguments");
        Collection collection = list2;
        boolean bl = false;
        if (!collection.isEmpty()) {
            return false;
        }
        boolean bl2 = false;
        if (bl2) {
            return false;
        }
        Object obj3 = resolvedCall2.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj3, (String)"resolvedCall.candidateDescriptor");
        List<ValueParameterDescriptor> list3 = obj3.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"resolvedCall.candidateDescriptor.valueParameters");
        Iterable $this$filter$iv = list3;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ValueParameterDescriptor)element$iv$iv;
            boolean bl3 = false;
            ValueParameterDescriptor valueParameterDescriptor = it;
            Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"it");
            KotlinType kotlinType2 = valueParameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"it.type");
            if (!FunctionTypesKt.isFunctionOrSuspendFunctionType(kotlinType2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ValueParameterDescriptor)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl4 = false;
            ValueParameterDescriptor valueParameterDescriptor = it;
            Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"it");
            Object object2 = valueParameterDescriptor.getReturnType();
            KotlinType kotlinType3 = object2 != null && (object2 = ((KotlinType)object2).getArguments()) != null && (object2 = (TypeProjection)CollectionsKt.last((List)object2)) != null ? object2.getType() : null;
            collection2.add(kotlinType3);
        }
        Set lambdasFromArgumentsReturnTypes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        CallableDescriptor callableDescriptor = resultingDescriptor.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"resultingDescriptor.original");
        KotlinType unsubstitutedReturnType = callableDescriptor.getReturnType();
        KotlinType kotlinType4 = inferredReturnType;
        if (kotlinType4 == null) return false;
        if (!TypeUtilsKt.isNothing(kotlinType4)) return false;
        KotlinType kotlinType5 = unsubstitutedReturnType;
        if (kotlinType5 == null) return false;
        if (!TypeUtilsKt.isTypeParameter(kotlinType5)) return false;
        if (!TypeUtils.noExpectedType(expectedType2)) {
            if (TypeUtilsKt.isNothing(expectedType2)) return false;
        }
        boolean bl5 = true;
        boolean hasImplicitNothing = bl5;
        if (!hasImplicitNothing) return false;
        if (lambdasFromArgumentsReturnTypes.contains(unsubstitutedReturnType)) return false;
        BindingTrace bindingTrace = context2.getTrace();
        SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.IMPLICIT_NOTHING_TYPE_ARGUMENT_IN_RETURN_POSITION.on(reportOn);
        Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"Errors.IMPLICIT_NOTHING_\u2026URN_POSITION.on(reportOn)");
        Diagnostic diagnostic = simpleDiagnostic;
        DiagnosticFactory[] diagnosticFactoryArray = new DiagnosticFactory[1];
        DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.IMPLICIT_NOTHING_TYPE_ARGUMENT_AGAINST_NOT_NOTHING_EXPECTED_TYPE;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"Errors.IMPLICIT_NOTHING_\u2026NOT_NOTHING_EXPECTED_TYPE");
        diagnosticFactoryArray[0] = diagnosticFactory0;
        DiagnosticUtilsKt.reportDiagnosticOnceWrtDiagnosticFactoryList(bindingTrace, diagnostic, diagnosticFactoryArray);
        return true;
    }

    private final ResolvedCallAtom getResolvedCallAtom(ResolvedAtom $this$getResolvedCallAtom, BindingContext bindingContext) {
        if ($this$getResolvedCallAtom instanceof SingleCallResolutionResult) {
            return ((SingleCallResolutionResult)$this$getResolvedCallAtom).getResultCallAtom();
        }
        ResolutionAtom resolutionAtom = $this$getResolvedCallAtom.getAtom();
        if (!(resolutionAtom instanceof KotlinCallArgument)) {
            resolutionAtom = null;
        }
        KotlinCallArgument kotlinCallArgument = (KotlinCallArgument)((Object)resolutionAtom);
        if (kotlinCallArgument == null) {
            return null;
        }
        KotlinCallArgument resolutionAtom2 = kotlinCallArgument;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(NewCallArgumentsKt.getPsiExpression(resolutionAtom2), bindingContext);
        return resolvedCall2 instanceof NewResolvedCallImpl ? ((NewResolvedCallImpl)resolvedCall2).getResolvedCallAtom() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean findFunctionsWithImplicitNothingAndReport(List<? extends ResolvedAtom> resolvedAtoms, CallCheckerContext context2) {
        boolean hasAlreadyReportedAtDepth = false;
        for (ResolvedAtom resolvedAtom : resolvedAtoms) {
            void $this$run;
            boolean hasExplicitTypeArguments;
            boolean bl;
            CallableDescriptor candidateDescriptor;
            ResolvedCallAtom resolvedCallAtom;
            block6: {
                List<ResolvedAtom> subResolveAtoms = resolvedAtom.getSubResolvedAtoms();
                Collection collection = subResolveAtoms;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!(collection == null || collection.isEmpty()) && this.findFunctionsWithImplicitNothingAndReport(subResolveAtoms, context2)) {
                    hasAlreadyReportedAtDepth = true;
                    continue;
                }
                BindingContext bindingContext = context2.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
                if (this.getResolvedCallAtom(resolvedAtom, bindingContext) == null) {
                    continue;
                }
                candidateDescriptor = resolvedCallAtom.getCandidateDescriptor();
                List<TypeParameterDescriptor> list2 = candidateDescriptor.getTypeParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"candidateDescriptor.typeParameters");
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                        boolean bl4 = false;
                        TypeParameterDescriptor typeParameterDescriptor = it;
                        Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"it");
                        KotlinType kotlinType = candidateDescriptor.getReturnType();
                        if (!Intrinsics.areEqual((Object)typeParameterDescriptor.getTypeConstructor(), (Object)(kotlinType != null ? kotlinType.getConstructor() : null))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            boolean isReturnTypeOwnTypeParameter = bl;
            boolean isSpecialCall = GenericCandidateResolverKt.getSPECIAL_FUNCTION_NAMES().contains(candidateDescriptor.getName());
            Object object = PSIKotlinCallsKt.getPsiKotlinCall(resolvedCallAtom.getAtom()).getTypeArguments();
            boolean bl5 = false;
            boolean bl2 = hasExplicitTypeArguments = !object.isEmpty();
            if (isSpecialCall || !isReturnTypeOwnTypeParameter || hasExplicitTypeArguments) continue;
            object = PSIKotlinCallsKt.getPsiKotlinCall(resolvedCallAtom.getAtom()).getPsiCall();
            bl5 = false;
            boolean bl7 = false;
            Object bl4 = object;
            DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.IMPLICIT_NOTHING_TYPE_ARGUMENT_AGAINST_NOT_NOTHING_EXPECTED_TYPE;
            BindingTrace bindingTrace = context2.getTrace();
            boolean bl8 = false;
            KtExpression ktExpression = $this$run.getCalleeExpression();
            KtElement ktElement = ktExpression != null ? (KtElement)ktExpression : $this$run.getCallElement();
            SimpleDiagnostic<PsiElement> simpleDiagnostic = diagnosticFactory0.on(ktElement);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"Errors.IMPLICIT_NOTHING_\u2026 },\n                    )");
            Diagnostic diagnostic = simpleDiagnostic;
            DiagnosticFactory[] diagnosticFactoryArray = new DiagnosticFactory[1];
            DiagnosticFactory0<PsiElement> diagnosticFactory02 = Errors.IMPLICIT_NOTHING_TYPE_ARGUMENT_IN_RETURN_POSITION;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory02, (String)"Errors.IMPLICIT_NOTHING_\u2026GUMENT_IN_RETURN_POSITION");
            diagnosticFactoryArray[0] = diagnosticFactory02;
            DiagnosticUtilsKt.reportDiagnosticOnceWrtDiagnosticFactoryList(bindingTrace, diagnostic, diagnosticFactoryArray);
            hasAlreadyReportedAtDepth = true;
        }
        return hasAlreadyReportedAtDepth;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ResolvedAtom> getSubResolvedAtomsToAnalyze(ResolvedCall<?> resolvedCall2, KotlinType expectedType2, BindingContext bindingContext) {
        List<ResolvedAtom> list2;
        KtExpression extensionReceiver;
        void $this$mapNotNullTo$iv$iv;
        boolean isSubResolvedAtomsNotEmpty;
        if (!(resolvedCall2 instanceof NewResolvedCallImpl)) {
            return null;
        }
        boolean hasNotNothingExpectedType = !TypeUtils.noExpectedType(expectedType2) && !TypeUtilsKt.isNothingOrNullableNothing(expectedType2);
        KotlinType kotlinType = ((NewResolvedCallImpl)resolvedCall2).getResultingDescriptor().getReturnType();
        boolean hasNothingReturnType = kotlinType != null && TypeUtilsKt.isNothingOrNullableNothing(kotlinType);
        Collection collection = ((NewResolvedCallImpl)resolvedCall2).getResolvedCallAtom().getSubResolvedAtoms();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = isSubResolvedAtomsNotEmpty = !(collection == null || collection.isEmpty());
        if (hasNotNothingExpectedType && hasNothingReturnType && isSubResolvedAtomsNotEmpty) {
            return ((NewResolvedCallImpl)resolvedCall2).getResolvedCallAtom().getSubResolvedAtoms();
        }
        Iterable $this$mapNotNull$iv = ((NewResolvedCallImpl)resolvedCall2).getValueArguments().values();
        boolean $i$f$mapNotNull = false;
        Object object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            List<ResolvedAtom> list3;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl4 = false;
            ResolvedValueArgument argument = (ResolvedValueArgument)element$iv$iv;
            boolean bl5 = false;
            if (!(argument instanceof ExpressionValueArgument)) {
                list3 = null;
            } else {
                ResolvedCall<? extends CallableDescriptor> resolvedCall3;
                Object object2 = ((ExpressionValueArgument)argument).getValueArgument();
                if (!((object2 != null && (object2 = object2.getArgumentExpression()) != null ? CallUtilKt.getResolvedCall((KtElement)object2, bindingContext) : (resolvedCall3 = null)) instanceof NewResolvedCallImpl)) {
                    resolvedCall3 = null;
                }
                if ((NewResolvedCallImpl)resolvedCall3 == null) {
                    list3 = null;
                } else {
                    Annotated annotated = CallUtilKt.getParameterForArgument(resolvedCall2, ((ExpressionValueArgument)argument).getValueArgument());
                    if (annotated == null || (annotated = annotated.getType()) == null) {
                        list3 = null;
                    } else {
                        NewResolvedCallImpl resolvedCallForArgument;
                        Intrinsics.checkNotNullExpressionValue((Object)annotated, (String)"resolvedCall.getParamete\u2026?: return@mapNotNull null");
                        Annotated expectedTypeForArgument = annotated;
                        list3 = INSTANCE.getSubResolvedAtomsToAnalyze(resolvedCallForArgument, (KotlinType)expectedTypeForArgument, bindingContext);
                    }
                }
            }
            if (list3 == null) continue;
            List<ResolvedAtom> list4 = list3;
            boolean bl6 = false;
            boolean bl7 = false;
            List<ResolvedAtom> it$iv$iv = list4;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List resolvedAtomsFromArguments = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        SimpleKotlinCallArgument simpleKotlinCallArgument = ((NewResolvedCallImpl)resolvedCall2).getResolvedCallAtom().getExtensionReceiverArgument();
        KtExpression ktExpression = extensionReceiver = simpleKotlinCallArgument != null ? NewCallArgumentsKt.getPsiExpression(simpleKotlinCallArgument) : null;
        if (ktExpression != null) {
            object = ktExpression;
            boolean bl9 = false;
            boolean bl10 = false;
            Object $this$run = object;
            boolean bl11 = false;
            ResolvedCall<? extends CallableDescriptor> extensionReceiverResolvedCall = CallUtilKt.getResolvedCall((KtElement)$this$run, bindingContext);
            if (Intrinsics.areEqual(extensionReceiverResolvedCall, resolvedCall2)) {
                list2 = null;
            } else {
                List<ResolvedAtom> list5;
                ResolvedCall<? extends CallableDescriptor> resolvedCall4 = CallUtilKt.getResolvedCall((KtElement)$this$run, bindingContext);
                if (resolvedCall4 == null) {
                    list2 = list5 = null;
                } else {
                    Annotated annotated = ((NewResolvedCallImpl)resolvedCall2).getResultingDescriptor().getExtensionReceiverParameter();
                    if (annotated == null || (annotated = annotated.getType()) == null) {
                        list2 = list5 = null;
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)annotated, (String)"resolvedCall.resultingDe\u2026?.type ?: return@run null");
                        list2 = INSTANCE.getSubResolvedAtomsToAnalyze(resolvedCall4, (KotlinType)annotated, bindingContext);
                    }
                }
            }
        } else {
            list2 = null;
        }
        List<ResolvedAtom> resolvedAtomsFromExtensionReceiver = list2;
        return resolvedAtomsFromExtensionReceiver != null ? CollectionsKt.plus((Collection)resolvedAtomsFromArguments, (Iterable)resolvedAtomsFromExtensionReceiver) : resolvedAtomsFromArguments;
    }

    private final boolean checkAgainstNotNothingExpectedType(ResolvedCall<?> resolvedCall2, CallCheckerContext context2) {
        KotlinType kotlinType = context2.getResolutionContext().expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"context.resolutionContext.expectedType");
        BindingContext bindingContext = context2.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
        List<ResolvedAtom> list2 = this.getSubResolvedAtomsToAnalyze(resolvedCall2, kotlinType, bindingContext);
        if (list2 == null) {
            return false;
        }
        List<ResolvedAtom> subResolvedAtoms = list2;
        return this.findFunctionsWithImplicitNothingAndReport(subResolvedAtoms, context2);
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.checkByReturnPositionWithoutExpected(resolvedCall2, reportOn, context2) || this.checkAgainstNotNothingExpectedType(resolvedCall2, context2)) {
            // empty if block
        }
    }

    private ImplicitNothingAsTypeParameterCallChecker() {
    }

    static {
        ImplicitNothingAsTypeParameterCallChecker implicitNothingAsTypeParameterCallChecker;
        INSTANCE = implicitNothingAsTypeParameterCallChecker = new ImplicitNothingAsTypeParameterCallChecker();
    }
}

