/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.GenericsUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;

public class PsiDisjunctionType
extends PsiType.Stub {
    private final PsiManager myManager;
    private final List<PsiType> myTypes;
    private final CachedValue<PsiType> myLubCache;

    public PsiDisjunctionType(@NotNull List<PsiType> types2, @NotNull PsiManager psiManager) {
        if (types2 == null) {
            PsiDisjunctionType.$$$reportNull$$$0(0);
        }
        if (psiManager == null) {
            PsiDisjunctionType.$$$reportNull$$$0(1);
        }
        super(TypeAnnotationProvider.EMPTY);
        this.myManager = psiManager;
        this.myTypes = Collections.unmodifiableList(types2);
        this.myLubCache = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(() -> {
            PsiType lub = this.myTypes.get(0);
            for (int i = 1; i < this.myTypes.size(); ++i) {
                if ((lub = GenericsUtil.getLeastUpperBound(lub, this.myTypes.get(i), this.myManager)) != null) continue;
                lub = PsiType.getJavaLangObject(this.myManager, GlobalSearchScope.allScope(this.myManager.getProject()));
                break;
            }
            return CachedValueProvider.Result.create(lub, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        }, false);
    }

    @NotNull
    public static PsiType createDisjunction(@NotNull List<PsiType> types2, @NotNull PsiManager psiManager) {
        if (types2 == null) {
            PsiDisjunctionType.$$$reportNull$$$0(2);
        }
        if (psiManager == null) {
            PsiDisjunctionType.$$$reportNull$$$0(3);
        }
        assert (!types2.isEmpty());
        return types2.size() == 1 ? types2.get(0) : new PsiDisjunctionType(types2, psiManager);
    }

    @NotNull
    public PsiType getLeastUpperBound() {
        PsiType psiType2 = this.myLubCache.getValue();
        if (psiType2 == null) {
            PsiDisjunctionType.$$$reportNull$$$0(4);
        }
        return psiType2;
    }

    @NotNull
    public List<PsiType> getDisjunctions() {
        List<PsiType> list2 = this.myTypes;
        if (list2 == null) {
            PsiDisjunctionType.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public PsiDisjunctionType newDisjunctionType(List<PsiType> types2) {
        return new PsiDisjunctionType(types2, this.myManager);
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        String string2 = StringUtil.join(this.myTypes, psiType2 -> psiType2.getPresentableText(annotated), " | ");
        if (string2 == null) {
            PsiDisjunctionType.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string2 = StringUtil.join(this.myTypes, psiType2 -> psiType2.getCanonicalText(annotated), " | ");
        if (string2 == null) {
            PsiDisjunctionType.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string2 = StringUtil.join(this.myTypes, psiType2 -> psiType2.getInternalCanonicalText(), " | ");
        if (string2 == null) {
            PsiDisjunctionType.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @Override
    public boolean isValid() {
        for (PsiType type2 : this.myTypes) {
            if (type2.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(@NotNull @NonNls String text2) {
        if (text2 == null) {
            PsiDisjunctionType.$$$reportNull$$$0(9);
        }
        return Comparing.equal(text2, this.getCanonicalText());
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            PsiDisjunctionType.$$$reportNull$$$0(10);
        }
        return visitor2.visitDisjunctionType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.getLeastUpperBound().getResolveScope();
    }

    @Override
    public PsiType @NotNull [] getSuperTypes() {
        PsiType lub = this.getLeastUpperBound();
        if (lub instanceof PsiIntersectionType) {
            PsiType[] psiTypeArray = ((PsiIntersectionType)lub).getConjuncts();
            if (psiTypeArray == null) {
                PsiDisjunctionType.$$$reportNull$$$0(11);
            }
            return psiTypeArray;
        }
        PsiType[] psiTypeArray = new PsiType[]{lub};
        if (psiTypeArray == null) {
            PsiDisjunctionType.$$$reportNull$$$0(12);
        }
        return psiTypeArray;
    }

    public int hashCode() {
        return this.myTypes.get(0).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiDisjunctionType that = (PsiDisjunctionType)o;
        if (that.myTypes.size() != this.myTypes.size()) {
            return false;
        }
        for (int i = 0; i < this.myTypes.size(); ++i) {
            if (this.myTypes.get(i).equals(that.myTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    public static List<PsiType> flattenAndRemoveDuplicates(@NotNull List<? extends PsiType> types2) {
        if (types2 == null) {
            PsiDisjunctionType.$$$reportNull$$$0(13);
        }
        LinkedHashSet disjunctionSet = new LinkedHashSet();
        for (PsiType psiType2 : types2) {
            PsiDisjunctionType.flatten(disjunctionSet, psiType2);
        }
        ArrayList<PsiType> disjunctions = new ArrayList<PsiType>(disjunctionSet);
        Iterator iterator2 = disjunctions.iterator();
        block1: while (iterator2.hasNext()) {
            PsiType d1 = (PsiType)iterator2.next();
            for (PsiType d2 : disjunctions) {
                if (d1 == d2 || !d2.isAssignableFrom(d1)) continue;
                iterator2.remove();
                continue block1;
            }
        }
        return disjunctions;
    }

    private static void flatten(Set<? super PsiType> disjunctions, PsiType type2) {
        if (type2 instanceof PsiDisjunctionType) {
            for (PsiType child : ((PsiDisjunctionType)type2).getDisjunctions()) {
                PsiDisjunctionType.flatten(disjunctions, child);
            }
        } else {
            disjunctions.add(type2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/PsiDisjunctionType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/PsiDisjunctionType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeastUpperBound";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisjunctions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDisjunction";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "flattenAndRemoveDuplicates";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

