/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.BuiltInWithDifferentJvmName;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.SpecialBridgeMethods;
import org.jetbrains.kotlin.backend.common.lower.SpecialMethodWithDefaultInfo;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.IrCodegenUtilsKt;
import org.jetbrains.kotlin.backend.jvm.codegen.IrTypeMapper;
import org.jetbrains.kotlin.backend.jvm.codegen.MethodSignatureMapper;
import org.jetbrains.kotlin.backend.jvm.lower.BridgeLowering;
import org.jetbrains.kotlin.backend.jvm.lower.BridgeLoweringKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0003HIJB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0017H\u0016J\u0014\u0010$\u001a\u00020\n*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u001c\u0010%\u001a\u00020\n*\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\nH\u0002J\u001c\u0010'\u001a\u00020\n*\u00020\u00172\u0006\u0010(\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\nH\u0002J.\u0010)\u001a\u00020\u0015*\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\n2\u0010\b\u0002\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,H\u0002J.\u0010.\u001a\u00020/*\u00020/2\u0006\u0010&\u001a\u00020\n2\f\u00100\u001a\b\u0012\u0004\u0012\u000202012\n\b\u0002\u00103\u001a\u0004\u0018\u00010-H\u0002J(\u00104\u001a\u000205*\u0002062\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010&\u001a\u00020\n2\n\b\u0002\u00107\u001a\u0004\u0018\u000108H\u0002J\u001c\u00109\u001a\u000205*\u0002062\u0006\u0010:\u001a\u0002052\u0006\u0010;\u001a\u00020-H\u0002J\u0012\u0010<\u001a\b\u0012\u0004\u0012\u00020\f0,*\u00020\nH\u0002J\u0012\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00110,*\u00020\nH\u0002J$\u0010>\u001a\u00020?*\u0002062\u0006\u0010@\u001a\u00020/2\u0006\u0010A\u001a\u00020-2\u0006\u0010B\u001a\u000205H\u0002J$\u0010C\u001a\u00020\u0015*\u00020\n2\u0006\u0010D\u001a\u00020\f2\u0006\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020GH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/BridgeLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "potentialBridgeTargets", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "jvmMethod", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getJvmMethod", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/org/objectweb/asm/commons/Method;", "specialBridgeOrNull", "Lorg/jetbrains/kotlin/backend/jvm/lower/BridgeLowering$SpecialBridge;", "getSpecialBridgeOrNull", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/backend/jvm/lower/BridgeLowering$SpecialBridge;", "createBridges", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irFunction", "generateBridges", "getBridgeVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "bridge", "Lorg/jetbrains/kotlin/backend/jvm/lower/BridgeLowering$Bridge;", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "addAbstractMethodStub", "addBridge", "target", "addSpecialBridge", "specialBridge", "copyParametersWithErasure", "from", "substitutedParameterTypes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "copyWithTypeErasure", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "visibleTypeParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "substitutedType", "delegatingCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "superQualifierSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "irCastIfNeeded", "expression", "to", "overriddenFinalSpecialBridges", "overriddenSpecialBridges", "parameterTypeCheck", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrIfThenElseImpl;", "parameter", "type", "defaultValue", "rewriteSpecialMethodBody", "ourSignature", "specialOverrideSignature", "specialOverrideInfo", "Lorg/jetbrains/kotlin/backend/common/lower/SpecialMethodWithDefaultInfo;", "Bridge", "BridgeLoweringCache", "SpecialBridge", "backend.jvm"})
public final class BridgeLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    private final List<IrSimpleFunction> potentialBridgeTargets;
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.transformChildrenVoid(irFile);
        this.generateBridges();
        this.potentialBridgeTargets.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration2) {
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.DEFAULT_IMPLS.INSTANCE) || IrUtilsKt.isAnnotationClass(declaration2)) {
            return super.visitClass(declaration2);
        }
        Sequence<IrSimpleFunction> sequence2 = IrUtilsKt.getFunctions(declaration2);
        Collection destination$iv = this.potentialBridgeTargets;
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            boolean bl;
            IrSimpleFunction irFunction = (IrSimpleFunction)element$iv;
            boolean bl2 = false;
            if (DescriptorVisibilities.isPrivate(irFunction.getVisibility()) || org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isStatic(irFunction) || irFunction.getOverriddenSymbols().isEmpty()) {
                bl = false;
            } else if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isMethodOfAny(irFunction)) {
                bl = false;
            } else if (org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.isJvmAbstract(irFunction, this.context.getState().getJvmDefaultMode())) {
                if (IrCodegenUtilsKt.isJvmInterface(IrUtilsKt.getParentAsClass(irFunction))) {
                    if (this.getSpecialBridgeOrNull(irFunction) != null) {
                        this.context.getFunctionsWithSpecialBridges$backend_jvm().add(irFunction);
                    }
                    bl = false;
                } else {
                    bl = true;
                }
            } else {
                bl = !irFunction.isFakeOverride() || BridgeLoweringKt.access$resolvesToClass(irFunction);
            }
            if (!bl) continue;
            destination$iv.add(element$iv);
        }
        if (declaration2.isInline()) {
            for (IrSimpleFunction irFunction : IrUtilsKt.getFunctions(declaration2)) {
                IrFunction originalFunction;
                if (this.context.getInlineClassReplacements().getOriginalFunctionForStaticReplacement$backend_jvm().get(irFunction) == null) {
                    continue;
                }
                if (!this.context.getMethodSignatureMapper().shouldBoxSingleValueParameterForSpecialCaseOfRemove$backend_jvm(originalFunction)) continue;
                IrValueParameter oldValueParameter1 = irFunction.getValueParameters().get(1);
                IrValueParameter newValueParameter1 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(oldValueParameter1, irFunction, null, 0, 0, 0, null, null, IrTypesKt.makeNullable(oldValueParameter1.getType()), null, null, false, false, false, 8062, null);
                irFunction.setValueParameters(CollectionsKt.listOf((Object[])new IrValueParameter[]{irFunction.getValueParameters().get(0), newValueParameter1}));
                IrBody irBody = irFunction.getBody();
                if (irBody != null) {
                    irBody.transform((IrElementTransformer)new VariableRemapper(MapsKt.mapOf((Pair)TuplesKt.to((Object)oldValueParameter1, (Object)newValueParameter1))), (Object)null);
                }
                break;
            }
        }
        return super.visitClass(declaration2);
    }

    private final void generateBridges() {
        for (IrSimpleFunction member : this.potentialBridgeTargets) {
            IrClass parent2 = IrUtilsKt.getParentAsClass(member);
            this.createBridges(parent2, member);
            if (!Intrinsics.areEqual((Object)member.getName(), (Object)OperatorNameConventions.INVOKE) || !Intrinsics.areEqual((Object)parent2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.LAMBDA_IMPL.INSTANCE) && !Intrinsics.areEqual((Object)parent2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.FUNCTION_REFERENCE_IMPL.INSTANCE) || BridgeLoweringKt.access$isInlineClassErasingToAny$p(member.getReturnType())) continue;
            member.setOverriddenSymbols(CollectionsKt.emptyList());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createBridges(IrClass irClass2, IrSimpleFunction irFunction) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        boolean bl = false;
        Set blacklist = new LinkedHashSet();
        IrSimpleFunction irSimpleFunction = IrFakeOverrideUtilsKt.resolveFakeOverride$default(irFunction, false, null, 3, null);
        if (irSimpleFunction == null) {
            irSimpleFunction = irFunction;
        }
        Method targetMethod = this.getJvmMethod(irSimpleFunction);
        if (!irFunction.isFakeOverride() || irFunction.getModality() == Modality.FINAL) {
            Collection collection = blacklist;
            boolean bl2 = false;
            collection.add(targetMethod);
        }
        SpecialBridge specialBridge = this.getSpecialBridgeOrNull(irFunction);
        IrSimpleFunction bridgeTarget = irFunction;
        if (specialBridge != null) {
            IrSimpleFunction specialBridgeTarget;
            IrSimpleFunction irSimpleFunction2;
            Object object;
            boolean bl3;
            Collection collection = blacklist;
            Iterable iterable = this.overriddenFinalSpecialBridges(irFunction);
            boolean bl4 = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            if (!(blacklist.contains(specialBridge.getSignature()) || irFunction.isFakeOverride() && !(Intrinsics.areEqual((Object)this.getJvmMethod(irFunction), (Object)specialBridge.getSignature()) ^ true))) {
                boolean superTarget2;
                Object overriddenFromClass;
                if (irFunction.isFakeOverride()) {
                    IrSimpleFunction irSimpleFunction3;
                    if (org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.isJvmAbstract(irFunction, this.context.getState().getJvmDefaultMode())) {
                        irClass2.getDeclarations().remove(irFunction);
                        irSimpleFunction3 = this.addAbstractMethodStub(irClass2, irFunction);
                    } else if (irFunction.getModality() != Modality.FINAL) {
                        Object superTarget2;
                        IrSimpleFunction irSimpleFunction4 = BridgeLoweringKt.access$overriddenFromClass(irFunction);
                        Intrinsics.checkNotNull((Object)irSimpleFunction4);
                        overriddenFromClass = irSimpleFunction4;
                        SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo = specialBridge.getMethodInfo();
                        boolean bl5 = false;
                        boolean bl6 = false;
                        bl3 = false;
                        SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo2 = specialMethodWithDefaultInfo != null ? SpecialMethodWithDefaultInfo.copy$default(specialMethodWithDefaultInfo, null, 0, false, 5, null) : null;
                        IrClassSymbol irClassSymbol = (IrClassSymbol)IrUtilsKt.getParentAsClass((IrDeclaration)overriddenFromClass).getSymbol();
                        SpecialBridge superBridge = new SpecialBridge(irFunction, this.getJvmMethod(irFunction), false, null, null, specialMethodWithDefaultInfo2, irClassSymbol, bl3, bl6, bl5, 796, null);
                        object = overriddenFromClass;
                        bl3 = false;
                        boolean bl7 = false;
                        Object it = object;
                        boolean bl8 = false;
                        boolean bl9 = !((IrSimpleFunction)it).isFakeOverride();
                        Object object2 = bl9 ? object : null;
                        if (object2 == null) {
                            object2 = superTarget2 = specialBridge.getOverridden();
                        }
                        if (Intrinsics.areEqual((Object)superBridge.getSignature(), (Object)this.getJvmMethod((IrFunction)superTarget2))) {
                            irSimpleFunction3 = irFunction;
                        } else {
                            irClass2.getDeclarations().remove(irFunction);
                            irSimpleFunction3 = this.addSpecialBridge(irClass2, superBridge, (IrSimpleFunction)superTarget2);
                        }
                    } else {
                        irSimpleFunction3 = irFunction;
                    }
                    bridgeTarget = irSimpleFunction3;
                    overriddenFromClass = blacklist;
                    Method superBridge = this.getJvmMethod(bridgeTarget);
                    superTarget2 = false;
                    overriddenFromClass.add(superBridge);
                }
                overriddenFromClass = blacklist;
                Method superBridge = specialBridge.getSignature();
                superTarget2 = false;
                overriddenFromClass.add(superBridge);
                irSimpleFunction2 = this.addSpecialBridge(irClass2, specialBridge, bridgeTarget);
            } else {
                irSimpleFunction2 = specialBridgeTarget = irFunction;
            }
            if (!irFunction.isFakeOverride() && specialBridge.getMethodInfo() != null) {
                this.rewriteSpecialMethodBody(irFunction, targetMethod, specialBridge.getSignature(), specialBridge.getMethodInfo());
            }
            if (specialBridge.getSubstitutedReturnType() != null) {
                for (SpecialBridge overriddenSpecialBridge : this.overriddenSpecialBridges(irFunction)) {
                    if (blacklist.contains(overriddenSpecialBridge.getSignature())) continue;
                    this.addSpecialBridge(irClass2, overriddenSpecialBridge, specialBridgeTarget);
                    Collection superTarget2 = blacklist;
                    object = overriddenSpecialBridge.getSignature();
                    bl3 = false;
                    superTarget2.add(object);
                }
            }
        } else if (org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.isJvmAbstract(irFunction, this.context.getState().getJvmDefaultMode())) {
            return;
        }
        boolean overriddenSpecialBridge = false;
        Map generated = new LinkedHashMap();
        for (IrSimpleFunction override : org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.allOverridden$default(irFunction, false, 1, null)) {
            Object object;
            Method signature2;
            if (override.isFakeOverride() || !(Intrinsics.areEqual((Object)targetMethod, (Object)(signature2 = this.getJvmMethod(override))) ^ true) || blacklist.contains(signature2)) continue;
            Object $this$getOrPut$iv = generated;
            boolean $i$f$getOrPut22 = false;
            Object value$iv22 = $this$getOrPut$iv.get(signature2);
            if (value$iv22 == null) {
                boolean bl10 = false;
                Bridge answer$iv = new Bridge(override, signature2, null, 4, null);
                $this$getOrPut$iv.put(signature2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv22;
            }
            $this$getOrPut$iv = ((Bridge)object).getOverriddenSymbols();
            IrFunctionSymbol $i$f$getOrPut22 = override.getSymbol();
            boolean value$iv22 = false;
            $this$getOrPut$iv.add($i$f$getOrPut22);
        }
        if (generated.isEmpty()) {
            return;
        }
        if (irFunction.isFakeOverride()) {
            void $this$forEach$iv2;
            Sequence override = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)irFunction.getOverriddenSymbols()), (Function1)createBridges.2.INSTANCE), (Function1)((Function1)new Function1<IrSimpleFunction, Boolean>(this){
                final /* synthetic */ BridgeLowering this$0;

                public final boolean invoke(@NotNull IrSimpleFunction it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.isJvmAbstract(it, this.this$0.getContext().getState().getJvmDefaultMode());
                }
                {
                    this.this$0 = bridgeLowering;
                    super(1);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                void $this$mapTo$iv;
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv;
                IrSimpleFunction override2 = (IrSimpleFunction)element$iv;
                boolean bl11 = false;
                Iterable bl10 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.allOverridden$default(override2, false, 1, null);
                boolean $i$f$filter = false;
                void var16_49 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
                    boolean bl12 = false;
                    if (!(!it.isFakeOverride())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                Collection destination$iv = blacklist;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    IrSimpleFunction irSimpleFunction5 = (IrSimpleFunction)item$iv;
                    Collection collection = destination$iv;
                    boolean bl13 = false;
                    Method method = this.getJvmMethod((IrFunction)it);
                    collection.add(method);
                }
            }
        }
        Iterable $this$filter$iv = generated.values();
        boolean $i$f$filter = false;
        Iterable signature2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Bridge it = (Bridge)element$iv$iv;
            boolean bl14 = false;
            if (!(!blacklist.contains(it.getSignature()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Bridge it = (Bridge)element$iv;
            boolean bl15 = false;
            this.addBridge(irClass2, it, bridgeTarget);
        }
    }

    private final SpecialBridge getSpecialBridgeOrNull(IrSimpleFunction $this$specialBridgeOrNull) {
        return this.context.getBridgeLoweringCache$backend_jvm().computeSpecialBridge($this$specialBridgeOrNull);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Method> overriddenFinalSpecialBridges(IrSimpleFunction $this$overriddenFinalSpecialBridges) {
        void var3_4;
        void $this$mapNotNullTo$iv;
        Iterable iterable = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.allOverridden$default($this$overriddenFinalSpecialBridges, false, 1, null);
        boolean bl = false;
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl3 = false;
            if (IrUtilsKt.isInterface(IrUtilsKt.getParentAsClass(it)) || org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.isFromJava(it)) {
                object = null;
            } else {
                Object object2 = this.getSpecialBridgeOrNull(it);
                if (object2 != null && (object2 = ((SpecialBridge)object2).getSignature()) != null) {
                    Object object3 = object2;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Object bridgeSignature = object3;
                    boolean bl6 = false;
                    object = Intrinsics.areEqual((Object)bridgeSignature, (Object)this.getJvmMethod(it)) ^ true ? object3 : null;
                } else {
                    object = null;
                }
            }
            if (object == null) continue;
            Object object4 = object;
            boolean bl7 = false;
            boolean bl8 = false;
            Object it$iv = object4;
            boolean bl9 = false;
            destination$iv.add(it$iv);
        }
        return (List)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SpecialBridge> overriddenSpecialBridges(IrSimpleFunction $this$overriddenSpecialBridges) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Method targetJvmMethod = MethodSignatureMapper.mapCalleeToAsmMethod$backend_jvm$default(this.context.getMethodSignatureMapper(), $this$overriddenSpecialBridges, false, 2, null);
        Iterable $this$filter$iv = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.allOverridden$default($this$overriddenSpecialBridges, false, 1, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrSimpleFunction)element$iv$iv;
            boolean bl = false;
            if (!(IrUtilsKt.isInterface(IrUtilsKt.getParentAsClass((IrDeclaration)it)) || org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.isFromJava((IrDeclaration)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            SpecialBridge specialBridge;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            IrSimpleFunction it2 = (IrSimpleFunction)element$iv$iv;
            boolean bl2 = false;
            if (this.getSpecialBridgeOrNull(it2) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            SpecialBridge it$iv$iv = specialBridge;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SpecialBridge)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)((SpecialBridge)it).getSignature(), (Object)targetJvmMethod) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SpecialBridge)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean bl6 = false;
            SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo = null;
            boolean bl7 = true;
            IrClassSymbol irClassSymbol = null;
            boolean bl8 = false;
            SpecialBridge specialBridge = SpecialBridge.copy$default((SpecialBridge)it, null, null, false, null, null, specialMethodWithDefaultInfo, irClassSymbol, bl8, bl7, bl6, 607, null);
            collection.add(specialBridge);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction addAbstractMethodStub(IrClass $this$addAbstractMethodStub, IrSimpleFunction irFunction) {
        Collection<IrValueParameter> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrClass $this$addFunction$iv = $this$addAbstractMethodStub;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction2 = false;
        Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
        boolean $i$f$buildFun22 = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionBuilder $this$run$iv$iv$iv = irFunctionBuilder;
        boolean bl3 = false;
        IrFunctionBuilder $this$addFunction = $this$run$iv$iv$iv;
        boolean bl4 = false;
        $this$addFunction.updateFrom(irFunction);
        $this$addFunction.setModality(Modality.ABSTRACT);
        $this$addFunction.setOrigin(JvmLoweredDeclarationOrigin.ABSTRACT_BRIDGE_STUB.INSTANCE);
        $this$addFunction.setName(irFunction.getName());
        $this$addFunction.setReturnType(irFunction.getReturnType());
        $this$addFunction.setFakeOverride(false);
        $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$run$iv$iv$iv);
        $i$f$buildFun22 = false;
        boolean bl5 = false;
        Object function$iv$iv = $this$buildFun$iv$iv$iv;
        boolean $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
        function$iv$iv.setParent($this$addFunction$iv);
        Object object = $this$buildFun$iv$iv$iv;
        boolean bl6 = false;
        boolean bl7 = false;
        Object $this$apply = object;
        boolean bl8 = false;
        org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.copyCorrespondingPropertyFrom((IrSimpleFunction)$this$apply, irFunction);
        IrValueParameter irValueParameter = $this$addAbstractMethodStub.getThisReceiver();
        ((IrFunction)$this$apply).setDispatchReceiverParameter(irValueParameter != null ? org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(irValueParameter, (IrFunction)$this$apply, null, 0, 0, 0, null, null, IrUtilsKt.getDefaultType($this$addAbstractMethodStub), null, null, false, false, false, 8062, null) : null);
        Iterable $i$f$buildFun22 = irFunction.getValueParameters();
        Object object2 = $this$apply;
        boolean $i$f$map = false;
        void $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void param;
            IrValueParameter irValueParameter2 = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl9 = false;
            IrValueParameter irValueParameter3 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)param, (IrFunction)$this$apply, null, 0, 0, 0, null, null, param.getType(), null, null, false, false, false, 8062, null);
            collection.add(irValueParameter3);
        }
        collection = (List)destination$iv$iv;
        ((IrFunction)object2).setValueParameters((List<? extends IrValueParameter>)collection);
        $this$apply.setOverriddenSymbols(CollectionsKt.toList((Iterable)irFunction.getOverriddenSymbols()));
        return object;
    }

    private final DescriptorVisibility getBridgeVisibility(Bridge bridge) {
        DescriptorVisibility descriptorVisibility;
        DescriptorVisibility overriddenVisibility;
        if (Intrinsics.areEqual((Object)bridge.getOverridden().getName().asString(), (Object)"clone")) {
            IrDeclarationWithName irDeclarationWithName = IrUtilsKt.getParentAsClass(bridge.getOverridden());
            FqName fqName2 = StandardNames.FqNames.cloneable.toSafe();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"StandardNames.FqNames.cloneable.toSafe()");
            if (AdditionalIrUtilsKt.hasEqualFqName(irDeclarationWithName, fqName2)) {
                DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"DescriptorVisibilities.PUBLIC");
                return descriptorVisibility2;
            }
        }
        if (Intrinsics.areEqual((Object)(overriddenVisibility = bridge.getOverridden().getVisibility()), (Object)DescriptorVisibilities.INTERNAL)) {
            DescriptorVisibility descriptorVisibility3 = DescriptorVisibilities.PUBLIC;
            descriptorVisibility = descriptorVisibility3;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility3, (String)"DescriptorVisibilities.PUBLIC");
        } else {
            descriptorVisibility = overriddenVisibility;
        }
        return descriptorVisibility;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction addBridge(IrClass $this$addBridge, Bridge bridge, IrSimpleFunction target) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void destination$iv;
        Iterable $this$flatMapTo$iv;
        Iterable destination$iv2;
        void $this$flatMapTo$iv2;
        void $this$run;
        IrClass $this$addFunction$iv = $this$addBridge;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction2 = false;
        Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
        boolean $i$f$buildFun22 = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionBuilder $this$run$iv$iv$iv = irFunctionBuilder;
        boolean bl3 = false;
        IrFunctionBuilder $this$addFunction = $this$run$iv$iv$iv;
        boolean bl4 = false;
        $this$addFunction.setStartOffset($this$addBridge.getStartOffset());
        $this$addFunction.setEndOffset($this$addBridge.getStartOffset());
        $this$addFunction.setModality(Modality.OPEN);
        $this$addFunction.setOrigin(IrDeclarationOrigin.BRIDGE.INSTANCE);
        $this$addFunction.setVisibility(this.getBridgeVisibility(bridge));
        Name name = Name.identifier(bridge.getSignature().getName());
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(bridge.signature.name)");
        $this$addFunction.setName(name);
        $this$addFunction.setReturnType(org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.eraseTypeParameters(bridge.getOverridden().getReturnType()));
        $this$addFunction.setSuspend(bridge.getOverridden().isSuspend());
        $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$run$iv$iv$iv);
        $i$f$buildFun22 = false;
        boolean bl5 = false;
        Object function$iv$iv322 = $this$buildFun$iv$iv$iv;
        boolean $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv322);
        function$iv$iv322.setParent($this$addFunction$iv);
        Object object = $this$buildFun$iv$iv$iv;
        boolean bl6 = false;
        boolean bl7 = false;
        Object $this$apply = object;
        boolean bl8 = false;
        BridgeLowering.copyParametersWithErasure$default(this, (IrSimpleFunction)$this$apply, $this$addBridge, bridge.getOverridden(), null, 4, null);
        DeclarationIrBuilder $i$f$buildFun22 = LowerUtilsKt.createIrBuilder(this.context, ((IrFunction)$this$apply).getSymbol(), $this$apply.getStartOffset(), $this$apply.getEndOffset());
        bl5 = false;
        boolean function$iv$iv322 = false;
        DeclarationIrBuilder $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = $i$f$buildFun22;
        Object object2 = $this$apply;
        boolean bl9 = false;
        Object object3 = ExpressionHelpersKt.irExprBody((IrBuilderWithScope)$this$run, BridgeLowering.delegatingCall$default(this, (IrBuilderWithScope)$this$run, (IrSimpleFunction)$this$apply, target, null, 4, null));
        ((IrFunction)object2).setBody((IrBody)object3);
        Iterable iterable = bridge.getOverriddenSymbols();
        function$iv$iv322 = false;
        Collection function$iv$iv322 = new LinkedHashSet();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv : $this$flatMapTo$iv2) {
            Object object4;
            IrSimpleFunctionSymbol function2 = (IrSimpleFunctionSymbol)element$iv;
            boolean bl10 = false;
            Object $this$safeAs$iv = function2.getOwner();
            boolean $i$f$safeAs = false;
            Object b = $this$safeAs$iv;
            if (!(b instanceof IrSimpleFunction)) {
                b = null;
            }
            if ((object4 = (IrSimpleFunction)b) == null || (object4 = object4.getOverriddenSymbols()) == null) {
                object4 = CollectionsKt.emptyList();
            }
            Iterable list$iv = (Iterable)object4;
            CollectionsKt.addAll((Collection)destination$iv2, (Iterable)list$iv);
        }
        Set inheritedOverrides = (Set)destination$iv2;
        destination$iv2 = inheritedOverrides;
        $i$f$flatMapTo22 = false;
        Collection $i$f$flatMapTo22 = new LinkedHashSet();
        boolean $i$f$flatMapTo32 = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            void $this$mapTo$iv$iv;
            IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
            boolean bl11 = false;
            Iterable $this$map$iv = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.allOverridden$default((IrSimpleFunction)it.getOwner(), false, 1, null);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void override;
                IrSimpleFunction irSimpleFunction = (IrSimpleFunction)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl12 = false;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)override.getSymbol();
                collection.add(irSimpleFunctionSymbol);
            }
            Iterable list$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        Set redundantOverrides = (Set)destination$iv;
        $this$flatMapTo$iv = inheritedOverrides;
        object2 = $this$apply;
        boolean $i$f$filter = false;
        void $i$f$flatMapTo32 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv$iv;
            boolean bl13 = false;
            if (!(!redundantOverrides.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object3 = (List)destination$iv$iv;
        object2.setOverriddenSymbols(object3);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction addSpecialBridge(IrClass $this$addSpecialBridge, SpecialBridge specialBridge, IrSimpleFunction target) {
        void $this$irBlockBody;
        void this_$iv$iv;
        IrClass $this$addFunction$iv = $this$addSpecialBridge;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction2 = false;
        Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
        boolean $i$f$buildFun = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        Object $this$run$iv$iv$iv = irFunctionBuilder;
        boolean bl3 = false;
        IrFunctionBuilder $this$addFunction = $this$run$iv$iv$iv;
        boolean bl4 = false;
        $this$addFunction.setStartOffset($this$addSpecialBridge.getStartOffset());
        $this$addFunction.setEndOffset($this$addSpecialBridge.getStartOffset());
        $this$addFunction.setModality(specialBridge.isFinal() ? Modality.FINAL : Modality.OPEN);
        $this$addFunction.setOrigin(specialBridge.isSynthetic() ? (IrDeclarationOrigin)IrDeclarationOrigin.BRIDGE.INSTANCE : (IrDeclarationOrigin)IrDeclarationOrigin.BRIDGE_SPECIAL.INSTANCE);
        Name name = Name.identifier(specialBridge.getSignature().getName());
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(specialBridge.signature.name)");
        $this$addFunction.setName(name);
        IrType irType = specialBridge.getSubstitutedReturnType();
        if (irType == null || (irType = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.eraseToScope(irType, IrUtilsKt.getParentAsClass(target))) == null) {
            irType = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.eraseTypeParameters(specialBridge.getOverridden().getReturnType());
        }
        $this$addFunction.setReturnType(irType);
        $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, (IrFunctionBuilder)$this$run$iv$iv$iv);
        $i$f$buildFun = false;
        boolean bl5 = false;
        Object function$iv$iv = $this$buildFun$iv$iv$iv;
        boolean bl6 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
        function$iv$iv.setParent($this$addFunction$iv);
        Object object = $this$buildFun$iv$iv$iv;
        boolean bl7 = false;
        boolean bl8 = false;
        Object $this$apply = object;
        boolean bl9 = false;
        this.context.getFunctionsWithSpecialBridges$backend_jvm().add(target);
        this.copyParametersWithErasure((IrSimpleFunction)$this$apply, $this$addSpecialBridge, specialBridge.getOverridden(), specialBridge.getSubstitutedParameterTypes());
        IrBuilderWithScope $this$irBlockBody$iv = LowerUtilsKt.createIrBuilder(this.context, ((IrFunction)$this$apply).getSymbol(), $this$apply.getStartOffset(), $this$apply.getEndOffset());
        int startOffset$iv = $this$irBlockBody$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        $this$run$iv$iv$iv = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        $this$addFunction = this_$iv$iv;
        Object object2 = $this$apply;
        boolean bl10 = false;
        SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo = specialBridge.getMethodInfo();
        if (specialMethodWithDefaultInfo != null) {
            SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo2 = specialMethodWithDefaultInfo;
            boolean bl11 = false;
            boolean bl12 = false;
            SpecialMethodWithDefaultInfo info = specialMethodWithDefaultInfo2;
            boolean bl13 = false;
            Iterable $this$forEach$iv = CollectionsKt.take((Iterable)((IrFunction)$this$apply).getValueParameters(), (int)info.getArgumentsToCheck());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl14 = false;
                $this$irBlockBody.unaryPlus(this.parameterTypeCheck((IrBuilderWithScope)$this$irBlockBody, it, target.getValueParameters().get(it.getIndex()).getType(), (IrExpression)info.getDefaultValueGenerator().invoke($this$apply)));
            }
        }
        $this$irBlockBody.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$irBlockBody, this.delegatingCall((IrBuilderWithScope)$this$irBlockBody, (IrSimpleFunction)$this$apply, target, specialBridge.getSuperQualifierSymbol())));
        Unit unit = Unit.INSTANCE;
        ((IrFunction)object2).setBody(this_$iv$iv.doBuild());
        if (specialBridge.isOverriding()) {
            $this$apply.setOverriddenSymbols(CollectionsKt.listOf((Object)specialBridge.getOverridden().getSymbol()));
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private final void rewriteSpecialMethodBody(IrSimpleFunction $this$rewriteSpecialMethodBody, Method ourSignature, Method specialOverrideSignature, SpecialMethodWithDefaultInfo specialOverrideInfo) {
        block18: {
            block17: {
                block16: {
                    block15: {
                        var6_5 = false;
                        variableMap = new LinkedHashMap<K, V>();
                        if (!Intrinsics.areEqual((Object)specialOverrideSignature, (Object)ourSignature)) break block16;
                        argumentsToCheck = CollectionsKt.take((Iterable)$this$rewriteSpecialMethodBody.getValueParameters(), (int)specialOverrideInfo.getArgumentsToCheck());
                        $this$any$iv = argumentsToCheck;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v0 = false;
                        } else {
                            var10_12 = $this$any$iv.iterator();
                            while (var10_12.hasNext()) {
                                element$iv = var10_12.next();
                                it = (IrValueParameter)element$iv;
                                $i$a$-any-BridgeLowering$rewriteSpecialMethodBody$shouldGenerateParameterChecks$1 = false;
                                if (!(IrTypeUtilsKt.isNullable(it.getType()) == false)) continue;
                                v0 = true;
                                break block15;
                            }
                            v0 = shouldGenerateParameterChecks = false;
                        }
                    }
                    if (shouldGenerateParameterChecks) {
                        $this$any$iv = LowerUtilsKt.createIrBuilder$default(this.context, $this$rewriteSpecialMethodBody.getSymbol(), 0, 0, 6, null);
                        $i$f$any = false;
                        var10_13 = false;
                        $this$run = $this$any$iv;
                        $i$a$-run-BridgeLowering$rewriteSpecialMethodBody$1 = false;
                        $this$irBlockBody$iv = (IrBuilderWithScope)$this$run;
                        startOffset$iv = $this$irBlockBody$iv.getStartOffset();
                        endOffset$iv = $this$irBlockBody$iv.getEndOffset();
                        $i$f$irBlockBody = false;
                        var17_30 = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), startOffset$iv, endOffset$iv);
                        $i$f$blockBody = false;
                        var19_34 = this_$iv$iv;
                        var20_36 = $this$rewriteSpecialMethodBody;
                        $i$a$-irBlockBody-BridgeLowering$rewriteSpecialMethodBody$1$1 = false;
                        newValueParameters = new ArrayList<IrValueParameter>((Collection)$this$rewriteSpecialMethodBody.getValueParameters());
                        $this$forEach$iv = argumentsToCheck;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (IrValueParameter)element$iv;
                            $i$a$-forEach-BridgeLowering$rewriteSpecialMethodBody$1$1$1 = false;
                            parameterType = it.getType();
                            if (IrTypeUtilsKt.isNullable(parameterType)) continue;
                            newParameter = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)it, $this$rewriteSpecialMethodBody, null, 0, 0, 0, null, null, IrTypesKt.makeNullable(parameterType), null, null, false, false, false, 8062, null);
                            variableMap.put($this$rewriteSpecialMethodBody.getValueParameters().get(it.getIndex()), newParameter);
                            newValueParameters.set(it.getIndex(), newParameter);
                            $this$irBlockBody.unaryPlus(this.parameterTypeCheck((IrBuilderWithScope)$this$irBlockBody, newParameter, parameterType, (IrExpression)specialOverrideInfo.getDefaultValueGenerator().invoke((Object)$this$rewriteSpecialMethodBody)));
                        }
                        $this$rewriteSpecialMethodBody.setValueParameters((List<? extends IrValueParameter>)newValueParameters);
                        if ($this$rewriteSpecialMethodBody.getBody() instanceof IrExpressionBody) {
                            v1 = $this$rewriteSpecialMethodBody.getBody();
                            if (v1 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpressionBody");
                            }
                            $this$irBlockBody.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$irBlockBody, ((IrExpressionBody)v1).getExpression()));
                        } else {
                            v2 = $this$rewriteSpecialMethodBody.getBody();
                            if (v2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                            }
                            $this$forEach$iv = ((IrBlockBody)v2).getStatements();
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                it = (IrStatement)element$iv;
                                $i$a$-forEach-BridgeLowering$rewriteSpecialMethodBody$1$1$2 = false;
                                $this$irBlockBody.unaryPlus(it);
                            }
                        }
                        var31_47 = Unit.INSTANCE;
                        var20_36.setBody(this_$iv$iv.doBuild());
                    }
                    break block17;
                }
                argumentsToCheck = $this$rewriteSpecialMethodBody.getValueParameters();
                var32_48 = $this$rewriteSpecialMethodBody;
                $i$f$mapIndexed = false;
                $this$any$iv = $this$mapIndexed$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                $i$f$mapIndexedTo = false;
                index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    var14_25 = index$iv$iv++;
                    var15_27 = false;
                    if (var14_25 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    $i$f$irBlockBody = (IrValueParameter)item$iv$iv;
                    this_$iv$iv = var14_25;
                    var33_49 = destination$iv$iv;
                    $i$a$-mapIndexed-BridgeLowering$rewriteSpecialMethodBody$2 = false;
                    if (!AsmUtil.isPrimitive(IrTypeMapper.mapType$default(this.context.getTypeMapper(), p.getType(), null, null, 6, null))) ** GOTO lbl-1000
                    v3 = ourSignature.getArgumentTypes()[i];
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"ourSignature.argumentTypes[i]");
                    if (v3.getSort() == 10) {
                        newParameter = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)p, $this$rewriteSpecialMethodBody, null, 0, 0, 0, null, null, IrTypesKt.makeNullable(p.getType()), null, null, false, false, false, 8062, null);
                        variableMap.put(p, newParameter);
                        v4 = newParameter;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = p;
                    }
                    var34_50 = v4;
                    var33_49.add(var34_50);
                }
                var33_49 = (List)destination$iv$iv;
                var32_48.setValueParameters((List<? extends IrValueParameter>)var33_49);
            }
            var6_6 = variableMap;
            var7_23 = false;
            if (!(var6_6.isEmpty() == false)) break block18;
            v5 = $this$rewriteSpecialMethodBody.getBody();
            if (v5 != null) {
                v5.transform((IrElementTransformer)new VariableRemapper(variableMap), (Object)null);
            }
        }
    }

    private final IrIfThenElseImpl parameterTypeCheck(IrBuilderWithScope $this$parameterTypeCheck, IrValueParameter parameter, IrType type2, IrExpression defaultValue) {
        return ExpressionHelpersKt.irIfThen$default($this$parameterTypeCheck, $this$parameterTypeCheck.getContext().getIrBuiltIns().getUnitType(), LowerUtilsKt.irNot($this$parameterTypeCheck, ExpressionHelpersKt.irIs($this$parameterTypeCheck, ExpressionHelpersKt.irGet($this$parameterTypeCheck, parameter), type2)), ExpressionHelpersKt.irReturn($this$parameterTypeCheck, defaultValue), null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void copyParametersWithErasure(IrSimpleFunction $this$copyParametersWithErasure, IrClass irClass2, IrSimpleFunction from, List<? extends IrType> substitutedParameterTypes) {
        List list2;
        IrSimpleFunction irSimpleFunction;
        Set<IrTypeParameter> visibleTypeParameters = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.collectVisibleTypeParameters($this$copyParametersWithErasure);
        IrValueParameter irValueParameter = irClass2.getThisReceiver();
        $this$copyParametersWithErasure.setDispatchReceiverParameter(irValueParameter != null ? org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(irValueParameter, $this$copyParametersWithErasure, null, 0, 0, 0, null, null, IrUtilsKt.getDefaultType(irClass2), null, null, false, false, false, 8062, null) : null);
        IrValueParameter irValueParameter2 = from.getExtensionReceiverParameter();
        $this$copyParametersWithErasure.setExtensionReceiverParameter(irValueParameter2 != null ? BridgeLowering.copyWithTypeErasure$default(this, irValueParameter2, $this$copyParametersWithErasure, visibleTypeParameters, null, 4, null) : null);
        IrSimpleFunction irSimpleFunction2 = $this$copyParametersWithErasure;
        if (substitutedParameterTypes != null) {
            Collection<IrValueParameter> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = CollectionsKt.zip((Iterable)from.getValueParameters(), (Iterable)substitutedParameterTypes);
            IrSimpleFunction irSimpleFunction3 = irSimpleFunction2;
            boolean $i$f$map = false;
            void var8_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void param;
                void $dstr$param$type;
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                IrValueParameter irValueParameter3 = (IrValueParameter)$dstr$param$type.component1();
                IrType type2 = (IrType)$dstr$param$type.component2();
                IrValueParameter irValueParameter4 = this.copyWithTypeErasure((IrValueParameter)param, $this$copyParametersWithErasure, visibleTypeParameters, type2);
                collection.add(irValueParameter4);
            }
            collection = (List)destination$iv$iv;
            irSimpleFunction = irSimpleFunction3;
            list2 = collection;
        } else {
            Collection<IrValueParameter> collection;
            Iterable $this$map$iv = from.getValueParameters();
            IrSimpleFunction irSimpleFunction4 = irSimpleFunction2;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrValueParameter $dstr$param$type = (IrValueParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                IrValueParameter irValueParameter5 = BridgeLowering.copyWithTypeErasure$default(this, (IrValueParameter)it, $this$copyParametersWithErasure, visibleTypeParameters, null, 4, null);
                collection.add(irValueParameter5);
            }
            collection = (List)destination$iv$iv;
            irSimpleFunction = irSimpleFunction4;
            list2 = collection;
        }
        irSimpleFunction.setValueParameters(list2);
    }

    static /* synthetic */ void copyParametersWithErasure$default(BridgeLowering bridgeLowering, IrSimpleFunction irSimpleFunction, IrClass irClass2, IrSimpleFunction irSimpleFunction2, List list2, int n, Object object) {
        if ((n & 4) != 0) {
            list2 = null;
        }
        bridgeLowering.copyParametersWithErasure(irSimpleFunction, irClass2, irSimpleFunction2, list2);
    }

    private final IrValueParameter copyWithTypeErasure(IrValueParameter $this$copyWithTypeErasure, IrSimpleFunction target, Set<? extends IrTypeParameter> visibleTypeParameters, IrType substitutedType) {
        IrFunction irFunction = target;
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.BRIDGE.INSTANCE;
        IrType irType = substitutedType;
        if (irType == null || (irType = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.eraseToScope(irType, visibleTypeParameters)) == null) {
            irType = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.eraseTypeParameters($this$copyWithTypeErasure.getType());
        }
        IrType irType2 = $this$copyWithTypeErasure.getVarargElementType();
        return org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default($this$copyWithTypeErasure, irFunction, irDeclarationOrigin, 0, 0, 0, null, null, irType, irType2 != null ? org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.eraseToScope(irType2, visibleTypeParameters) : null, null, false, false, false, 7804, null);
    }

    static /* synthetic */ IrValueParameter copyWithTypeErasure$default(BridgeLowering bridgeLowering, IrValueParameter irValueParameter, IrSimpleFunction irSimpleFunction, Set set, IrType irType, int n, Object object) {
        if ((n & 4) != 0) {
            irType = null;
        }
        return bridgeLowering.copyWithTypeErasure(irValueParameter, irSimpleFunction, set, irType);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression delegatingCall(IrBuilderWithScope $this$delegatingCall, IrSimpleFunction bridge, IrSimpleFunction target, IrClassSymbol superQualifierSymbol) {
        IrCall irCall = ExpressionHelpersKt.irCall($this$delegatingCall, target, IrStatementOrigin.BRIDGE_DELEGATION.INSTANCE, superQualifierSymbol);
        boolean bl = false;
        boolean bl2 = false;
        IrCall irCall2 = irCall;
        IrBuilderWithScope irBuilderWithScope = $this$delegatingCall;
        BridgeLowering bridgeLowering = this;
        boolean bl3 = false;
        for (Pair pair : CollectionsKt.zip((Iterable)IrUtilsKt.getExplicitParameters(bridge), (Iterable)IrUtilsKt.getExplicitParameters(target))) {
            void argument;
            void $this$apply;
            void param;
            IrValueParameter irValueParameter = (IrValueParameter)pair.component1();
            IrValueParameter targetParam = (IrValueParameter)pair.component2();
            IrGetValueImpl irGetValueImpl = ExpressionHelpersKt.irGet($this$delegatingCall, (IrValueDeclaration)param);
            boolean bl4 = false;
            boolean bl5 = false;
            IrGetValueImpl irGetValueImpl2 = irGetValueImpl;
            IrValueParameter irValueParameter2 = targetParam;
            IrFunctionAccessExpression irFunctionAccessExpression = (IrFunctionAccessExpression)$this$apply;
            boolean bl6 = false;
            IrExpression irExpression = Intrinsics.areEqual((Object)param, (Object)bridge.getDispatchReceiverParameter()) ? (IrExpression)argument : this.irCastIfNeeded($this$delegatingCall, (IrExpression)argument, org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.getUpperBound(targetParam.getType()));
            IrFunctionAccessExpressionKt.putArgument(irFunctionAccessExpression, irValueParameter2, irExpression);
        }
        Unit unit = Unit.INSTANCE;
        return bridgeLowering.irCastIfNeeded(irBuilderWithScope, irCall, org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.getUpperBound(bridge.getReturnType()));
    }

    static /* synthetic */ IrExpression delegatingCall$default(BridgeLowering bridgeLowering, IrBuilderWithScope irBuilderWithScope, IrSimpleFunction irSimpleFunction, IrSimpleFunction irSimpleFunction2, IrClassSymbol irClassSymbol, int n, Object object) {
        if ((n & 4) != 0) {
            irClassSymbol = null;
        }
        return bridgeLowering.delegatingCall(irBuilderWithScope, irSimpleFunction, irSimpleFunction2, irClassSymbol);
    }

    private final IrExpression irCastIfNeeded(IrBuilderWithScope $this$irCastIfNeeded, IrExpression expression2, IrType to) {
        return Intrinsics.areEqual((Object)expression2.getType(), (Object)to) || IrTypePredicatesKt.isAny(to) || IrTypePredicatesKt.isNullableAny(to) ? expression2 : (IrExpression)ExpressionHelpersKt.irImplicitCast($this$irCastIfNeeded, expression2, to);
    }

    private final Method getJvmMethod(IrFunction $this$jvmMethod) {
        return this.context.getBridgeLoweringCache$backend_jvm().computeJvmMethod($this$jvmMethod);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public BridgeLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        boolean bl = false;
        this.potentialBridgeTargets = new ArrayList();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/BridgeLowering$Bridge;", "", "overridden", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "signature", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "overriddenSymbols", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;Lorg/jetbrains/org/objectweb/asm/commons/Method;Ljava/util/List;)V", "getOverridden", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getOverriddenSymbols", "()Ljava/util/List;", "getSignature", "()Lorg/jetbrains/org/objectweb/asm/commons/Method;", "backend.jvm"})
    private static final class Bridge {
        @NotNull
        private final IrSimpleFunction overridden;
        @NotNull
        private final Method signature;
        @NotNull
        private final List<IrSimpleFunctionSymbol> overriddenSymbols;

        @NotNull
        public final IrSimpleFunction getOverridden() {
            return this.overridden;
        }

        @NotNull
        public final Method getSignature() {
            return this.signature;
        }

        @NotNull
        public final List<IrSimpleFunctionSymbol> getOverriddenSymbols() {
            return this.overriddenSymbols;
        }

        public Bridge(@NotNull IrSimpleFunction overridden, @NotNull Method signature2, @NotNull List<IrSimpleFunctionSymbol> overriddenSymbols2) {
            Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
            Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
            Intrinsics.checkNotNullParameter(overriddenSymbols2, (String)"overriddenSymbols");
            this.overridden = overridden;
            this.signature = signature2;
            this.overriddenSymbols = overriddenSymbols2;
        }

        public /* synthetic */ Bridge(IrSimpleFunction irSimpleFunction, Method method, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                boolean bl = false;
                list2 = new ArrayList();
            }
            this(irSimpleFunction, method, list2);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001Bs\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0013J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J\u0011\u0010&\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\t\u0010*\u001a\u00020\u0007H\u00c6\u0003J\t\u0010+\u001a\u00020\u0007H\u00c6\u0003J{\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00072\b\b\u0002\u0010\u0011\u001a\u00020\u00072\b\b\u0002\u0010\u0012\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010-\u001a\u00020\u00072\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u000202H\u00d6\u0001R\u0011\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0014R\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0014R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/BridgeLowering$SpecialBridge;", "", "overridden", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "signature", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "needsGenericSignature", "", "substitutedParameterTypes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "substitutedReturnType", "methodInfo", "Lorg/jetbrains/kotlin/backend/common/lower/SpecialMethodWithDefaultInfo;", "superQualifierSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "isFinal", "isSynthetic", "isOverriding", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;Lorg/jetbrains/org/objectweb/asm/commons/Method;ZLjava/util/List;Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/backend/common/lower/SpecialMethodWithDefaultInfo;Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;ZZZ)V", "()Z", "getMethodInfo", "()Lorg/jetbrains/kotlin/backend/common/lower/SpecialMethodWithDefaultInfo;", "getNeedsGenericSignature", "getOverridden", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getSignature", "()Lorg/jetbrains/org/objectweb/asm/commons/Method;", "getSubstitutedParameterTypes", "()Ljava/util/List;", "getSubstitutedReturnType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "getSuperQualifierSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "", "backend.jvm"})
    public static final class SpecialBridge {
        @NotNull
        private final IrSimpleFunction overridden;
        @NotNull
        private final Method signature;
        private final boolean needsGenericSignature;
        @Nullable
        private final List<IrType> substitutedParameterTypes;
        @Nullable
        private final IrType substitutedReturnType;
        @Nullable
        private final SpecialMethodWithDefaultInfo methodInfo;
        @Nullable
        private final IrClassSymbol superQualifierSymbol;
        private final boolean isFinal;
        private final boolean isSynthetic;
        private final boolean isOverriding;

        @NotNull
        public final IrSimpleFunction getOverridden() {
            return this.overridden;
        }

        @NotNull
        public final Method getSignature() {
            return this.signature;
        }

        public final boolean getNeedsGenericSignature() {
            return this.needsGenericSignature;
        }

        @Nullable
        public final List<IrType> getSubstitutedParameterTypes() {
            return this.substitutedParameterTypes;
        }

        @Nullable
        public final IrType getSubstitutedReturnType() {
            return this.substitutedReturnType;
        }

        @Nullable
        public final SpecialMethodWithDefaultInfo getMethodInfo() {
            return this.methodInfo;
        }

        @Nullable
        public final IrClassSymbol getSuperQualifierSymbol() {
            return this.superQualifierSymbol;
        }

        public final boolean isFinal() {
            return this.isFinal;
        }

        public final boolean isSynthetic() {
            return this.isSynthetic;
        }

        public final boolean isOverriding() {
            return this.isOverriding;
        }

        public SpecialBridge(@NotNull IrSimpleFunction overridden, @NotNull Method signature2, boolean needsGenericSignature, @Nullable List<? extends IrType> substitutedParameterTypes, @Nullable IrType substitutedReturnType, @Nullable SpecialMethodWithDefaultInfo methodInfo, @Nullable IrClassSymbol superQualifierSymbol, boolean isFinal, boolean isSynthetic, boolean isOverriding) {
            Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
            Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
            this.overridden = overridden;
            this.signature = signature2;
            this.needsGenericSignature = needsGenericSignature;
            this.substitutedParameterTypes = substitutedParameterTypes;
            this.substitutedReturnType = substitutedReturnType;
            this.methodInfo = methodInfo;
            this.superQualifierSymbol = superQualifierSymbol;
            this.isFinal = isFinal;
            this.isSynthetic = isSynthetic;
            this.isOverriding = isOverriding;
        }

        public /* synthetic */ SpecialBridge(IrSimpleFunction irSimpleFunction, Method method, boolean bl, List list2, IrType irType, SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo, IrClassSymbol irClassSymbol, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                list2 = null;
            }
            if ((n & 0x10) != 0) {
                irType = null;
            }
            if ((n & 0x20) != 0) {
                specialMethodWithDefaultInfo = null;
            }
            if ((n & 0x40) != 0) {
                irClassSymbol = null;
            }
            if ((n & 0x80) != 0) {
                bl2 = true;
            }
            if ((n & 0x100) != 0) {
                bl3 = false;
            }
            if ((n & 0x200) != 0) {
                bl4 = true;
            }
            this(irSimpleFunction, method, bl, list2, irType, specialMethodWithDefaultInfo, irClassSymbol, bl2, bl3, bl4);
        }

        @NotNull
        public final IrSimpleFunction component1() {
            return this.overridden;
        }

        @NotNull
        public final Method component2() {
            return this.signature;
        }

        public final boolean component3() {
            return this.needsGenericSignature;
        }

        @Nullable
        public final List<IrType> component4() {
            return this.substitutedParameterTypes;
        }

        @Nullable
        public final IrType component5() {
            return this.substitutedReturnType;
        }

        @Nullable
        public final SpecialMethodWithDefaultInfo component6() {
            return this.methodInfo;
        }

        @Nullable
        public final IrClassSymbol component7() {
            return this.superQualifierSymbol;
        }

        public final boolean component8() {
            return this.isFinal;
        }

        public final boolean component9() {
            return this.isSynthetic;
        }

        public final boolean component10() {
            return this.isOverriding;
        }

        @NotNull
        public final SpecialBridge copy(@NotNull IrSimpleFunction overridden, @NotNull Method signature2, boolean needsGenericSignature, @Nullable List<? extends IrType> substitutedParameterTypes, @Nullable IrType substitutedReturnType, @Nullable SpecialMethodWithDefaultInfo methodInfo, @Nullable IrClassSymbol superQualifierSymbol, boolean isFinal, boolean isSynthetic, boolean isOverriding) {
            Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
            Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
            return new SpecialBridge(overridden, signature2, needsGenericSignature, substitutedParameterTypes, substitutedReturnType, methodInfo, superQualifierSymbol, isFinal, isSynthetic, isOverriding);
        }

        public static /* synthetic */ SpecialBridge copy$default(SpecialBridge specialBridge, IrSimpleFunction irSimpleFunction, Method method, boolean bl, List list2, IrType irType, SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo, IrClassSymbol irClassSymbol, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                irSimpleFunction = specialBridge.overridden;
            }
            if ((n & 2) != 0) {
                method = specialBridge.signature;
            }
            if ((n & 4) != 0) {
                bl = specialBridge.needsGenericSignature;
            }
            if ((n & 8) != 0) {
                list2 = specialBridge.substitutedParameterTypes;
            }
            if ((n & 0x10) != 0) {
                irType = specialBridge.substitutedReturnType;
            }
            if ((n & 0x20) != 0) {
                specialMethodWithDefaultInfo = specialBridge.methodInfo;
            }
            if ((n & 0x40) != 0) {
                irClassSymbol = specialBridge.superQualifierSymbol;
            }
            if ((n & 0x80) != 0) {
                bl2 = specialBridge.isFinal;
            }
            if ((n & 0x100) != 0) {
                bl3 = specialBridge.isSynthetic;
            }
            if ((n & 0x200) != 0) {
                bl4 = specialBridge.isOverriding;
            }
            return specialBridge.copy(irSimpleFunction, method, bl, list2, irType, specialMethodWithDefaultInfo, irClassSymbol, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "SpecialBridge(overridden=" + this.overridden + ", signature=" + this.signature + ", needsGenericSignature=" + this.needsGenericSignature + ", substitutedParameterTypes=" + this.substitutedParameterTypes + ", substitutedReturnType=" + this.substitutedReturnType + ", methodInfo=" + this.methodInfo + ", superQualifierSymbol=" + this.superQualifierSymbol + ", isFinal=" + this.isFinal + ", isSynthetic=" + this.isSynthetic + ", isOverriding=" + this.isOverriding + ")";
        }

        public int hashCode() {
            IrSimpleFunction irSimpleFunction = this.overridden;
            Method method = this.signature;
            int n = ((irSimpleFunction != null ? irSimpleFunction.hashCode() : 0) * 31 + (method != null ? ((Object)method).hashCode() : 0)) * 31;
            int n2 = this.needsGenericSignature ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            List<IrType> list2 = this.substitutedParameterTypes;
            IrType irType = this.substitutedReturnType;
            SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo = this.methodInfo;
            IrClassSymbol irClassSymbol = this.superQualifierSymbol;
            int n3 = (((((n + n2) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (irType != null ? ((Object)irType).hashCode() : 0)) * 31 + (specialMethodWithDefaultInfo != null ? ((Object)specialMethodWithDefaultInfo).hashCode() : 0)) * 31 + (irClassSymbol != null ? irClassSymbol.hashCode() : 0)) * 31;
            int n4 = this.isFinal ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            int n5 = (n3 + n4) * 31;
            int n6 = this.isSynthetic ? 1 : 0;
            if (n6 != 0) {
                n6 = 1;
            }
            int n7 = (n5 + n6) * 31;
            int n8 = this.isOverriding ? 1 : 0;
            if (n8 != 0) {
                n8 = 1;
            }
            return n7 + n8;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SpecialBridge)) break block3;
                    SpecialBridge specialBridge = (SpecialBridge)object;
                    if (!Intrinsics.areEqual((Object)this.overridden, (Object)specialBridge.overridden) || !Intrinsics.areEqual((Object)this.signature, (Object)specialBridge.signature) || this.needsGenericSignature != specialBridge.needsGenericSignature || !Intrinsics.areEqual(this.substitutedParameterTypes, specialBridge.substitutedParameterTypes) || !Intrinsics.areEqual((Object)this.substitutedReturnType, (Object)specialBridge.substitutedReturnType) || !Intrinsics.areEqual((Object)this.methodInfo, (Object)specialBridge.methodInfo) || !Intrinsics.areEqual((Object)this.superQualifierSymbol, (Object)specialBridge.superQualifierSymbol) || this.isFinal != specialBridge.isFinal || this.isSynthetic != specialBridge.isSynthetic || this.isOverriding != specialBridge.isOverriding) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/BridgeLowering$BridgeLoweringCache;", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "signatureCache", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "Lkotlin/collections/HashMap;", "specialBridgeMethods", "Lorg/jetbrains/kotlin/backend/common/lower/SpecialBridgeMethods;", "computeJvmMethod", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "computeSpecialBridge", "Lorg/jetbrains/kotlin/backend/jvm/lower/BridgeLowering$SpecialBridge;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "backend.jvm"})
    public static final class BridgeLoweringCache {
        private final SpecialBridgeMethods specialBridgeMethods;
        private final HashMap<IrFunctionSymbol, Method> signatureCache;
        private final JvmBackendContext context;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Method computeJvmMethod(@NotNull IrFunction function2) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            Map map2 = this.signatureCache;
            IrFunctionSymbol key$iv = function2.getSymbol();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Method answer$iv = this.context.getMethodSignatureMapper().mapAsmMethod(function2);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (Method)object;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final SpecialBridge computeSpecialBridge(@NotNull IrSimpleFunction function2) {
            SpecialMethodWithDefaultInfo specialMethodInfo;
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            IrPropertySymbol correspondingProperty2 = function2.getCorrespondingPropertySymbol();
            if (correspondingProperty2 != null) {
                if (!this.specialBridgeMethods.getSpecialPropertyNames().contains(((IrProperty)correspondingProperty2.getOwner()).getName())) {
                    return null;
                }
            } else if (!this.specialBridgeMethods.getSpecialMethodNames().contains(function2.getName())) {
                String string2 = function2.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"function.name.asString()");
                if (!StringsKt.startsWith$default((String)string2, (String)"removeAt-", (boolean)false, (int)2, null)) {
                    String string3 = function2.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"function.name.asString()");
                    if (!StringsKt.startsWith$default((String)string3, (String)"remove-", (boolean)false, (int)2, null)) {
                        return null;
                    }
                }
            }
            if ((specialMethodInfo = this.specialBridgeMethods.getSpecialMethodInfo(function2)) != null) {
                return new SpecialBridge(function2, this.computeJvmMethod(function2), specialMethodInfo.getNeedsGenericSignature(), null, null, specialMethodInfo, null, false, false, false, 984, null);
            }
            BuiltInWithDifferentJvmName specialBuiltInInfo = this.specialBridgeMethods.getBuiltInWithDifferentJvmName(function2);
            if (specialBuiltInInfo != null) {
                return new SpecialBridge(function2, this.computeJvmMethod(function2), specialBuiltInInfo.getNeedsGenericSignature(), null, null, null, null, false, false, specialBuiltInInfo.isOverriding(), 504, null);
            }
            for (IrSimpleFunctionSymbol overridden : function2.getOverriddenSymbols()) {
                Collection<IrValueParameter> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$mapIndexedTo$iv$iv;
                SpecialBridge specialBridge = this.computeSpecialBridge((IrSimpleFunction)overridden.getOwner());
                if (specialBridge == null) {
                    continue;
                }
                SpecialBridge specialBridge2 = specialBridge;
                if (!specialBridge2.getNeedsGenericSignature()) {
                    return specialBridge2;
                }
                SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo = specialBridge2.getMethodInfo();
                int erasedParameterCount = specialMethodWithDefaultInfo != null ? specialMethodWithDefaultInfo.getArgumentsToCheck() : 0;
                Iterable $this$mapIndexed$iv = function2.getValueParameters();
                boolean $i$f$mapIndexed = false;
                Iterable iterable = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void param;
                    void index2;
                    int n = index$iv$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                    int n2 = n;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    IrType irType = index2 < erasedParameterCount ? this.context.getIrBuiltIns().getAnyNType() : param.getType();
                    collection2.add(irType);
                }
                List substitutedParameterTypes = (List)destination$iv$iv;
                IrFactory $this$buildFun$iv = this.context.getIrFactory();
                boolean $i$f$buildFun = false;
                IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
                $i$f$mapIndexedTo = false;
                index$iv$iv = 0;
                Object $this$run$iv = irFunctionBuilder;
                boolean bl = false;
                IrFunctionBuilder $this$buildFun = $this$run$iv;
                boolean $i$a$-buildFun-BridgeLowering$BridgeLoweringCache$computeSpecialBridge$substitutedOverride$22 = false;
                $this$buildFun.updateFrom(specialBridge2.getOverridden());
                Name name = Name.identifier(specialBridge2.getSignature().getName());
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(specialBridge.signature.name)");
                $this$buildFun.setName(name);
                $this$buildFun.setReturnType(function2.getReturnType());
                IrSimpleFunction irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, (IrFunctionBuilder)$this$run$iv);
                boolean bl3 = false;
                boolean bl4 = false;
                IrSimpleFunction $this$apply = irSimpleFunction;
                boolean bl5 = false;
                $this$run$iv = CollectionsKt.zip((Iterable)function2.getValueParameters(), (Iterable)substitutedParameterTypes);
                IrSimpleFunction irSimpleFunction2 = $this$apply;
                boolean $i$f$map = false;
                void $i$a$-buildFun-BridgeLowering$BridgeLoweringCache$computeSpecialBridge$substitutedOverride$22 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void param;
                    void $dstr$param$type;
                    Pair pair = (Pair)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl6 = false;
                    IrValueParameter irValueParameter = (IrValueParameter)$dstr$param$type.component1();
                    IrType type2 = (IrType)$dstr$param$type.component2();
                    IrValueParameter irValueParameter2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)param, $this$apply, IrDeclarationOrigin.BRIDGE.INSTANCE, 0, 0, 0, null, null, type2, null, null, false, false, false, 8060, null);
                    collection.add(irValueParameter2);
                }
                collection = (List)destination$iv$iv2;
                irSimpleFunction2.setValueParameters((List<? extends IrValueParameter>)collection);
                $this$apply.setOverriddenSymbols(CollectionsKt.listOf((Object)specialBridge2.getOverridden().getSymbol()));
                $this$apply.setParent(function2.getParent());
                IrSimpleFunction substitutedOverride = irSimpleFunction;
                return SpecialBridge.copy$default(specialBridge2, null, this.computeJvmMethod(substitutedOverride), false, substitutedParameterTypes, function2.getReturnType(), null, null, false, false, false, 997, null);
            }
            return null;
        }

        public BridgeLoweringCache(@NotNull JvmBackendContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.context = context2;
            this.specialBridgeMethods = new SpecialBridgeMethods(this.context);
            boolean bl = false;
            this.signatureCache = new HashMap();
        }
    }
}

