/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.lower.WasmCallableReferenceLoweringKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainerKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0018B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0016H\u0016J\f\u0010\u0017\u001a\u00020\n*\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmCallableReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "ignoredFunctionReferences", "", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "isIgnored", "", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;)Z", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "visitFunctionReference", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "isSuspendCallableReference", "FunctionReferenceBuilder", "backend.wasm"})
public final class WasmCallableReferenceLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    private final Set<IrFunctionReference> ignoredFunctionReferences;
    private final WasmBackendContext context;

    private final boolean isIgnored(IrFunctionReference $this$isIgnored) {
        return (!IrTypeUtilsKt.isFunctionOrKFunction($this$isIgnored.getType()) || this.ignoredFunctionReferences.contains($this$isIgnored)) && !this.isSuspendCallableReference($this$isIgnored);
    }

    private final boolean isSuspendCallableReference(IrFunctionReference $this$isSuspendCallableReference) {
        return org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend($this$isSuspendCallableReference) && $this$isSuspendCallableReference.getOrigin() == null;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!WasmCallableReferenceLoweringKt.isLambda(expression2.getOrigin())) {
            return super.visitBlock(expression2);
        }
        Object object = CollectionsKt.last(expression2.getStatements());
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
        }
        IrFunctionReference reference = (IrFunctionReference)object;
        if (this.isIgnored(reference)) {
            return super.visitBlock(expression2);
        }
        Iterable $this$forEach$iv = CollectionsKt.dropLast(expression2.getStatements(), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrStatement it = (IrStatement)element$iv;
            boolean bl = false;
            it.transform(this, null);
        }
        IrElementTransformerVoidKt.transformChildrenVoid(reference, this);
        return new FunctionReferenceBuilder(this, reference, null, 2, null).build();
    }

    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        return this.isIgnored(expression2) ? (IrExpression)expression2 : new FunctionReferenceBuilder(this, expression2, null, 2, null).build();
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2.getOperator() == IrTypeOperator.SAM_CONVERSION) {
            IrFunctionReference irFunctionReference;
            IrExpression invokable = expression2.getArgument();
            if (invokable instanceof IrFunctionReference) {
                irFunctionReference = (IrFunctionReference)invokable;
            } else if (invokable instanceof IrBlock && WasmCallableReferenceLoweringKt.isLambda(((IrBlock)invokable).getOrigin()) && CollectionsKt.last(((IrBlock)invokable).getStatements()) instanceof IrFunctionReference) {
                Iterable $this$forEach$iv = CollectionsKt.dropLast(((IrBlock)invokable).getStatements(), (int)1);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrStatement it = (IrStatement)element$iv;
                    boolean bl = false;
                    it.transform(this, null);
                }
                Object object = CollectionsKt.last(((IrBlock)invokable).getStatements());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
                }
                irFunctionReference = (IrFunctionReference)object;
            } else {
                return super.visitTypeOperator(expression2);
            }
            IrFunctionReference reference = irFunctionReference;
            this.transformChildrenVoid(reference);
            return new FunctionReferenceBuilder(this, reference, expression2.getTypeOperand()).build();
        }
        return super.visitTypeOperator(expression2);
    }

    public WasmCallableReferenceLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        boolean bl = false;
        this.ignoredFunctionReferences = new LinkedHashSet();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001f\u001a\u00020\fJ\b\u0010 \u001a\u00020!H\u0002J\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0016\u0010&\u001a\u00020'*\u00020#2\b\u0010(\u001a\u0004\u0018\u00010%H\u0002J\f\u0010)\u001a\u00020'*\u00020#H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00050\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmCallableReferenceLowering$FunctionReferenceBuilder;", "", "irFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "samSuperType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Lorg/jetbrains/kotlin/backend/wasm/lower/WasmCallableReferenceLowering;Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "argumentTypes", "", "boundReceiver", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "callee", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "functionReferenceClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "functionSuperClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getIrFunctionReference", "()Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "isLambda", "", "parameterTypes", "getSamSuperType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "superMethod", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "typeArgumentsMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "build", "createConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "createInvokeMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "receiverVar", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "createFunctionReferenceInvokeMethod", "", "receiver", "createLambdaInvokeMethod", "backend.wasm"})
    private final class FunctionReferenceBuilder {
        private final boolean isLambda;
        private final IrFunction callee;
        private final Pair<IrValueParameter, IrExpression> boundReceiver;
        private final List<IrType> parameterTypes;
        private final List<IrType> argumentTypes;
        private final Map<IrTypeParameterSymbol, IrType> typeArgumentsMap;
        private final IrClassSymbol functionSuperClass;
        private final IrSimpleFunctionSymbol superMethod;
        private final IrClass functionReferenceClass;
        @NotNull
        private final IrFunctionReference irFunctionReference;
        @Nullable
        private final IrType samSuperType;
        final /* synthetic */ WasmCallableReferenceLowering this$0;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IrExpression build() {
            void $this$apply;
            void this_$iv$iv;
            BackendContext backendContext = this.this$0.context;
            ScopeWithIr scopeWithIr = this.this$0.getCurrentScope();
            Intrinsics.checkNotNull((Object)scopeWithIr);
            DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder$default(backendContext, scopeWithIr.getScope().getScopeOwnerSymbol(), 0, 0, 6, null);
            boolean bl = false;
            boolean bl2 = false;
            DeclarationIrBuilder $this$run = declarationIrBuilder;
            boolean bl3 = false;
            IrBuilderWithScope $this$irBlock$iv = $this$run;
            int startOffset$iv = $this$irBlock$iv.getStartOffset();
            int endOffset$iv = $this$irBlock$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock$iv.getContext(), $this$irBlock$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$irBlock = this_$iv$iv;
            boolean bl4 = false;
            IrConstructor constructor2 = this.createConstructor();
            this.createInvokeMethod(this.samSuperType != null && this.boundReceiver != null ? ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$irBlock, (IrExpression)this.boundReceiver.getSecond(), null, null, false, 14, null) : null);
            $this$irBlock.unaryPlus(this.functionReferenceClass);
            IrConstructorCall irConstructorCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irBlock, (IrConstructorSymbol)constructor2.getSymbol());
            boolean bl5 = false;
            boolean bl6 = false;
            IrConstructorCall irConstructorCall2 = irConstructorCall;
            void var21_21 = $this$irBlock;
            boolean bl7 = false;
            if ($this$apply.getValueArgumentsCount() > 0) {
                Pair<IrValueParameter, IrExpression> pair = this.boundReceiver;
                Intrinsics.checkNotNull(pair);
                $this$apply.putValueArgument(0, (IrExpression)pair.getSecond());
            }
            Unit unit = Unit.INSTANCE;
            var21_21.unaryPlus(irConstructorCall);
            return this_$iv$iv.doBuild();
        }

        /*
         * WARNING - void declaration
         */
        private final IrConstructor createConstructor() {
            void $this$irBlockBody;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlockBody$iv;
            Object object;
            IrClass $this$addConstructor$iv = this.functionReferenceClass;
            boolean $i$f$addConstructor = false;
            IrFactory $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
            boolean bl = false;
            boolean bl2 = false;
            IrFunctionBuilder $this$run$iv$iv2 = irFunctionBuilder;
            boolean bl3 = false;
            IrFunctionBuilder $this$buildConstructor$iv = $this$run$iv$iv2;
            boolean $i$a$-buildConstructor-DeclarationBuildersKt$addConstructor$2$iv22 = false;
            IrFunctionBuilder $this$addConstructor = $this$buildConstructor$iv;
            boolean $i$a$-addConstructor-WasmCallableReferenceLowering$FunctionReferenceBuilder$createConstructor$22 = false;
            $this$addConstructor.setReturnType(IrUtilsKt.getDefaultType(this.functionReferenceClass));
            $this$addConstructor.setPrimary(true);
            $this$buildConstructor$iv.setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv));
            Object object2 = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv$iv, $this$run$iv$iv2);
            $i$f$buildConstructor = false;
            boolean bl4 = false;
            Object constructor$iv = object2;
            boolean $i$a$-also-DeclarationBuildersKt$addConstructor$3$iv22 = false;
            $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
            constructor$iv.setParent($this$addConstructor$iv);
            Object object3 = object2;
            boolean bl5 = false;
            boolean bl6 = false;
            Object $this$apply = object3;
            boolean bl7 = false;
            if (this.samSuperType == null && (object = this.boundReceiver) != null && (object = (IrValueParameter)object.getFirst()) != null) {
                constructor$iv = object;
                $i$a$-also-DeclarationBuildersKt$addConstructor$3$iv22 = false;
                boolean $this$run$iv$iv2 = false;
                Object param = constructor$iv;
                boolean bl8 = false;
                Object object4 = $this$apply;
                ((IrFunction)object4).setValueParameters(CollectionsKt.plus((Collection)((IrFunction)object4).getValueParameters(), (Object)org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)param, (IrFunction)$this$apply, null, 0, 0, 0, null, null, IrTypeUtilsKt.substitute(((IrValueDeclaration)param).getType(), this.typeArgumentsMap), null, null, false, false, false, 8058, null)));
            }
            IrConstructor constructor2 = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)this.this$0.context.getIrBuiltIns().getAnyClass().getOwner()));
            IrBuilderWithScope $i$a$-also-DeclarationBuildersKt$addConstructor$3$iv22 = LowerUtilsKt.createIrBuilder$default(this.this$0.context, ((IrFunction)$this$apply).getSymbol(), 0, 0, 6, null);
            int $this$run$iv$iv2 = $this$apply.getStartOffset();
            int endOffset$iv = $this$apply.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder $i$a$-buildConstructor-DeclarationBuildersKt$addConstructor$2$iv22 = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void $i$a$-addConstructor-WasmCallableReferenceLowering$FunctionReferenceBuilder$createConstructor$22 = this_$iv$iv;
            Object object5 = $this$apply;
            boolean bl9 = false;
            IrDelegatingConstructorCall irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$irBlockBody, constructor2);
            boolean bl10 = false;
            boolean bl11 = false;
            IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall;
            void var20_33 = $this$irBlockBody;
            boolean bl12 = false;
            Unit unit = Unit.INSTANCE;
            var20_33.unaryPlus(irDelegatingConstructorCall);
            $this$irBlockBody.unaryPlus(new IrInstanceInitializerCallImpl($this$irBlockBody.getStartOffset(), $this$irBlockBody.getEndOffset(), (IrClassSymbol)this.functionReferenceClass.getSymbol(), $this$irBlockBody.getContext().getIrBuiltIns().getUnitType()));
            Unit unit2 = Unit.INSTANCE;
            ((IrFunction)object5).setBody(this_$iv$iv.doBuild());
            return object3;
        }

        private final IrSimpleFunction createInvokeMethod(IrValueDeclaration receiverVar) {
            IrClass $this$addFunction$iv = this.functionReferenceClass;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
            boolean bl = false;
            boolean bl2 = false;
            IrFunctionBuilder $this$run$iv$iv$iv = irFunctionBuilder;
            boolean bl3 = false;
            IrFunctionBuilder $this$addFunction = $this$run$iv$iv$iv;
            boolean bl4 = false;
            IrElementBuilderKt.setSourceRange($this$addFunction, this.isLambda ? (IrElement)this.callee : (IrElement)this.irFunctionReference);
            $this$addFunction.setName(((IrSimpleFunction)this.superMethod.getOwner()).getName());
            $this$addFunction.setReturnType(this.callee.getReturnType());
            $this$addFunction.setSuspend(AdditionalIrUtilsKt.isSuspend(this.callee));
            $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$run$iv$iv$iv);
            boolean bl5 = false;
            boolean bl6 = false;
            Object function$iv$iv = $this$buildFun$iv$iv$iv;
            boolean bl7 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
            function$iv$iv.setParent($this$addFunction$iv);
            Object object = $this$buildFun$iv$iv$iv;
            boolean bl8 = false;
            boolean bl9 = false;
            Object $this$apply = object;
            boolean bl10 = false;
            Object object2 = $this$apply;
            object2.setOverriddenSymbols(CollectionsKt.plus((Collection)object2.getOverriddenSymbols(), (Object)this.superMethod));
            IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass((IrDeclaration)$this$apply).getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter);
            ((IrFunction)$this$apply).setDispatchReceiverParameter(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(irValueParameter, (IrFunction)$this$apply, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8190, null));
            if (this.isLambda) {
                this.createLambdaInvokeMethod((IrSimpleFunction)$this$apply);
            } else {
                this.createFunctionReferenceInvokeMethod((IrSimpleFunction)$this$apply, receiverVar);
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final void createLambdaInvokeMethod(IrSimpleFunction $this$createLambdaInvokeMethod) {
            void $this$associateTo$iv$iv;
            IrSimpleFunction irSimpleFunction = $this$createLambdaInvokeMethod;
            irSimpleFunction.setAnnotations(CollectionsKt.plus((Collection)irSimpleFunction.getAnnotations(), (Iterable)this.callee.getAnnotations()));
            Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)IrUtilsKt.getExplicitParameters(this.callee));
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                void index2;
                Map map2 = destination$iv$iv;
                IndexedValue $dstr$index$param = (IndexedValue)element$iv$iv;
                boolean bl = false;
                int n = $dstr$index$param.component1();
                IrValueParameter param = (IrValueParameter)$dstr$index$param.component2();
                Pair pair = TuplesKt.to((Object)param, (Object)org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(param, $this$createLambdaInvokeMethod, null, (int)index2, 0, 0, null, null, null, null, null, false, false, false, 8186, null));
                boolean bl2 = false;
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map valueParameterMap = destination$iv$iv;
            IrSimpleFunction irSimpleFunction2 = $this$createLambdaInvokeMethod;
            irSimpleFunction2.setValueParameters(CollectionsKt.plus((Collection)irSimpleFunction2.getValueParameters(), (Iterable)valueParameterMap.values()));
            $this$createLambdaInvokeMethod.setBody(IrInlineUtilsKt.moveBodyTo(this.callee, $this$createLambdaInvokeMethod, valueParameterMap));
        }

        /*
         * WARNING - void declaration
         */
        private final void createFunctionReferenceInvokeMethod(IrSimpleFunction $this$createFunctionReferenceInvokeMethod, IrValueDeclaration receiver) {
            void $this$apply;
            void $this$run;
            Object valueParameter$iv;
            boolean bl;
            Object object;
            boolean bl2;
            Object $this$addValueParameter$iv;
            boolean bl3 = false;
            for (IrType argumentType : (Iterable)this.argumentTypes) {
                void index2;
                $this$addValueParameter$iv = $this$createFunctionReferenceInvokeMethod;
                boolean $i$f$addValueParameter = false;
                IrValueParameterBuilder irValueParameterBuilder = new IrValueParameterBuilder();
                boolean bl4 = false;
                bl2 = false;
                IrValueParameterBuilder $this$run$iv = irValueParameterBuilder;
                boolean bl5 = false;
                IrValueParameterBuilder $this$addValueParameter = $this$run$iv;
                boolean bl6 = false;
                Name name = Name.identifier("" + 'p' + (int)index2);
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(\"p$index\")");
                $this$addValueParameter.setName(name);
                $this$addValueParameter.setType(argumentType);
                if ($this$run$iv.getIndex() == -1) {
                    $this$run$iv.setIndex(((IrFunction)$this$addValueParameter$iv).getValueParameters().size());
                }
                object = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$run$iv, (IrDeclarationParent)$this$addValueParameter$iv);
                bl = false;
                boolean bl7 = false;
                valueParameter$iv = object;
                boolean bl8 = false;
                ((IrFunction)$this$addValueParameter$iv).setValueParameters(CollectionsKt.plus((Collection)((IrFunction)$this$addValueParameter$iv).getValueParameters(), (Object)valueParameter$iv));
                ++index2;
            }
            DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder$default(this.this$0.context, $this$createFunctionReferenceInvokeMethod.getSymbol(), 0, 0, 6, null);
            boolean bl9 = false;
            boolean bl10 = false;
            $this$addValueParameter$iv = declarationIrBuilder;
            IrSimpleFunction irSimpleFunction = $this$createFunctionReferenceInvokeMethod;
            boolean bl11 = false;
            int unboundIndex = 0;
            IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$run, this.callee);
            bl2 = false;
            boolean bl12 = false;
            IrFunctionAccessExpression bl5 = irFunctionAccessExpression;
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$run;
            boolean bl13 = false;
            object = this.typeArgumentsMap;
            bl = false;
            Iterator<Object> iterator2 = object.entrySet().iterator();
            while (iterator2.hasNext()) {
                void typeParameter;
                Object object2 = valueParameter$iv = iterator2.next();
                boolean bl14 = false;
                object = object2.getKey();
                object2 = valueParameter$iv;
                bl14 = false;
                IrType typeArgument = (IrType)object2.getValue();
                $this$apply.putTypeArgument(((IrTypeParameter)typeParameter.getOwner()).getIndex(), typeArgument);
            }
            for (IrValueParameter parameter : IrUtilsKt.getExplicitParameters(this.callee)) {
                IrGetValueImpl irGetValueImpl;
                Pair<IrValueParameter, IrExpression> pair = this.boundReceiver;
                if (Intrinsics.areEqual((Object)(pair != null ? (IrValueParameter)pair.getFirst() : null), (Object)parameter)) {
                    IrValueDeclaration irValueDeclaration = receiver;
                    if (irValueDeclaration == null) {
                        String string2 = "Binding receivers is not supported yet";
                        boolean bl15 = false;
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    irGetValueImpl = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$run, irValueDeclaration);
                } else if (AdditionalIrUtilsKt.isVararg(parameter) && unboundIndex < this.argumentTypes.size() && Intrinsics.areEqual((Object)parameter.getType(), (Object)$this$createFunctionReferenceInvokeMethod.getValueParameters().get(unboundIndex).getType())) {
                    int n = unboundIndex;
                    unboundIndex = n + 1;
                    irGetValueImpl = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$run, $this$createFunctionReferenceInvokeMethod.getValueParameters().get(n));
                } else {
                    if (AdditionalIrUtilsKt.isVararg(parameter) && (unboundIndex < this.argumentTypes.size() || !IrUtilsKt.hasDefaultValue(parameter))) {
                        boolean bl16 = false;
                        throw (Throwable)new NotImplementedError(null, 1, null);
                    }
                    if (unboundIndex >= this.argumentTypes.size()) {
                        irGetValueImpl = null;
                    } else {
                        int n = unboundIndex;
                        unboundIndex = n + 1;
                        irGetValueImpl = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$run, $this$createFunctionReferenceInvokeMethod.getValueParameters().get(n));
                    }
                }
                if (irGetValueImpl == null) continue;
                IrGetValueImpl irGetValueImpl2 = irGetValueImpl;
                boolean bl17 = false;
                boolean bl18 = false;
                IrGetValueImpl it = irGetValueImpl2;
                boolean bl19 = false;
                IrMemberAccessExpressionKt.putArgument((IrMemberAccessExpression)$this$apply, this.callee, parameter, it);
            }
            Unit unit = Unit.INSTANCE;
            IrExpressionBody irExpressionBody = ExpressionHelpersKt.irExprBody(irBuilderWithScope, irFunctionAccessExpression);
            irSimpleFunction.setBody(irExpressionBody);
        }

        @NotNull
        public final IrFunctionReference getIrFunctionReference() {
            return this.irFunctionReference;
        }

        @Nullable
        public final IrType getSamSuperType() {
            return this.samSuperType;
        }

        /*
         * WARNING - void declaration
         */
        public FunctionReferenceBuilder(@NotNull WasmCallableReferenceLowering this$0, @Nullable IrFunctionReference irFunctionReference, IrType samSuperType) {
            void $this$apply;
            void $this$buildClass;
            void $this$single$iv;
            Collection<IrType> collection;
            void $this$mapTo$iv$iv;
            Sequence<IrSimpleFunctionSymbol> $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)irFunctionReference, (String)"irFunctionReference");
            this.this$0 = this$0;
            this.irFunctionReference = irFunctionReference;
            this.samSuperType = samSuperType;
            this.isLambda = WasmCallableReferenceLoweringKt.isLambda(this.irFunctionReference.getOrigin());
            this.callee = ((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner();
            this.boundReceiver = (Pair)CollectionsKt.singleOrNull(IrUtilsKt.getArgumentsWithIr(this.irFunctionReference));
            IrType irType = this.irFunctionReference.getType();
            if (irType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            }
            Object object = ((IrSimpleType)irType).getArguments();
            FunctionReferenceBuilder functionReferenceBuilder = this;
            boolean $i$f$map = false;
            IrClassBuilder irClassBuilder = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                if (v1 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrTypeProjection");
                }
                IrType irType2 = ((IrTypeProjection)v1).getType();
                collection.add(irType2);
            }
            collection = (List)destination$iv$iv;
            functionReferenceBuilder.parameterTypes = collection;
            this.argumentTypes = CollectionsKt.dropLast(this.parameterTypes, (int)1);
            this.typeArgumentsMap = IrUtilsKt.getTypeSubstitutionMap(this.irFunctionReference);
            Object object2 = this.samSuperType;
            if (object2 == null || (object2 = IrTypesKt.getClassOrNull((IrType)object2)) == null) {
                object2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend(this.irFunctionReference) ? this$0.context.getIr().getSymbols().suspendFunctionN(this.argumentTypes.size()) : this$0.context.getIr().getSymbols().functionN(this.argumentTypes.size());
            }
            this.functionSuperClass = object2;
            $this$map$iv = IrUtilsKt.getFunctions(this.functionSuperClass);
            functionReferenceBuilder = this;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv22 = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                boolean bl2 = false;
                if (!(((IrSimpleFunction)it.getOwner()).getModality() == Modality.ABSTRACT)) continue;
                if (found$iv22) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv22 = true;
            }
            if (!found$iv22) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            collection = single$iv;
            functionReferenceBuilder.superMethod = (IrSimpleFunctionSymbol)((Object)collection);
            IrFactory $this$buildClass$iv = this$0.context.getIrFactory();
            boolean $i$f$buildClass = false;
            irClassBuilder = new IrClassBuilder();
            found$iv22 = false;
            $i$f$mapTo = false;
            IrClassBuilder $this$run$iv = irClassBuilder;
            boolean bl = false;
            IrClassBuilder bl2 = $this$run$iv;
            functionReferenceBuilder = this;
            boolean bl3 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)$this$buildClass, this.irFunctionReference);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"DescriptorVisibilities.LOCAL");
            $this$buildClass.setVisibility(descriptorVisibility);
            Name name = SpecialNames.NO_NAME_PROVIDED;
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"SpecialNames.NO_NAME_PROVIDED");
            $this$buildClass.setName(name);
            collection = Unit.INSTANCE;
            object = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$run$iv);
            boolean bl4 = false;
            boolean bl5 = false;
            Object found$iv22 = object;
            boolean bl6 = false;
            IrDeclarationParent irDeclarationParent = this.this$0.getCurrentDeclarationParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent);
            $this$apply.setParent(irDeclarationParent);
            if (this.samSuperType == null) {
                void v6 = $this$apply;
                v6.setSuperTypes(CollectionsKt.plus((Collection)v6.getSuperTypes(), (Object)IrTypesKt.typeWith((IrClassifierSymbol)this.functionSuperClass, this.parameterTypes)));
            }
            org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$apply);
            IrAttributeContainerKt.copyAttributes((IrAttributeContainer)$this$apply, this.irFunctionReference);
            if (this.isLambda) {
                $this$apply.setMetadata(((IrFunctionSymbol)this.irFunctionReference.getSymbol()).getOwner().getMetadata());
            }
            collection = Unit.INSTANCE;
            functionReferenceBuilder.functionReferenceClass = object;
        }

        public /* synthetic */ FunctionReferenceBuilder(WasmCallableReferenceLowering wasmCallableReferenceLowering, IrFunctionReference irFunctionReference, IrType irType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                irType = null;
            }
            this(wasmCallableReferenceLowering, irFunctionReference, irType);
        }
    }
}

