/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u0018R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/builtins/UnsignedTypes;", "", "()V", "arrayClassIdToUnsignedClassId", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lkotlin/collections/HashMap;", "arrayClassesShortNames", "", "Lorg/jetbrains/kotlin/name/Name;", "unsignedClassIdToArrayClassId", "unsignedTypeNames", "getUnsignedArrayClassIdByUnsignedClassId", "arrayClassId", "getUnsignedClassIdByArrayClassId", "isShortNameOfUnsignedArray", "", "name", "isShortNameOfUnsignedType", "isUnsignedClass", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isUnsignedType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "toUnsignedType", "Lorg/jetbrains/kotlin/builtins/UnsignedType;", "descriptors"})
public final class UnsignedTypes {
    private static final Set<Name> unsignedTypeNames;
    private static final HashMap<ClassId, ClassId> arrayClassIdToUnsignedClassId;
    private static final HashMap<ClassId, ClassId> unsignedClassIdToArrayClassId;
    private static final Set<Name> arrayClassesShortNames;
    @NotNull
    public static final UnsignedTypes INSTANCE;

    public final boolean isShortNameOfUnsignedArray(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return arrayClassesShortNames.contains(name);
    }

    public final boolean isShortNameOfUnsignedType(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return unsignedTypeNames.contains(name);
    }

    @Nullable
    public final ClassId getUnsignedClassIdByArrayClassId(@NotNull ClassId arrayClassId) {
        Intrinsics.checkNotNullParameter((Object)arrayClassId, (String)"arrayClassId");
        return arrayClassIdToUnsignedClassId.get(arrayClassId);
    }

    @Nullable
    public final ClassId getUnsignedArrayClassIdByUnsignedClassId(@NotNull ClassId arrayClassId) {
        Intrinsics.checkNotNullParameter((Object)arrayClassId, (String)"arrayClassId");
        return unsignedClassIdToArrayClassId.get(arrayClassId);
    }

    @JvmStatic
    public static final boolean isUnsignedType(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (TypeUtils.noExpectedType(type2)) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptor, (String)"type.constructor.declara\u2026escriptor ?: return false");
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        return INSTANCE.isUnsignedClass(descriptor2);
    }

    @Nullable
    public final UnsignedType toUnsignedType(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return KotlinBuiltIns.isUByte(type2) ? UnsignedType.UBYTE : (KotlinBuiltIns.isUShort(type2) ? UnsignedType.USHORT : (KotlinBuiltIns.isUInt(type2) ? UnsignedType.UINT : (KotlinBuiltIns.isULong(type2) ? UnsignedType.ULONG : null)));
    }

    public final boolean isUnsignedClass(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        return container2 instanceof PackageFragmentDescriptor && Intrinsics.areEqual((Object)((PackageFragmentDescriptor)container2).getFqName(), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME) && unsignedTypeNames.contains(descriptor2.getName());
    }

    private UnsignedTypes() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_5;
        void $this$mapTo$iv;
        Name name;
        Collection collection;
        void $this$mapTo$iv$iv;
        UnsignedTypes unsignedTypes;
        INSTANCE = unsignedTypes = new UnsignedTypes();
        UnsignedType[] $this$map$iv322 = UnsignedType.values();
        boolean $i$f$map = false;
        UnsignedType[] unsignedTypeArray = $this$map$iv322;
        Collection destination$iv$iv = new ArrayList($this$map$iv322.length);
        boolean $i$f$mapTo = false;
        void var6_13 = $this$mapTo$iv$iv;
        int n = ((void)var6_13).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_21 = item$iv$iv = var6_13[i];
            collection = destination$iv$iv;
            boolean bl = false;
            name = it.getTypeName();
            collection.add(name);
        }
        unsignedTypeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean $this$map$iv322 = false;
        arrayClassIdToUnsignedClassId = new HashMap();
        $this$map$iv322 = false;
        unsignedClassIdToArrayClassId = new HashMap();
        UnsignedType[] $this$map$iv322 = UnsignedType.values();
        $i$f$map = false;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo2 = false;
        void var4_10 = $this$mapTo$iv;
        int n2 = ((void)var4_10).length;
        for (int i = 0; i < n2; ++i) {
            void it;
            void item$iv;
            void var8_18 = item$iv = var4_10[i];
            collection = destination$iv;
            boolean bl = false;
            name = it.getArrayClassId().getShortClassName();
            collection.add(name);
        }
        arrayClassesShortNames = (Set)var2_5;
        for (UnsignedType unsignedType : UnsignedType.values()) {
            ((Map)arrayClassIdToUnsignedClassId).put(unsignedType.getArrayClassId(), unsignedType.getClassId());
            ((Map)unsignedClassIdToArrayClassId).put(unsignedType.getClassId(), unsignedType.getArrayClassId());
        }
    }
}

