/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.plugins.DescriptorListLoadingContext;
import org.jetbrains.kotlin.com.intellij.ide.plugins.DescriptorLoadingContext;
import org.jetbrains.kotlin.com.intellij.ide.plugins.DisabledPluginsState;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PathBasedJdomXIncluder;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginDescriptorLoader;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginLoadingResult;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.impl.ApplicationInfoImpl;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import org.jetbrains.kotlin.com.intellij.openapi.util.BuildNumber;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.util.LineSeparator;
import org.jetbrains.kotlin.com.intellij.util.execution.ParametersListUtil;
import org.jetbrains.kotlin.com.intellij.util.lang.UrlClassLoader;

public final class PluginManagerCore {
    public static final PluginId CORE_ID = PluginId.getId("org.jetbrains.kotlin.com.intellij");
    public static final PluginId JAVA_PLUGIN_ID = PluginId.getId("org.jetbrains.kotlin.com.intellij.java");
    private static final PluginId JAVA_MODULE_ID = PluginId.getId("org.jetbrains.kotlin.com.intellij.modules.java");
    private static final PluginId ALL_MODULES_MARKER = PluginId.getId("org.jetbrains.kotlin.com.intellij.modules.all");
    private static final PluginId SPECIAL_IDEA_PLUGIN_ID = PluginId.getId("IDEA CORE");
    private static Reference<Map<PluginId, Set<String>>> ourBrokenPluginVersions;
    static volatile List<IdeaPluginDescriptorImpl> ourLoadedPlugins;
    private static Map<String, String[]> ourAdditionalLayoutMap;
    public static volatile boolean isUnitTestMode;
    @ApiStatus.Internal
    static final boolean usePluginClassLoader;
    private static BuildNumber ourBuildNumber;

    @ApiStatus.Internal
    @Nullable
    public static String getPluginsCompatibleBuild() {
        return System.getProperty("idea.plugins.compatible.build");
    }

    @NotNull
    private static Map<PluginId, Set<String>> getBrokenPluginVersions() {
        Map<PluginId, Set<String>> result2 = org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(ourBrokenPluginVersions);
        if (result2 != null) {
            Map<PluginId, Set<String>> map2 = result2;
            if (map2 == null) {
                PluginManagerCore.$$$reportNull$$$0(8);
            }
            return map2;
        }
        if (System.getProperty("idea.ignore.disabled.plugins") != null) {
            result2 = Collections.emptyMap();
            ourBrokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(result2);
            Map<PluginId, Set<String>> map3 = result2;
            if (map3 == null) {
                PluginManagerCore.$$$reportNull$$$0(9);
            }
            return map3;
        }
        result2 = new HashMap<PluginId, Set<String>>();
        try (InputStream resource = PluginManagerCore.class.getResourceAsStream("/brokenPlugins.txt");
             BufferedReader br = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));){
            String s;
            while ((s = br.readLine()) != null) {
                List<String> tokens;
                if ((s = s.trim()).startsWith("//") || (tokens = ParametersListUtil.parse(s)).isEmpty()) continue;
                if (tokens.size() == 1) {
                    throw new RuntimeException("brokenPlugins.txt is broken. The line contains plugin name, but does not contains version: " + s);
                }
                PluginId pluginId = PluginId.getId(tokens.get(0));
                List<String> versions2 = tokens.subList(1, tokens.size());
                result2.computeIfAbsent(pluginId, k -> new HashSet()).addAll(versions2);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read /brokenPlugins.txt", e);
        }
        ourBrokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(result2);
        Map<PluginId, Set<String>> map4 = result2;
        if (map4 == null) {
            PluginManagerCore.$$$reportNull$$$0(10);
        }
        return map4;
    }

    public static void savePluginsList(@NotNull Collection<PluginId> ids, @NotNull Path file2, boolean append2) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(12);
        }
        Files.createDirectories(file2.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = append2 ? Files.newBufferedWriter(file2, StandardOpenOption.APPEND, StandardOpenOption.CREATE) : Files.newBufferedWriter(file2, new OpenOption[0]);){
            PluginManagerCore.writePluginsList(ids, writer);
        }
    }

    public static void writePluginsList(@NotNull Collection<PluginId> ids, @NotNull Writer writer) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(13);
        }
        if (writer == null) {
            PluginManagerCore.$$$reportNull$$$0(14);
        }
        ArrayList<PluginId> sortedIds = new ArrayList<PluginId>(ids);
        sortedIds.sort(null);
        String separator = LineSeparator.getSystemLineSeparator().getSeparatorString();
        for (PluginId id : sortedIds) {
            writer.write(id.getIdString());
            writer.write(separator);
        }
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className2) {
        PluginId id;
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(22);
        }
        return (id = PluginManagerCore.getPluginOrPlatformByClassName(className2)) == null || CORE_ID == id ? null : id;
    }

    @Nullable
    public static PluginId getPluginOrPlatformByClassName(@NotNull String className2) {
        PluginDescriptor result2;
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(23);
        }
        return (result2 = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(className2)) == null ? null : result2.getPluginId();
    }

    @ApiStatus.Internal
    @Nullable
    public static PluginDescriptor getPluginDescriptorOrPlatformByClassName(@NotNull String className2) {
        List<IdeaPluginDescriptorImpl> loadedPlugins;
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(24);
        }
        if ((loadedPlugins = ourLoadedPlugins) == null || className2.startsWith("java.") || className2.startsWith("javax.") || className2.startsWith("kotlin.") || className2.startsWith("groovy.")) {
            return null;
        }
        PluginDescriptor result2 = null;
        for (IdeaPluginDescriptorImpl o : loadedPlugins) {
            ClassLoader classLoader = o.getPluginClassLoader();
            if (classLoader == null || !PluginManagerCore.hasLoadedClass(className2, classLoader)) continue;
            result2 = o;
            break;
        }
        if (result2 == null) {
            return null;
        }
        if (result2.getPluginId() != CORE_ID || className2.startsWith("com.jetbrains.") || className2.startsWith("org.jetbrains.") || className2.startsWith("org.jetbrains.kotlin.com.intellij.") || className2.startsWith("org.intellij.") || className2.startsWith("com.android.") || className2.startsWith("git4idea.") || className2.startsWith("org.angularjs.")) {
            return result2;
        }
        String root2 = PathManager.getResourceRoot(result2.getPluginClassLoader(), "/" + className2.replace('.', '/') + ".class");
        if (root2 == null) {
            return null;
        }
        for (IdeaPluginDescriptorImpl o : loadedPlugins) {
            Path path2;
            if (!o.isUseIdeaClassLoader() || !root2.startsWith(FileUtilRt.toSystemIndependentName((path2 = o.getPluginPath()).toString()))) continue;
            result2 = o;
            break;
        }
        return result2;
    }

    private static boolean hasLoadedClass(@NotNull String className2, @NotNull ClassLoader loader) {
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(25);
        }
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(26);
        }
        if (loader instanceof UrlClassLoader) {
            return ((UrlClassLoader)loader).hasLoadedClass(className2);
        }
        Class<?> aClass2 = loader.getClass();
        if (PluginManagerCore.isInstanceofUrlClassLoader(aClass2)) {
            try {
                return (Boolean)aClass2.getMethod("hasLoadedClass", String.class).invoke((Object)loader, className2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isInstanceofUrlClassLoader(Class<?> aClass2) {
        String urlClassLoaderName = UrlClassLoader.class.getName();
        while (aClass2 != null) {
            if (aClass2.getName().equals(urlClassLoaderName)) {
                return true;
            }
            aClass2 = aClass2.getSuperclass();
        }
        return false;
    }

    @NotNull
    static PluginLoadingResult createLoadingResult(@Nullable BuildNumber buildNumber) {
        return new PluginLoadingResult(PluginManagerCore.getBrokenPluginVersions(), () -> buildNumber == null ? PluginManagerCore.getBuildNumber() : buildNumber);
    }

    @NotNull
    static BuildNumber getBuildNumber() {
        BuildNumber result2 = ourBuildNumber;
        if (result2 == null) {
            result2 = BuildNumber.fromString(PluginManagerCore.getPluginsCompatibleBuild());
            if (result2 == null) {
                if (isUnitTestMode) {
                    result2 = BuildNumber.currentVersion();
                } else {
                    try {
                        result2 = ApplicationInfoImpl.getShadowInstance().getApiVersionAsNumber();
                    }
                    catch (RuntimeException ignore) {
                        result2 = BuildNumber.currentVersion();
                    }
                }
            }
            ourBuildNumber = result2;
        }
        BuildNumber buildNumber = result2;
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(73);
        }
        return buildNumber;
    }

    @Nullable
    static String getIncompatibleMessage(@NotNull BuildNumber buildNumber, @Nullable String sinceBuild, @Nullable String untilBuild) {
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(81);
        }
        try {
            BuildNumber untilBuildNumber;
            BuildNumber sinceBuildNumber;
            String message2 = null;
            BuildNumber buildNumber2 = sinceBuildNumber = sinceBuild == null ? null : BuildNumber.fromString(sinceBuild, null, null);
            if (sinceBuildNumber != null && sinceBuildNumber.compareTo(buildNumber) > 0) {
                message2 = "since build " + sinceBuildNumber + " > " + buildNumber;
            }
            BuildNumber buildNumber3 = untilBuildNumber = untilBuild == null ? null : BuildNumber.fromString(untilBuild, null, null);
            if (untilBuildNumber != null && untilBuildNumber.compareTo(buildNumber) < 0) {
                message2 = message2 == null ? "" : message2 + ", ";
                message2 = message2 + "until build " + untilBuildNumber + " < " + buildNumber;
            }
            return message2;
        }
        catch (Exception e) {
            PluginManagerCore.getLogger().error(e);
            return "version check failed";
        }
    }

    public static void registerExtensionPointAndExtensions(@NotNull Path pluginRoot2, @NotNull String fileName, @NotNull ExtensionsArea area) {
        IdeaPluginDescriptorImpl descriptor2;
        if (pluginRoot2 == null) {
            PluginManagerCore.$$$reportNull$$$0(104);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(105);
        }
        if (area == null) {
            PluginManagerCore.$$$reportNull$$$0(106);
        }
        DescriptorListLoadingContext parentContext = DescriptorListLoadingContext.createSingleDescriptorContext(DisabledPluginsState.disabledPlugins());
        try (DescriptorLoadingContext context2 = new DescriptorLoadingContext(parentContext, true, true, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER);){
            descriptor2 = Files.isDirectory(pluginRoot2, new LinkOption[0]) ? PluginDescriptorLoader.loadDescriptorFromDir(pluginRoot2, "META-INF/" + fileName, null, context2) : PluginDescriptorLoader.loadDescriptorFromJar(pluginRoot2, fileName, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER, context2, null);
        }
        if (descriptor2 == null) {
            PluginManagerCore.getLogger().error("Cannot load " + fileName + " from " + pluginRoot2);
            return;
        }
        List<ExtensionPointImpl<?>> extensionPoints = descriptor2.appContainerDescriptor.extensionPoints;
        if (extensionPoints != null) {
            ((ExtensionsAreaImpl)area).registerExtensionPoints(extensionPoints, false);
        }
        descriptor2.registerExtensions((ExtensionsAreaImpl)area, descriptor2, descriptor2.appContainerDescriptor, null);
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        if (logger == null) {
            PluginManagerCore.$$$reportNull$$$0(107);
        }
        return logger;
    }

    static {
        ourAdditionalLayoutMap = Collections.emptyMap();
        isUnitTestMode = Boolean.getBoolean("idea.is.unit.test");
        usePluginClassLoader = Boolean.getBoolean("idea.from.sources.plugins.class.loader");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: 
            case 6: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 7: 
            case 27: 
            case 28: 
            case 29: 
            case 37: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 93: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 12: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 94: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPluginId";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 26: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlLoaderBuilder";
                break;
            }
            case 31: 
            case 84: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 32: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalLayoutMap";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLoaders";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 40: 
            case 49: 
            case 56: 
            case 76: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 45: 
            case 47: 
            case 74: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToDescriptorMap";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDir";
                break;
            }
            case 51: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledIds";
                break;
            }
            case 54: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledRequiredIds";
                break;
            }
            case 55: 
            case 65: 
            case 68: 
            case 75: 
            case 82: 
            case 95: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idMap";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreClassLoader";
                break;
            }
            case 64: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledPlugins";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedDescriptor";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDependencies";
                break;
            }
            case 71: 
            case 109: 
            case 111: 
            case 114: 
            case 117: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildNumber";
                break;
            }
            case 86: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedPluginIds";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedModuleIds";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginRoot";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 110: 
            case 113: 
            case 116: 
            case 120: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 112: 
            case 115: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToMap";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depProcessed";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortedAll";
                break;
            }
            case 125: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenPluginVersions";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginClassLoader";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "localFileToUrl";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "testLoadDescriptorsFromClassPath";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrScheduleLoading";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledPluginRawList";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "initPlugins";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAdditionalLayoutMap";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "createUrlClassLoaderBuilder";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildNumber";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopologicallySorted";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPluginIdMap";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableName";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnlyEnabledPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doSetPlugins";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenPlugin";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "savePluginsList";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writePluginsList";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependency";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createPluginException";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPluginOrPlatformByClassName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptorOrPlatformByClassName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasLoadedClass";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitDependency";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasModuleDependencies";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createPluginClassLoader";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "localFileToUrl";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "logPlugins";
                break;
            }
            case 40: 
            case 41: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "prepareLoadingPluginsErrorMessage";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingError";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getFirstDisabledDependency";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findErrorForPlugin";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createPluginIdGraph";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "checkPluginCycles";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createPluginJarsPathResolver";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorsToMigrate";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "testLoadDescriptorsFromClassPath";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "initPlugins";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalConfigs";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalDescriptors";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "initClassLoader";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "disableIncompatiblePlugins";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatible";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getIncompatibleMessage";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "checkEssentialPluginsAreAvailable";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "initializePlugins";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "configureClassLoaders";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getTopologicallySorted";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "buildPluginIdMap";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "checkAndPut";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "computePluginEnabled";
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointAndExtensions";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "findPluginByModuleDependency";
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "processAllDependencies";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "processAllBackwardDependencies";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "getOnlyEnabledPlugins";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "removeDisablePluginListener";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "isUpdatedBundledPlugin";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

