/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.PackageFragmentProviderKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentProviderOptimized;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/descriptors/impl/CompositePackageFragmentProvider;", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProviderOptimized;", "providers", "", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "(Ljava/util/List;)V", "collectPackageFragments", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "packageFragments", "", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "getPackageFragments", "getSubPackagesOf", "", "nameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "", "descriptors"})
public final class CompositePackageFragmentProvider
implements PackageFragmentProviderOptimized {
    private final List<PackageFragmentProvider> providers;

    @Override
    @NotNull
    public List<PackageFragmentDescriptor> getPackageFragments(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        ArrayList result2 = new ArrayList();
        for (PackageFragmentProvider provider : this.providers) {
            PackageFragmentProviderKt.collectPackageFragmentsOptimizedIfPossible(provider, fqName2, result2);
        }
        return CollectionsKt.toList((Iterable)result2);
    }

    @Override
    public void collectPackageFragments(@NotNull FqName fqName2, @NotNull Collection<PackageFragmentDescriptor> packageFragments2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter(packageFragments2, (String)"packageFragments");
        for (PackageFragmentProvider provider : this.providers) {
            PackageFragmentProviderKt.collectPackageFragmentsOptimizedIfPossible(provider, fqName2, packageFragments2);
        }
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, Boolean> nameFilter2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter(nameFilter2, (String)"nameFilter");
        HashSet<FqName> result2 = new HashSet<FqName>();
        for (PackageFragmentProvider provider : this.providers) {
            result2.addAll(provider.getSubPackagesOf(fqName2, nameFilter2));
        }
        return result2;
    }

    public CompositePackageFragmentProvider(@NotNull List<? extends PackageFragmentProvider> providers) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        this.providers = providers;
        boolean bl = this.providers.size() == CollectionsKt.toSet((Iterable)this.providers).size();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "providers.size is " + this.providers.size() + " while only " + CollectionsKt.toSet((Iterable)this.providers).size() + " unique providers";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
    }
}

