/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002JF\u0010\u0015\u001a\u00020\u0006\"\n\b\u0000\u0010\u0016\u0018\u0001*\u00020\u0017\"\b\b\u0001\u0010\u0018*\u00020\u0019*\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u0001H\u00162\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00180\u001cH\u0082\b\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "isAllowedArray", "", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isAllowedClassKind", "cone", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "report", "T", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "P", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "source", "factory", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory0;", "(Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/FirSourceElement;Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory0;)V", "checkers"})
public final class FirAnnotationClassDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirAnnotationClassDeclarationChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        Object factory$iv;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(declaration2 instanceof FirRegularClass)) {
            return;
        }
        if (((FirRegularClass)declaration2).getClassKind() != ClassKind.ANNOTATION_CLASS) {
            return;
        }
        Object $this$isLocal$iv = (FirRegularClass)declaration2;
        boolean $i$f$isLocal22 = false;
        if (((FirRegularClass)$this$isLocal$iv).getSymbol().getClassId().isLocal()) {
            DiagnosticReporter $i$f$isLocal22 = reporter;
            $this$isLocal$iv = this;
            FirSourceElement firSourceElement = declaration2.getSource();
            factory$iv = FirErrors.INSTANCE.getLOCAL_ANNOTATION_CLASS_ERROR();
            boolean $i$f$report = false;
            FirSourceElement firSourceElement2 = firSourceElement;
            if (firSourceElement2 != null) {
                void $this$report$iv;
                object = firSourceElement2;
                boolean bl = false;
                boolean bl2 = false;
                FirSourceElement it$iv = object;
                boolean bl322 = false;
                $this$report$iv.report((FirDiagnostic)((FirDiagnosticFactory0)factory$iv).on(it$iv));
            }
        }
        for (FirDeclaration it : ((FirRegularClass)declaration2).getDeclarations()) {
            void $this$report$iv;
            void var11_25;
            void source$iv;
            if (it instanceof FirConstructor && ((FirConstructor)it).isPrimary()) {
                for (FirValueParameter firValueParameter : ((FirConstructor)it).getValueParameters()) {
                    void $this$report$iv2;
                    void var17_62;
                    void source$iv2;
                    boolean bl;
                    void it$iv;
                    boolean bl3;
                    boolean bl4;
                    ClassId classId;
                    ConeLookupTagBasedType coneType;
                    FirTypeRef typeRef;
                    FirSourceElement source;
                    if (firValueParameter.getSource() == null) {
                        continue;
                    }
                    if (!LightTreePositioningStrategiesKt.hasValOrVar(source)) {
                        DiagnosticReporter diagnosticReporter = reporter;
                        object = this;
                        FirDiagnosticFactory0<FirSourceElement, KtParameter> factory$iv2 = FirErrors.INSTANCE.getMISSING_VAL_ON_ANNOTATION_PARAMETER();
                        boolean $i$f$report = false;
                        if (source != null) {
                            void $this$report$iv22;
                            FirSourceElement bl322;
                            boolean bl5 = false;
                            boolean bl6 = false;
                            FirSourceElement it$iv2 = bl322;
                            boolean $i$a$-let-FirAnnotationClassDeclarationChecker$report$1$iv2 = false;
                            $this$report$iv22.report((FirDiagnostic)factory$iv2.on(it$iv2));
                        }
                    } else if (LightTreePositioningStrategiesKt.hasVar(source)) {
                        DiagnosticReporter $this$report$iv22 = reporter;
                        FirAnnotationClassDeclarationChecker this_$iv = this;
                        FirDiagnosticFactory0<FirSourceElement, KtParameter> factory$iv3 = FirErrors.INSTANCE.getVAR_ANNOTATION_PARAMETER();
                        boolean $i$f$report = false;
                        if (source != null) {
                            void $this$report$iv3;
                            FirSourceElement bl322;
                            boolean bl7 = false;
                            boolean bl8 = false;
                            FirSourceElement it$iv3 = bl322;
                            boolean $i$a$-let-FirAnnotationClassDeclarationChecker$report$1$iv3 = false;
                            $this$report$iv3.report((FirDiagnostic)factory$iv3.on(it$iv3));
                        }
                    }
                    FirTypeRef $this$coneTypeSafe$iv = typeRef = firValueParameter.getReturnTypeRef();
                    boolean $i$f$coneTypeSafe22 = false;
                    boolean bl322 = false;
                    FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
                    if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                        firTypeRef = null;
                    }
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
                        coneKotlinType = null;
                    }
                    ConeLookupTagBasedType coneLookupTagBasedType = coneType = (ConeLookupTagBasedType)((ConeKotlinType)((ConeLookupTagBasedType)coneKotlinType));
                    ClassId classId2 = classId = coneLookupTagBasedType != null ? ConeTypeUtilsKt.getClassId(coneLookupTagBasedType) : null;
                    if (coneType == null || Intrinsics.areEqual((Object)classId, (Object)ClassId.fromString("<error>"))) continue;
                    if (ConeTypeUtilsKt.isNullable(coneType)) {
                        void source$iv22;
                        DiagnosticReporter bl322 = reporter;
                        FirAnnotationClassDeclarationChecker $i$f$coneTypeSafe22 = this;
                        FirSourceElement firSourceElement = typeRef.getSource();
                        FirDiagnosticFactory0<FirSourceElement, KtTypeReference> factory$iv4 = FirErrors.INSTANCE.getNULLABLE_TYPE_OF_ANNOTATION_MEMBER();
                        boolean $i$f$report = false;
                        if (source$iv22 != null) {
                            void $this$report$iv3;
                            void var17_60;
                            bl4 = false;
                            bl3 = false;
                            it$iv = var17_60;
                            boolean bl9 = false;
                            $this$report$iv3.report((FirDiagnostic)factory$iv4.on((FirSourceElement)it$iv));
                        }
                        continue;
                    }
                    if (CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getPrimitiveTypes(), (Object)classId) || CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getUnsignedTypes(), (Object)classId) || Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getKClass()) || Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getString()) || CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values(), (Object)classId)) continue;
                    if (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getArray())) {
                        void source$iv3;
                        if (this.isAllowedArray(typeRef, context2.getSession())) continue;
                        DiagnosticReporter $this$report$iv3 = reporter;
                        FirAnnotationClassDeclarationChecker this_$iv = this;
                        FirSourceElement source$iv22 = typeRef.getSource();
                        FirDiagnosticFactory0<FirSourceElement, KtTypeReference> factory$iv5 = FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER();
                        boolean $i$f$report = false;
                        if (source$iv3 != null) {
                            void $this$report$iv4;
                            void var17_61;
                            bl4 = false;
                            bl3 = false;
                            it$iv = var17_61;
                            bl = false;
                            $this$report$iv4.report((FirDiagnostic)factory$iv5.on((FirSourceElement)it$iv));
                        }
                        continue;
                    }
                    if (this.isAllowedClassKind(coneType, context2.getSession())) continue;
                    DiagnosticReporter $this$report$iv4 = reporter;
                    FirAnnotationClassDeclarationChecker this_$iv = this;
                    FirSourceElement source$iv3 = typeRef.getSource();
                    FirDiagnosticFactory0<FirSourceElement, KtTypeReference> factory$iv6 = FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER();
                    boolean $i$f$report = false;
                    if (source$iv2 == null) continue;
                    bl4 = false;
                    bl3 = false;
                    it$iv = var17_62;
                    bl = false;
                    $this$report$iv2.report((FirDiagnostic)factory$iv6.on((FirSourceElement)it$iv));
                }
                continue;
            }
            if (it instanceof FirRegularClass) continue;
            if (it instanceof FirProperty) {
                FirSourceElement firSourceElement = it.getSource();
                if (Intrinsics.areEqual((Object)(firSourceElement != null ? firSourceElement.getElementType() : null), (Object)KtNodeTypes.VALUE_PARAMETER)) continue;
            }
            if (it instanceof FirSimpleFunction) {
                FirSourceElement firSourceElement = it.getSource();
                if (Intrinsics.areEqual((Object)(firSourceElement != null ? firSourceElement.getElementType() : null), (Object)KtNodeTypes.FUN) ^ true) continue;
            }
            factory$iv = reporter;
            FirAnnotationClassDeclarationChecker firAnnotationClassDeclarationChecker = this;
            FirSourceElement source = it.getSource();
            FirDiagnosticFactory0<FirSourceElement, PsiElement> factory$iv7 = FirErrors.INSTANCE.getANNOTATION_CLASS_MEMBER();
            boolean $i$f$report = false;
            if (source$iv == null) continue;
            boolean bl = false;
            boolean bl10 = false;
            void it$iv = var11_25;
            boolean bl11 = false;
            $this$report$iv.report((FirDiagnostic)factory$iv7.on((FirSourceElement)it$iv));
        }
    }

    private final boolean isAllowedClassKind(ConeLookupTagBasedType cone, FirSession session2) {
        Object object;
        FirClassifierSymbol<?> firClassifierSymbol = LookupTagUtilsKt.toSymbol(cone.getLookupTag(), session2);
        Object object2 = firClassifierSymbol != null ? firClassifierSymbol.getFir() : null;
        if (!(object2 instanceof FirRegularClass)) {
            object2 = null;
        }
        if ((object = (FirRegularClass)object2) == null || (object = object.getClassKind()) == null) {
            return false;
        }
        Object typeRefClassKind = object;
        return typeRefClassKind == ClassKind.ANNOTATION_CLASS || typeRefClassKind == ClassKind.ENUM_CLASS;
    }

    private final boolean isAllowedArray(FirTypeRef typeRef, FirSession session2) {
        ConeKotlinTypeProjection coneKotlinTypeProjection;
        FirTypeRef $this$coneType$iv = typeRef;
        boolean $i$f$getConeType = false;
        FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        ConeTypeProjection[] typeArguments2 = coneKotlinType.getTypeArguments();
        if (typeArguments2.length != 1) {
            return false;
        }
        ConeTypeProjection coneTypeProjection = typeArguments2[0];
        if (!(coneTypeProjection instanceof ConeKotlinTypeProjection)) {
            coneTypeProjection = null;
        }
        if ((coneKotlinTypeProjection = (ConeKotlinTypeProjection)coneTypeProjection) == null || (coneKotlinTypeProjection = coneKotlinTypeProjection.getType()) == null) {
            return false;
        }
        ConeKotlinTypeProjection arrayType = coneKotlinTypeProjection;
        if (ConeTypeUtilsKt.isNullable((ConeKotlinType)arrayType)) {
            return false;
        }
        ClassId arrayTypeClassId = ConeTypeUtilsKt.getClassId((ConeKotlinType)arrayType);
        if (Intrinsics.areEqual((Object)arrayTypeClassId, (Object)StandardClassIds.INSTANCE.getKClass())) {
            return true;
        }
        if (Intrinsics.areEqual((Object)arrayTypeClassId, (Object)StandardClassIds.INSTANCE.getString())) {
            return true;
        }
        ConeKotlinTypeProjection coneKotlinTypeProjection2 = arrayType;
        if (coneKotlinTypeProjection2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType");
        }
        return this.isAllowedClassKind((ConeLookupTagBasedType)coneKotlinTypeProjection2, session2);
    }

    private FirAnnotationClassDeclarationChecker() {
    }

    static {
        FirAnnotationClassDeclarationChecker firAnnotationClassDeclarationChecker;
        INSTANCE = firAnnotationClassDeclarationChecker = new FirAnnotationClassDeclarationChecker();
    }
}

