/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElement;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceChildrenKt;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.PathAwarePropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.PropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.TraverseDirection;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0016\u0010\u0010\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0004\u0012\u00020\u00130\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0004H\u0016J\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\t\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "()V", "canBeValOccurrenceRanges", "", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "isDestructuring", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Z", "analyze", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/PathAwarePropertyInitializationInfo;", "properties", "canBeVal", "symbol", "value", "getDestructuringChildrenCount", "", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Ljava/lang/Integer;", "UninitializedPropertyReporter", "checkers"})
public final class CanBeValChecker
extends AbstractFirPropertyInitializationChecker {
    private static final Set<EventOccurrencesRange> canBeValOccurrenceRanges;
    @NotNull
    public static final CanBeValChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void analyze(@NotNull ControlFlowGraph graph2, @NotNull DiagnosticReporter reporter, @NotNull Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data, @NotNull Set<? extends FirPropertySymbol> properties2) {
        Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(properties2, (String)"properties");
        boolean bl = false;
        Set unprocessedProperties = new LinkedHashSet();
        boolean bl2 = false;
        Map propertiesCharacteristics = new LinkedHashMap();
        UninitializedPropertyReporter reporterVisitor = new UninitializedPropertyReporter(data, properties2, unprocessedProperties, propertiesCharacteristics);
        CfgTraverserKt.traverse(graph2, TraverseDirection.Forward, reporterVisitor);
        for (FirPropertySymbol property2 : unprocessedProperties) {
            if (((FirProperty)property2.getFir()).getSource() instanceof FirFakeSourceElement || this.isDestructuring(property2)) continue;
            propertiesCharacteristics.put(property2, EventOccurrencesRange.ZERO);
        }
        FirSourceElement lastDestructuringSource = null;
        boolean destructuringCanBeVal = false;
        int lastDestructuredVariables = 0;
        Object object = propertiesCharacteristics;
        boolean bl3 = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            boolean bl4;
            FirSourceElement it$iv;
            boolean bl5;
            boolean bl6;
            FirSourceElement firSourceElement;
            boolean $i$f$report;
            FirDiagnosticFactory0<FirSourceElement, PsiElement> factory$iv;
            FirSourceElement source;
            void symbol2;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            boolean bl7 = false;
            object = (FirPropertySymbol)entry2.getKey();
            entry2 = entry;
            bl7 = false;
            EventOccurrencesRange value2 = (EventOccurrencesRange)((Object)entry2.getValue());
            FirSourceElement firSourceElement2 = ((FirProperty)symbol2.getFir()).getSource();
            FirSourceElement firSourceElement3 = source = firSourceElement2 != null ? FirSourceChildrenKt.getChild$default(firSourceElement2, SetsKt.setOf((Object[])new KtKeywordToken[]{KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD}), 0, 1, 2, null) : null;
            if (this.isDestructuring((FirPropertySymbol)symbol2)) {
                lastDestructuringSource = source;
                Integer n = this.getDestructuringChildrenCount((FirPropertySymbol)symbol2);
                if (n == null) {
                    continue;
                }
                lastDestructuredVariables = n;
                destructuringCanBeVal = true;
                continue;
            }
            if (lastDestructuringSource != null) {
                if (lastDestructuredVariables == 1 && destructuringCanBeVal && this.canBeVal((FirPropertySymbol)symbol2, value2)) {
                    void $this$report$iv;
                    DiagnosticReporter diagnosticReporter = reporter;
                    factory$iv = FirErrors.INSTANCE.getCAN_BE_VAL();
                    $i$f$report = false;
                    firSourceElement = lastDestructuringSource;
                    bl6 = false;
                    bl5 = false;
                    it$iv = firSourceElement;
                    bl4 = false;
                    $this$report$iv.report((FirDiagnostic)factory$iv.on(it$iv));
                    lastDestructuringSource = null;
                } else if (!this.canBeVal((FirPropertySymbol)symbol2, value2)) {
                    destructuringCanBeVal = false;
                }
                --lastDestructuredVariables;
                continue;
            }
            if (!this.canBeVal((FirPropertySymbol)symbol2, value2) || ((FirProperty)symbol2.getFir()).getDelegate() != null) continue;
            DiagnosticReporter $this$report$iv = reporter;
            factory$iv = FirErrors.INSTANCE.getCAN_BE_VAL();
            $i$f$report = false;
            if (source == null) continue;
            bl6 = false;
            bl5 = false;
            it$iv = firSourceElement;
            bl4 = false;
            $this$report$iv.report((FirDiagnostic)factory$iv.on(it$iv));
        }
    }

    private final boolean canBeVal(FirPropertySymbol symbol2, EventOccurrencesRange value2) {
        return canBeValOccurrenceRanges.contains((Object)value2) && ((FirProperty)symbol2.getFir()).isVar();
    }

    /*
     * WARNING - void declaration
     */
    private final Integer getDestructuringChildrenCount(FirPropertySymbol $this$getDestructuringChildrenCount) {
        Integer n;
        FirSourceElement firSourceElement = ((FirProperty)$this$getDestructuringChildrenCount.getFir()).getSource();
        if (firSourceElement instanceof FirPsiSourceElement) {
            PsiElement[] psiElementArray = FirSourceElementKt.getPsi((FirElement)$this$getDestructuringChildrenCount.getFir());
            n = psiElementArray != null && (psiElementArray = psiElementArray.getChildren()) != null ? Integer.valueOf(psiElementArray.length - 1) : null;
        } else if (firSourceElement instanceof FirLightSourceElement) {
            void $this$filterTo$iv$iv;
            FirSourceElement firSourceElement2 = ((FirProperty)$this$getDestructuringChildrenCount.getFir()).getSource();
            if (firSourceElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirLightSourceElement");
            }
            FirLightSourceElement source = (FirLightSourceElement)firSourceElement2;
            FirSourceElement firSourceElement3 = ((FirProperty)$this$getDestructuringChildrenCount.getFir()).getSource();
            if (firSourceElement3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirLightSourceElement");
            }
            FlyweightCapableTreeStructure<LighterASTNode> tree = ((FirLightSourceElement)firSourceElement3).getTreeStructure();
            List<LighterASTNode> children2 = SourceHelpersKt.getChildren(source.getLighterASTNode(), tree);
            Iterable $this$filter$iv = children2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LighterASTNode it = (LighterASTNode)element$iv$iv;
                boolean bl = false;
                LighterASTNode lighterASTNode2 = it;
                if (!Intrinsics.areEqual((Object)(lighterASTNode2 != null ? lighterASTNode2.getTokenType() : null), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            n = ((List)destination$iv$iv).size();
        } else {
            n = null;
        }
        return n;
    }

    private final boolean isDestructuring(FirPropertySymbol $this$isDestructuring) {
        return Intrinsics.areEqual((Object)$this$isDestructuring.getCallableId().getCallableName().asString(), (Object)"<destruct>");
    }

    private CanBeValChecker() {
    }

    static {
        CanBeValChecker canBeValChecker;
        INSTANCE = canBeValChecker = new CanBeValChecker();
        canBeValOccurrenceRanges = SetsKt.setOf((Object[])new EventOccurrencesRange[]{EventOccurrencesRange.EXACTLY_ONCE, EventOccurrencesRange.AT_MOST_ONCE, EventOccurrencesRange.ZERO});
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BM\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001bH\u0016R!\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/CanBeValChecker$UninitializedPropertyReporter;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/PathAwarePropertyInitializationInfo;", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "unprocessedProperties", "", "propertiesCharacteristics", "", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "(Ljava/util/Map;Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;)V", "getData", "()Ljava/util/Map;", "getLocalProperties", "()Ljava/util/Set;", "getPropertiesCharacteristics", "getUnprocessedProperties", "visitNode", "", "node", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "checkers"})
    private static final class UninitializedPropertyReporter
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data;
        @NotNull
        private final Set<FirPropertySymbol> localProperties;
        @NotNull
        private final Set<FirPropertySymbol> unprocessedProperties;
        @NotNull
        private final Map<FirPropertySymbol, EventOccurrencesRange> propertiesCharacteristics;

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            FirReference firReference = node.getFir().getCalleeReference();
            if (!(firReference instanceof FirResolvedNamedReference)) {
                firReference = null;
            }
            FirResolvedNamedReference firResolvedNamedReference = (FirResolvedNamedReference)firReference;
            AbstractFirBasedSymbol<Object> abstractFirBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
            if (!(abstractFirBasedSymbol instanceof FirPropertySymbol)) {
                abstractFirBasedSymbol = null;
            }
            FirPropertySymbol firPropertySymbol = (FirPropertySymbol)abstractFirBasedSymbol;
            if (firPropertySymbol == null) {
                return;
            }
            FirPropertySymbol symbol2 = firPropertySymbol;
            if (!this.localProperties.contains(symbol2)) {
                return;
            }
            this.unprocessedProperties.remove(symbol2);
            EventOccurrencesRange currentCharacteristic = this.propertiesCharacteristics.getOrDefault(symbol2, EventOccurrencesRange.ZERO);
            PathAwarePropertyInitializationInfo info = (PathAwarePropertyInitializationInfo)MapsKt.getValue(this.data, (Object)node);
            EventOccurrencesRange eventOccurrencesRange = (EventOccurrencesRange)((Object)((PropertyInitializationInfo)info.getInfoAtNormalPath$checkers()).get(symbol2));
            if (eventOccurrencesRange == null) {
                eventOccurrencesRange = EventOccurrencesRange.ZERO;
            }
            this.propertiesCharacteristics.put(symbol2, currentCharacteristic.or(eventOccurrencesRange));
        }

        @Override
        public void visitVariableDeclarationNode(@NotNull VariableDeclarationNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            FirPropertySymbol symbol2 = node.getFir().getSymbol();
            if (node.getFir().getInitializer() == null && node.getFir().getDelegate() == null) {
                this.unprocessedProperties.add(symbol2);
            } else {
                this.propertiesCharacteristics.put(symbol2, EventOccurrencesRange.AT_MOST_ONCE);
            }
        }

        @NotNull
        public final Map<CFGNode<?>, PathAwarePropertyInitializationInfo> getData() {
            return this.data;
        }

        @NotNull
        public final Set<FirPropertySymbol> getLocalProperties() {
            return this.localProperties;
        }

        @NotNull
        public final Set<FirPropertySymbol> getUnprocessedProperties() {
            return this.unprocessedProperties;
        }

        @NotNull
        public final Map<FirPropertySymbol, EventOccurrencesRange> getPropertiesCharacteristics() {
            return this.propertiesCharacteristics;
        }

        public UninitializedPropertyReporter(@NotNull Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data, @NotNull Set<? extends FirPropertySymbol> localProperties, @NotNull Set<FirPropertySymbol> unprocessedProperties, @NotNull Map<FirPropertySymbol, EventOccurrencesRange> propertiesCharacteristics) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Intrinsics.checkNotNullParameter(localProperties, (String)"localProperties");
            Intrinsics.checkNotNullParameter(unprocessedProperties, (String)"unprocessedProperties");
            Intrinsics.checkNotNullParameter(propertiesCharacteristics, (String)"propertiesCharacteristics");
            this.data = data;
            this.localProperties = localProperties;
            this.unprocessedProperties = unprocessedProperties;
            this.propertiesCharacteristics = propertiesCharacteristics;
        }
    }
}

