/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.builder.FirResolvedImportBuilder;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirImportResolveTransformerKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageOrClass;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ/\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u0002H\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0017J \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016J \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00122\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00122\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u001cH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0010\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirImportResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "phase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "isAcceptable", "", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "transformElement", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformImport", "Lorg/jetbrains/kotlin/fir/declarations/FirImport;", "import", "transformImportForFqName", "fqName", "delegate", "resolve"})
public class FirImportResolveTransformer
extends FirAbstractTreeTransformer {
    private final FirSymbolProvider symbolProvider;
    @NotNull
    private final FirSession session;

    @Override
    @NotNull
    public <E extends FirElement> CompositeTransformResult<E> transformElement(@NotNull E element, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        E $this$compose$iv = element;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @Override
    @NotNull
    public CompositeTransformResult<FirFile> transformFile(@NotNull FirFile file2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.checkSessionConsistency(file2);
        file2.replaceResolvePhase(this.getTransformerPhase());
        FirFile firFile = file2;
        boolean bl = false;
        boolean bl2 = false;
        FirFile it = firFile;
        boolean bl3 = false;
        it.transformChildren(this, null);
        FirElement $this$compose$iv = firFile;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @Override
    @NotNull
    public CompositeTransformResult<FirImport> transformImport(@NotNull FirImport firImport, @Nullable Void data) {
        boolean $i$f$compose;
        FirElement $this$compose$iv;
        FqName fqName2;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)firImport, (String)"import");
                fqName2 = firImport.getImportedFqName();
                if (fqName2 == null) break block5;
                FqName fqName3 = fqName2;
                boolean bl = false;
                boolean bl2 = false;
                FqName it = fqName3;
                boolean bl3 = false;
                fqName2 = !it.isRoot() ? fqName3 : null;
                if (fqName2 != null) break block6;
            }
            $this$compose$iv = firImport;
            $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }
        FqName fqName4 = fqName2;
        if (!this.isAcceptable(fqName4)) {
            $this$compose$iv = firImport;
            $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }
        if (firImport.isAllUnder()) {
            return this.transformImportForFqName(fqName4, firImport);
        }
        FqName fqName5 = fqName4.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName5, (String)"fqName.parent()");
        FqName parentFqName = fqName5;
        return this.transformImportForFqName(parentFqName, firImport);
    }

    protected boolean isAcceptable(@NotNull FqName $this$isAcceptable) {
        Intrinsics.checkNotNullParameter((Object)$this$isAcceptable, (String)"$this$isAcceptable");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final CompositeTransformResult<FirImport> transformImportForFqName(FqName fqName2, FirImport delegate) {
        void $this$compose$iv;
        void packageFqName;
        PackageOrClass packageOrClass = FirImportResolveTransformerKt.resolveToPackageOrClass(this.symbolProvider, fqName2);
        if (packageOrClass == null) {
            FirElement $this$compose$iv22 = delegate;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv22);
        }
        PackageOrClass packageOrClass2 = packageOrClass;
        FqName fqName3 = packageOrClass2.component1();
        FqName relativeClassFqName = packageOrClass2.component2();
        boolean $i$f$buildResolvedImport22 = false;
        boolean $this$compose$iv22 = false;
        FirResolvedImportBuilder $this$compose$iv22 = new FirResolvedImportBuilder();
        boolean bl = false;
        boolean bl2 = false;
        FirResolvedImportBuilder $this$buildResolvedImport = $this$compose$iv22;
        boolean bl3 = false;
        $this$buildResolvedImport.setDelegate(delegate);
        $this$buildResolvedImport.setPackageFqName((FqName)packageFqName);
        $this$buildResolvedImport.setRelativeClassName(relativeClassFqName);
        FirElement $i$f$buildResolvedImport22 = $this$compose$iv22.build();
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @Override
    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    protected FirImportResolveTransformer(@NotNull FirSession session2, @NotNull FirResolvePhase phase) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        super(phase);
        this.session = session2;
        this.symbolProvider = MainSessionComponentsKt.getFirSymbolProvider(this.session);
    }

    public FirImportResolveTransformer(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this(session2, FirResolvePhase.IMPORTS);
    }
}

