/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageOrClass;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"resolveToPackageOrClass", "Lorg/jetbrains/kotlin/fir/resolve/transformers/PackageOrClass;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "resolve"})
public final class FirImportResolveTransformerKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final PackageOrClass resolveToPackageOrClass(@NotNull FirSymbolProvider symbolProvider2, @NotNull FqName fqName2) {
        void $this$mapTo$iv$iv;
        int prefixSize;
        Intrinsics.checkNotNullParameter((Object)symbolProvider2, (String)"symbolProvider");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        FqName currentPackage = fqName2;
        List<Name> list2 = fqName2.pathSegments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"fqName.pathSegments()");
        List<Name> pathSegments = list2;
        for (prefixSize = pathSegments.size(); !currentPackage.isRoot() && prefixSize > 0 && symbolProvider2.getPackage(currentPackage) == null; --prefixSize) {
            Intrinsics.checkNotNullExpressionValue((Object)currentPackage.parent(), (String)"currentPackage.parent()");
        }
        if (Intrinsics.areEqual((Object)currentPackage, (Object)fqName2)) {
            return new PackageOrClass(currentPackage, null, null);
        }
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)prefixSize, (int)pathSegments.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = pathSegments.get((int)it).asString();
            collection.add(string2);
        }
        FqName fqName3 = FqName.fromSegments((List)destination$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"FqName.fromSegments((pre\u2026egments[it].asString() })");
        FqName relativeClassFqName = fqName3;
        ClassId classId = new ClassId(currentPackage, relativeClassFqName, false);
        FirClassLikeSymbol<?> firClassLikeSymbol = symbolProvider2.getClassLikeSymbolByFqName(classId);
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> symbol2 = firClassLikeSymbol;
        return new PackageOrClass(currentPackage, relativeClassFqName, symbol2);
    }
}

