/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.body.resolve;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.CopyUtilsKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirVarargArgumentsExpressionBuilder;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.BodyResolveUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001aX\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n`\u000b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\"\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n`\u000bH\u0000\u001a\u0016\u0010\u0010\u001a\u00020\u000e*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\"\u0010\u0014\u001a\u0002H\u0015\"\n\b\u0000\u0010\u0015\u0018\u0001*\u00020\u0016*\u0006\u0012\u0002\b\u00030\u0017H\u0086\b\u00a2\u0006\u0002\u0010\u0018\u001a\u0012\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013\"*\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\u00018\u00c0\u0002@\u00c0\u0002X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"type", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "resultType", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getResultType", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "setResultType", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)V", "remapArgumentsWithVararg", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lkotlin/collections/LinkedHashMap;", "varargParameter", "varargArrayType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "argumentMapping", "expectedConeType", "Lorg/jetbrains/kotlin/fir/expressions/FirConstKind;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "firUnsafe", "T", "Lorg/jetbrains/kotlin/fir/FirElement;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Lorg/jetbrains/kotlin/fir/FirElement;", "writeResultType", "", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "resolve"})
public final class BodyResolveUtilsKt {
    public static final /* synthetic */ <T extends FirElement> T firUnsafe(FirBasedSymbol<?> $this$firUnsafe) {
        int $i$f$firUnsafe = 0;
        Intrinsics.checkNotNullParameter($this$firUnsafe, (String)"$this$firUnsafe");
        Object fir = $this$firUnsafe.getFir();
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        boolean bl = fir instanceof FirElement;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            StringBuilder stringBuilder2 = new StringBuilder().append("Not an expected fir element type = ");
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            String string2 = stringBuilder2.append(Reflection.getOrCreateKotlinClass(FirElement.class)).append(", symbol = ").append($this$firUnsafe).append(", fir = ").append(FirRendererKt.renderWithType$default((FirElement)fir, null, 1, null)).toString();
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return (T)((FirElement)fir);
    }

    @NotNull
    public static final FirTypeRef getResultType(@NotNull FirExpression $this$resultType) {
        int $i$f$getResultType = 0;
        Intrinsics.checkNotNullParameter((Object)$this$resultType, (String)"$this$resultType");
        return $this$resultType.getTypeRef();
    }

    public static final void setResultType(@NotNull FirExpression $this$resultType, @NotNull FirTypeRef type2) {
        int $i$f$setResultType = 0;
        Intrinsics.checkNotNullParameter((Object)$this$resultType, (String)"$this$resultType");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        $this$resultType.replaceTypeRef(type2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final LinkedHashMap<FirExpression, FirValueParameter> remapArgumentsWithVararg(@NotNull FirValueParameter varargParameter, @NotNull ConeKotlinType varargArrayType, @NotNull LinkedHashMap<FirExpression, FirValueParameter> argumentMapping) {
        Intrinsics.checkNotNullParameter((Object)varargParameter, (String)"varargParameter");
        Intrinsics.checkNotNullParameter((Object)varargArrayType, (String)"varargArrayType");
        Intrinsics.checkNotNullParameter(argumentMapping, (String)"argumentMapping");
        FirTypeRef varargParameterTypeRef = varargParameter.getReturnTypeRef();
        ConeKotlinType varargElementType = ArrayUtilsKt.arrayElementType(varargArrayType);
        Set<FirExpression> set = argumentMapping.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"argumentMapping.keys");
        List argumentList2 = CollectionsKt.toList((Iterable)set);
        int indexAfterVarargs = argumentList2.size();
        boolean bl = false;
        LinkedHashMap<FirExpression, FirValueParameter> newArgumentMapping = new LinkedHashMap<FirExpression, FirValueParameter>();
        int $i$f$buildVarargArgumentsExpression = 0;
        boolean bl2 = false;
        FirVarargArgumentsExpressionBuilder firVarargArgumentsExpressionBuilder = new FirVarargArgumentsExpressionBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        FirVarargArgumentsExpressionBuilder $this$buildVarargArgumentsExpression = firVarargArgumentsExpressionBuilder;
        boolean bl5 = false;
        $this$buildVarargArgumentsExpression.setVarargElementType(TypeUtilsKt.withReplacedConeType$default(varargParameterTypeRef, varargElementType, null, 2, null));
        $this$buildVarargArgumentsExpression.setTypeRef(TypeUtilsKt.withReplacedConeType$default(varargParameterTypeRef, varargArrayType, null, 2, null));
        boolean bl6 = false;
        for (FirExpression arg : (Iterable)argumentList2) {
            void i;
            Map map2 = argumentMapping;
            FirExpression firExpression2 = arg;
            Intrinsics.checkNotNullExpressionValue((Object)firExpression2, (String)"arg");
            FirValueParameter valueParameter = (FirValueParameter)MapsKt.getValue((Map)map2, (Object)firExpression2);
            if (Intrinsics.areEqual((Object)valueParameter, (Object)varargParameter) || valueParameter.isVararg() && !(arg instanceof FirNamedArgumentExpression)) {
                Collection collection = $this$buildVarargArgumentsExpression.getArguments();
                boolean bl7 = false;
                collection.add(arg);
                if ($this$buildVarargArgumentsExpression.getSource() == null) {
                    FirSourceElement firSourceElement = arg.getSource();
                    $this$buildVarargArgumentsExpression.setSource(firSourceElement != null ? FirSourceElementKt.fakeElement(firSourceElement, FirFakeSourceElementKind.VarargArgument.INSTANCE) : null);
                }
            } else if ($this$buildVarargArgumentsExpression.getArguments().isEmpty()) {
                ((Map)newArgumentMapping).put(arg, valueParameter);
            } else {
                indexAfterVarargs = i;
                break;
            }
            ++i;
        }
        FirVarargArgumentsExpression varargArgument = firVarargArgumentsExpressionBuilder.build();
        ((Map)newArgumentMapping).put(varargArgument, varargParameter);
        $i$f$buildVarargArgumentsExpression = indexAfterVarargs;
        int n = argumentList2.size();
        while ($i$f$buildVarargArgumentsExpression < n) {
            void i;
            Object e = argumentList2.get((int)i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"argumentList[i]");
            FirExpression arg = (FirExpression)e;
            ((Map)newArgumentMapping).put(arg, MapsKt.getValue((Map)argumentMapping, (Object)arg));
            ++i;
        }
        return newArgumentMapping;
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeResultType(@NotNull FirBlock $this$writeResultType, @NotNull FirSession session2) {
        void type$iv;
        FirTypeRef theType;
        FirTypeRef firTypeRef;
        Intrinsics.checkNotNullParameter((Object)$this$writeResultType, (String)"$this$writeResultType");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirStatement statement2 = (FirStatement)CollectionsKt.lastOrNull($this$writeResultType.getStatements());
        FirExpression resultExpression = statement2 instanceof FirReturnExpression ? ((FirReturnExpression)statement2).getResult() : (statement2 instanceof FirExpression ? (FirExpression)statement2 : null);
        FirExpression firExpression2 = $this$writeResultType;
        if (resultExpression == null) {
            FirExpression $this$resultType$iv = $this$writeResultType;
            boolean $i$f$getResultType = false;
            firTypeRef = CopyUtilsKt.resolvedTypeFromPrototype($this$resultType$iv.getTypeRef(), session2.getBuiltinTypes().getUnitType().getType());
        } else {
            FirResolvedTypeRef firResolvedTypeRef;
            boolean bl;
            FirExpression $this$resultType$iv = resultExpression;
            boolean $i$f$getResultType = false;
            theType = $this$resultType$iv.getTypeRef();
            if (theType instanceof FirResolvedTypeRef) {
                void $this$buildResolvedTypeRef;
                boolean $i$f$buildResolvedTypeRef = false;
                bl = false;
                FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
                boolean bl2 = false;
                boolean bl3 = false;
                FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = firResolvedTypeRefBuilder;
                FirExpression firExpression3 = firExpression2;
                boolean bl4 = false;
                FirSourceElement firSourceElement = theType.getSource();
                $this$buildResolvedTypeRef.setSource(firSourceElement != null ? FirSourceElementKt.fakeElement(firSourceElement, FirFakeSourceElementKind.ImplicitTypeRef.INSTANCE) : null);
                $this$buildResolvedTypeRef.setType(((FirResolvedTypeRef)theType).getType());
                Collection collection = $this$buildResolvedTypeRef.getAnnotations();
                Iterable iterable = theType.getAnnotations();
                boolean bl5 = false;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                Unit unit = Unit.INSTANCE;
                firExpression2 = firExpression3;
                firResolvedTypeRef = firResolvedTypeRefBuilder.build();
            } else {
                void $this$buildErrorTypeRef;
                boolean $i$f$buildErrorTypeRef = false;
                bl = false;
                FirErrorTypeRefBuilder firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
                boolean bl6 = false;
                boolean bl7 = false;
                FirErrorTypeRefBuilder $this$buildResolvedTypeRef = firErrorTypeRefBuilder;
                FirExpression firExpression4 = firExpression2;
                boolean bl8 = false;
                $this$buildErrorTypeRef.setDiagnostic(new ConeSimpleDiagnostic("No type for block", DiagnosticKind.InferenceError));
                Unit unit = Unit.INSTANCE;
                firExpression2 = firExpression4;
                firResolvedTypeRef = firErrorTypeRefBuilder.build();
            }
            firTypeRef = firResolvedTypeRef;
        }
        theType = firTypeRef;
        FirExpression $this$resultType$iv = firExpression2;
        boolean $i$f$setResultType = false;
        $this$resultType$iv.replaceTypeRef((FirTypeRef)type$iv);
    }

    @NotNull
    public static final ConeKotlinType expectedConeType(@NotNull FirConstKind<?> $this$expectedConeType, @NotNull FirSession session2) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter($this$expectedConeType, (String)"$this$expectedConeType");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Function2<ClassId, Boolean, ConeKotlinType> $fun$constructLiteralType$1 = new Function2<ClassId, Boolean, ConeKotlinType>(session2){
            final /* synthetic */ FirSession $session;

            @NotNull
            public final ConeKotlinType invoke(@NotNull ClassId classId, boolean isNullable) {
                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getFirSymbolProvider(this.$session).getClassLikeSymbolByFqName(classId);
                if (firClassLikeSymbol == null) {
                    return new ConeClassErrorType(new ConeSimpleDiagnostic("Missing stdlib class: " + classId, DiagnosticKind.MissingStdlibClass));
                }
                FirClassLikeSymbol<?> symbol2 = firClassLikeSymbol;
                return TypeConstructionUtilsKt.constructClassType$default(symbol2.toLookupTag(), new ConeTypeProjection[0], isNullable, null, 4, null);
            }

            public static /* synthetic */ ConeKotlinType invoke$default(expectedConeType.1 var0, ClassId classId, boolean bl, int n, Object object) {
                if ((n & 2) != 0) {
                    bl = false;
                }
                return var0.invoke(classId, bl);
            }
            {
                this.$session = firSession;
                super(2);
            }
        };
        FirConstKind<?> firConstKind = $this$expectedConeType;
        if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Null.INSTANCE)) {
            coneKotlinType = session2.getBuiltinTypes().getNullableNothingType().getType();
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Boolean.INSTANCE)) {
            coneKotlinType = session2.getBuiltinTypes().getBooleanType().getType();
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Char.INSTANCE)) {
            coneKotlinType = expectedConeType.1.invoke$default($fun$constructLiteralType$1, StandardClassIds.INSTANCE.getChar(), false, 2, null);
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Byte.INSTANCE)) {
            coneKotlinType = expectedConeType.1.invoke$default($fun$constructLiteralType$1, StandardClassIds.INSTANCE.getByte(), false, 2, null);
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Short.INSTANCE)) {
            coneKotlinType = expectedConeType.1.invoke$default($fun$constructLiteralType$1, StandardClassIds.INSTANCE.getShort(), false, 2, null);
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Int.INSTANCE)) {
            coneKotlinType = expectedConeType.1.invoke$default($fun$constructLiteralType$1, StandardClassIds.INSTANCE.getInt(), false, 2, null);
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Long.INSTANCE)) {
            coneKotlinType = expectedConeType.1.invoke$default($fun$constructLiteralType$1, StandardClassIds.INSTANCE.getLong(), false, 2, null);
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.String.INSTANCE)) {
            coneKotlinType = expectedConeType.1.invoke$default($fun$constructLiteralType$1, StandardClassIds.INSTANCE.getString(), false, 2, null);
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Float.INSTANCE)) {
            coneKotlinType = expectedConeType.1.invoke$default($fun$constructLiteralType$1, StandardClassIds.INSTANCE.getFloat(), false, 2, null);
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Double.INSTANCE)) {
            coneKotlinType = expectedConeType.1.invoke$default($fun$constructLiteralType$1, StandardClassIds.INSTANCE.getDouble(), false, 2, null);
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.UnsignedByte.INSTANCE)) {
            coneKotlinType = expectedConeType.1.invoke$default($fun$constructLiteralType$1, StandardClassIds.INSTANCE.getUByte(), false, 2, null);
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.UnsignedShort.INSTANCE)) {
            coneKotlinType = expectedConeType.1.invoke$default($fun$constructLiteralType$1, StandardClassIds.INSTANCE.getUShort(), false, 2, null);
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.UnsignedInt.INSTANCE)) {
            coneKotlinType = expectedConeType.1.invoke$default($fun$constructLiteralType$1, StandardClassIds.INSTANCE.getUInt(), false, 2, null);
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.UnsignedLong.INSTANCE)) {
            coneKotlinType = expectedConeType.1.invoke$default($fun$constructLiteralType$1, StandardClassIds.INSTANCE.getULong(), false, 2, null);
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.IntegerLiteral.INSTANCE)) {
            coneKotlinType = expectedConeType.1.invoke$default($fun$constructLiteralType$1, StandardClassIds.INSTANCE.getInt(), false, 2, null);
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.UnsignedIntegerLiteral.INSTANCE)) {
            coneKotlinType = expectedConeType.1.invoke$default($fun$constructLiteralType$1, StandardClassIds.INSTANCE.getUInt(), false, 2, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType;
    }
}

