/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.export.ErrorDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGenerator$WhenMappings;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.export.Exportability;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedClass;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedConstructor;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedFunction;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedModule;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedNamespace;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedParameter;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedProperty;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedType;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6AddInternalParametersToConstructorPhase;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunctionKt;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0)2\u0006\u0010*\u001a\u00020+J\f\u0010,\u001a\u00020-*\u00020.H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/export/ExportModelGenerator;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "classExportability", "Lorg/jetbrains/kotlin/ir/backend/js/export/Exportability;", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "exportClass", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedDeclaration;", "exportConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "exportDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "exportFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "exportParameter", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedParameter;", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "exportProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "exportType", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedType;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "exportTypeArgument", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "functionExportability", "generateExport", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedModule;", "modules", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "getExportedIdentifier", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "backend.js"})
public final class ExportModelGenerator {
    @NotNull
    private final JsIrBackendContext context;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ExportedDeclaration> generateExport(@NotNull IrPackageFragment file2) {
        List list2;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FqName namespaceFqName = file2.getFqName();
        Iterable $this$flatMap$iv = file2.getDeclarations();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrDeclaration declaration2 = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object)this.exportDeclaration(declaration2));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List exports = (List)destination$iv$iv;
        if (exports.isEmpty()) {
            list2 = CollectionsKt.emptyList();
        } else if (namespaceFqName.isRoot()) {
            list2 = exports;
        } else {
            String string2 = namespaceFqName.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"namespaceFqName.toString()");
            list2 = CollectionsKt.listOf((Object)new ExportedNamespace(string2, exports));
        }
        return list2;
    }

    @NotNull
    public final ExportedModule generateExport(@NotNull Iterable<? extends IrModuleFragment> modules) {
        Iterable list$iv$iv;
        IrElementBase it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        String string2 = this.context.getConfiguration().get(CommonConfigurationKeys.MODULE_NAME);
        Intrinsics.checkNotNull((Object)string2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.configuration[Co\u2026rationKeys.MODULE_NAME]!!");
        ModuleKind moduleKind = this.context.getConfiguration().get(JSConfigurationKeys.MODULE_KIND);
        Intrinsics.checkNotNull((Object)((Object)moduleKind));
        Intrinsics.checkNotNullExpressionValue((Object)((Object)moduleKind), (String)"context.configuration[JS\u2026rationKeys.MODULE_KIND]!!");
        Iterable<? extends IrModuleFragment> iterable = modules;
        List list2 = this.context.getExternalPackageFragment().values();
        ModuleKind moduleKind2 = moduleKind;
        String string3 = string2;
        boolean $i$f$flatMap = false;
        void var4_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IrModuleFragment)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        $this$flatMap$iv = CollectionsKt.plus(list2, (Iterable)list3);
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IrFile)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.generateExport((IrPackageFragment)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list4 = list2 = (List)destination$iv$iv;
        ModuleKind moduleKind3 = moduleKind2;
        String string4 = string3;
        return new ExportedModule(string4, moduleKind3, list4);
    }

    private final ExportedDeclaration exportDeclaration(IrDeclaration declaration2) {
        ExportedDeclaration exportedDeclaration;
        IrDeclarationWithName irDeclarationWithName = ExportModelGeneratorKt.access$getExportCandidate(declaration2);
        if (irDeclarationWithName == null) {
            return null;
        }
        IrDeclarationWithName candidate2 = irDeclarationWithName;
        if (!ExportModelGeneratorKt.access$shouldDeclarationBeExported(candidate2, this.context)) {
            return null;
        }
        IrDeclarationWithName irDeclarationWithName2 = candidate2;
        if (irDeclarationWithName2 instanceof IrSimpleFunction) {
            exportedDeclaration = this.exportFunction((IrSimpleFunction)candidate2);
        } else if (irDeclarationWithName2 instanceof IrProperty) {
            exportedDeclaration = this.exportProperty((IrProperty)candidate2);
        } else if (irDeclarationWithName2 instanceof IrClass) {
            exportedDeclaration = this.exportClass((IrClass)candidate2);
        } else if (irDeclarationWithName2 instanceof IrField) {
            exportedDeclaration = null;
        } else {
            String string2 = "Can't export declaration " + candidate2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return exportedDeclaration;
    }

    private final ExportedDeclaration exportFunction(IrSimpleFunction function2) {
        ExportedDeclaration exportedDeclaration;
        Exportability exportability = this.functionExportability(function2);
        if (exportability instanceof Exportability.NotNeeded) {
            exportedDeclaration = null;
        } else if (exportability instanceof Exportability.Prohibited) {
            exportedDeclaration = new ErrorDeclaration(((Exportability.Prohibited)exportability).getReason());
        } else if (exportability instanceof Exportability.Allowed) {
            Object object;
            IrTypeParameter it;
            Collection<ExportedParameter> collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            IrDeclarationParent parent2 = function2.getParent();
            Iterable iterable = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)function2.getExtensionReceiverParameter()), (Iterable)function2.getValueParameters());
            ExportedType exportedType = this.exportType(function2.getReturnType());
            String string2 = this.getExportedIdentifier(function2);
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object = this.exportParameter((IrValueParameter)((Object)it));
                collection.add((ExportedParameter)object);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = function2.getTypeParameters();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string3;
                it = (IrTypeParameter)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getName().getIdentifier(), (String)"it.name.identifier");
                object.add(string3);
            }
            object = (List)destination$iv$iv;
            IrSimpleFunction irSimpleFunction = function2;
            boolean bl = parent2 instanceof IrClass && !IrUtilsKt.isInterface((IrClass)parent2) && function2.getModality() == Modality.ABSTRACT;
            boolean bl2 = IrFunctionKt.isStaticMethodOfClass(function2);
            boolean bl3 = parent2 instanceof IrClass;
            Object object2 = object;
            Collection<ExportedParameter> collection2 = collection;
            ExportedType exportedType2 = exportedType;
            String string4 = string2;
            exportedDeclaration = new ExportedFunction(string4, exportedType2, (List<ExportedParameter>)collection2, (List<String>)object2, bl3, bl2, bl, irSimpleFunction);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return exportedDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportConstructor(IrConstructor constructor2) {
        Collection<ExportedParameter> collection;
        void $this$mapTo$iv$iv;
        IrValueParameter it;
        Iterable $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        if (!constructor2.isPrimary()) {
            return null;
        }
        Iterable iterable = constructor2.getValueParameters();
        Collection collection2 = CollectionsKt.listOfNotNull((Object)constructor2.getExtensionReceiverParameter());
        boolean $i$f$filterNot = false;
        void var5_5 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (IrValueParameter)element$iv$iv;
            boolean bl = false;
            if (it.getOrigin() == ES6AddInternalParametersToConstructorPhase.ES6_RESULT_TYPE_PARAMETER.INSTANCE || it.getOrigin() == ES6AddInternalParametersToConstructorPhase.ES6_INIT_BOX_PARAMETER.INSTANCE) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        List allValueParameters = CollectionsKt.plus((Collection)collection2, (Iterable)list2);
        Iterable $this$map$iv = allValueParameters;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ExportedParameter exportedParameter = this.exportParameter(it);
            collection.add(exportedParameter);
        }
        collection = (List)destination$iv$iv;
        List list3 = collection;
        return new ExportedConstructor(list3);
    }

    private final ExportedParameter exportParameter(IrValueParameter parameter) {
        String string2 = parameter.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parameter.name.asString()");
        String parameterName = NameTablesKt.sanitizeName(string2);
        if (ExportModelGeneratorKt.access$getAllReservedWords$p().contains(parameterName)) {
            parameterName = '_' + parameterName;
        }
        return new ExportedParameter(parameterName, this.exportType(parameter.getType()));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ExportedDeclaration exportProperty(IrProperty property2) {
        boolean bl;
        for (IrSimpleFunction accessor : CollectionsKt.listOfNotNull((Object[])new IrSimpleFunction[]{property2.getGetter(), property2.getSetter()})) {
            if (accessor.getExtensionReceiverParameter() != null) {
                return null;
            }
            if (!accessor.isFakeOverride()) continue;
            return null;
        }
        IrDeclarationParent irDeclarationParent = property2.getParent();
        if (!(irDeclarationParent instanceof IrClass)) {
            irDeclarationParent = null;
        }
        IrClass parentClass = (IrClass)irDeclarationParent;
        String string2 = this.getExportedIdentifier(property2);
        IrSimpleFunction irSimpleFunction = property2.getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        ExportedType exportedType = this.exportType(irSimpleFunction.getReturnType());
        boolean bl2 = property2.isVar();
        boolean bl3 = parentClass != null;
        IrClass irClass2 = parentClass;
        if (irClass2 != null && !IrUtilsKt.isInterface(irClass2) && property2.getModality() == Modality.ABSTRACT) {
            bl = true;
            return new ExportedProperty(string2, exportedType, bl2, bl3, false, bl, property2.getGetter(), property2.getSetter());
        }
        bl = false;
        return new ExportedProperty(string2, exportedType, bl2, bl3, false, bl, property2.getGetter(), property2.getSetter());
    }

    private final Exportability classExportability(IrClass klass) {
        switch (ExportModelGenerator$WhenMappings.$EnumSwitchMapping$0[klass.getKind().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return new Exportability.Prohibited("Class " + IrUtilsKt.getFqNameWhenAvailable(klass) + " with kind: " + (Object)((Object)klass.getKind()));
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        if (klass.isInline()) {
            return new Exportability.Prohibited("Inline class " + IrUtilsKt.getFqNameWhenAvailable(klass));
        }
        return Exportability.Allowed.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportClass(IrClass klass) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        ExportedType exportedType;
        Object it;
        Object v0;
        IrType $this$firstOrNull$iv;
        boolean $i$f$firstOrNull2;
        List typeParameters2;
        Object object;
        boolean bl;
        Collection collection;
        List nestedClasses2;
        List members;
        block20: {
            void $this$mapTo$iv$iv2;
            Object object2;
            Exportability exportability = this.classExportability(klass);
            if (exportability instanceof Exportability.Prohibited) {
                String string2 = ((Exportability.Prohibited)exportability).getReason();
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            if (exportability instanceof Exportability.NotNeeded) {
                return null;
            }
            boolean bl3 = false;
            members = new ArrayList();
            boolean bl4 = false;
            nestedClasses2 = new ArrayList();
            for (IrDeclaration declaration2 : klass.getDeclarations()) {
                boolean bl5;
                Object ec2;
                IrDeclarationWithName candidate2;
                if (ExportModelGeneratorKt.access$getExportCandidate(declaration2) == null) {
                    continue;
                }
                if (!ExportModelGeneratorKt.access$shouldDeclarationBeExported(candidate2, this.context)) continue;
                object2 = candidate2;
                if (object2 instanceof IrSimpleFunction) {
                    org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(members, this.exportFunction((IrSimpleFunction)candidate2));
                    continue;
                }
                if (object2 instanceof IrConstructor) {
                    org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(members, this.exportConstructor((IrConstructor)candidate2));
                    continue;
                }
                if (object2 instanceof IrProperty) {
                    org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(members, this.exportProperty((IrProperty)candidate2));
                    continue;
                }
                if (object2 instanceof IrClass) {
                    ec2 = this.exportClass((IrClass)candidate2);
                    if (ec2 instanceof ExportedClass) {
                        nestedClasses2.add(ec2);
                        continue;
                    }
                    org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(members, ec2);
                    continue;
                }
                if (object2 instanceof IrField) {
                    boolean ec2 = Intrinsics.areEqual((Object)candidate2.getOrigin(), (Object)IrDeclarationOrigin.FIELD_FOR_OBJECT_INSTANCE.INSTANCE) || ((IrField)candidate2).getCorrespondingPropertySymbol() != null;
                    bl5 = false;
                    if (!_Assertions.ENABLED || ec2) continue;
                    boolean $i$a$-assert-ExportModelGenerator$exportClass$22 = false;
                    String $i$a$-assert-ExportModelGenerator$exportClass$22 = "Unexpected field without property " + IrUtilsKt.getFqNameWhenAvailable(candidate2);
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ExportModelGenerator$exportClass$22));
                }
                ec2 = "Can't export member declaration " + declaration2;
                bl5 = false;
                throw (Throwable)new IllegalStateException(ec2.toString());
            }
            Iterable $this$map$iv2 = klass.getTypeParameters();
            boolean $i$f$map22 = false;
            object2 = $this$map$iv2;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                object = it2.getName().getIdentifier();
                collection.add(object);
            }
            typeParameters2 = (List)destination$iv$iv;
            Iterable $i$f$map22 = klass.getSuperTypes();
            $i$f$firstOrNull2 = false;
            destination$iv$iv = $this$firstOrNull$iv.iterator();
            while (destination$iv$iv.hasNext()) {
                Object element$iv = destination$iv$iv.next();
                IrType it3 = (IrType)element$iv;
                boolean bl6 = false;
                if (!(!ExportModelGeneratorKt.access$isInterface$p(IrTypesKt.getClassifierOrFail(it3)) && !IrTypePredicatesKt.isAny(it3))) continue;
                v0 = element$iv;
                break block20;
            }
            v0 = null;
        }
        IrType irType = v0;
        if (irType != null) {
            $this$firstOrNull$iv = irType;
            $i$f$firstOrNull2 = false;
            boolean destination$iv$iv = false;
            IrType it4 = $this$firstOrNull$iv;
            boolean bl7 = false;
            ExportedType bl6 = this.exportType(it4);
            boolean bl8 = false;
            bl = false;
            it = bl6;
            boolean bl9 = false;
            exportedType = !(it instanceof ExportedType.ErrorType) ? bl6 : null;
        } else {
            exportedType = null;
        }
        ExportedType superType = exportedType;
        Iterable $i$f$firstOrNull2 = klass.getSuperTypes();
        boolean $i$f$filter = false;
        void it4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrType)element$iv$iv;
            boolean bl10 = false;
            if (!ExportModelGeneratorKt.access$isInterface$p(IrTypesKt.getClassifierOrFail((IrType)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl11 = false;
            object = this.exportType((IrType)it);
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ExportedType)element$iv$iv;
            boolean bl12 = false;
            if (!(!(it instanceof ExportedType.ErrorType))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List superInterfaces = (List)destination$iv$iv;
        String name = this.getExportedIdentifier(klass);
        if (klass.getKind() == ClassKind.OBJECT) {
            ExportedType t = new ExportedType.InlineInterfaceType(CollectionsKt.plus((Collection)members, (Iterable)nestedClasses2));
            if (superType != null) {
                t = new ExportedType.IntersectionType(t, superType);
            }
            for (ExportedType superInterface : superInterfaces) {
                t = new ExportedType.IntersectionType(t, superInterface);
            }
            boolean bl13 = klass.getParent() instanceof IrClass;
            IrSimpleFunction irSimpleFunction = this.context.getMapping().getObjectToGetInstanceFunction().get((IrClass)((IrDeclaration)klass));
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            return new ExportedProperty(name, t, false, bl13, true, false, irSimpleFunction, null);
        }
        return new ExportedClass(name, IrUtilsKt.isInterface(klass), klass.getModality() == Modality.ABSTRACT, superType, superInterfaces, typeParameters2, members, nestedClasses2, klass);
    }

    private final ExportedType exportTypeArgument(IrTypeArgument type2) {
        if (type2 instanceof IrTypeProjection) {
            return this.exportType(((IrTypeProjection)type2).getType());
        }
        if (type2 instanceof IrType) {
            return this.exportType((IrType)((Object)type2));
        }
        return new ExportedType.ErrorType("UnknownType " + RenderIrElementKt.render(type2));
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedType exportType(IrType type2) {
        ExportedType exportedType;
        boolean isNullable;
        block11: {
            IrClassifierSymbol classifier2;
            block30: {
                Object object;
                Object object2;
                Iterable $this$mapTo$iv$iv;
                block29: {
                    block28: {
                        IrSimpleType nonNullType;
                        block27: {
                            block26: {
                                block25: {
                                    block24: {
                                        block23: {
                                            block22: {
                                                block21: {
                                                    block20: {
                                                        block19: {
                                                            block18: {
                                                                block17: {
                                                                    block16: {
                                                                        block15: {
                                                                            block14: {
                                                                                block13: {
                                                                                    block12: {
                                                                                        block10: {
                                                                                            if (type2 instanceof IrDynamicType) {
                                                                                                return ExportedType.Primitive.Any.INSTANCE;
                                                                                            }
                                                                                            if (!(type2 instanceof IrSimpleType)) {
                                                                                                return new ExportedType.ErrorType("NonSimpleType " + RenderIrElementKt.render(type2));
                                                                                            }
                                                                                            classifier2 = ((IrSimpleType)type2).getClassifier();
                                                                                            isNullable = ((IrSimpleType)type2).getHasQuestionMark();
                                                                                            IrType irType = IrTypesKt.makeNotNull(type2);
                                                                                            if (irType == null) {
                                                                                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
                                                                                            }
                                                                                            nonNullType = (IrSimpleType)irType;
                                                                                            if (!IrTypePredicatesKt.isBoolean(nonNullType)) break block10;
                                                                                            exportedType = ExportedType.Primitive.Boolean.INSTANCE;
                                                                                            break block11;
                                                                                        }
                                                                                        if (!IrTypePredicatesKt.isPrimitiveType$default(nonNullType, false, 1, null) || IrTypePredicatesKt.isLong(nonNullType) || IrTypePredicatesKt.isChar(nonNullType)) break block12;
                                                                                        exportedType = ExportedType.Primitive.Number.INSTANCE;
                                                                                        break block11;
                                                                                    }
                                                                                    if (!IrTypePredicatesKt.isByteArray(nonNullType)) break block13;
                                                                                    exportedType = ExportedType.Primitive.ByteArray.INSTANCE;
                                                                                    break block11;
                                                                                }
                                                                                if (!IrTypePredicatesKt.isShortArray(nonNullType)) break block14;
                                                                                exportedType = ExportedType.Primitive.ShortArray.INSTANCE;
                                                                                break block11;
                                                                            }
                                                                            if (!IrTypePredicatesKt.isIntArray(nonNullType)) break block15;
                                                                            exportedType = ExportedType.Primitive.IntArray.INSTANCE;
                                                                            break block11;
                                                                        }
                                                                        if (!IrTypePredicatesKt.isFloatArray(nonNullType)) break block16;
                                                                        exportedType = ExportedType.Primitive.FloatArray.INSTANCE;
                                                                        break block11;
                                                                    }
                                                                    if (!IrTypePredicatesKt.isDoubleArray(nonNullType)) break block17;
                                                                    exportedType = ExportedType.Primitive.DoubleArray.INSTANCE;
                                                                    break block11;
                                                                }
                                                                if (!IrTypePredicatesKt.isBooleanArray(nonNullType)) break block18;
                                                                exportedType = new ExportedType.ErrorType("BooleanArray");
                                                                break block11;
                                                            }
                                                            if (!IrTypePredicatesKt.isLongArray(nonNullType)) break block19;
                                                            exportedType = new ExportedType.ErrorType("LongArray");
                                                            break block11;
                                                        }
                                                        if (!IrTypePredicatesKt.isCharArray(nonNullType)) break block20;
                                                        exportedType = new ExportedType.ErrorType("CharArray");
                                                        break block11;
                                                    }
                                                    if (!IrTypePredicatesKt.isString(nonNullType)) break block21;
                                                    exportedType = ExportedType.Primitive.String.INSTANCE;
                                                    break block11;
                                                }
                                                if (!IrTypeUtilsKt.isThrowable(nonNullType)) break block22;
                                                exportedType = ExportedType.Primitive.Throwable.INSTANCE;
                                                break block11;
                                            }
                                            if (!IrTypePredicatesKt.isAny(nonNullType)) break block23;
                                            exportedType = ExportedType.Primitive.Any.INSTANCE;
                                            break block11;
                                        }
                                        if (!IrTypePredicatesKt.isUnit(nonNullType)) break block24;
                                        exportedType = ExportedType.Primitive.Unit.INSTANCE;
                                        break block11;
                                    }
                                    if (!IrTypePredicatesKt.isNothing(nonNullType)) break block25;
                                    exportedType = ExportedType.Primitive.Nothing.INSTANCE;
                                    break block11;
                                }
                                if (!IrTypePredicatesKt.isArray(nonNullType)) break block26;
                                exportedType = new ExportedType.Array(this.exportTypeArgument(nonNullType.getArguments().get(0)));
                                break block11;
                            }
                            if (!IrTypeUtilsKt.isSuspendFunction(nonNullType)) break block27;
                            exportedType = new ExportedType.ErrorType("Suspend functions are not supported");
                            break block11;
                        }
                        if (!IrTypeUtilsKt.isFunction(nonNullType)) break block28;
                        Iterable $this$map$iv = CollectionsKt.dropLast(nonNullType.getArguments(), (int)1);
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                            object2 = destination$iv$iv;
                            boolean bl = false;
                            object = this.exportTypeArgument((IrTypeArgument)it);
                            object2.add(object);
                        }
                        object2 = (List)destination$iv$iv;
                        ExportedType exportedType2 = this.exportTypeArgument((IrTypeArgument)CollectionsKt.last(nonNullType.getArguments()));
                        List list2 = object2;
                        exportedType = new ExportedType.Function(list2, exportedType2);
                        break block11;
                    }
                    if (!(classifier2 instanceof IrTypeParameterSymbol)) break block29;
                    String string2 = ((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()).getName().getIdentifier();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classifier.owner.name.identifier");
                    exportedType = new ExportedType.TypeParameter(string2);
                    break block11;
                }
                if (!(classifier2 instanceof IrClassSymbol)) break block30;
                IrClass klass = (IrClass)((IrClassSymbol)classifier2).getOwner();
                FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(klass);
                Intrinsics.checkNotNull((Object)fqName2);
                String string3 = fqName2.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"klass.fqNameWhenAvailable!!.asString()");
                String name = string3;
                switch (ExportModelGenerator$WhenMappings.$EnumSwitchMapping$1[klass.getKind().ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        exportedType = new ExportedType.ErrorType("Class " + name + " with kind: " + (Object)((Object)klass.getKind()));
                        break block11;
                    }
                    case 4: {
                        exportedType = new ExportedType.TypeOf(name);
                        break block11;
                    }
                    case 5: 
                    case 6: {
                        void $this$mapTo$iv$iv2;
                        void $this$map$iv;
                        $this$mapTo$iv$iv = ((IrSimpleType)type2).getArguments();
                        object2 = name;
                        boolean $i$f$map = false;
                        void $i$f$mapTo = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                            void it;
                            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                            object = destination$iv$iv;
                            boolean bl = false;
                            ExportedType exportedType3 = this.exportTypeArgument((IrTypeArgument)it);
                            object.add(exportedType3);
                        }
                        Object object3 = object = (List)destination$iv$iv;
                        Object object4 = object2;
                        exportedType = new ExportedType.ClassType((String)object4, (List<? extends ExportedType>)object3);
                        break block11;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            String string4 = "Unexpected classifier " + classifier2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string4.toString());
        }
        ExportedType exportedType4 = exportedType;
        return exportedType4.withNullability(isNullable);
    }

    private final String getExportedIdentifier(IrDeclarationWithName $this$getExportedIdentifier) {
        Name name = AnnotationUtilsKt.getJsNameOrKotlinName($this$getExportedIdentifier);
        boolean bl = false;
        boolean bl2 = false;
        Name $this$with = name;
        boolean bl3 = false;
        if ($this$with.isSpecial()) {
            String string2 = "Cannot export special name: " + $this$getExportedIdentifier.getName().asString() + " for declaration " + IrUtilsKt.getFqNameWhenAvailable($this$getExportedIdentifier);
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String string3 = $this$with.getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"with(getJsNameOrKotlinNa\u2026else identifier\n        }");
        return string3;
    }

    private final Exportability functionExportability(IrSimpleFunction function2) {
        if (function2.isInline()) {
            boolean bl;
            block16: {
                Iterable $this$any$iv = function2.getTypeParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrTypeParameter it = (IrTypeParameter)element$iv;
                        boolean bl2 = false;
                        if (!it.isReified()) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return new Exportability.Prohibited("Inline reified function");
            }
        }
        if (function2.isSuspend()) {
            return new Exportability.Prohibited("Suspend function");
        }
        if (function2.isFakeOverride()) {
            return Exportability.NotNeeded.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrDeclarationOrigin.BRIDGE.INSTANCE) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JsLoweredDeclarationOrigin.BRIDGE_TO_EXTERNAL_FUNCTION.INSTANCE) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrDeclarationOrigin.FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JsLoweredDeclarationOrigin.OBJECT_GET_INSTANCE_FUNCTION.INSTANCE)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        if (IrUtilsKt.isFakeOverriddenFromAny(function2)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        String string2 = function2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"function.name.asString()");
        String nameString = string2;
        if (StringsKt.endsWith$default((String)nameString, (String)"-impl", (boolean)false, (int)2, null)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        if (StringsKt.endsWith$default((String)nameString, (String)"$", (boolean)false, (int)2, null)) {
            boolean bl;
            block17: {
                Iterable $this$any$iv = function2.getValueParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl3 = false;
                        String string3 = it.getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.name.asString()");
                        if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"$mask", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return Exportability.NotNeeded.INSTANCE;
            }
        }
        String name = this.getExportedIdentifier(function2);
        if (ExportModelGeneratorKt.access$getAllReservedWords$p().contains(name)) {
            return new Exportability.Prohibited("Name is a reserved word");
        }
        return Exportability.Allowed.INSTANCE;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public ExportModelGenerator(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }
}

