/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrScriptSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a\u0013\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0082\u0010\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0001\u001a\f\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\u0003\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0003\u00a8\u0006\u000b"}, d2={"erase", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getInlineClassBackingField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "irClass", "getInlineClassUnderlyingType", "getInlinedClass", "isInlined", "", "ir.tree"})
public final class InlineClassesKt {
    @Nullable
    public static final IrClass getInlinedClass(@NotNull IrType $this$getInlinedClass) {
        Intrinsics.checkNotNullParameter((Object)$this$getInlinedClass, (String)"$this$getInlinedClass");
        if ($this$getInlinedClass instanceof IrSimpleType) {
            IrClass irClass2 = InlineClassesKt.erase($this$getInlinedClass);
            if (irClass2 == null) {
                return null;
            }
            IrClass erased = irClass2;
            if (erased.isInline()) {
                if (IrTypePredicatesKt.isMarkedNullable($this$getInlinedClass)) {
                    IrType fieldType = null;
                    IrClass fieldInlinedClass = erased;
                    while (true) {
                        if (IrTypePredicatesKt.isMarkedNullable(fieldType = InlineClassesKt.getInlineClassUnderlyingType(fieldInlinedClass))) {
                            return null;
                        }
                        if (InlineClassesKt.getInlinedClass(fieldType) != null) continue;
                        break;
                    }
                }
                return erased;
            }
        }
        return null;
    }

    public static final boolean isInlined(@NotNull IrType $this$isInlined) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlined, (String)"$this$isInlined");
        return InlineClassesKt.getInlinedClass($this$isInlined) != null;
    }

    private static final IrClass erase(IrType type2) {
        IrClass irClass2;
        block3: {
            IrClassifierSymbol classifier2;
            while (true) {
                IrClassifierSymbol irClassifierSymbol;
                if ((irClassifierSymbol = (classifier2 = IrTypesKt.getClassifierOrFail(type2))) instanceof IrClassSymbol) {
                    irClass2 = (IrClass)((IrClassSymbol)classifier2).getOwner();
                    break block3;
                }
                if (irClassifierSymbol instanceof IrScriptSymbol) {
                    irClass2 = null;
                    break block3;
                }
                if (!(irClassifierSymbol instanceof IrTypeParameterSymbol)) break;
                type2 = (IrType)CollectionsKt.first(((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()).getSuperTypes());
            }
            boolean bl = false;
            throw (Throwable)new IllegalStateException(classifier2.toString());
        }
        return irClass2;
    }

    @NotNull
    public static final IrType getInlineClassUnderlyingType(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        for (IrDeclaration declaration2 : irClass2.getDeclarations()) {
            if (!(declaration2 instanceof IrConstructor) || !((IrConstructor)declaration2).isPrimary()) continue;
            return ((IrConstructor)declaration2).getValueParameters().get(0).getType();
        }
        String string2 = "Inline class has no primary constructor: " + IrUtilsKt.getFqNameWhenAvailable(irClass2);
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    @NotNull
    public static final IrField getInlineClassBackingField(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        for (IrDeclaration declaration2 : irClass2.getDeclarations()) {
            IrField backingField2;
            if (declaration2 instanceof IrField && !((IrField)declaration2).isStatic()) {
                return (IrField)declaration2;
            }
            if (!(declaration2 instanceof IrProperty) || (backingField2 = ((IrProperty)declaration2).getBackingField()) == null || backingField2.isStatic()) continue;
            return backingField2;
        }
        String string2 = "Inline class has no field: " + IrUtilsKt.getFqNameWhenAvailable(irClass2);
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }
}

